#!/usr/bin/perl


# NetBilling - log
#
# (C) 2003, Michael Klimenko
#
# $Revision: 2.1 $
#

use DBI;
use CGI;

require "./procs.pl";

$scriptpath=$spath_log;

html_start($lang{LOG_TITLE});
print_navmenu();


my $co = new CGI;

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:database=$dbname;host=$dbhost",
                           $dbuser, $dbpass,{'RaiseError' => 1});

if ($dbh == undef) { print "Error connecting to database"; exit(-1); }

print "<DIV align=center><h1>$orgtitle</h1><h2>$lang{LOG_HEAD}</h2></DIV><br>";

# get events of current month by default
my $null;
($null,$null,$null,$null,my $month,my $year,$null,$null,$null) = localtime(time);
$month++; $year+=1900;

if ( ($co->param('Action') eq 'arch') && (defined $co->param('M')) && (defined $co->param('Y')) )  {
    #  
    $month = $co->param('M'); $year = $co->param('Y');
}
    my $orderby;
    if (defined $co->param('orderby')) {$orderby = $co->param('orderby') } else {$orderby='EventTime'}
    print "<TABLE width=100% align=center><TR valign=top align=center><TD>";
    get_logslist($month,$year,$orderby);
    print "</TD><TD>";
    get_logsarch();
    print "</TD></TR></TABLE><br>\n";

$dbh->disconnect();
html_end();

exit;

##########################################

#      
sub get_logslist($$$)
{
    (my $month, my $year, my $orderby) = @_;
    my $sth;
    eval { $sth = $dbh->prepare("SELECT L.*,C.IP,C.ID as ID FROM Log L,Client C WHERE C.ID=L.Client_ID AND MONTH(L.EventTime)=$month AND YEAR(L.EventTime)=$year ORDER BY $orderby");$sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    print "<DIV align=center><h3>".sprintf($lang{LOG_REPORT_HEAD},$monthnames[$month],$year)."</h3></DIV>\n";
    print "<TABLE border=1 align=center  cellspacing=0 align=center class=btbl>";
    print "<TR style='background-color:#4fafaf'><TH TITLE='$lang{LOG_REPORT_SORT_TIME}' class=btbl><A href=$scriptpath?Action=arch&M=$month&Y=$year class=atbl>$lang{LOG_REPORT_TIME}</A></TH><TH TITLE='$lang{LOG_REPORT_SORT_CLIENT}' class=btbl><A href=$scriptpath?Action=arch&M=$month&Y=$year&orderby=IP class=atbl>$lang{LOG_REPORT_CLIENT}</A></TH><TH class=btbl>$lang{LOG_REPORT_EVENT}</TH></TR>";
    while (my $ref = $sth->fetchrow_hashref()) {
	my $date = $ref->{'EventTime'}; $date =~ s/\s/\&nbsp;/g;
	print "<TR style='background-color:#efef9f'><TD class=btbl>$date</TD><TD class=btbl><A href=$spath_clients?Action=show&ID=$ref->{'ID'} class=atbl>$ref->{'IP'}</A></TD><TD class=btbl>$ref->{'Msg'}</TD></TR>";
    }
    $sth->finish();
    print "</TABLE>\n";
}

#    
sub get_logsarch($$)
{
    (my $month, my $year) = @_;
    my $sth;
    eval { $sth = $dbh->prepare("SELECT DISTINCT CONCAT(MONTH(EventTime),\".\",YEAR(EventTime)) date  FROM Log ORDER BY EventTime");$sth->execute();};
    if ($@) { print "<FONT color=red>: $@</FONT><br>";}
    print "<DIV align=center><h3>$lang{LOG_ARCH_HEAD}</h3></DIV>\n";
    print "<TABLE border=1 align=center cellpadding=2 cellspacing=0 align=center class=btbl>";
    print "<TR style='background-color:#efef9f'>";
    my $dcount = 1;
    while (my $ref = $sth->fetchrow_hashref()) {
	$ref->{'date'} =~ /^(\d{1,2})\.(\d+)$/;
	my $m = $1; my $y = $2;
	my $date = sprintf "%02d.%d",$m,$y;
	print "<TD class=btbl><A href='$scriptpath?Action=arch&M=$m&Y=$y' class=atbl>$date</A></TD>";
	if ($dcount % 2 == 0) {print "</TR><TR style='background-color:#efef9f'>";}
	$dcount++;
    }
    $sth->finish();
    print "</TABLE>\n";
}
