#!/usr/bin/perl

#
# NetBilling - zones
#
# (C) 2003, Michael Klimenko
#
# $Revision: 2.6 $
#

use DBI;
use CGI;

require "./procs.pl";

$scriptpath=$spath_zones;;

html_start($lang{ZONES_TITLE});
print_navmenu();

my $co = new CGI;

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:database=$dbname;host=$dbhost",
                           $dbuser, $dbpass,{'RaiseError' => 1});

if ($dbh == undef) { print "Error connecting to database"; exit(-1); }

if ($co->param('Action') eq 'edit') {

    # Edit zone
    print "<DIV align=center><h1>$orgtitle</h1><h2>$lang{ZONES_HEAD}</h2></DIV><br>";
    print "<h3>$lang{ZONES_EDIT_HEAD}</h3>\n";
    my $sth1;
    eval { $sth1 = $dbh->prepare("SELECT Name,Descr,PriceIn,PriceOut FROM Zone WHERE ID=".$co->param('ID'));$sth1->execute();};
    if ($@) {print ": $@";}
    my $ref1 = $sth1->fetchrow_hashref();
    print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
    print "<INPUT TYPE=hidden NAME=Action VALUE='editzone'><INPUT TYPE=hidden NAME=ID VALUE='".$co->param('ID')."'>";
    print "<TABLE>";
    print "<TR><TD>$lang{ZONES_FIELD_NAME}:</TD><TD><INPUT TYPE=text MAXLENGTH=20 NAME=ZoneName VALUE='".$ref1->{'Name'}."'></TD></TR>";
    print "<TR><TD>$lang{ZONES_FIELD_DESCR}:</TD><TD><INPUT TYPE=text MAXLENGTH=150 NAME=ZoneDescr SIZE=40 VALUE='".$ref1->{'Descr'}."'></TD></TR>";
    print "<TR><TD>$lang{ZONES_FIELD_PRICEIN}:</TD><TD><INPUT TYPE=text MAXLENGTH=8 NAME=PriceIn VALUE='".$ref1->{'PriceIn'}."'></TD></TR>";
    print "<TR><TD>$lang{ZONES_FIELD_PRICEOUT}:</TD><TD><INPUT TYPE=text MAXLENGTH=8 NAME=PriceOut VALUE='".$ref1->{'PriceOut'}."'></TD></TR>";
    print "</TABLE>";
    print "<input type=\"submit\" value=\"$lang{BTN_EDIT}\"></FORM>";
    $sth1->finish();
    
    # Edit zone IPs
    print "<hr>\n<h4>$lang{ZONES_EDIT_ADDRESS_HEAD}</h4>\n";
    print "<TABLE>";
    my $sth1;
    eval { $sth1 = $dbh->prepare("SELECT ID,IP,Mask,Neg FROM Address WHERE Zone_ID=".$co->param('ID'));$sth1->execute();};
    if ($@) {print ": $@";}
    while (my $ref1 = $sth1->fetchrow_hashref()) {
	print "<TR><FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
	print "<INPUT TYPE=hidden NAME=Action VALUE=editip>";
	print "<INPUT TYPE=hidden NAME=ID VALUE='".$ref1->{'ID'}."'>";
	print "<INPUT TYPE=hidden NAME=Zone_ID VALUE='".$co->param('ID')."'>";
	# 
	print "<TD><INPUT TYPE=checkbox NAME='Neg' TITLE='$lang{ADDRESS_FIELD_NOT}' ";
	if ($ref1->{'Neg'} eq '1') {print "CHECKED";}; print "></TD>";
	# IP
	print "<TD><INPUT TYPE=text MAXLENGTH=15 TITLE='$lang{ADDRESS_FIELD_IP}' NAME='IP' VALUE=".ipnum2str($ref1->{'IP'})."></TD>";
	# 
	print "<TD><SELECT NAME=Mask TITLE='$lang{ADDRESS_FIELD_MASK}'>";
	for (my $i=0; $i<= 32; $i++) {
	    if ($mask_const[$i] != $ref1->{'Mask'}) {print "<OPTION VALUE='" . sprintf "0x%08x", $mask_const[$i]; print "'>$i";}
	    else {print "<OPTION VALUE='" . sprintf "0x%08x", $mask_const[$i]; print "' SELECTED>$i";}
	}
	print "</SELECT></TD>";
	# 
	print "<TD><INPUT TYPE=submit VALUE='$lang{BTN_EDIT}'</TD></FORM>";
	print "<TD><FORM ACTION=\"$scriptpath\" METHOD=\"POST\"><INPUT TYPE=hidden NAME=Action VALUE=delip><INPUT TYPE=hidden NAME=ID VALUE='".$ref1->{'ID'}."'><INPUT TYPE=submit VALUE='$lang{BTN_DEL}'></FORM></TD>";
	print "</TR>\n";
	# 
        my $sth_port;
	eval { $sth_port = $dbh->prepare("SELECT ID,PortNum FROM Port WHERE Address_ID=$ref1->{'ID'} ORDER BY PortNum");$sth_port->execute();};
        if ($@) {print ": $@";}
	while (my $ref_port = $sth_port->fetchrow_hashref()) {
	    print "<TR><TD colspan=2></TD>";
    	    print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\"><TD><INPUT TYPE=text SIZE=5 MAXLENGTH=5 NAME='PortNum' TITLE='$lang{PORT_FIELD_PORTNUM}' VALUE='$ref_port->{'PortNum'}'></TD>";
    	    print "<TD><INPUT TYPE=hidden NAME='Action' VALUE='editport'><INPUT TYPE=hidden NAME='Port_ID' VALUE='$ref_port->{'ID'}'><INPUT TYPE=submit VALUE='$lang{BTN_EDIT}'></TD></FORM>";
    	    print "<TD><FORM ACTION=\"$scriptpath\" METHOD=\"POST\"><INPUT TYPE=hidden NAME='Action' VALUE='delport'><INPUT TYPE=hidden NAME='Port_ID' VALUE='$ref_port->{'ID'}'><INPUT TYPE=submit VALUE='$lang{BTN_DEL}'></FORM></TD>";
	    print "</TR>\n";
	}
	$sth_port->finish();
	#  
	print "<TR><TD colspan=2></TD>";
	print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\"><INPUT TYPE=hidden NAME='Action' VALUE='addport'><INPUT TYPE=hidden NAME='Address_ID' VALUE='$ref1->{'ID'}'>";
	print "<TD><INPUT TYPE=text SIZE=5 MAXLENGTH=5 NAME='PortNum' TITLE='$lang{PORT_FIELD_PORTNUM}'></TD>";
	print "<TD><INPUT TYPE=submit VALUE='$lang{BTN_ADD}'></TD></FORM>";
	print "</TR>";
	print "<TR><TD colspan=5><hr></TD></TR>\n";
    }
    print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\"><INPUT TYPE=hidden NAME='Action' VALUE='addip'><INPUT TYPE=hidden NAME=Zone_ID VALUE='".$co->param('ID')."'>";
    print "<TR><TD><INPUT TYPE=checkbox NAME='Neg' TITLE='$lang{ADDRESS_FIELD_NOT}'></TD><TD><INPUT TYPE=text MAXLENGTH=15 TITLE='$lang{ADDRESS_FIELD_IP}' NAME='IP' VALUE='0.0.0.0'></TD>";
    print "<TD><SELECT NAME=Mask TITLE='$lang{ADDRESS_FIELD_MASK}'>";
	for (my $i=0; $i<= 31; $i++) {
	    print "<OPTION VALUE='0x" . sprintf "%08x", $mask_const[$i]; print "'>$i";
        }
	print "<OPTION VALUE='0x" . sprintf "%08x", $mask_const[32]; print "' SELECTED>32";
    print "</SELECT></TD>";
    print "<TD><INPUT TYPE=submit VALUE='$lang{BTN_ADD}'></TD></TR></FORM>";
    $sth1->finish();
    print "</TABLE>\n";

} else {

    print "<DIV align=center><h1>$orgtitle</h1><h2>$lang{ZONES_HEAD}</h2></DIV><br>";
    # ADD ZONE
    if ( ($co->param('Action') eq 'add') && ($co->param('ZoneName') ne '') ) {
	add_zone($dbh, $co->param('ZoneName'), $co->param('ZoneDescr'), $co->param('PriceIn'), $co->param('PriceOut'));
    }
    # DEL ZONE
    if ( ($co->param('Action') eq 'del') && (defined $co->param('ID')) && (defined $co->param('confirm')) ) {
	del_zone($dbh, $co->param('ID'));
    }
    # ZONE MOVE UP
    if ( ($co->param('Action') eq 'moveup') && (defined $co->param('ID')) ) {
	zone_moveup($dbh, $co->param('ID'));
    }
    # ZONE MOVE DOWN
    if ( ($co->param('Action') eq 'movedown') && (defined $co->param('ID')) ) {
	zone_movedown($dbh, $co->param('ID'));
    }
    # ADD IP
    if ( ($co->param('Action') eq 'addip') && (defined $co->param('IP')) ) {
	my $neg = 0; if (defined $co->param('Neg')) {$neg=1;}
	my $query="INSERT INTO Address (Zone_ID,IP,Mask,Neg) VALUES (";
	$query .= $co->param('Zone_ID').",".ipstr2num($co->param('IP')).",".$co->param('Mask').",$neg)";
	eval { $dbh->do($query) };
	if ($@) {print "<FONT color=red>   ($@).</FONT><br>"};
    }
    # DEL IP
    if ( ($co->param('Action') eq 'delip') && (defined $co->param('ID')) ) {
	del_address($dbh, $co->param('ID'));
    }
    # EDIT IP
    if ( ($co->param('Action') eq 'editip') && (defined $co->param('ID')) ) {
	my $neg = 0; if (defined $co->param('Neg')) {$neg=1;}
	my $query="UPDATE Address SET Zone_ID = " . $co->param('Zone_ID');
	$query .= ", IP = ".ipstr2num($co->param('IP'));
	$query .= ", Mask = ".$co->param('Mask');
	$query .= ", Neg = $neg";
	$query .= " WHERE ID=".$co->param('ID');
	eval { $dbh->do($query) };
	if ($@) {print "<FONT color=red>     ($@)   $query.</FONT><br>"};
    }
    
    # ADD PORT
    if ( ($co->param('Action') eq 'addport') && (defined $co->param('PortNum')) ) {
	my $query="INSERT INTO Port (Address_ID,PortNum) VALUES (";
	$query .= $co->param('Address_ID').",".$co->param('PortNum').")";
	eval { $dbh->do($query) };
	if ($@) {print "<FONT color=red>   ($@).</FONT><br>"};
    }
    # DEL PORT
    if ( ($co->param('Action') eq 'delport') && (defined $co->param('Port_ID')) ) {
	my $query="DELETE FROM Port WHERE ID=".$co->param('Port_ID');
	eval { $dbh->do($query) };
	if ($@) {print "<FONT color=red>   ($@).</FONT><br>"};
    }
    # EDIT PORT
    if ( ($co->param('Action') eq 'editport') && (defined $co->param('Port_ID')) && (defined $co->param('PortNum')) ) {
	my $query="UPDATE Port SET PortNum = ".$co->param('PortNum')." WHERE ID=".$co->param('Port_ID');
	eval { $dbh->do($query) };
	if ($@) {print "<FONT color=red>     ($@).</FONT><br>"};
    }
    
    # EDIT ZONE
    if ( ($co->param('Action') eq 'editzone') && (defined $co->param('ID')) ) {
	my $query = "UPDATE Zone SET Name='" . $co->param('ZoneName') . "', ";
	$query .= "Descr = '" . $co->param('ZoneDescr') . "', ";
	$query .= "PriceIn = " . $co->param('PriceIn') . ", PriceOut = ". $co->param('PriceOut');
	$query .= " WHERE ID=".$co->param('ID');
	eval { $dbh->do($query) };
	if ($@) {print "<FONT color=red>   ($@).</FONT><br>"};
    }
    # Produce Query Form
    print "<TABLE>";
    get_zonelist();
    print "</TABLE>";
    print "<DIV align=center><h3>$lang{ZONES_ADD_HEAD}</h3></DIV>\n";
    print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
    print "<INPUT TYPE=hidden NAME=Action VALUE='add'>";
    print "<TABLE align=center><TR><TD>$lang{ZONES_FIELD_NAME}:</TD><TD><INPUT TYPE=text MAXLENGTH=20 NAME=ZoneName VALUE='$lang{ZONES_FIELD_NAME_DEFAULT}'></TD></TR>";
    print "<TR><TD>$lang{ZONES_FIELD_DESCR}:</TD><TD><INPUT TYPE=text MAXLENGTH=150 NAME=ZoneDescr></TD></TR>";
    print "<TR><TD>$lang{ZONES_FIELD_PRICEIN}:</TD><TD><INPUT TYPE=text MAXLENGTH=8 NAME=PriceIn VALUE='0.00'}'></TD></TR>";
    print "<TR><TD>$lang{ZONES_FIELD_PRICEOUT}:</TD><TD><INPUT TYPE=text MAXLENGTH=8 NAME=PriceOut VALUE='0.00'></TD></TR>";
    print "</TABLE>";
    print "<div align=center><input type=\"submit\" value=\"$lang{BTN_ADD}\"></div></FORM>";


}

# Disconnect from the database.
$dbh->disconnect();

html_end();


####################################
# SUBs
#

sub get_zonelist()
{
    my $zonecount = 1;
    my $sth;
    eval {$sth = $dbh->prepare("SELECT * FROM Zone ORDER BY OrderNum");$sth->execute();};
    if ($@) {print ": $@";}
    while (my $ref = $sth->fetchrow_hashref()) {
	print "<TABLE width=550 align=center border=1 cellspacing=0 class=btbl style='BACKGROUND-COLOR:#ffffff'><TR><TD class=btbl>";
	print "<TABLE align=center width=100%><TR style='background-color:#4fafaf'><TD style='font-size:16pt'>$zonecount. $ref->{'Name'}</TD>";
        print "<TD><TABLE><TR><TD>";
	print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
	print "<INPUT TYPE=hidden NAME=ID VALUE=$ref->{'ID'}>";
	print "<INPUT TYPE=hidden NAME=Action VALUE='moveup'>";
	print "<input type=\"submit\" value=\"$lang{BTN_MOVEUP}\"></FORM></TD><TD>";
	print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
	print "<INPUT TYPE=hidden NAME=ID VALUE=$ref->{'ID'}>";
	print "<INPUT TYPE=hidden NAME=Action VALUE='movedown'>";
	print "<input type=\"submit\" value=\"$lang{BTN_MOVEDOWN}\"></FORM></TD><TD>";
	print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
	print "<INPUT TYPE=hidden NAME=ID VALUE=$ref->{'ID'}>";
	print "<INPUT TYPE=hidden NAME=Action VALUE='edit'>";
	print "<input type=\"submit\" value=\"$lang{BTN_EDIT}\"></FORM></TD><TD>";
        print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
	print "<INPUT TYPE=hidden NAME=ID VALUE=$ref->{'ID'}>";
	print "<INPUT TYPE=hidden NAME=Action VALUE='del'>";
	print "<input type=\"submit\" value=\"$lang{BTN_DEL}\"><INPUT TYPE=checkbox NAME=confirm TITLE='$lang{BTN_DEL_CONFIRM}'></FORM></TD></TR></TABLE>";
	print "</TD></TR><TR style='background-color:#efef9f; font-style:italic'><TD colspan=2>$ref->{'Descr'}</TD></TR>";
	print "<TR style='background-color:#efef9f'><TD>$lang{ZONES_FIELD_PRICEIN}:</TD><TD>$ref->{'PriceIn'}&nbsp;$currencysign</TD></TR>";
	print "<TR style='background-color:#efef9f'><TD>$lang{ZONES_FIELD_PRICEOUT}:</TD><TD>$ref->{'PriceOut'}&nbsp;$currencysign</TD></TR>";
	print "<TR style='background-color:#efef9f'><TD>$lang{ZONES_ADDRESS_LIST}:</TD><TD>";
	print "<TABLE cellspacing=0 cellpadding=0>";
	my $sth1;
	eval {$sth1 = $dbh->prepare("SELECT ID,IP,Mask,Neg FROM Address WHERE Zone_ID=$ref->{'ID'} ORDER BY Neg DESC");$sth1->execute();};
	if ($@) {print ": $@";}
	while (my $ref1 = $sth1->fetchrow_hashref()) {
	    print "<TR><TD>";
	    print "<b>!</b> " if ($ref1->{'Neg'} eq '1');
	    print ipnum2str($ref1->{'IP'})."/".ipnum2str($ref1->{'Mask'}).port_list($dbh,$ref1->{'ID'})."</TD></TR>";
	}
	$sth1->finish();
	print "</TABLE></TD></TR>";
	print "</TABLE></TD></TR></TABLE><br>\n";
	$zonecount++;
    }
    print "<hr>";
    $sth->finish();

    $dbh->disconnect();
}

#   ,    Address_ID
sub port_list($$)
{
    (my $dbh, my $addressid) = @_;
    my $sth;
    eval {$sth = $dbh->prepare("SELECT PortNum FROM Port WHERE Address_ID=$addressid ORDER BY PortNum");$sth->execute();};
    if ($@) {print ": $@";return;}
    my $portlist = '';
    while (my $ref = $sth->fetchrow_hashref()) {
	if ($portlist eq '') { $portlist .= "&nbsp;:&nbsp;$ref->{'PortNum'}"; } else { $portlist .= ",$ref->{'PortNum'}";}
    }
    $sth->finish();
    return $portlist;
}

#   
sub add_zone($$$$$)
{
    (my $dbh, my $zname, my $zdescr, my $prin, my $prout) = @_;
    #      
    $query = "SELECT MAX(OrderNum)+1 as M FROM Zone";
    my $sth = $dbh->prepare($query); $sth->execute();
    my $ref = $sth->fetchrow_hashref(); my $ordernum = $ref->{'M'};
    $sth->finish();
    if ( (! defined $ordernum) || ($ordernum <= 0) ) { $ordernum=1; }
    #  
    my $query = "INSERT INTO Zone (Name,Descr,PriceIn,PriceOut,OrderNum) VALUES ";
    $query .= "('$zname', '$zdescr', $prin, $prout, $ordernum)";
    eval { $dbh->do($query) };
    if ($@) {print "<FONT color=red>  :<br>$@.<br>    .</FONT><br>"; return;}
    #      
    $query = "SELECT ID FROM Zone WHERE Name='$zname' AND Descr='$zdescr' AND PriceIn='$prin' AND PriceOut='$prout'";
    undef $sth;
    my $sth = $dbh->prepare($query); $sth->execute();
    my $ref = $sth->fetchrow_hashref(); my $zone_id = $ref->{'ID'};
    if ((! defined $zone_id) || $zone_id eq '') { print "<FONT color=red>  .</FONT><br>";return; }
    $sth->finish();
    #       
    undef $sth;
    eval { $sth = $dbh->prepare("SELECT ID FROM Client"); $sth->execute();};
    if ($@) {print "<FONT color=red>:<br> ($@).</FONT><br>"};
    while (my $ref = $sth->fetchrow_hashref()) {
	$query = "INSERT INTO Traffic (Client_ID,Zone_ID,Year,Month) VALUES ($ref->{'ID'}, $zone_id, YEAR(NOW()), MONTH(NOW()))";
	eval { $dbh->do($query); };
	if ($@) {print "<FONT color=red>  :<br>$@.</FONT><br>";}
    }
    $sth->finish();
}

#   
sub del_zone($$)
{
    (my $dbh, my $id) = @_;
    eval { $dbh->do("DELETE FROM Zone WHERE ID=$id") };
    if ($@) {print "<FONT color=red>   ($@).</FONT><br>";return;};
    #     
    eval { $dbh->do("DELETE FROM Traffic WHERE Zone_ID=$id") };
    if ($@) {print "<FONT color=red>    ($@).</FONT><br>";return;};
    #     
    my $sth;
    eval {$sth = $dbh->prepare("SELECT ID FROM Address WHERE Zone_ID=$id");$sth->execute();};
    if ($@) {print "<FONT color=red>   : $@</FONT>";return;}
    while (my $ref = $sth->fetchrow_hashref()) {
        del_address($dbh,$ref->{'ID'});
    }
    $sth->finish();
    #  
    my $counter = 1; my $sth;
    eval {$sth = $dbh->prepare("SELECT ID FROM Zone ORDER BY OrderNum");$sth->execute();};
    if ($@) {print "<FONT color=red>  : $@</FONT>";return;}
    while (my $ref = $sth->fetchrow_hashref()) {
        eval { $dbh->do("UPDATE Zone SET OrderNum=$counter WHERE ID=$ref->{'ID'}") };
	if ($@) {print "<FONT color=red>   ($@).</FONT><br>"};
	$counter++;
    }
    $sth->finish();
}

#
sub del_address($$)
{
    (my $dbh, my $aid) = @_;
    #   
    eval { $dbh->do("DELETE FROM Port WHERE Address_ID=$aid") };
    if ($@) {print "<FONT color=red>   ($@).</FONT><br>";return;};
    #  
    my $query="DELETE FROM Address WHERE ID=$aid";
    eval { $dbh->do($query) };
    if ($@) {print "<FONT color=red>    ($@).</FONT><br>";};
}

#   
sub zone_moveup($$)
{
    (my $dbh, my $zid) = @_;
    #     
    $query = "SELECT MIN(OrderNum) as M FROM Zone";
    my $sth = $dbh->prepare($query); $sth->execute();
    my $ref = $sth->fetchrow_hashref(); my $minordernum = $ref->{'M'};
    $sth->finish();
    if (! defined $minordernum) {print "<FONT color=red>  :<br>$@.</FONT><br>";return;}
    #    
    undef $sth;
    $query = "SELECT OrderNum as M FROM Zone WHERE ID=$zid";
    my $sth = $dbh->prepare($query); $sth->execute();
    my $ref = $sth->fetchrow_hashref(); my $ordernum = $ref->{'M'};
    $sth->finish();
    if (! defined $ordernum) {print "<FONT color=red> :<br>$@.</FONT><br>";return;}
    #     ,       
    if ($minordernum == $ordernum) { return; }
    #    ,    
    undef $sth;
    $query = "SELECT OrderNum as M FROM Zone WHERE OrderNum < $ordernum ORDER BY OrderNum DESC LIMIT 1";
    my $sth = $dbh->prepare($query); $sth->execute();
    my $ref = $sth->fetchrow_hashref(); my $ordernum2 = $ref->{'M'};
    $sth->finish();
    if (! defined $ordernum2) {print "<FONT color=red> :<br>$@.</FONT><br>";}
    #  
    eval { $dbh->do("UPDATE Zone SET OrderNum=65535 WHERE OrderNum=$ordernum") };
    if ($@) {print "<FONT color=red>  1   ($@).</FONT><br>";return;};
    eval { $dbh->do("UPDATE Zone SET OrderNum=$ordernum WHERE OrderNum=$ordernum2") };
    if ($@) {print "<FONT color=red> 2   ($@).</FONT><br>";return;};
    eval { $dbh->do("UPDATE Zone SET OrderNum=$ordernum2 WHERE OrderNum=65535") };
    if ($@) {print "<FONT color=red>  3   ($@).</FONT><br>";return;};
}

#   
sub zone_movedown($$)
{
    (my $dbh, my $zid) = @_;
    #     
    $query = "SELECT MAX(OrderNum) as M FROM Zone";
    my $sth = $dbh->prepare($query); $sth->execute();
    my $ref = $sth->fetchrow_hashref(); my $maxordernum = $ref->{'M'};
    $sth->finish();
    if (! defined $maxordernum) {print "<FONT color=red>  :<br>$@.</FONT><br>";return;}
    #    
    undef $sth;
    $query = "SELECT OrderNum as M FROM Zone WHERE ID=$zid";
    my $sth = $dbh->prepare($query); $sth->execute();
    my $ref = $sth->fetchrow_hashref(); my $ordernum = $ref->{'M'};
    $sth->finish();
    if (! defined $ordernum) {print "<FONT color=red> :<br>$@.</FONT><br>";return;}
    #     ,       
    if ($maxordernum == $ordernum) { return; }
    #    ,    
    undef $sth;
    $query = "SELECT OrderNum as M FROM Zone WHERE OrderNum > $ordernum ORDER BY OrderNum LIMIT 1";
    my $sth = $dbh->prepare($query); $sth->execute();
    my $ref = $sth->fetchrow_hashref(); my $ordernum2 = $ref->{'M'};
    $sth->finish();
    if (! defined $ordernum2) {print "<FONT color=red> :<br>$@.</FONT><br>";}
    #  
    eval { $dbh->do("UPDATE Zone SET OrderNum=65535 WHERE OrderNum=$ordernum") };
    if ($@) {print "<FONT color=red>  1   ($@).</FONT><br>";return;};
    eval { $dbh->do("UPDATE Zone SET OrderNum=$ordernum WHERE OrderNum=$ordernum2") };
    if ($@) {print "<FONT color=red> 2   ($@).</FONT><br>";return;};    
    eval { $dbh->do("UPDATE Zone SET OrderNum=$ordernum2 WHERE OrderNum=65535") };
    if ($@) {print "<FONT color=red>  3   ($@).</FONT><br>"};
}
