/*
 *  $Id: vscan-fsav_core.h,v 1.1.2.4 2004/04/03 16:11:40 reniar Exp $
 *
 * virusscanning module for samba. provides helper methods to call fsecure
 *
 * Copyright (C) Monex AG  Oliver Jehle, 2003
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __VSCAN_FSAV_CORE_H_
#define __VSCAN_FSAV_CORE_H_

#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>


#define BUFFERSIZE 2047
#define RCVSIZE    1023

/*
 * comm structure 
 */

typedef struct fsav_handle {
        struct sockaddr_un *server;
        int  rc;
        int  sockd;
	uid_t uid;
	uid_t connect_uid;
	short userinstance;         
	short configured;         
	short infected;         
	short fail;         
	short archive;
	short maxnested;
	short timeout;
	short mime;
        char *buffer;
        char *recv_buffer;
  	char *config_file;      /* location of config file */
	char *db_dir;   	/* location of the database dir*/
	char *binary;           /* location of the fsavd deamon */
	char *user;
	char *socket;
	char *virusname;
} fsav_handle;

fsav_handle * fsav_create_handle();
void fsav_start(fsav_handle *h);
void fsav_daemonize(fsav_handle *h);
void fsav_kill(fsav_handle *h);
void fsav_free_handle(fsav_handle *h);
void fsav_clean_handle(fsav_handle *h);
void fsav_socket_create(fsav_handle *h);
void fsav_socket_name_create(fsav_handle *h);

int fsav_switch_uid(fsav_handle *h);
int fsav_connect_handle(fsav_handle *h);
int fsav_configure(fsav_handle *h,char *option, int value);
int fsav_scan(fsav_handle *h, char *file, char* client_ip);
int fsav_process(fsav_handle *h);

#endif /* __VSCAN_FSAV_H */
