
#define	DEF_USEREDITOR		"/usr/bin/vi"

#define	FIRSTALLOC	100

#define	MINPAGESIZE	5
#define	Y_FIRST		3
#define	X_FIRST		0
#define	X_CURSOR	6
#define	X_NAME		9

#define	ctrl(c)		((c) & 0x1F)
#define	ESC		'\033'
#define	CR		'\r'
#define	NL		'\n'
#define	BS		'\b'

#define	DEFCOLOR	"\033[0;37;40m\033[H\033[J"
#define	NICECOLOR	"\033[0m\033[1;33;44m\033[H\033[J"

/*
 *  used by get_arrow_key()
 */
#define	KEYMAP_UNKNOWN		0
#define	KEYMAP_UP		1
#define	KEYMAP_DOWN		2
#define	KEYMAP_LEFT		3
#define	KEYMAP_RIGHT		4
#define	KEYMAP_PAGE_UP		5
#define	KEYMAP_PAGE_DOWN	6
#define	KEYMAP_HOME		7
#define	KEYMAP_END		8
#define	KEYMAP_INS		9
#define	KEYMAP_F1		10
#define	KEYMAP_F2		11
#define	KEYMAP_F3		12
#define	KEYMAP_F4		13

#define	MAXUSRNAMELEN		24	/* Maximum username length */

/*
 * User entry
 */
struct usrent {
	time_t u_time;			/* lastcall time */
	unsigned int u_tleft;		/* timeleft */
	unsigned int u_call;		/* number of call */
	unsigned char u_priv;		/* privlevel */
	unsigned char u_flag;		/* user flags */
	unsigned char u_nlen;		/* length of string in name */
	char u_name[MAXUSRNAMELEN+1];	/* name of user */
};

/*
 * User flags are
 */
#define	UF_UNKNOWN	0
#define	UF_REGULAR	1
#define	UF_CHARGE	2
#define	UF_GBANK	4
#define	UF_GROUP	8
#define	UF_BLOCKED	16
#define	UF_TERMINATOR	32
#define	UF_INFINITY	64
#define	UF_FLAGS	(UF_REGULAR|UF_CHARGE|UF_GBANK|UF_GROUP|UF_BLOCKED|UF_INFINITY|UF_TERMINATOR)

#define	UF_MARKED	128
#define	UF_CURSOR	256

#define	USRSIZ(up) \
((sizeof (struct usrent) - (MAXUSRNAMELEN+1)) + (((up)->u_nlen+1 + 3) &~ 3))

extern char *itoa();
extern char *flag2str();
