/*
 *	Copyright (c) 1994 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "drive.h"
#include "sysmsg.h"
#include "ripwraps.h"

#define	MAXLANGNUM	16

extern int errno;

char *langname;
int langnumber;
int codepage;

/* languages conf file */
static struct {
	char *lang;
	int num;
	int page;
	char *file;
	char *tabl;
	char *desc;
} lng[MAXLANGNUM+1];

/* language msgs file */
static struct {
	int num;
	char *msg;
} msgs[MAXSYSMSGS+1];

int
langinit(havelang)
	char *havelang;
{
	int n;
	char *ptr, *line, *lang, *file, *tabl;
	struct stat st;

	deftable();

	if ((ptr = loadfile(MAINLANGCONF)) == NULL &&
	    (ptr = loadfile(LANGCONF)) == NULL) {
		LOGIT(LOG_ERR, "can't find \"%s\" or \"%s\"",
		      MAINLANGCONF, LANGCONF);
		return -1;
	}
	for (n = 0; n < MAXLANGNUM &&
	     (line = strchr(ptr, '\n')) != NULL; ptr = line) {
		*line++ = '\0';
		while ((u_char)*ptr <= 0x20 && *ptr) ptr++;
		if (!*ptr || *ptr == '#') continue;
		lang = ptr;
		while ((u_char)*ptr > 0x20) ptr++;
		if (*ptr) for (*ptr++ = 0; (u_char)*ptr <= 0x20 && *ptr; ptr++);
		if (!*ptr) continue;
		file = ptr;
		while ((u_char)*ptr > 0x20) ptr++;
		if (*ptr) for (*ptr++ = 0; (u_char)*ptr <= 0x20 && *ptr; ptr++);
		if (!*ptr) continue;
		if ((tabl = strchr(file, '/')) == NULL) continue;
		*tabl++ = '\0';
		lng[n].num = atoi(file);
		lng[n].page = atoi(tabl);
		file = ptr;
		while ((u_char)*ptr > 0x20 && *ptr != ',') ptr++;
		for (tabl = ptr; (u_char)*tabl <= 0x20 && *tabl; tabl++);
		if (*tabl == ',') {
			for (*tabl++ = 0; (u_char)*tabl <= 0x20 && *tabl; tabl++);
			ptr = tabl;
			while ((u_char)*ptr > 0x20) ptr++;
		} else  tabl = NULL;
		if (*ptr) for (*ptr++ = 0; (u_char)*ptr <= 0x20 && *ptr; ptr++);
		if (!*ptr) continue;
		if (stat(file, &st) < 0 || (st.st_mode & S_IFMT) != S_IFREG ||
		    !(st.st_mode & S_IRUSR) || st.st_mode & S_IXUSR) {
			LOGIT(LOG_ERR, "can't find \"%s\"", file);
			continue;
		}
		lng[n].lang = strdup(lang);
		lng[n].file = strdup(file);
		lng[n].tabl = NULL;
		if (tabl != NULL) {
			if (stat(tabl, &st) < 0 || (st.st_mode & S_IFMT) != S_IFREG ||
			    !(st.st_mode & S_IRUSR) || st.st_mode & S_IXUSR)
				LOGIT(LOG_ERR, "can't find \"%s\"", tabl);
			else	lng[n].tabl = strdup(tabl);
		}
		lng[n].desc = strdup(ptr);
		n++;
	}
	lng[n].lang = NULL;
	if (!n) return -1;
	for (n = 0; n < MAXSYSMSGS; n++) msgs[n].msg = NULL;
	return (language(havelang));
}

int
language(havelang)
	char *havelang;
{
	int i, j, n;
	char *ptr, *ptr2, *line, buf[1024];
	struct stat st;
	extern int loggedin;

	if (havelang == NULL) {
		if (termflags & RIPTERM)
			sprintf(buf, "((*%s::", sysmsg(MSG_SELECTLANGUAGE));
		else	putchr('\n');
		for (i = 0; lng[i].lang; i++) {
			if (termflags & ANSITERM)
				putrawstr("\033[1;33m%2d \033[0;36m%s\n", i+1, lng[i].desc);
			else if (termflags & RIPTERM)
				strcatf(buf, "%d^m@~%d~ %s,", i+1, i+1, lng[i].desc);
			else	putrawstr("%2d) %s\n", i+1, lng[i].desc);
		}
		if (!i) {
			if (termflags & (ANSITERM | RIPTERM)) putstr("\033[1;31m");
			putstr("No language available\n");
			return -1;
		}
		if (termflags & RIPTERM) {
			strcat(buf, "0^m@~0~ Quit))");
			rip_query(0, 0, 0, buf);
			ripio_flush();
			n = atoi(getstr(0, 1, ECHODISABLE));
		} else	n = prompt_num(MSG_SELECTLANGUAGE, 0, i);
		if (n < 1 || n > i) return 0;
		i = n - 1;
		if (!loggedin) globalflags |= LANGPRESELECTED;
	} else	for (i = 0; lng[i].lang; i++)
			if (!strcmp(lng[i].lang, havelang)) break;
	if (lng[i].lang == NULL) {
		LOGIT(LOG_ERR, "No language configured");
		return -1;
	}
	if (stat(lng[i].file, &st) < 0 || !st.st_size || !st.st_mtime) {
		LOGIT(LOG_ERR, "can't find \"%s\"", lng[i].file);
		return -1;
	}
	deftable();
	if (lng[i].tabl != NULL && !settable(lng[i].tabl)) return -1;
	if ((ptr = loadfile(lng[i].file)) == NULL) return -1;

	for (n = j = 0; n < MAXSYSMSGS &&
	     (line = strchr(ptr, '\n')) != NULL; ptr = line) {
		*line++ = '\0';
		while ((u_char)*ptr <= 0x20 && *ptr) ptr++;
		if (!*ptr || *ptr == '#') continue;
		ptr2 = ptr;
		while ((u_char)*ptr > 0x20) ptr++;
		if (*ptr) for (*ptr++ = 0; (u_char)*ptr <= 0x20 && *ptr; ptr++);
		if (!*ptr || !(j = atoi(ptr2))) continue;
		if (*ptr == '"') {
			for (ptr2 = ptr; *ptr2 != 0; ptr2++)
				if (*ptr2 == '"' && *(ptr2-1) != '\\') break;
			if (!*ptr2) continue;
		} else {
			for (ptr2 = ptr; (u_char)*ptr2 > 0x20; ptr2++);
			*ptr2 = '\0';
			if (stat(ptr, &st) < 0 ||
			    (st.st_mode & S_IFMT) != S_IFREG ||
			    !(st.st_mode & S_IRUSR) || st.st_mode & S_IXUSR) {
				LOGIT(LOG_ERR, "can't find \"%s\"", ptr);
				continue;
			}
		}
		if (j != n+1) {
			LOGIT(LOG_ERR, "wrong line #%d in \"%s\"", n+1,
				lng[i].file);
			return -1;
		}
		if (msgs[n].msg != NULL) free(msgs[n].msg);
		if ((msgs[n].msg = strdup(ptr)) == NULL) return -1;
		msgs[n].num = j;
		n++;
	}
	while (n <= MAXSYSMSGS) msgs[n++].msg = NULL;
	if (j) {
		langname = lng[i].lang;
		langnumber = lng[i].num;
		codepage = lng[i].page;
	}
	return j;
}

/*
 * Chars translation table
 */
unsigned char table[256][2];

deftable()
{
	register i;
	for (i = 0; i < 256; i++) table[i][0] = table[i][1] = i;
}

int
settable(filename)
	char *filename;
{
	int i, n;
	char *ptr, *line, *idx, *left, *right;

	if ((ptr = loadfile(filename)) == NULL) return 0;

	for (n = 0; n < 256 && (line = strchr(ptr, '\n')) != NULL; ptr = line) {
		*line++ = '\0';
		while ((u_char)*ptr <= 0x20 && *ptr) ptr++;
		if (!*ptr || *ptr == '#') continue;
		idx = ptr;
		while ((u_char)*ptr > 0x20) ptr++;
		if (*ptr) for (*ptr++ = 0; (u_char)*ptr <= 0x20 && *ptr != 0; ptr++);
		left = ptr;
		if (*ptr) while ((u_char)*ptr > 0x20) ptr++;
		if (*ptr) for (*ptr++ = 0; (u_char)*ptr <= 0x20 && *ptr != 0; ptr++);
		right = ptr;
		if (*ptr) while ((u_char)*ptr > 0x20) ptr++;
		*ptr = '\0';
		if (!*left || !*right) continue;
		i = atoi(idx);
		if (*left == 0x27) table[i][0] = *++left;
		else table[i][0] = atoi(left);
		if (*right == 0x27) table[i][1] = *++right;
		else table[i][1] = atoi(right);
		n++;
	}
	return n;
}

char *
sysmsg(num)
	register num;
{
	static char smsg[2048];
	int fd;

	if (num >= 1 && num <= MAXSYSMSGS) {
		if (msgs[num-1].num == num && msgs[num-1].msg != NULL) {
			if (msgs[num-1].msg[0] == '"') {
/*				parse_msgkeys(msgs[num-1].msg); */
				strcpy(smsg, &msgs[num-1].msg[1]);
				smsg[strlen(smsg)-1] = '\0';
				return smsg;
			}
			if ((fd = open(msgs[num-1].msg, O_RDONLY)) >= 0) {
				int n;
				while ((n = read(fd, smsg, sizeof(smsg)-1)) < 0 &&
				       errno == EINTR);
				close(fd);
				smsg[n] = '\0';
				return smsg;
			}
		}
	}
	sprintf(smsg, "SYSMSG #%d (null)", num);
	return smsg;
}

int
psysmsg(num)
	int num;
{
	return (putstr("%s ", sysmsg(num)));
}

/*
parse_msgkeys(str)
	char *str;
{
	char *p1, *p2, buf[80];

	for (p1 = str; (p1 = strchr(p1, '[')) != NULL && *(p1-1) != '\'; p1++);
	if (p1 == NULL) return;
	for (p2 = ++p1; (p2 = strchr(p2, ']')) != NULL && *(p2-1) != '\'; p2++);
	if (p2 == NULL) return;
}
*/
