/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#ifdef	HAVE_FTS_H
#include <fts.h>
#elif	HAVE_FTW_H
#include <ftw.h>
#endif

#ifdef	HAVE_FTS_OPEN

/* use BSD traverse a file hierarchy functions */

/*
 * Delete directories tree.
 * Return: -1 on error or 0 for success.
 */
int
deldirtree(dirname)
	char *dirname;
{
	register FTS *fts;
	register FTSENT *p;
	char *av[2];
	extern int errno;

	av[0] = dirname;
	av[1] = NULL;
	if (!(fts = fts_open(av, FTS_PHYSICAL | FTS_NOSTAT, (int (*)())NULL)))
		return -1;
	while ((p = fts_read(fts)) != NULL) {
		switch (p->fts_info) {
			case FTS_DNR:
			case FTS_ERR:
				fts_close(fts);
				return -1;
			case FTS_D:
				continue;
		}
		if (p->fts_info == FTS_DP || p->fts_info == FTS_DNR) {
			if (!rmdir(p->fts_accpath) || errno == ENOENT)
				continue;
		} else	if (!unlink(p->fts_accpath) || errno == ENOENT)
				continue;
		fts_close(fts);
		return -1;		
	}
	fts_close(fts);
	return 0;
}

#elif	HAVE_NFTW

/* use SYSV traverse a file hierarchy functions */

static int
rm_func(path, st, obj, f)
	 char *path;
	 struct stat *st;
	 int obj;
	 struct FTW *f; /* f->base and f->level */
{
	switch (obj) {
		case FTW_DNR:
		case FTW_NS:
			return -1;
		case FTW_D:
			return 0;
	}
	if (obj == FTW_DP || obj == FTW_DNR) {
		if (!rmdir(path) || errno == ENOENT)
			return 0;
	} else	if (!unlink(path) || errno == ENOENT)
			return 0;
	return -1;
}

int
deldirtree(dirname)
	char *dirname;
{
	return nftw(dirname, rm_func, 10, FTW_PHYS | FTW_DEPTH);
}

#else

/* use rm program */

#include <stdio.h>
#include <string.h>

/*
 * Delete directories tree.
 * Return 0 for success.
 */
int
deldirtree(dirname)
	char *dirname;
{
	int len;
	struct stat st;
	char buf[1024];

	if (stat(dirname, &st) < 0 || (st.st_mode & S_IFMT) != S_IFDIR)
		return -1; /* not a directory */

	(void)sprintf(buf, "%s %s %s", PROG_RM, PROG_RM_ARGS, dirname);
	len = strlen(buf);
	if (buf[len-1] == '/') buf[len-1] = '\0';

	return system(buf);
}

#endif
