/*
 *	Copyright (c) 1995 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#define	MAXUSRNAMELEN		24
#define	USRHOMEDIR		"usr"
#define	LOGINFOFILE		"/tmp/loginfo"
#define	USERCONF		".user.conf"
#define	CHARGEUSERCONF		".cuser.conf"
#define	CALLSIGNLIST		".callsign.conf"
#define	TERM			"TERM"
#define	USERLOCATION		"LOCATION"
#define	USERPRIVLEVEL		"PRIVLEVEL"
#define	DAILYTIMELEFT		"DAILYTIMELEFT"
#define	PASSWORD		"PASSWORD"
#define	DAILYDLLIMIT		"DAILYDLLIMIT"
#define	LASTCALLTIME		"LASTCALLTIME"
#define	LANGUAGE		"LANGUAGE"
#define	MENUPATH		"MENUPATH"
#define	CALLNUMBER		"CALLNUMBER"
#define	REALNAME		"REALNAME"
#define	USERORG			"ORGANIZATION"
#define	USERLOCATION		"LOCATION"
#define	PHONENUMBER		"PHONE"
#define	USERDEFFROM		"DEFINE-FROM"
#define	SIGNATURE		"SIGNATURE"
#define	USERDLSIZE		"USERDLSIZE"
#define	USERULSIZE		"USERULSIZE"
#define	USERARTREAD		"ARTREAD"
#define	USERARTPOST		"ARTPOST"
#define	USERMSGREAD		"MSGREAD"
#define	USERMSGPOST		"MSGPOST"
#define	USERGROUP		"GROUP"
#define	USERDEFGROUP		"default"


/* userinfo record */
struct loginfo {
	char	tty[12];	/* tty name */
	char	name[26];	/* user name */
	time_t	ltime;		/* user login time */
	pid_t	pid;		/* PID of bbs proccess */
	int	baud;		/* baudrate */
	int	port;		/* IPC port number */
	int	flags;		/* user flags (bitmaped), see bellow */
};

/* user flags are */
#define	MESGNO		1	/* user have mesg no */
#define	INTALK		2	/* user in talk */
#define	INCONF		4	/* user in conference */
#define	KICKER		8	/* has kicker status */
#define	TERMINATOR	16	/* has terminator status */
#define	INFINITYCONF	32	/* infinity conference */
#define	EXECEXT		64	/* running external application */
#define	CHARGEUSER	128	/* charge user */
#define	INFINITYUSER	256	/* infinity user */
#define	HIDDENUSER	512	/* hidden user */
