/*=============================================================================

                              HydraCom Version 1.00

                         A sample implementation of the
                   HYDRA Bi-Directional File Transfer Protocol

                             HydraCom was written by
                   Arjen G. Lentz, LENTZ SOFTWARE-DEVELOPMENT
                  COPYRIGHT (C) 1991-1993; ALL RIGHTS RESERVED

                       The HYDRA protocol was designed by
                 Arjen G. Lentz, LENTZ SOFTWARE-DEVELOPMENT and
                             Joaquim H. Homrighausen
                  COPYRIGHT (C) 1991-1993; ALL RIGHTS RESERVED


  Revision history:
  06 Sep 1991 - (AGL) First tryout
  .. ... .... - Internal development
  11 Jan 1993 - HydraCom version 1.00, Hydra revision 001 (01 Dec 1992)


  For complete details of the Hydra and HydraCom licensing restrictions,
  please refer to the license agreements which are published in their entirety
  in HYDRACOM.C and LICENSE.DOC, and also contained in the documentation file
  HYDRACOM.DOC

  Use of this file is subject to the restrictions contained in the Hydra and
  HydraCom licensing agreements. If you do not find the text of this agreement
  in any of the aforementioned files, or if you do not have these files, you
  should immediately contact LENTZ SOFTWARE-DEVELOPMENT and/or Joaquim
  Homrighausen at one of the addresses listed below. In no event should you
  proceed to use this file without having accepted the terms of the Hydra and
  HydraCom licensing agreements, or such other agreement as you are able to
  reach with LENTZ SOFTWARE-DEVELOMENT and Joaquim Homrighausen.


  Hydra protocol design and HydraCom driver:         Hydra protocol design:
  Arjen G. Lentz                                     Joaquim H. Homrighausen
  LENTZ SOFTWARE-DEVELOPMENT                         389, route d'Arlon
  Langegracht 7B                                     L-8011 Strassen
  3811 BT  Amersfoort                                Luxembourg
  The Netherlands
  FidoNet 2:283/512, AINEX-BBS +31-33-633916         FidoNet 2:270/17
  arjen_lentz@f512.n283.z2.fidonet.org               joho@ae.lu

  Please feel free to contact us at any time to share your comments about our
  software and/or licensing policies.

=============================================================================*/

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <ctype.h>
#include <signal.h>
#include <stdlib.h>
#include <errno.h>
#include <termios.h>
#include <paths.h>
#include <unistd.h>
#include "hydracom.h"

extern int errno;
static struct termios oldtty;

static void hungup()
{
	carrier = 0;
}

int sys_init(void)         /* all system dependent init should be done here */
{
	struct termios tty;
	char tty_name[40];

	tty_name[0] = '\0';
	if (port != NULL) {
		if (*port != '/') {
			if (!strncasecmp(port, "tty", 3))
				strcat(tty_name, _PATH_DEV);
			else	strcat(tty_name, _PATH_TTY);
		}
		strcat(tty_name, port);
	}
	if (tty_name[0]) {
		if ((fdin = open(tty_name, O_RDWR | O_NONBLOCK)) < 0) {
			fprintf(stderr, "Can't open \"%s\": %s\n",
				strerror(errno));
			endprog(1);
		}
		if (!isatty(fdin)) {
			fprintf(stderr, "\"%s\" not a terminal type device\n");
			endprog(1);
		}
		fdout = fdin;
	}
	if (tcgetattr(fdin, &tty) != 0) {
		fprintf(stderr, "Can't get terminal setting: %s\n",
			strerror(errno));
		endprog(1);
	}
	oldtty = tty;
	cfmakeraw(&tty);
	if (com_speed)	cfsetspeed(&tty, (speed_t)com_speed);
	if (tty_name[0] || nocarrier) tty.c_cflag |= CLOCAL;
	if (flowflags & 0x02 || flowflags & 0x0b) tty.c_cflag |= CRTSCTS;
	if (parity) tty.c_cflag |= (CS7 | PARENB);
	if (tcsetattr(fdin, TCSAFLUSH, &tty) < 0) {
		fprintf(stderr, "Can't set terminal settings: %s\n",
			strerror(errno));
		endprog(1);
	}
	if (tcsetattr(fdout, TCSADRAIN, &tty) < 0) {
		fprintf(stderr, "Can't set terminal settings: %s\n",
			strerror(errno));
		endprog(1);
	}
	if (tty_name[0])
		if (fcntl(fdin, F_SETFL, 0) == -1) {	/* clear O_NONBLOCK */
			fprintf(stderr, "Can't clear device status: %s\n",
				strerror(errno));
			endprog(1);
		}
	carrier = 1;
	signal(SIGHUP, hungup);
	return((int)cfgetispeed(&tty));
}

void sys_restore(void)
{
	if (tcsetattr(fdin, TCSAFLUSH, &oldtty) < 0)
		fprintf(stderr, "Can't return terminal settings: %s\n",
			strerror(errno));
	signal(SIGHUP, SIG_DFL);
}

void sys_idle()
{
	sleep(1);
}

com_putbyte(b)
{
	while (write(fdout, &b, 1) < 0) if (errno != EINTR) {
		fprintf(stderr, "Can't write to terminal device: %s\n",
			strerror(errno));
		endprog(1);
	}
	tcdrain(fdout);
}

com_getbyte()
{
	int b;

	ioctl(fdin, FIONREAD, &b);
	if (b < 1) return -1;
	while (read(fdin, &b, 1) < 0) if (errno != EINTR) return -1;
	return b;
}

void com_putblock (byte *s, word len)
{
	while (write(fdout, s, len) < 0) if (errno != EINTR) {
		fprintf(stderr, "Can't write to terminal device: %s\n",
			strerror(errno));
		endprog(1);
	}
	tcdrain(fdout);
	usleep(100000);
}

int com_outfull (void)          
{                               
	int queue = 0;

	ioctl(fdout, TIOCOUTQ, &queue);
	return queue;
}

void com_flush()
{
	tcdrain(fdout);
	usleep(100000);
}

void com_purge()
{
	tcflush(fdin, TCIFLUSH);
}

void com_dump()
{
	tcflush(fdout, TCOFLUSH);
}


void setstamp(char *name,long tim)                  /* Set time/date of file */
{
        int fd;
        struct timeval tm;

        if (tim == 0L)	gettimeofday(&tm, (struct timezone *)NULL);
	else		tm.tv_sec = tim, tm.tv_usec = 0;
	utimes(name, &tm);
}

/* get free diskspace for specified drive */
/*
long freespace(char *drivepath)    
{
        union REGS regs;

        if (drivepath[0] && drivepath[1] == ':' && isalpha(drivepath[0]))
           regs.h.dl = (toupper(drivepath[0]) - 64);
        else
           regs.h.dl = 0;
        regs.h.ah = 0x36;
        intdos(&regs,&regs);
        return ((long)regs.x.cx * (long)regs.x.ax * (long)regs.x.bx);
}
*/

/* end of syspc.c */
