#include "HTUtils.h"
#include "HTInit.h"
#include "LYCurses.h"
#include "HTML.h"
#include "HTAccess.h"
#include "LYUtils.h"
#include "LYGlobalDefs.h"
#include "LYSignal.h"
#include "LYGetFile.h"
#include "LYStrings.h"
#include "LYClean.h"
#include "LYCharSets.h"
#include "LYReadCFG.h"
#include "LYrcFile.h"
#include "LYKeymap.h"
#ifdef VMS
#include <descrip.h>
#include <lib$routines.h>
#include "HTVMSUtils.h"
#endif /* VMS */

#ifdef SUN
#include<locale.h>
#endif /* SUN */

#include "LYexit.h"
#include "LYLeaks.h"

/* ahhhhhhhhhh!! Global variables :-< */
int HTCacheSize = DEFAULT_CACHE_SIZE;  /* number of docs cached in memory */
#if defined(VMS) && defined(VAXC) && !defined(__DECC)
/* Don't dump doc cache unless this size is exceeded */
int HTVirtualMemorySize = DEFAULT_VIRTUAL_MEMORY_SIZE;
#endif /* VMS && VAXC && !_DECC */
char *empty_string = "\0";
int display_lines;  /* number of lines in display */
int www_search_result= -1;
lynx_printer_item_type *printers = NULL;    /* linked list of printers */
lynx_html_item_type *downloaders = NULL;    /* linked list of download options*/
lynx_html_item_type *uploaders = NULL;
char *log_file_name = NULL;  /* for WAIS log file name in libWWW */
int port_syntax = 1;

BOOLEAN LYShowCursor=SHOW_CURSOR; /* to show or not to show */
BOOLEAN LYforce_no_cache=FALSE;
BOOLEAN LYUserSpecifiedURL=TRUE;  /* always true the first time */
BOOLEAN LYJumpFileURL=FALSE;	  /* always false the first time */
BOOLEAN jump_buffer=JUMPBUFFER;   /* TRUE if recalling shortcuts */
BOOLEAN recent_sizechange=FALSE;  /* the window size changed recently? */
BOOLEAN user_mode=NOVICE_MODE;
BOOLEAN dump_output_immediately=FALSE;
BOOLEAN is_www_index=FALSE;
BOOLEAN lynx_mode=NORMAL_LYNX_MODE;

#ifdef DIRED_SUPPORT
BOOLEAN lynx_edit_mode = FALSE;
BOOLEAN dir_list_style = MIXED_STYLE;
taglink *tagged = NULL;
#endif /* DIRED_SUPPORT */
#ifdef IGNORE_CTRL_C
BOOLEAN sigint = FALSE;
#endif

BOOLEAN child_lynx = FALSE;
#if defined(EXEC_LINKS) || defined(EXEC_SCRIPTS)
#ifndef NEVER_ALLOW_REMOTE_EXEC
BOOLEAN local_exec = LOCAL_EXECUTION_LINKS_ALWAYS_ON;
#else
BOOLEAN local_exec = FALSE;
#endif /* NEVER_ALLOW_REMOTE_EXEC */
BOOLEAN local_exec_on_local_files = LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE;
#endif /* EXEC_LINKS || EXEC_SCRIPTS */
BOOLEAN error_logging = MAIL_SYSTEM_ERROR_LOGGING;
BOOLEAN check_mail = CHECKMAIL;
BOOLEAN vi_keys = VI_KEYS_ALWAYS_ON;
BOOLEAN emacs_keys = EMACS_KEYS_ALWAYS_ON;
BOOLEAN keypad_mode = DEFAULT_KEYPAD_MODE;
BOOLEAN case_sensitive = CASE_SENSITIVE_ALWAYS_ON;
BOOLEAN telnet_ok = TRUE;
BOOLEAN news_ok = TRUE;
BOOLEAN rlogin_ok = TRUE;
BOOLEAN ftp_ok = TRUE;
#ifndef	BBS
BOOLEAN system_editor = FALSE;
#else
BOOLEAN system_editor = TRUE;
#endif
BOOLEAN no_inside_telnet = FALSE;
BOOLEAN no_outside_telnet = FALSE;
BOOLEAN no_inside_news = FALSE;
BOOLEAN no_outside_news = FALSE;
BOOLEAN no_inside_ftp = FALSE;
BOOLEAN no_outside_ftp = FALSE;
BOOLEAN no_inside_rlogin = FALSE;
BOOLEAN no_outside_rlogin = FALSE;
BOOLEAN no_suspend = FALSE;
BOOLEAN no_editor = FALSE;
BOOLEAN no_shell = FALSE;
BOOLEAN no_bookmark = FALSE;
BOOLEAN no_option_save = FALSE;
BOOLEAN no_print = FALSE;
BOOLEAN no_download = FALSE;
BOOLEAN no_disk_save = FALSE;
BOOLEAN no_exec = FALSE;
BOOLEAN exec_frozen = FALSE;
BOOLEAN no_goto = FALSE;
BOOLEAN no_jump = FALSE;
BOOLEAN no_file_url = FALSE;
BOOLEAN no_newspost = FALSE;
BOOLEAN no_mail = FALSE;
BOOLEAN no_statusline = FALSE;

#ifdef DIRED_SUPPORT
BOOLEAN no_dired_support = FALSE;
#endif /* DIRED_SUPPORT */

BOOLEAN LYforce_HTML_mode=FALSE;
char *homepage = NULL;		    /* home page or main screen */
char *editor = NULL;  		    /* the name of the current editor */
char *jumpfile = NULL;		    /* the name of the file containing jumps */
char *bookmark_page = NULL;   	    /* the name of the current bookmark page */
char *startfile = NULL;		    /* the first file */
char *helpfile = NULL; 		    /* the help file */
char *indexfile = NULL;		    /* an index file if there is one */
char *personal_mail_address=NULL;   /* the users mail address */
char *display=NULL;		    /* display environment variable */
char *personal_type_map = NULL;	    /* .mailcap */
char *global_type_map = NULL;	    /* global mailcap */
char *global_extension_map = NULL;  /* global mime.types */
char *personal_extension_map = NULL;/* .mime.types */
int LYlines = 24;
int LYcols = 80;

linkstruct links[MAXLINKS] = {NULL};

histstruct history[MAXHIST] = {NULL};

int nlinks = 0;  /* number of links in memory */
int nhist = 0;   /* number of history entries */
int more = FALSE; /* is there more text to display? */

PRIVATE void FatalProblem PARAMS((int sig));
extern void mainloop();

PUBLIC int main ARGS2(int,argc, char **,argv)
{
    int  i;  /* indexing variable */
    char *terminal=NULL;
    char *cp;
    char *lynx_version_putenv_command=0;
    BOOLEAN restrictions_set=FALSE;
    BOOLEAN stack_dump=FALSE;

#ifdef LY_FIND_LEAKS
    /*
     *	Register the final function to be executed when being exited.
     *	Will display memory leaks if LY_FIND_LEAKS is defined.
     */
    atexit(LYLeaks);
#endif /* LY_FIND_LEAKS */

#ifdef SUN
    /* SUN specific support for international characters. */
    setlocale(LC_ALL, "");
#endif /* SUN */

    /* initialize some variables */
    /* zero the links struct array */
    memset(links, 0, sizeof(linkstruct)*MAXLINKS);

    StrAllocCopy(helpfile, HELPFILE);
    StrAllocCopy(startfile, STARTFILE);
#ifdef JUMPFILE
    StrAllocCopy(jumpfile, JUMPFILE);
#endif /* JUMPFILE */
    StrAllocCopy(indexfile, DEFAULT_INDEX_FILE);
    StrAllocCopy(global_type_map, GLOBAL_MAILCAP);
    StrAllocCopy(personal_type_map, PERSONAL_MAILCAP);
    StrAllocCopy(global_extension_map, GLOBAL_EXTENSION_MAP);
    StrAllocCopy(personal_extension_map, PERSONAL_EXTENSION_MAP);

#ifdef	BBS
	if (!personal_mail_address) {
		char *s, *p;
		if ((s = getenv("USER")) == NULL) {
			fprintf(stderr, "Can't get USER from environment\n");
			exit(1);
		}
		for (p = s; *p; p++) if (*p == ' ' || *p == '\t') *p = '.';
		StrAllocCopy(personal_mail_address, s);
		StrAllocCat(personal_mail_address, "@bbs.");
		StrAllocCat(personal_mail_address, LOCAL_DOMAIN);
	}
#endif

#ifdef UNIX
    StrAllocCopy(lynx_version_putenv_command,"LYNX_VERSION=");
    StrAllocCat(lynx_version_putenv_command,LYNX_VERSION);
    putenv(lynx_version_putenv_command);
#endif /* UNIX */

    /* set up trace now, if requested - GL */
    for (i=1; i<argc; i++) {
	if (strncmp(argv[i], "-trace", 6) == 0) {
	    WWW_TraceFlag = TRUE;
	}
    }

    /* read the lynx.cfg file */
    read_cfg(LYNX_CFG_FILE);

    /* set up the file extension and conversions */
    HTFormatInit();
    HTFileInit();

    /* get WWW_HOME environment variable if it exists) */
    if((cp = getenv("WWW_HOME")) != NULL)
	StrAllocCopy(startfile, cp);

    /*
     * Process arguments - with none, look for the database in STARTDIR,
     * starting with STARTFILE.
     *
     * If a pathname is given, use it as the starting point.  Split it
     * into directory and file components, 'cd' to the directory, and
     * view the file.
     */
    for (i=1; i<argc; i++) {
	if (strncmp(argv[i], "-anonymous", 10) == 0) {
	    if(!restrictions_set)
	        parse_restrictions("default");

        } else if(strncmp(argv[i], "-restrictions", 13) == 0) {
            if((cp=strchr(argv[i],'=')) != NULL)
                parse_restrictions(cp+1);
	    else 
	    {
		/* print help */
		printf("\n\
   USAGE: lynx -restrictions=[option][,option][,option]\n\
   list of options:\n\
   all             restricts all options.\n\
   default         same as commandline option -anonymous.  Disables\n\
                   default services for anonymous users.  Currently set to,\n\
                   all restricted except for: inside_telnet, outside_telnet,\n\
                   inside_news, inside_ftp, outside_ftp, inside_rlogin,\n\
		   outside_rlogin, goto, jump and mail.  Defaults settable\n\
		   within userdefs.h\n\
   inside_telnet   disallow telnets for people coming from inside your\n\
                   domain.\n\
   outside_telnet  disallow telnets for people coming from outside your\n\
                   domain.\n\
   inside_news     disallow USENET news posting for people coming from inside\n\
                   your domain.\n\
   outside_news    disallow USENET news posting for people coming from outside\n\
                   your domain.\n\
   inside_ftp      disallow ftps for people coming from inside your\n\
                   domain.\n\
   outside_ftp     disallow ftps for people coming from outside your\n\
                   domain.\n\
   inside_rlogin   disallow rlogins for people coming from inside your\n\
                   domain.\n\
   outside_rlogin  disallow rlogins for people coming from outside your\n\
                   domain.\n\
   shell           disallow shell escapes\n");
#ifdef DIRED_SUPPORT
	        printf("\
   dired_support   disallow local file management\n");
#endif /* DIRED_SUPPORT */
	        printf("\
   editor          disallow editing\n\
   bookmark        disallow changing the location of the bookmark file.\n\
   option_save     disallow saving options in .lynxrc\n\
   print           disallow most print options\n\
   goto            disable the 'g' (goto) command.\n\
   jump            disable the 'j' (jump) command.\n\
   file_url        disallow using G)oto to go to file: URL's\n\
   download        disallow downloaders in the download menu.\n\
   disk_save       disallow saving binary files to disk in the download menu\n\
   exec            disable execution scripts\n\
   exec_frozen     disallow the user from changing the execution link\n\
   mail            disallow mail\n\
   news_post       disallow USENET News posting\n\
                   setting in the O)ptions menu.\n");
		exit(1);
	    }


	} else if(strncmp(argv[i], "-homepage", 9) == 0) {
	    if((cp=strchr(argv[i],'=')) != NULL)
	    	StrAllocCopy(homepage,cp+1);
	    else {
	    	StrAllocCopy(homepage,argv[i+1]);
		i++;
	    }

	} else if(strncmp(argv[i], "-editor", 7) == 0) {
	    if((cp=strchr(argv[i],'=')) != NULL)
	    	StrAllocCopy(editor,cp+1);
	    else {
	    	StrAllocCopy(editor,argv[i+1]);
		i++;
	    }
	    system_editor = TRUE;

	} else if(strncmp(argv[i], "-display", 8) == 0) {

	    char *putenv_command;

	    if((cp=strchr(argv[i],'=')) != NULL)
	    	display = cp+1;
	    else {
	    	display = argv[i+1];
		i++;
	    }
	    
#ifdef UNIX
	    StrAllocCopy(putenv_command,"DISPLAY=");
	    StrAllocCopy(putenv_command,display);
	    putenv(putenv_command);
#endif /* UNIX */

	} else if(strncmp(argv[i], "-index", 6) == 0) {
	    if((cp=strchr(argv[i],'=')) != NULL)
	    	StrAllocCopy(indexfile, cp+1);
	    else {
	    	StrAllocCopy(indexfile, argv[i+1]);
		i++;
	    }

	} else if(strncmp(argv[i], "-cfg", 4) == 0) {
		/* reading the cfg file may overide 
		 * previous settings 
		 */
	    if((cp=strchr(argv[i],'=')) != NULL)
                read_cfg(cp+1);
            else {
                read_cfg(argv[i+1]);
                i++;
            }


	} else if(strncmp(argv[i], "-stack_dump", 11) == 0) {
	    stack_dump = TRUE;

	} else if(strncmp(argv[i], "-cache", 6) == 0) {
	    if((cp=strchr(argv[i],'=')) != NULL)
	    	HTCacheSize = atoi(cp+1);
	    else {
	    	HTCacheSize= atoi(argv[i+1]);
		i++;
	    }

	    /* limit size */
	    if(HTCacheSize < 2) HTCacheSize = 2;

	} else if(strncmp(argv[i], "-vikeys", 7) == 0) {
	    vi_keys = TRUE;

	} else if(strncmp(argv[i], "-emacskeys", 10) == 0) {
	    emacs_keys = TRUE;

	} else if(strncmp(argv[i], "-version", 8) == 0) {
	    printf("\n%s Version %s\n(c)1994 University of Kansas\n<lynx-help@ukanaix.cc.ukans.edu>\n\n",LYNX_NAME, LYNX_VERSION);
	    exit(0);

	} else if(strncmp(argv[i], "-case", 5) == 0) {
	    case_sensitive = TRUE;

	} else if(strncmp(argv[i], "-dump", 5) == 0) {
	    dump_output_immediately = TRUE;
	    LYcols=80;

	} else if(strncmp(argv[i], "-source", 7) == 0) {
	    dump_output_immediately = TRUE;
	    HTOutputFormat = HTAtom_for("www/dump");
	    LYcols=999;

	} else if(strncmp(argv[i], "-force_html", 11) == 0) {
	    LYforce_HTML_mode = TRUE;

	} else if (strncmp(argv[i], "-trace", 6) == 0) {
	    WWW_TraceFlag = TRUE;

	} else if (strncmp(argv[i], "-linknums", 9) == 0) {
	    keypad_mode = LINKS_ARE_NUMBERED;

 	} else if (strncmp(argv[i], "-noprint", 8) == 0) {
	    no_print=TRUE;

 	} else if (strncmp(argv[i], "-print", 6) == 0) {
	    no_print=FALSE;

#if defined(EXEC_LINKS) || defined(EXEC_SCRIPTS)
 	} else if (strncmp(argv[i], "-exec", 5) == 0) {
#ifndef NEVER_ALLOW_REMOTE_EXEC
	    local_exec=TRUE;
#else
	    local_exec_on_local_files=TRUE;
#endif /* NEVER_ALLOW_REMOTE_EXEC */

 	} else if (strncmp(argv[i], "-locexec", 8) == 0) {
	    local_exec_on_local_files=TRUE;

 	} else if (strncmp(argv[i], "-noexec", 7) == 0) {
	    local_exec=FALSE;
#endif /* EXEC_LINKS || EXEC_SCRIPTS */

 	} else if (strncmp(argv[i], "-child", 6) == 0) {
	    child_lynx=TRUE;

 	} else if (strncmp(argv[i], "-nolog", 6) == 0) {
	    error_logging=TRUE;
	
	} else if(strncmp(argv[i], "-nostatus", 9) == 0)	{
	    no_statusline = TRUE;

	} else if(strncmp(argv[i], "-show_cursor", 12) == 0) {
	    LYShowCursor = TRUE;

	} else if (strncmp(argv[i], "-term", 5) == 0) {
	    if((cp=strchr(argv[i],'=')) != NULL)
		terminal = cp+1;
	    else {
	    	terminal = argv[i+1];
		i++;
	    }

 	} else if (strncmp(argv[i], "-telnet", 7) == 0) {
	    telnet_ok=FALSE;

 	} else if (strncmp(argv[i], "-ftp", 4) == 0) {
	    ftp_ok=FALSE;

 	} else if (strncmp(argv[i], "-rlogin", 7) == 0) {
	    rlogin_ok=FALSE;

#ifdef	NCURSES_TRANSLATE
 	} else if (strncmp(argv[i], "-koi82alt", 9) == 0) {
	    ncurses_translate = KOI82ALT;

 	} else if (strncmp(argv[i], "-alt2koi8", 9) == 0) {
	    ncurses_translate = ALT2KOI8;

 	} else if (strncmp(argv[i], "-koi82win", 9) == 0) {
	    ncurses_translate = KOI82WIN;

 	} else if (strncmp(argv[i], "-win2koi8", 9) == 0) {
	    ncurses_translate = WIN2KOI8;
#endif

	} else if (strncmp(argv[i], "-", 1) == 0) {
	    printf("Usage: %s [options] [file]\n",argv[0]);
	    printf("Options are:\n");
	    printf("    -anonymous       used to specify the anonymous account\n");
	    printf("    -case            enable case sensitive user searching\n");
	    printf("    -cache=NUMBER    NUMBER of documents cached in memory. (default is %d\n",DEFAULT_CACHE_SIZE);
	    printf("    -cfg=FILENAME    specifies a lynx.cfg file other than the default.\n");
	    printf("    -display=DISPLAY set the display variable for X execed programs\n");
	    printf("    -dump            dump the first file to stdout and exit\n");
	    printf("    -editor=EDITOR   enable edit mode with specified editor\n");
	    printf("    -emacskeys       enable emacs-like key movement\n");
#if defined(EXEC_LINKS) || defined(EXEC_SCRIPTS)
#ifndef NEVER_ALLOW_REMOTE_EXEC
	    printf("    -exec            enable local program execution\n");
#endif /* !NEVER_ALLOW_REMOTE_EXEC */
	    printf("    -locexec         enable local program execution from local files only\n");
	    printf("    -noexec          disable local program execution (DEFAULT)\n");
#endif /* EXEC_LINKS || EXEC_SCRIPTS */
	    printf("    -force_html      forces the first document to be interpreted as HTML\n");
	    printf("    -ftp             disable ftp access\n");
	    printf("    -help            print this usage message\n");
	    printf("    -homepage=URL    set homepage separate from start page\n");
	    printf("    -index=URL       set the default index file to URL\n");
	    printf("    -noprint         disable print functions\n");
	    printf("    -nostatus        disable the miscellaneous information messages\n");
	    printf("    -print           enable print functions (DEFAULT)\n");
	    printf("    -restrictions=[options]  use -restrictions to see list\n");
	    printf("    -rlogin          disable rlogins\n");
	    printf("    -show_cursor     don't hide the curser in the lower right corner\n");
	    printf("    -source          dump the source of the first file to stdout and exit\n");
	    printf("    -telnet          disable telnets\n");
	    printf("    -term=TERM       set terminal type to TERM\n");
	    printf("    -trace           turns on WWW trace mode\n");
	    printf("    -vikeys          enable vi-like key movement\n");
	    printf("    -version         prints version information\n");
#ifdef	NCURSES_TRANSLATE
	    printf("    -koi82alt        translate koi8 to alt on output\n");
	    printf("    -alt2koi8        translate alt to koi8 on output\n");
	    printf("    -koi82win        translate koi8 to win on output\n");
	    printf("    -win2koi8        translate win to koi8 on output\n");
#endif
	    exit(0);
	} else {	/* alternate database path */

		StrAllocCopy(startfile, argv[i]);
	}
    }

    /* read the rc file */
    read_rc();
#if defined(EXEC_LINKS) || defined(EXEC_SCRIPTS)
#ifdef NEVER_ALLOW_REMOTE_EXEC
    if (local_exec) {
        local_exec = FALSE;
	local_exec_on_local_files=TRUE;
    }
#endif /* NEVER_ALLOW_REMOTE_EXEC */
#endif /* EXEC_LINKS || EXEC_SCRIPTS */


    if (emacs_keys)
        set_emacs_keys();
 
    if (vi_keys)
        set_vi_keys();
 
    if (keypad_mode == NUMBERS_AS_ARROWS)
        set_numbers_as_arrows();

    /* disable news posting if no posting command */
    if (INEWS == "" || !strcasecomp(INEWS,"none"))
        no_newspost = TRUE;

#ifdef VMS
    set_vms_keys();
#endif /* VMS */


    /* trap interrupts */    
    if(!dump_output_immediately)
        (void) signal (SIGHUP, cleanup_sig);
    (void) signal (SIGTERM, cleanup_sig);
    (void) signal (SIGQUIT, SIG_IGN);
#ifdef SIGWINCH
    (void) signal (SIGWINCH, size_change);
#endif /* SIGWINCH */
#ifndef VMS
    if(!TRACE && !dump_output_immediately && !stack_dump) {
        (void) signal (SIGINT, cleanup_sig);
#ifndef __linux__
        (void) signal (SIGBUS, FatalProblem);
#endif /* !__linux__ */
        (void) signal (SIGSEGV, FatalProblem);
        (void) signal (SIGILL, FatalProblem);
        /*
	 * Since we're doing lots of TCP, just ignore SIGPIPE altogether.
	 *
	 * HTTCP.c should deal with a broken pipe for servers.
	 * Rick Mallet's check after c = GetChar() in LYStrings.c should
	 *  deal with a disconnected terminal.
	 * So the runaway CPU time problem on Unix should not occur any
	 *  more.
	 */
        (void) signal (SIGPIPE, SIG_IGN);
    }
#endif /* !VMS */

    /* set up the proper character set */
    HTMLUseCharacterSet(current_char_set);

	/* if its not a URL then make it one */
    if(!is_url(startfile)) {
	    /* rewrite the file as a URL */
	   char *old_startfile=startfile; 

	   startfile = NULL;  /* so StrAllocCopy doesn't free it */
	   StrAllocCopy(startfile,"file://localhost");
	   if(*old_startfile != '/') {
#ifdef VMS
	      /*
	       *  Not a URL pathspec.  Get the full VMS spec and convert it.
	       */
	       char *cp;
	       static char start_file[256], file_name[256];
	       int context = 0;
	       $DESCRIPTOR(start_file_dsc, start_file);
	       $DESCRIPTOR(file_name_dsc, file_name);
	       strcpy(start_file, old_startfile);
	       start_file_dsc.dsc$w_length = (short) strlen(old_startfile);
	       if (1&lib$find_file(&start_file_dsc, &file_name_dsc, &context,
    				   0, 0, 0, 0)) {
		  /*
		   *  We found the file.  Convert to a URL pathspec.
		   */
	           if ((cp=strchr(file_name, ';')) != NULL)
		       *cp = '\0';
		   for (cp = file_name; *cp; cp++)
		   	*cp = _tolower(*cp);
		   strcpy(start_file, HTVMS_wwwName(file_name));
	       } else {
	          /*
		   *  File not found.  Use original pathspec for the
		   *  error message that will result.
		   */
	           strcpy(start_file, "/");
	           strcat(start_file, old_startfile);
	       }
	       lib$find_file_end(&context);
	       StrAllocCat(startfile, start_file);
	   } else {
	      /*
	       *  Use the original, URL pathspec.
	       */
	       StrAllocCat(startfile, old_startfile);
	   }
#else /* Unix: */
               	char curdir[256];
#ifdef NO_GETCWD
      		getwd (curdir);
#else
    		getcwd (curdir, DIRNAMESIZE);
#endif /* NO_GETCWD */
		StrAllocCat(startfile,curdir);

		StrAllocCat(startfile,"/");
	   }
	   StrAllocCat(startfile,old_startfile);
#endif /* VMS */
	   if(old_startfile)
	       free(old_startfile);
    }

    if(homepage && !is_url(homepage)) {
	    /* rewrite the file as a URL */
	   char *old_homepage=homepage; 

	   homepage = NULL;  /* so StrAllocCopy doesn't free it */
	   StrAllocCopy(homepage,"file://localhost");
	   if(*old_homepage != '/') {
#ifdef VMS
	      /*
	       *  Not a URL pathspec.  Get the full VMS spec and convert it.
	       */
	       char *cp;
	       static char home_page[256], file_name[256];
	       int context = 0;
	       $DESCRIPTOR(home_page_dsc, home_page);
	       $DESCRIPTOR(file_name_dsc, file_name);
	       strcpy(home_page, old_homepage);
	       home_page_dsc.dsc$w_length = (short) strlen(old_homepage);
	       if (1&lib$find_file(&home_page_dsc, &file_name_dsc, &context,
    				   0, 0, 0, 0)) {
		  /*
		   *  We found the file.  Convert to a URL pathspec.
		   */
	           if ((cp=strchr(file_name, ';')) != NULL)
		       *cp = '\0';
		   for (cp = file_name; *cp; cp++)
		   	*cp = _tolower(*cp);
		   strcpy(home_page, HTVMS_wwwName(file_name));
	       } else {
	          /*
		   *  File not found.  Use original pathspec for the
		   *  error message that will result.
		   */
	           strcpy(home_page, "/");
	           strcat(home_page, old_homepage);
	       }
	       lib$find_file_end(&context);
	       StrAllocCat(homepage, home_page);
	   } else {
	      /*
	       *  Use the original, URL pathspec.
	       */
	       StrAllocCat(homepage, old_homepage);
	   }
#else /* Unix: */
               	char curdir[256];
#ifdef NO_GETCWD
      		getwd (curdir);
#else
    		getcwd (curdir, DIRNAMESIZE);
#endif /* NO_GETCWD */
		StrAllocCat(homepage,curdir);

		StrAllocCat(homepage,"/");
	   }
	   StrAllocCat(homepage,old_homepage);
#endif /* VMS */
	   if(old_homepage)
	       free(old_homepage);
    }
    if (!homepage)
	homepage = startfile;

    /*
     * anonymous may already be set above by command line options.
     * so this just sets the correct options.
     */
#ifndef VMS
#ifdef NO_CUSERID
    if (STREQ(((char *)getlogin()==NULL ? " " : getlogin()) , ANONYMOUS_USER)) {
#else
    if (STREQ((char *)cuserid((char *) NULL), ANONYMOUS_USER)) {
#endif /* NO_CUSERID */
	if(!restrictions_set)
	    parse_restrictions("default");
    }
#endif /* !VMS */

    if(inlocaldomain()) {
	if(TRACE)
	   fprintf(stderr,"LYMain.c: User in Local domain");
        telnet_ok = !no_inside_telnet && telnet_ok;
	news_ok = !no_inside_news && news_ok;
	ftp_ok = !no_inside_ftp && ftp_ok;
	rlogin_ok = !no_inside_rlogin && rlogin_ok;
    } else {
	if(TRACE)
	   fprintf(stderr,"LYMain.c: User in REMOTE domain");
        telnet_ok = !no_outside_telnet && telnet_ok;
	news_ok = !no_outside_news && news_ok;
	ftp_ok = !no_outside_ftp && ftp_ok;
	rlogin_ok = !no_outside_rlogin && rlogin_ok;
    }

#ifdef SIGTSTP
    if(no_suspend)
	signal(SIGTSTP,SIG_IGN);
#endif /* SIGTSTP */

    /*
     * here's where we do all the work
     */
    if(dump_output_immediately) {
	mainloop();
        (void) signal (SIGHUP, SIG_IGN);
        (void) signal (SIGTERM, SIG_IGN);
        (void) signal (SIGINT, SIG_IGN);
    } else {
 	if (setup(terminal)) {
	    mainloop();
	    cleanup();
	}
    }
 
    exit(0);
    /* NOTREACHED */
}

#ifndef VMS

static void FatalProblem ARGS1(int,sig)
{
fprintf (stderr, "\r\nSorry, you have encountered a bug in %s Ver. %s\r\n",
	LYNX_NAME, LYNX_VERSION);

fprintf(stderr, "\r\nPlease send a concise mail message to\r\n\
lynx-bug@ukanaix.cc.ukans.edu describing what you were doing,\r\n\
the URL you were looking at or attempting to access,\r\n\
your operating system name with version number,\r\n\
the TCP/IP implementation that your system is using,\r\n\
and any other information you deem relevant.\r\n");

fprintf(stderr, "\r\nDo not mail the core file if one was generated.\r\n");

fprintf(stderr, "\r\nLynx now exiting with signal:  %d\r\n\n", sig);

    /* ignore further interrupts */     /*  mhc: 11/2/91 */
    (void) signal (SIGHUP, SIG_IGN);
    (void) signal (SIGTERM, SIG_IGN);
#ifndef VMS  /* use ttclose() from cleanup() for VMS */
    (void) signal (SIGINT, SIG_IGN);
#endif /* !VMS */
#ifndef __linux__
     (void) signal (SIGBUS, SIG_IGN);
#endif /* !__linux__ */
     (void) signal (SIGSEGV, SIG_IGN);
     (void) signal (SIGILL, SIG_IGN);

  cleanup_sig(0);
#ifndef __linux__
  signal (SIGBUS, 0);
#endif /* !__linux__ */
  signal (SIGSEGV, 0);
  signal (SIGILL, 0);
  abort();  /* exit and dump core */
}
#endif /* !VMS */
