/*
 * lang.h - language file, all system messages must be located here.
 *
 * Created by Vladimir Vorobyev <bob@turbo.nsk.su>
 *
 * text strings for certain actions
 * changing these text strings is a way to customize 
 * your environment to better suit your tastes
 */

#ifdef	RUSSIAN

/* GridText.c */
#define	MSG_ENTER_DATABASE_ENTRY	"    : "
#define	MSG_EDIT_CURRENT_QUERY		"  : "
#define	MSG_TO_RESUBMIT_QUERY		" ^R   "
#define	MSG_SUBMITING_FORM		" ..."
#define	MSG_RESETTING_FORM		" ..."
#define MSG_WWW_WAIT_MESSAGE		" %s"

/* HTFWriter.c */
#define	MSG_FILE_CANT_BE_DISPLAYED	"       :  D-  C-"
#define	MSG_CANCELLING_FILE		" "
#define	MSG_RETRIEVING_FILE		" ,  "

/* LYBookmark.c */
#define	MSG_BOOKMARK_NOT_DEFINED	"Bookmark   .  "
#define	MSG_UNABLE_OPEN_HOTLIST		"     X Mosaic hotlist "
#define	MSG_UNABLE_OPEN_BOOKMARK	" -   bookmark "
#define	MSG_ALL_DONE			"!"
#define	MSG_UNABLE_BF_DELETE_LINK	"  bookmark    "
#define	MSG_UNABLE_SF_DELETE_LINK	"      "
#define	MSG_UNABLE_TF_DELETE_LINK	"      "
#define	MSG_ERROR_RENAME_SF		"   "
#define	MSG_ERROR_RENAME_TF		"   "
#define	MSG_BOOKMARK_DELETE_FAIL	"Bookmark   "

/* LYClean.c */
#define	MSG_REALLY_EXIT_LYNX		"   Lynx? [Y]"

/* LYDownload.c */
#define	MSG_ENTER_FILENAME		"  : "
#define	MSG_FILE_EXIST_CREATE		" .   ? (y/n)"
#define	MSG_FILE_EXIST_OVERWRITE	" . ? (y/n)"
#define	MSG_CANT_WRITE_FILE		"   .    : "
#define	MSG_SAVING			"..."
#define	MSG_DOWNLOAD_MISCONFIGURED	"! -   "
#define	MSG_UNABLE_DOWNLOAD_FILE	"  "
#define	MSG_CANCELLING			""
#ifdef	BBS
#define	MSG_BAD_FILENAME_ENTERED	"     !"
#endif

/* LYEdit.c */
#define	MSG_CANT_EDIT_REMOTE		"Lynx      WWW "
#define	MSG_YOU_CANT_EDIT_FILE		"      "

/* LYForms.c */
#define	MSG_RADIO_BUTTON_CHECKED	"        !"
#define	MSG_WANT_PREVIOUS_DOC		"    ? [N]"
#define	MSG_ENTER_TEXT			" .     TAB    "
#define	MSG_LINK_ALREADY_SELECTED	"  !"
#define	MSG_MAX_LENGTH_REACHED		"  !"

/* LYGetFile.c */
#define	MSG_NEWS_POSTING_DISABLED	"  !"
#define	MSG_FILE_MANAGER_DISABLED	"   !"
#define	MSG_EXECUTION_DISABLED		"   "
#define	MSG_EXECUTION_NOT_ENABLED	"     .   "
#define	MSG_EXECUTION_NOT_COMPILED	"      "
#define	MSG_TELNET_ACCESS_DISABLED	"Telnet  !"
#define	MSG_USENET_ACCESS_DISABLED	"   USENET !"
#define	MSG_RLOGIN_ACCESS_DISABLED	"Rlogin  !"
#define	MSG_MAIL_ACCESS_DISABLED	"  !"
#define	MSG_FTP_ACCESS_DISABLED		"Ftp  !"
#define	MSG_FOLLOW_LINK_NUMBER		"  : "
#define	MSG_CANCELLED			"!"
#define RETURN_TO_LYNX			" ENTER    Lynx"

/* LYJump.c */
#define	MSG_JUMP_TO			"  ('?' ): "
#define	MSG_CANT_LOCATE_JUMP_FILE	"  jump "
#define	MSG_OUT_MEMORY_JUMP_FILE	"    jump "
#define	MSG_CANT_OPEN_JUMP_FILE		"  jump "
#define	MSG_ERROR_READING_JUMP_FILE	"  jump "
#define	MSG_OUT_MEMORY_JUMP_TABLE	"    jump "

/* LYLocal.c */
#define	MSG_REMOVE_TAG_FILES		"     ? (y/n): "
#define	MSG_ENTER_NEW_TAG_LOCATION	"    : "
#define	MSG_SRC_DST_ARE_EQUAL		"      .  !"
#define	MSG_DST_DIFF_OWNER		"   .  !"
#define	MSG_DST_NOT_VALID_DIR		" -  .  !"
#define	MSG_ENTER_NEW_DIRNAME		"    : "
#define	MSG_ENTER_NEW_FILENAME		"    : "
#define	MSG_ITEM_NOT_FILE_OR_DIR	"      .  !"
#define	MSG_FOUND_ILLEGAL_REDIRECTION	"   \"../\".  !"
#define	MSG_FOUND_ILLEGAL_CHARACTER	"  \"/\".  !"
#define	MSG_UNABLE_PROCESS_REQUEST	"  ,    !"
#define	MSG_UNABLE_COMPLETE_REQUEST	"  ,    !"
#define	MSG_FAILURE_COMPLETE_REQUEST	"   ,    !"
#define	MSG_DIR_ALREADY_EXIST		"     .  !"
#define	MSG_FILE_ALREADY_EXIST		"     .  !"
#define	MSG_NAME_ALREADY_IN_USE		"    .  !"
#define	MSG_ENTER_NEW_DIR_LOCATION	"    : "
#define	MSG_ENTER_NEW_FILE_LOCATION	"    : "
#define	MSG_UNABLE_FIND_TRAILER		"  -    \"/\""
#define	MSG_MODIFY_NAME_OR_LOCATION	"    (n  l): "
#define	MSG_NOT_IMPLEMENTED_YET		"    ! "
#define MSG_ENTER_FILENAME_TO_CREATE	"    : "
#define	MSG_ENTER_DIRNAME_TO_CREATE	"    : "
#define	MSG_CREATE_FILE_OR_DIR		"    (f  d): "
#define	MSG_UNABLE_OPEN_MENU_FILE	"     "

/* LYMail.c */
#define	MSG_COMMENT_REQUEST_CANCELLED	"   !"
#define	MSG_WANT_ORIGINAL_MESSAGE	"   ? (y/n) "
#define	MSG_SPAWNING_EDITOR		"       "
#define	MSG_ERROR_SPAWNING_EDITOR	"  ,      "
#define	MSG_SEND_THIS_COMMENT		"  ? (y/n) "
#define	MSG_SENDING_MESSAGE		"  ..."

/* LYMainLoop.c */
#define FORM_NOVICELINE_ONE		"                ,                  "
#define FORM_NOVICELINE_TWO		"    Ctrl-U     , BACKSPACE          "
#define MSG_HELP			"    , '?' , 'q' , '<-' "
#define MSG_MORE_HELP			"-- - ,   - , '?' , 'q' --"
#define MSG_SOURCE_HELP			"  .  '\\'   "
#define MSG_FORM_LINK_PASSWORD		"( )     UP, DOWN, TAB  "
#define MSG_FORM_LINK_OPTION_LIST	"( )  RETURN.     RETURN"
#define MSG_FORM_LINK_CHECKBOX		"( )   RIGHT  ENTER  "
#define MSG_FORM_LINK_SUBMIT		"(  )  RIGHT  ENTER -  ('x'  cache)"
#define MSG_FORM_LINK_RESET		"(  )  RIGHT  ENTER -    "
#define MSG_FORM_LINK_TEXT		"( )     UP, DOWN, TAB  "
#define MSG_NORMAL_LINK			"( )   RIGHT  ENTER  "
#define MSG_WWW_INDEX_MORE		"----   .  's'  "
#define MSG_WWW_INDEX			"  .  's'  "
#define MSG_MORE			"--        --"
#define MSG_BAD_LINK_NUM_ENTERED	"    "
#define MSG_QUIT			"    ? [Y] "
#define	MSG_EXCELLENT			"!"
#define	MSG_ALREADY_END_OF_DOC		"      "
#define	MSG_ALREADY_BEGIN_OF_DOC	"      "
#define	MSG_ALREADY_TOP_OF_DOC		"      "
#define	MSG_ALREADY_BOTTOM_OF_DOC	"      "
#define	MSG_ALREADY_AT_FIRST_DOC	"     "
#define	MSG_NOT_SUBMISSION_BUTTON	"     "
#define	MSG_MAILTO_NOT_SUPPORTED	"  Mailto   "
#define	MSG_RANDOM_URL_DISABLED		"   URL !"
#define	MSG_ENTER_URL_TO_OPEN		"URL  : "
#define	MSG_GOTO_URL_NOT_ALLOWED	"     URL  \"file:\""
#define	MSG_NO_INDEX_AVAILABLE		"   "
#define	MSG_X_TOGGLE_FORM_LINK		"'X'      "
#define	MSG_X_TOGGLE_FORM_MODE		"'X'     "
#define	MSG_Z_TOGGLE_FORM_LINK		"'Z'      "
#define	MSG_Z_TOGGLE_FORM_MODE		"'Z'     "
#define	MSG_WANT_GOTO_MAIN_SCREEN	"      ? (y/n) [n] "
#define	MSG_ALREADY_MAIN_SCREEN		"    !"
#define	MSG_NOT_SEACHABLE_INDEX_DOC	"   ,  '/'    "
#define	MSG_NO_OWNER_DEFINED_FILE	"    ,     "
#define	MSG_MAIL_IS_DISALLOWED		" ,     "
#define	MSG_WANT_TO_SEND_COMMENT	"   ? [N]"
#define	MSG_GET_STATUS_FAILED		"  -   "
#define	MSG_EDITOR_UNDEFINED		"  !"
#define	MSG_SAVE_DLC_TO_BOOKMARK	" D-, L-  bookmark   C-? (d,l,c): "
#define	MSG_CANT_SAVE_FORM		"   /"
#define	MSG_SAVE_DC_TO_BOOKMARK		" D-  bookmark   C-? (d,c): "
#define	MSG_CANT_SAVE_BOOKMARK		"         bookmark "
#define	MSG_WANT_TO_DELETE_BOOKMARK	"        bookmark ? (y/n)"
#define	MSG_REMOVE_ONLY_PAGE_LINKS	"      bookmark "
#define	MSG_UNABLE_OPEN_HOME_PAGE	"   ,  'a'    "
#define	MSG_SHELL_ESCAPE_DISABLED	" '!'  "
#define	MSG_CANT_DOWNLOAD_FIELD		"     "
#define	MSG_NOTHING_TO_DOWNLOAD		" "
#define	MSG_JUMPING_URL_DISALLOWED	"  shortcut URL !"
#define MSG_NO_JUMPFILE			"   jump-"

/* LYNews.c (some other msgs included from LYMail.c section above) */
#define	MSG_UNABLE_OPEN_TEMP_FILE	"   "
#define	MSG_NEWS_POST_CANCELLED		"  !"
#define	MSG_POST_THIS_MESSAGE		"  ? (y/n) "

/* LYOptions.c */ /* option_statusline() */
#define	MSG_ACCEPT_DATA			" ENTER   "
#define	MSG_CHANGE_EDITOR_DISABLED	"   "
#define	MSG_CHANGE_BOOKMARK_DISABLED	"   bookmark "
#define	MSG_CHANGE_SETTING_DISABLED	"    "
#define	MSG_SAVED			"!"
#define	MSG_OPTION_SAVING_DISABLED	"  !"
#define	MSG_R_TO_RETURN_LYNX		"'R'    Lynx"
#define	MSG_ANYKEY_TO_CHANGE_VALUE	"     , ENTER   "
#define	MSG_VALUE_ACCEPTED		" "

/* LYPrint.c */
#define	MSG_PRINT_REQUEST_CANCELLED	"   !"
#define	MSG_UNABLE_OPEN_OUTPUT_FILE	"   !"
#define	MSG_ENTER_VALID_EMAIL		"  e-mail : "
#define	MSG_MAIL_REQUEST_CANCELLED	"  !"
#define	MSG_UNABLE_MAIL_FILE		" -   !"
#define	MSG_UNABLE_OPEN_TEMPFILE	"   !"
#define	MSG_FILE_SCREENS_LONG		"    %d .      ? [y]"
#define	MSG_FILE_PAGES_LONG		"    %d .      ? [y]"
#define	MSG_PRESS_RETURN_TO_BEGIN	" ENTER  "
#define	MSG_UNABLE_ALLOCATE_SPACE	" -     !"
#define	MSG_PRINTER_MISCONFIGURED	" -   !"
#define	MSG_UNABLE_OPEN_PRINT_OPTIONS	"    !"
#define	MSG_MAILING_TO_YOUSELF		"  %s..."

/* LYSearch.c */
#define	MSG_ENTER_SEARCH_STRING		"  : "

/* LYShowInfo.c */
#define	MSG_LINK_STATUS_FAIL		"    !"

/* LYUpload.c */
#define	MSG_ILLEGAL_REDIR_USING_CHAR	"   \"~\" .  !"
#define	MSG_UPLOAD_MISCONFIGURED	" -   "
#define	MSG_UNABLE_UPLOAD_FILE		"  "

/* LYUtils.c */
#define NOVICE_LINE_ONE			"   : UP,DOWN - ; RIGHT - ; LEFT -   \n"
#define NOVICE_LINE_TWO			"  H- O- P- G- M- Q- /- DEL-   \n"
#define NOVICE_LINE_TWO_A		"  O-_ H- K- G- M- o- Q-      \n"
#define NOVICE_LINE_TWO_B		"  O-_ B- E- D- ^R- /-   \n"
#define NOVICE_LINE_TWO_C		"  O-_ C- DEL- V- A- R- \n"
#define DIRED_NOVICELINE		"  C)reate  D)ownload  E)dit  F)ull menu  M)odify  R)emove  T)ag  U)pload     \n"
#define	MSG_HAVE_UNREAD_MAIL		"***     ***"
#define	MSG_HAVE_NEW_MAIL		"***     ***"

#else /* ENGLISH */

/* GridText.c */
#define	MSG_ENTER_DATABASE_ENTRY	"Enter a database query: "
#define	MSG_EDIT_CURRENT_QUERY		"Edit the current query: "
#define	MSG_TO_RESUBMIT_QUERY		"Use Control-R to resubmit the current query."
#define	MSG_SUBMITING_FORM		"submitting form"
#define	MSG_RESETTING_FORM		"resetting form..."
#define MSG_WWW_WAIT_MESSAGE		"Getting %s"

/* HTFWriter.c */
#define	MSG_EXECUTION_DISABLED		"Execution is disabled."
#define	MSG_EXECUTION_NOT_ENABLED	"Execution is not enabled for this file.  See the O)ptions menu. (Press 'o')"
#define	MSG_FILE_CANT_BE_DISPLAYED	"This file cannot be displayed on this terminal:  D)ownload, or C)ancel"
#define	MSG_CANCELLING_FILE		"Cancelling file."
#define	MSG_RETRIEVING_FILE		"Retrieving file.  - PLEASE WAIT -"

/* LYBookmark.c */
#define	MSG_BOORMARK_NOT_DEFINED	"Bookmark file is not defined. Use 'O' to see options"
#define	MSG_UNABLE_OPEN_HOTLIST		"Unable to open tempfile for X Mosaic hotlist conversion"
#define	MSG_UNABLE_OPEN_BOOKMARK	"ERROR - unable to open bookmark file"
#define	MSG_ALL_DONE			"Done!"
#define	MSG_UNABLE_BF_DELETE_LINK	"Unable to open bookmark file for deletion of link."
#define	MSG_UNABLE_SF_DELETE_LINK	"Unabel to open scratch file for deletion of link."
#define	MSG_UNABLE_TF_DELETE_LINK	"Unable to open temporary file for deletion of link."
#define	MSG_ERROR_RENAME_SF		"Error renaming scratch file."
#define	MSG_ERROR_RENAME_TF		"Error renaming temporary file."
#define	MSG_BOOKMARK_DELETE_FAIL	"Bookmark deletion failed."

/* LYClean.c */
#define	MSG_REALLY_EXIT_LYNX		"Really exit from Lynx? [Y] "

/* LYDownload.c */
#define	MSG_ENTER_FILENAME		"Enter a filename: "
#define	MSG_FILE_EXIST_CREATE		"File exists. Create higher version? (y/n)"
#define	MSG_FILE_EXIST_OVERWRITE	"File exists. Overwrite? (y/n)"
#define	MSG_CANT_WRITE_FILE		"Cannot write to file. Enter a new filename: "
#define	MSG_SAVING			"Saving....."
#define	MSG_DOWNLOAD_MISCONFIGURED	"ERROR! - download command is misconfigured"
#define	MSG_UNABLE_DOWNLOAD_FILE	"Unable to download file"
#define	MSG_CANCELLING			"Cancelling"
#ifdef	BBS
#define	MSG_BAD_FILENAME_ENTERED	"You entered a bad filename!"
#endif

/* LYEdit.c */
#define	MSG_CAN_EDIT_REMOTE		"Lynx cannot currently edit remote WWW files"
#define	MSG_YOU_CANT_EDIT_FILE		"You are not authorized to edit this file."

/* LYForms.c */
#define	MSG_RADIO_BUTTON_CHECKED	"One radio button must be checked at all times!"
#define	MSG_WANT_PREVIOUS_DOC		"Do you want to go back to the previous document? [n]"
#define	MSG_ENTER_TEXT			"Enter text. Use arrows or tab to move off of field."
#define	MSG_LINK_ALREADY_SELECTED	"Link already selected!"
#define	MSG_MAX_LENGTH_REACHED		"Maximum length reached!"

/* LYGetFile.c */
#define	MSG_NEWS_POSTING_DISABLED	"News posting is disabled!"
#define	MSG_FILE_MANAGER_DISABLED	"File management support is disabled!"
#define	MSG_EXECUTION_DISABLED		"Execution has been disabled by system administrator."
#define	MSG_EXECUTION_NOT_ENABLED	"Execution is not enabled for this file.  See the O)ptions menu. (Press 'o')"
#define	MSG_EXECUTION_NOT_COMPILED	"Execution capibilities are not compiled into this version"
#define	MSG_TELNET_ACCESS_DISABLED	"Telnet access is disabled!"
#define	MSG_USENET_ACCESS_DISABLED	"USENET news access is disabled!"
#define	MSG_RLOGIN_ACCESS_DISABLED	"Rlogin access is disabled!"
#define	MSG_MAIL_ACCESS_DISABLED	"Mail access is disabled!"
#define	MSG_FTP_ACCESS_DISABLED		"Ftp access is disabled!"
#define	MSG_FOLLOW_LINK_NUMBER		"follow link number: "
#define	MSG_CANCELLED			"Cancelled!!!"
#define RETURN_TO_LYNX			"Press <return> to return to Lynx"

/* LYJump.c */
#define	MSG_JUMP_TO			"Jump to (use '?' for list): "
#define	MSG_CAN_LOCATE_JUMP_FILE	"Cannot locate jump file"
#define	MSG_OUT_MEMORY_JUMP_FILE	"Out of memory reading jump file"
#define	MSG_CANT_OPEN_JUMP_FILE		"Cannot open jump file"
#define	MSG_ERROR_READING_JUMP_FILE	"Error reading jump file"
#define	MSG_OUT_MEMORY_JUMP_TABLE	"Out of memory for jump table"

/* LYLocal.c */
#define	MSG_REMOVE_TAG_FILES		"Remove all tagged files and directories (y or n): "
#define	MSG_ENTER_NEW_TAG_LOCATION	"Enter new location for tagged items: "
#define	MSG_SRC_DST_ARE_EQUAL		"Source and destination are the same location - request ignored!"
#define	MSG_DST_DIFF_OWNER		"Destination has different owner! Request denied. "
#define	MSG_DST_NOT_VALID_DIR		"Destination is not a valid directory! Request denied. "
#define	MSG_ENTER_NEW_DIRNAME		"Enter new name for directory: "
#define	MSG_ENTER_NEW_FILENAME		"Enter new name for file: "
#define	MSG_ITEM_NOT_FILE_OR_DIR	"The selected item is not a file or a directory! Request ignored. "
#define	MSG_FOUND_ILLEGAL_REDIRECTION	"Illegal redirection \"../\" found! Request ignored. "
#define	MSG_FOUND_ILLEGAL_CHARACTER	"Illegal character \"/\" found! Request ignored. "
#define	MSG_UNABLE_PROCESS_REQUEST	"Unable to process request due to system error! "
#define	MSG_UNABLE_COMPLETE_REQUEST	"Unable to complete request due to system error! "
#define	MSG_FAILURE_COMPLETE_REQUEST	"Possible failure to complete request due to system error! "
#define	MSG_DIR_ALREADY_EXIST		"There is already a directory with that name! Request ignored. "
#define	MSG_FILE_ALREADY_EXIST		"There is already a file with that name! Request ignored. "
#define	MSG_NAME_ALREADY_IN_USE		"The specified name is already in use! Request ignored. "
#define	MSG_ENTER_NEW_DIR_LOCATION	"Enter new location for directory: "
#define	MSG_ENTER_NEW_FILE_LOCATION	"Enter new location for file: "
#define	MSG_UNABLE_FIND_TRAILER		"Unexpected failure - unable to find trailing \"/\""
#define	MSG_MODIFY_NAME_OR_LOCATION	"Modify name or location (n or l): "
#define	MSG_NOT_IMPLEMENTED_YET		"This feature not yet implemented! "
#define MSG_ENTER_FILENAME_TO_CREATE	"Enter name of file to create: "
#define	MSG_ENTER_DIRNAME_TO_CREATE	"Enter name for new directory: "
#define	MSG_CREATE_FILE_OR_DIR		"Create file or directory (f or d): "
#define	MSG_UNABLE_OPEN_MENU_FILE	"Unable to open file management menu file"

/* LYMail.c */
#define	MSG_COMMENT_REQUEST_CANCELLED	"Comment request cancelled!!!"
#define	MSG_WANT_ORIGINAL_MESSAGE	"Do you wish to include the original message? (y/n) "
#define	MSG_SPAWNING_EDITOR		"Spawning your selected editor to edit mail message"
#define	MSG_ERROR_SPAWNING_EDITOR	"Error spawning editor, check your editor definition in the options menu"
#define	MSG_SEND_THIS_COMMENT		"Send this comment? (y/n) "
#define	MSG_SENDING_MESSAGE		"Sending your message...."

/* LYMainLoop.c */
#define FORM_NOVICELINE_ONE		"            Enter text into the field by typing on the keyboard              "
#define FORM_NOVICELINE_TWO		"    Ctrl-U to delete all text in field, [Backspace] to delete a character    "
#define MSG_HELP			"Commands: Use arrow keys to move, '?' for help, 'q' to quit, '<-' to go back"
#define MSG_MORE_HELP			"-- press space for more, use arrow keys to move, '?' for help, 'q' to quit"
#define MSG_SOURCE_HELP			"Currently viewing document source.  Press '\\' to return to rendered version"
#define MSG_FORM_LINK_PASSWORD		"(Password entry field) Enter text. Use UP or DOWN arrows or tab to move off."
#define MSG_FORM_LINK_OPTION_LIST	"(Option list)  Hit return and use arrow keys and return to select option"
#define MSG_FORM_LINK_CHECKBOX		"(Checkbox Field)   Use right-arrow or <return> to toggle."
#define MSG_FORM_LINK_SUBMIT		"(Form submit button) Use right-arrow or <return> to submit ('x' for no cache)."
#define MSG_FORM_LINK_RESET		"(Form reset button)   Use right-arrow or <return> to reset form to defaults."
#define MSG_FORM_LINK_TEXT		"(Text entry field) Enter text. Use UP or DOWN arrows or tab to move off."
#define MSG_NORMAL_LINK			"(NORMAL LINK)   Use right-arrow or <return> to activate"
#define MSG_WWW_INDEX_MORE		"--More--  This is a searchable index.  Use 's' to search"
#define MSG_WWW_INDEX			"This is a searchable index.  Use 's' to search"
#define MSG_MORE			"-- press space for next page --"
#define MSG_BAD_LINK_NUM_ENTERED	"You have entered an invalid link number"
#define MSG_QUIT			"Are you sure you want to quit? [Y] "
#define	MSG_EXCELLENT			"Excellent!"
#define	MSG_ALREADY_END_OF_DOC		"You are already at the end of this document."
#define	MSG_ALREADY_BEGIN_OF_DOC	"You are already at the beginning of this document."
#define	MSG_ALREADY_TOP_OF_DOC		"You're already at the top of this document"
#define	MSG_ALREADY_BOTTOM_OF_DOC	"You're already at the bottom of this document"
#define	MSG_ALREADY_AT_FIRST_DOC	"Already at the first document"
#define	MSG_NOT_SUBMISSION_BUTTON	"You are not on a form submission button."
#define	MSG_MAILTO_NOT_SUPPORTED	"Mailto form action not yet supported."
#define	MSG_RANDOM_URL_DISABLED		"Goto a random URL is disallowed!"
#define	MSG_ENTER_URL_TO_OPEN		"URL to open: "
#define	MSG_GOTO_URL_NOT_ALLOWED	"You are not allowed to goto \"file:\" URL's"
#define	MSG_NO_INDEX_AVAILABLE		"No index is currently available"
#define	MSG_X_TOGGLE_FORM_LINK		"'X' can only toggle a form link"
#define	MSG_X_TOGGLE_FORM_MODE		"'X' only toggles in forms mode"
#define	MSG_Z_TOGGLE_FORM_LINK		"'Z' can only toggle a form link"
#define	MSG_Z_TOGGLE_FORM_MODE		"'Z' only toggles in forms mode"
#define	MSG_WANT_GOTO_MAIN_SCREEN	"Do you really want to go to the Main screen? (y/n) [n] "
#define	MSG_ALREADY_MAIN_SCREEN		"Already at main screen!"
#define	MSG_NOT_SEACHABLE_INDEX_DOC	"Not a searchable indexed document -- press '/' to search for a text string"
#define	MSG_NO_OWNER_DEFINED_FILE	"No owner is defined for this file so you cannot send a comment"
#define	MSG_MAIL_IS_DISALLOWED		"Mail is disallowed so you cannot send a comment"
#define	MSG_WANT_TO_SEND_COMMENT	"Do you wish to send a comment? [N]"
#define	MSG_GET_STATUS_FAILED		"System error - failure to get status. "
#define	MSG_EDITOR_UNDEFINED		"No editor is defined!"
#define	MSG_SAVE_DLC_TO_BOOKMARK	"Save D)ocument or L)ink to bookmark file or C)ancel? (d,l,c): "
#define	MSG_CANT_SAVE_FORM		"Cannot save form fields/links"
#define	MSG_SAVE_DC_TO_BOOKMARK		"Save D)ocument to bookmark file or C)ancel? (d,c): "
#define	MSG_CANT_SAVE_BOOKMARK		"History and Print files cannot be saved in the bookmark page"
#define	MSG_WANT_TO_DELETE_BOOKMARK	"Do you really want to delete this link from your bookmark file? (y/n)"
#define	MSG_REMOVE_ONLY_PAGE_LINKS	"Remove only works on bookmark page links"
#define	MSG_UNABLE_OPEN_HOME_PAGE	"Unable to open Home page, use 'a' to save a link first"
#define	MSG_SHELL_ESCAPE_DISABLED	"The (!) command is currently disabled"
#define	MSG_CANT_DOWNLOAD_FIELD		"You cannot download a input field"
#define	MSG_NOTHING_TO_DOWNLOAD		"Nothing to download"
#define	MSG_JUMPING_URL_DISALLOWED	"Jumping to shortcut URL is disallowed!"
#define MSG_NO_JUMPFILE			"No jump file is currently available"

/* LYNews.c (some other msgs included from LYMail.c section above) */
#define	MSG_UNABLE_OPEN_TEMP_FILE	"Unable to open temp file"
#define	MSG_NEWS_POST_CANCELLED		"News Post Cancelled!!!"
#define	MSG_POST_THIS_MESSAGE		"Post this message? (y/n) "

/* LYOptions.c */ /* option_statusline() */
#define	MSG_ACCEPT_DATA			"Hit return to accept entered data"
#define	MSG_CHANGE_EDITOR_DISABLED	"You are not allowed to change which editor to use!"
#define	MSG_CHANGE_BOOKMARK_DISABLED	"You are not allowed to change the bookmark file!"
#define	MSG_CHANGE_SETTING_DISABLED	"You are not allowed to change this setting!"
#define	MSG_SAVED			"Saved!"
#define	MSG_OPTION_SAVING_DISABLED	"Option saving disabled!"
#define	MSG_R_TO_RETURN_LYNX		"'R' to return to lynx"
#define	MSG_ANYKEY_TO_CHANGE_VALUE	"Hit any key to change value; RETURN to accept"
#define	MSG_VALUE_ACCEPTED		"Value accepted"

/* LYPrint.c */
#define	MSG_PRINT_REQUEST_CANCELLED	"Print request cancelled!!!"
#define	MSG_UNABLE_OPEN_OUTPUT_FILE	"Unable to open output file!!!"
#define	MSG_ENTER_VALID_EMAIL		"Please enter a valid internet mail address: "
#define	MSG_MAIL_REQUEST_CANCELLED	"Mail request cancelled!!!"
#define	MSG_UNABLE_MAIL_FILE		"ERROR - Unable to mail file"
#define	MSG_UNABLE_OPEN_TEMPFILE	"Unable to open tempfile"
#define	MSG_FILE_SCREENS_LONG		"File is %d screens long. Are you sure you want to print? [y]"
#define	MSG_FILE_PAGES_LONG		"File is %d pages long. Are you sure you want to print? [y]"
#define	MSG_PRESS_RETURN_TO_BEGIN	"Press RETURN to begin: "
#define	MSG_UNABLE_ALLOCATE_SPACE	"ERROR - Unable to allocate file space!!!"
#define	MSG_PRINTER_MISCONFIGURED	"ERROR! - printer is misconfigured"
#define	MSG_UNABLE_OPEN_PRINT_OPTIONS	"Unable to open print options file"
#define	MSG_MAILING_TO_YOUSELF		"Mailing to %s..."

/* LYSearch.c */
#define	MSG_ENTER_SEARCH_STRING		"Enter a search string: "

/* LYShowInfo.c */
#define	MSG_LINK_STATUS_FAIL		"Failed to obtain status of current link!"

/* LYUpload.c */
#define	MSG_ILLEGAL_REDIR_USING_CHAR	"Illegal redirection using \"~\" found! Request ignored. "
#define	MSG_UPLOAD_MISCONFIGURED	"ERROR! - upload command is misconfigured"
#define	MSG_UNABLE_UPLOAD_FILE		"Unable to upload file"

/* LYUtils.c */
#define NOVICE_LINE_ONE			"  Arrow keys: Up and Down to move. Right to follow a link; Left to go back.  \n"
#define NOVICE_LINE_TWO			" H)elp O)ptions P)rint G)o M)ain screen Q)uit /=search [delete]=history list \n"
#define NOVICE_LINE_TWO_A		"  O)ther cmds  H)elp  K)eymap  G)oto  P)rint  M)ain screen  o)ptions  Q)uit  \n"
#define NOVICE_LINE_TWO_B		"  O)ther cmds  B)ack  E)dit  D)ownload ^R)eload ^W)ipe screen  search doc: / \n"
#define NOVICE_LINE_TWO_C		"  O)ther cmds  C)omment  History: <delete>  Bookmarks: V)iew, A)dd, R)emove  \n"
#define DIRED_NOVICELINE		"  C)reate  D)ownload  E)dit  F)ull menu  M)odify  R)emove  T)ag  U)pload     \n"
#define	MSG_HAVE_UNREAD_MAIL		"*** You have unread mail. ***"
#define	MSG_HAVE_NEW_MAIL		"*** You have new mail. ***"

#endif /* RUSSIAN */
