#include <sys/types.h>
#include <sys/stat.h>

#ifdef	HAVE_FTS	/* use traverse a file hierarchy functions */

#include <fts.h>
#include <unistd.h>
#include <errno.h>

/*
 * Delete directories tree.
 * Return: -1 on error or 0 for success.
 */
deldirtree(dirname)
	char *dirname;
{
	register FTS *fts;
	register FTSENT *p;
	char *av[2];
	extern int errno;

	av[0] = dirname;
	av[1] = NULL;
	if (!(fts = fts_open(av, FTS_PHYSICAL | FTS_NOSTAT, (int (*)())NULL)))
		return -1;
	while ((p = fts_read(fts)) != NULL) {
		switch (p->fts_info) {
			case FTS_DNR:
			case FTS_ERR:
				fts_close(fts);
				return -1;
			case FTS_D:
				continue;
		}
		if (p->fts_info == FTS_DP || p->fts_info == FTS_DNR) {
			if (!rmdir(p->fts_accpath) || errno == ENOENT)
				continue;
		} else	if (!unlink(p->fts_accpath) || errno == ENOENT)
				continue;
		fts_close(fts);
		return -1;		
	}
	fts_close(fts);
	return 0;
}

#else	/* use rm program */

#include <stdio.h>
#include <stdlib.h>

#if defined(SVR4)
#define	SYS_RM	"/usr/bin/rm -rf"
#else /* BSD, SVR3, Linux */
#define	SYS_RM	"/bin/rm -rf"
#endif

/*
 * Delete directories tree.
 * Return 0 for success.
 */
deldirtree(dirname)
	char *dirname;
{
	int len;
	struct stat st;
	char buf[1024];

	if (stat(dirname, &st) < 0 || (st.st_mode & S_IFMT) != S_IFDIR)
		return -1;
	len = sprintf(buf, "%s %s", SYS_RM, dirname);
	if (buf[len-1] == '/') buf[len-1] = '\0';
	return system(buf);
}

#endif	/* HAVE_FTS */
