/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <varargs.h>
#include <syslog.h>
#include <unistd.h>
#include <paths.h>

#include "gettytab.h"
#include "pathnames.h"

extern char *mytty;

static struct sockaddr_in *hin = NULL;
static int hn = 0;
static int s = -1;

int
initnet(flag)
	int flag;
{
	register char *cp;
	FILE *fp;
	char buf[256];
	int on = 1;

	hin = NULL;
	hn = 0;
	s = -1;
	if (!flag) return 0;
	if ((fp = fopen(_PATH_GETTYLOG, "r")) == NULL) return 0;
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		if ((cp = strchr(buf, '#')) != NULL) *cp = '\0';
		if ((cp = strchr(buf, '\n')) != NULL) *cp = '\0';
		if (!buf[0]) continue;
		for (cp = buf; (u_char)*cp > 0x20; cp++);
		if (*cp != 0)
			for (*cp++ = 0; (u_char)*cp <= 0x20 && *cp != 0; cp++);
		if ((hin = realloc(hin, ++hn * sizeof(struct sockaddr_in))) == NULL) {
			syslog(LOG_ERR, "%s: can't allocate memory", mytty);
			fclose(fp);
			return 0;
		}
		if (atoi(buf) > 0) {
			hin[hn-1].sin_family = AF_INET;
			hin[hn-1].sin_addr.s_addr = inet_addr(buf);
		} else {
			struct hostent *hp;

			if ((hp = gethostbyname(buf)) == NULL) {
				syslog(LOG_ERR, "%s: gethostbyname: %s: Unknown host", mytty, buf);
				fclose(fp);
				return 0;
			}
			hin[hn-1].sin_family = hp->h_addrtype;
			bcopy(hp->h_addr, (char *)&hin[hn-1].sin_addr, hp->h_length);
		}
		if (*cp) hin[hn-1].sin_port = htons(atoi(cp));
		else {
			struct servent *sp;

			if ((sp = getservbyname(SERVICE_NAME, "udp")) == NULL) {
				syslog(LOG_ERR, "%s: getservbyname: %s/udp: Unknown service", mytty, SERVICE_NAME);
				fclose(fp);
				return 0;
			}
			hin[hn-1].sin_port = sp->s_port;
		}
	}
	fclose(fp);

	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		syslog(LOG_ERR, "%s: socket: %m", mytty);
		return 0;
	}
	if (dup2(s, 7) < 0) {
		syslog(LOG_ERR, "%s: dup2: %m", mytty);
		close(s);
		s = -1;
		return 0;
	}
	close(s);
	s = 7;
	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &on, sizeof (on)) < 0) {
		syslog(LOG_ERR, "%s: setsockopt(SO_REUSEADDR): %m", mytty);
		close(s);
		s = -1;
		return 0;
	}
	if (setsockopt(s, SOL_SOCKET, SO_BROADCAST, &on, sizeof (on)) < 0) {
		syslog(LOG_ERR, "%s: setsockopt(SO_BROADCAST): %m", mytty);
		close(s);
		s = -1;
		return 0;
	}
	return 1;
}

/*
 * Send message as "H:host~T:tty~..."
 */
message(va_alist)
	va_dcl
{
	register char *cp;
	register i;
	int j;
	char buf[256];
	va_list ap;

	if (s < 0) return;

	i = 0;
	buf[i++] = 'H';
	buf[i++] = ':';
	cp = HN;	/* hostname */
	while (*cp && *cp != '.') buf[i++] = *cp++;
	buf[i++] = '~';

	buf[i++] = 'T';
	buf[i++] = ':';
	cp = mytty + 3;	/* skip `tty' */
	while (*cp) buf[i++] = *cp++;
	buf[i++] = '~';

	va_start(ap);
	cp = va_arg(ap, char *);
	i += vsnprintf(&buf[i], sizeof(buf)-i, cp, ap);
	va_end(ap);

	for (j = 0; j < hn; j++)
		if (sendto(s, (char *)buf, i, 0,
			      (struct sockaddr *)(hin + j), sizeof(struct sockaddr)) < 0)
			syslog(LOG_ERR, "%s: sendto: %m", mytty);
}
