/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <fcntl.h>
#include <curses.h>
#include <string.h>
#include <signal.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <errno.h>
#include <netinet/in.h>

#define	HOST	"H:"
#define	LINE	"T:"
#define	MODEM	"M:"
#define	LOGIN	"L:"
#define	ERROR	"E:"
#define	PROCESS	"P:"

#define	MAXLINES	20
#define	SCR_OFFS	4
#define	MAXHOSTS	5

void onterm();
void onenter();
extern int errno;
extern int initnet();
extern char *waitmsg();
extern struct sockaddr_in from;

int fdowner, fdflags;

struct {
	char *host;
	char *line;
	char *msg;
} pkt;

struct {
	int tn;
	int lf;
	time_t lt;
} scrtty[MAXHOSTS][MAXLINES];

int	ntty[MAXHOSTS];
char	hname[MAXHOSTS][MAXHOSTNAMELEN];
int	chost, dhost;
WINDOW *win[MAXHOSTS];

main(argc, argv)
	int argc;
	char **argv;
{
	int i = 0, nbad;
	time_t clk, clkdiff;
	struct tm *tm;
	char *ptr, work[10];
/*	double avenrun[3]; */

	if (argc > 1) i = atoi(argv[1]);

	if (!initnet(i)) exit(1);

	signal(SIGHUP, onterm);
	signal(SIGINT, onterm);
	signal(SIGQUIT, onterm);
	signal(SIGTERM, onterm);
	signal(SIGTSTP, onterm);
	signal(SIGIO, onenter);

	initscr();
	noecho();

	fdowner = fcntl(0, F_GETOWN, 0);
	fdflags = fcntl(0, F_GETFL, 0);
	fcntl(0, F_SETOWN, getpid());
	fcntl(0, F_SETFL, FASYNC);

	addstr("========================= NetGetty TTY Status Monitor ==========================");
	if (i) sprintf(work, "%d", i);
	else strcpy(work, "ngetty");
	if (gethostname(hname[0], MAXHOSTNAMELEN) < 0)
		strcpy(hname[0], "Amnesiac");
        printw("%s listen on %.6s/udp\n\n", hname[0], work);
	printw(" TTY   LogIn     LastTime IdleTime  ModemStatus");
	move(0, 79);
	refresh();

	nbad = chost = dhost = 0;
	clk = time(NULL);
	for (i = 0; i < MAXHOSTS; i++) {
		register j;
		ntty[i] = 0;
		hname[i][0] = '\0';
		win[i] = newwin(MAXLINES, 80, SCR_OFFS, 0);
		for (j = 0; j < MAXLINES; j++) {
			scrtty[i][j].tn = 0xFF;
			scrtty[i][j].lf = 0;
			scrtty[i][j].lt = clk;
		}
	}
	while ((ptr = waitmsg()) != NULL) {
		clk = time(NULL);
		tm = localtime(&clk);
/*		getloadavg(avenrun, sizeof(avenrun) / sizeof(avenrun[0]));
		move(1, 36);
		for (i = 0; i < (sizeof(avenrun) / sizeof(avenrun[0])); i++)
			printw(" %.2f", avenrun[i]);
*/		move(1, 61);
		printw("%-19.19s", ctime(&clk));
		switch(parsedata(ptr)) {
		case 1:
		case 3:
			if ((i = numinsert(pkt.line)) >= 0) {
				wmove(win[chost], i, 35);
				wprintw(win[chost]," %-40.40s", pkt.msg);
				if (scrtty[chost][i].lf) {

					scrtty[chost][i].lf = 0;
					wmove(win[chost], i, 6);
					waddch(win[chost],'(');
					wmove(win[chost], i, 15);
					waddch(win[chost],')');
					wmove(win[chost], i, 16);
					wprintw(win[chost]," %02d:%02d:%02d ",
						tm->tm_hour, tm->tm_min, tm->tm_sec);
					scrtty[chost][i].lt = clk;
				}
				clkdiff = clk - scrtty[chost][i].lt;
				if (clkdiff > 0) {
					tm->tm_hour = clkdiff / 3600;
					tm->tm_min = (clkdiff % 3600) / 60;
					tm->tm_sec = (clkdiff % 3600) % 60;
					wmove(win[chost], i, 25);
					wprintw(win[chost]," %02d:%02d:%02d ",
						tm->tm_hour, tm->tm_min, tm->tm_sec);
				}
			}
			break;
		case 2:
			if ((i = numinsert(pkt.line)) >= 0) {
				wmove(win[chost], i, 16);
				wprintw(win[chost]," %02d:%02d:%02d ",
				       tm->tm_hour, tm->tm_min, tm->tm_sec);
				wmove(win[chost],i , 6);
				wprintw(win[chost]," %-8.8s ", pkt.msg);
				scrtty[chost][i].lf++;
				scrtty[chost][i].lt = clk;
				wmove(win[chost],i , 25);
				waddstr(win[chost]," -------- ");
			}
			break;
		default:
			move(24, 0);
			printw("Bad packet from %s (#%d at %02d:%02d:%02d)",
			       inet_ntoa(from.sin_addr), ++nbad, tm->tm_hour,
			       tm->tm_min, tm->tm_sec);
			clrtoeol();
		}
		move(SCR_OFFS-1, 61);
		printw("HOST: %-13.13s", hname[dhost]);
		refresh();
		wrefresh(win[dhost]);
	}
	onterm();
}

tsthost()
{
	register i;

	for (i = 0; i < MAXHOSTS; i++) {
		if (!hname[i][0]) {
			strcpy(hname[i], pkt.host);
			move(24, 0);
			printw("Host %s logged. <Enter> - next host.", hname[i]);
			clrtoeol();
			return i;
		}
		if (!strcmp(hname[i], pkt.host))
			return i;
	}
	return -1;
}

numinsert(str)
	char *str;
{
	register i;
	int j, n;

	if ((i = tsthost()) < 0) {
		move(24, 0);
		printw("Hosts table full (max %d), host %s (%s) discard",
		       MAXHOSTS, pkt.host, inet_ntoa(from.sin_addr));
		clrtoeol();
		return -1;
	}
	chost = i;
	errno = 0;
	n = strtol(str, NULL, 16);
	if (errno) return -1;
	for (i = 0; i < ntty[chost]; i++) {
		if (scrtty[chost][i].tn == n) return i;
		if (scrtty[chost][i].tn > n) break;
	}
	if (i >= MAXLINES) {
		move(24, 0);
		printw("TTY table full (max %d), tty%02X (%s) discard",
		       MAXLINES, n, inet_ntoa(from.sin_addr));
		clrtoeol();
		return -1;
	}
	for (j = ntty[chost]++; j > i; j--) {
		scrtty[chost][j].tn = scrtty[chost][j-1].tn;
		scrtty[chost][j].lf = scrtty[chost][j-1].lf;
		scrtty[chost][j].lt = scrtty[chost][j-1].lt;
	}
	scrtty[chost][i].tn = n;
	wmove(win[chost], i, 0);
	winsertln(win[chost]);
	wprintw(win[chost],"tty%02X ", n);
	return i;
}

parsedata(str)
	register char *str;
{
	int i = 0;
	register char *ptr;

	if ((ptr = strstr(str, HOST)) == NULL) return 0;
	pkt.host = ptr + strlen(HOST);
	if ((ptr = strstr(str, LINE)) == NULL) return 0;
	pkt.line = ptr + strlen(LINE);
	if ((ptr = strstr(str, MODEM)) != NULL)
		pkt.msg = ptr + strlen(MODEM), i += 1;
	if ((ptr = strstr(str, LOGIN)) != NULL)
		pkt.msg = ptr + strlen(LOGIN), i += 2;
	if ((ptr = strstr(str, ERROR)) != NULL)
		pkt.msg = ptr + strlen(ERROR), i += 3;
	ptr = str;
	while ((ptr = index(ptr, '~')) != NULL) *ptr++ = 0;
	for (ptr = pkt.msg; isprint(*ptr); ptr++);
	*ptr = 0;
	return i;
}

void
onenter()
{
	move(24, 0);
	if (hname[0][0]) {
		dhost++;
		if (dhost >= MAXHOSTS) {
			dhost = 0;
			addstr("Hosts table exceed. ");
		}
		if (hname[dhost][0] == '\0') {
			dhost = 0;
			addstr("No more hosts whiles. ");
		}
		printw("Switched to host %s.", hname[dhost]);
	} else 	addstr("No one logged host.");
	clrtoeol();
	move(SCR_OFFS-1, 61);
	printw("HOST: %-13.13s", hname[dhost]);
	refresh();
	touchwin(win[dhost]);
	wrefresh(win[dhost]);
}

void
onterm()
{
	fcntl(0, F_SETFL, fdflags);
	fcntl(0, F_SETOWN, fdowner);
	clear();
	refresh();
	endwin();
	exit(0);
}
