<?php
/***************************************************************************
*                             admin_mass_email.php
*                              -------------------
*     begin                : Thu May 31, 2001
*     copyright            : (C) 2001 The phpBB Group
*     email                : support@phpbb.com
*
*     $Id: admin_mass_email.php,v 1.15 2002/04/02 21:13:47 the_systech Exp $
*
****************************************************************************/

/***************************************************************************
 *   This file is part of the phpBB2 port to Nuke 5.5 (c) copyright 2002
 *   by Tom Nitzschner (tom@toms-home.com)
 *   http://bbtonuke.sourceforge.net (or http://www.toms-home.com)
 *
 *   As always, make a backup before messing with anything. All code
 *   release by me is considered sample code only. It may be fully
 *   functual, but you use it at your own risk, if you break it,
 *   you get to fix it too. No waranty is given or implied.
 *
 *   Please post all questions/request about this port on http://www.nukeforums.com first,
 *   then on my site. All original header code and copyright messages will be maintained
 *   to give credit where credit is due. If you modify this, the only requirement is
 *   that you also maintain all original copyright messages. All my work is released
 *   under the GNU GENERAL PUBLIC LICENSE. Please see the README for more information.
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['General']['Mass_Email'] = $filename;
	
	return;
}

//
// Load default header
//
$no_page_header = TRUE;
$phpbb_root_path = "../";
require($phpbb_root_path . 'extension.inc');
require('pagestart.' . $phpEx);

//
// Increase maximum execution time in case of a lot of users, but don't complain about it if it isn't
// allowed.
//
@set_time_limit(1200);

$message = "";
$subject = "";

//
// Do the job ...
//
if( isset($HTTP_POST_VARS['submit']) )
{
	$group_id = intval($HTTP_POST_VARS[POST_GROUPS_URL]);

	if( $group_id != -1 )
	{
		$sql = "SELECT u.email 
			FROM " . USERS_TABLE . " u, " . USER_GROUP_TABLE . " ug
			WHERE ug.group_id = $group_id 
				AND ug.user_pending <> " . TRUE . "  
				AND u.uid = ug.user_id";
	}
	else
	{
		$sql = "SELECT email 
			FROM " . USERS_TABLE;
	}

	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Coult not select group members!", __LINE__, __FILE__, $sql);
	}

	if( !$db->sql_numrows($result) )
	{
		//
		// Output a relevant GENERAL_MESSAGE about users/group
		// not existing
		//
	}

	$email_list = $db->sql_fetchrowset($g_result);
	
	$subject = stripslashes($HTTP_POST_VARS["subject"]);
	$message = stripslashes($HTTP_POST_VARS["message"]);
	
	//
	// Error checking needs to go here ... if no subject and/or
	// no message then skip over the send and return to the form
	//
	$error = FALSE;

	if( !$error )
	{
		include($phpbb_root_path . 'includes/emailer.'.$phpEx);
		//
		// Let's do some checking to make sure that mass mail functions
		// are working in win32 versions of php.
		//
		if( preg_match('/[c-z]:\\\.*/i', getenv('PATH')) && !$board_config['smtp_delivery'])
		{
			// We are running on windows, force delivery to use
			// our smtp functions since php's are broken by default
			$board_config['smtp_delivery'] = 1;
			$board_config['smtp_host'] = get_cfg_var('SMTP');
		}
		$emailer = new emailer($board_config['smtp_delivery']);
	
		$email_headers = "From: " . $board_config['board_email'] . "\n";

		$bcc_list = "";
		for($i = 0; $i < count($email_list); $i++)
		{
			if( $bcc_list != "" )
			{
				$bcc_list .= ", ";
			}
			$bcc_list .= $email_list[$i]['email'];
		}
		$email_headers .= "Bcc: $bcc_list\n";
		
		$email_headers .= "Return-Path: " . $userdata['board_email'] . "\n";
		$email_headers .= "X-AntiAbuse: Board servername - " . $server_name . "\n";
		$email_headers .= "X-AntiAbuse: User_id - " . $userdata['uid'] . "\n";
		$email_headers .= "X-AntiAbuse: Username - " . $userdata['uname'] . "\n";
		$email_headers .= "X-AntiAbuse: User IP - " . decode_ip($user_ip) . "\r\n";

		$emailer->use_template("admin_send_email");
		$emailer->email_address($board_config['board_email']);
		$emailer->set_subject($subject);
		$emailer->extra_headers($email_headers);

		$emailer->assign_vars(array(
			"SITENAME" => $board_config['sitename'], 
			"BOARD_EMAIL" => $board_config['board_email'], 
			"MESSAGE" => $message)
		);
		$emailer->send();
		$emailer->reset();

		$message = $lang['Email_sent'] . "<br /><br />" . sprintf($lang['Click_return_admin_index'],  "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
	}
}	

//
// Initial selection
//

$sql = "SELECT group_id, group_name 
	FROM ".GROUPS_TABLE . "  
	WHERE group_single_user <> 1";
$g_result = $db->sql_query($sql);
$group_list = $db->sql_fetchrowset($g_result);

$select_list = '<select name = "' . POST_GROUPS_URL . '">';
$select_list .= '<option value = "-1">' . $lang['All_users'] . '</option>';

for($i = 0;$i < count($group_list); $i++)
{
	$select_list .= "<option value = \"" . $group_list[$i]['group_id'];
	$select_list .= "\">" . $group_list[$i]['group_name'] . "</option>";
}
$select_list .= "</select>";

//
// Generate page
//
include('page_header_admin.'.$phpEx);

$template->set_filenames(array(
	"body" => "admin/user_email_body.tpl")
);

$template->assign_vars(array(
	"MESSAGE" => $message,
	"SUBJECT" => $subject, 

	"L_EMAIL_TITLE" => $lang['Email'],
	"L_EMAIL_EXPLAIN" => $lang['Mass_email_explain'],
	"L_COMPOSE" => $lang['Compose'],
	"L_RECIPIENTS" => $lang['Recipients'],
	"L_EMAIL_SUBJECT" => $lang['Subject'],
	"L_EMAIL_MSG" => $lang['Message'],
	"L_EMAIL" => $lang['Email'],
	"L_NOTICE" => $notice,

	"S_USER_ACTION" => append_sid('admin_mass_email.'.$phpEx),
	"S_GROUP_SELECT" => $select_list)
);

$template->pparse('body');

include('page_footer_admin.'.$phpEx);

?>
