<?php
/***************************************************************************
 *								admin_attachments.php
 *								-------------------
 *   begin                : Wednesday, Jan 09, 2002
 *   copyright            : (C) 2002 Meik Sievertsen
 *   email                : acyd.burn@gmx.de
 *
 *   $Id: admin_attachments.php,v 2.1.1 2002/03/25 meik Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Attachments']['Manage'] = $filename . "?mode=manage";
	$module['Attachments']['Extension_control'] = $filename . "?mode=extensions";
	$module['Attachments']['Mimetypes'] = $filename . "?mode=mimetypes";
	$module['Attachments']['Mimegroups'] = $filename . "?mode=mimegroups";
	$module['Attachments']['Shadow_attachments'] = $filename . "?mode=shadow";
	return;
}

//
// Load default header
//
$phpbb_root_dir = './../';
require('pagestart.inc');

// Have not put them into constants for now...
define('INLINE_LINK', 1);
define('PHYSICAL_LINK', 2);
define('NONE_CAT', 0);
define('IMAGE_CAT', 1);
define('WMA_CAT', 2);
define('SWF_CAT', 3);

//
// Init Vars
//
$types_download = array(INLINE_LINK, PHYSICAL_LINK);
$modes_download = array('inline', 'physical');

$types_category = array(IMAGE_CAT, WMA_CAT, SWF_CAT);
$modes_category = array($lang['Category_images'], $lang['Category_wma_files'], $lang['Category_swf_files']);

if( isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = '';
}

$submit = (isset($HTTP_POST_VARS['submit'])) ? TRUE : FALSE;

//
// Begin Functions
//
function group_select($select_name, $default_group = -1)
{
	global $db;
		
	$sql = "SELECT type_id, type_name
	FROM " . ATTACH_TYPES_TABLE . "
	ORDER BY type_name";

	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't query types table", "", __LINE__, __FILE__, $sql);
	}

	$group_select = "<select name=\"$select_name\">";

	if( ( $db->sql_numrows($result) ) > 0 )
	{
		$group_name = $db->sql_fetchrowset($result);
	
		for($i = 0; $i < count($group_name); $i++)
		{

			if ( ($default_group == -1) )
			{
				$selected = ($i == 0) ? " selected=\"selected\"" : "";
			}
			else
			{
				$selected = ( $group_name[$i]['type_id'] == $default_group ) ? " selected=\"selected\"" : "";
			}

			$group_select .= "<option value=\"" . $group_name[$i]['type_id'] . "\"$selected>" . $group_name[$i]['type_name'] . "</option>";
		}
	}

	$group_select .= '</select>';

	return($group_select);
}

function download_select($select_name, $type_id = -1)
{
	global $db, $types_download, $modes_download;
		
	if ($type_id != -1)
	{
		$sql = "SELECT download_mode
		FROM " . ATTACH_TYPES_TABLE . "
		WHERE type_id = " . $type_id;

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't query types table", "", __LINE__, __FILE__, $sql);
		}
	
		$row = $db->sql_fetchrow($result);

		if( count($row) == 0 )
		{
			return ('');
		}

		$download_mode = $row['download_mode'];
	}

	$group_select = "<select name=\"$select_name\">";

	for($i = 0; $i < count($types_download); $i++)
	{
		if ($type_id == -1)
		{
			$selected = ( $types_download[$i] == INLINE_LINK ) ? " selected=\"selected\"" : "";
		}
		else
		{
			$selected = ( $row['download_mode'] == $types_download[$i] ) ? " selected=\"selected\"" : "";
		}

		$group_select .= "<option value=\"" . $types_download[$i] . "\"$selected>" . $modes_download[$i] . "</option>";
	}

	$group_select .= "</select>";

	return($group_select);
}

function category_select($select_name, $type_id = -1)
{
	global $db, $types_category, $modes_category;
		
	$sql = "SELECT type_id, category
	FROM " . ATTACH_TYPES_TABLE;

	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't query types table", "", __LINE__, __FILE__, $sql);
	}
	
	$rows = $db->sql_fetchrowset($result);
	$cats = array();
	$type_category = -1;

	if ( ($db->sql_numrows($result)) > 0 )
	{
		for($i = 0; $i < count($rows); $i++)
		{
			$cats['type_id'][] = $rows[$i]['type_id'];
			$cats['category'][] = $rows[$i]['category'];
			
			if ($type_id == $rows[$i]['type_id'])
			{
				$category_type = $rows[$i]['category'];
			}
		}
	}

	//
	// Prevent Selecting of already existing categories
	//
	$types = array(NONE_CAT);
	$modes = array('none');

	if ($type_id == -1)
	{
		// evaluate all categories and add only those not defined
		for ($i = 0; $i < count($types_category); $i++)
		{
			if (!in_array($types_category[$i], $cats['category']))
			{
				$types[] = $types_category[$i];
				$modes[] = $modes_category[$i];
			}
		}
	}
	else
	{
		// evaluate all categories and add only those not defined
		for ($i = 0; $i < count($types_category); $i++)
		{
			if (!in_array($types_category[$i], $cats['category']))
			{
				$types[] = $types_category[$i];
				$modes[] = $modes_category[$i];
			}

			if ($category_type == $types_category[$i])
			{
				$types[] = $category_type;
				$modes[] = $modes_category[$i];
			}
		}

	}
	
	$group_select = "<select name=\"$select_name\" style=\"width:100px\">";

	for($i = 0; $i < count($types); $i++)
	{
		if ($type_id == -1)
		{
			$selected = ( $types[$i] == NONE_CAT ) ? " selected=\"selected\"" : "";
		}
		else
		{
			$selected = ( $types[$i] == $category_type ) ? " selected=\"selected\"" : "";
		}

		$group_select .= "<option value=\"" . $types[$i] . "\"$selected>" . $modes[$i] . "</option>";
	}

	$group_select .= "</select>";

	return($group_select);
}

function size_select($select_name, $size_compare)
{
	global $lang;

	$size_types_text = array($lang['Bytes'], $lang['KB'], $lang['MB']);
	$size_types = array("b", "kb", "mb");

	$select_field = "<select name=\"" . $select_name . "\">";

	for ($i = 0; $i < count($size_types_text); $i++)
	{
		$selected = ($size_compare == $size_types[$i]) ? " selected=\"selected\"" : "";
		$select_field .= "<option value=\"" . $size_types[$i] . "\"$selected>" . $size_types_text[$i] . "</option>";
	}
	
	$select_field .= "</select>";

	return ($select_field);
}

function existing_post($post_id)
{
	global $db;

	$sql = "SELECT post_id
	FROM " . POSTS_TABLE . "
	WHERE post_id = " . $post_id;

	if( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Could not get post", "", __LINE__, __FILE__, $sql);
	}
	
	if( ( $db->sql_numrows($result) ) > 0 )
	{
		return (TRUE);
	}

	return (FALSE);

}

//
// sort multi-dimensional array function
//
function sort_multi_array ($sort_array, $key, $sort_order) 
{
	$last_element = count($sort_array) - 1;

	$string_sort = ( is_string($sort_array[$last_element-1][$key]) ) ? TRUE : FALSE;

	for ($i = 0; $i < $last_element; $i++) 
	{
		$num_iterations = $last_element - $i;

		for ($j = 0; $j < $num_iterations; $j++) 
		{
			$next = 0;

			//
			// do checks based on key
			//
			$switch = FALSE;
			if ( !($string_sort) )
			{
				if ( ( ($sort_order == "DESC") && (intval($sort_array[$j][$key]) < intval($sort_array[$j + 1][$key])) ) || ( ($sort_order == "ASC") &&    (intval($sort_array[$j][$key]) > intval($sort_array[$j + 1][$key])) ) )
				{
					$switch = TRUE;
				}
			}
			else
			{
				if ( ( ($sort_order == "DESC") && (strcasecmp($sort_array[$j][$key], $sort_array[$j + 1][$key]) < 0) ) || ( ($sort_order ==   "ASC") && (strcasecmp($sort_array[$j][$key], $sort_array[$j + 1][$key]) > 0) ) )
				{
					$switch = TRUE;
				}
			}

			if ($switch)
			{
				$temp = $sort_array[$j];
				$sort_array[$j] = $sort_array[$j + 1];
				$sort_array[$j + 1] = $temp;
			}
		}
	}

	return ($sort_array);
}

//
// End Functions
//

if(isset($HTTP_GET_VARS['size']) || isset($HTTP_POST_VARS['size']))
{
	$size = (isset($HTTP_POST_VARS['size'])) ? $HTTP_POST_VARS['size'] : $HTTP_GET_VARS['size'];
}
else
{
	$size = '';
}

if(isset($HTTP_GET_VARS['quota_size']) || isset($HTTP_POST_VARS['quota_size']))
{
	$quota_size = (isset($HTTP_POST_VARS['quota_size'])) ? $HTTP_POST_VARS['quota_size'] : $HTTP_GET_VARS['quota_size'];
}
else
{
	$quota_size = '';
}

$attach_config = array();

$sql = "SELECT * 
FROM " . ATTACH_CONFIG_TABLE;
	 
if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Couldn't find Attachment Config Table", "", __LINE__, __FILE__, $sql);
}

while($row = $db->sql_fetchrow($result))
{
	$config_name = $row['config_name'];
	$config_value = $row['config_value'];
	$attach_config[$config_name] = $config_value;

	$new_attach[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $attach_config[$config_name];

	if ((empty($size)) && (!$submit) && ($config_name == 'max_filesize'))
	{
		$size = ($attach_config[$config_name] >= 1048576) ? "mb" : ( ($attach_config[$config_name] >= 1024) ? "kb" : "b" );
	}

	if ((empty($quota_size)) && (!$submit) && ($config_name == 'attachment_quota'))
	{
		$quota_size = ($attach_config[$config_name] >= 1048576) ? "mb" : ( ($attach_config[$config_name] >= 1024) ? "kb" : "b" );
	}

	if ((!$submit) && (($config_name == 'max_filesize') || ($config_name == 'attachment_quota')))
	{
		if($new_attach[$config_name] >= 1048576)
		{
			$new_attach[$config_name] = round($new_attach[$config_name] / 1048576 * 100) / 100;
		}
		else if($new_attach[$config_name] >= 1024)
		{
			$new_attach[$config_name] = round($new_attach[$config_name] / 1024 * 100) / 100;
		}
	}

	if( $submit && $mode == "manage")
	{
		if ($config_name == 'max_filesize')
		{
			$new_attach[$config_name] = ( $size == "kb" ) ? round($new_attach[$config_name] * 1024) : ( ($size == "mb") ? round($new_attach[$config_name] * 1048576) : $new_attach[$config_name] );
		}
		
		if ($config_name == 'attachment_quota')
		{
			$new_attach[$config_name] = ( $quota_size == "kb" ) ? round($new_attach[$config_name] * 1024) : ( ($quota_size == "mb") ? round($new_attach[$config_name] * 1048576) : $new_attach[$config_name] );
		}

		$sql = "UPDATE " . ATTACH_CONFIG_TABLE . " 
		SET	config_value = '" . str_replace("\'", "''", $new_attach[$config_name]) . "'
		WHERE config_name = '$config_name'";

		if( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Failed to update attachment configuration for $config_name", "", __LINE__, __FILE__, $sql);
		}
	}
}

$upload_dir = ( $attach_config['upload_dir'][0] == '/' ) ? $attach_config['upload_dir'] : '../' . $attach_config['upload_dir'];

$select_size_mode = size_select('size', $size);
$select_quota_size_mode = size_select('quota_size', $quota_size);

if( $submit && $mode == 'manage')
{
	// 
	// Some tests...
	//
	$attach_config = array();

	$sql = "SELECT config_value
	FROM " . ATTACH_CONFIG_TABLE . "
	WHERE config_name = 'upload_dir'";
	 
	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Couldn't find Attachment Config Table", "", __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);

	$upload_dir = ( $row['config_value'][0] == '/' ) ? $row['config_value'] : '../' . $row['config_value'];

	$message = '';
	$error = FALSE;

	//
	// Does the target directory exist, is a directory and writeable.
	//
	if ( !file_exists($upload_dir) )
	{
		$error = TRUE;
		$err_msg = sprintf($lang['Directory_does_not_exist'], $row['config_value']) . '<br />';
	}
	
	if (!$error && !is_dir($upload_dir))
	{
		$error = TRUE;
		$err_msg = sprintf($lang['Directory_is_not_a_dir'], $row['config_value']) . '<br />';
	}
	
	if (!$error)
	{
		if ( !($fp = @fopen($upload_dir . "/0_000000.000", "w")) )
		{
			$error = TRUE;
			$err_msg = sprintf($lang['Directory_not_writeable'], $row['config_value']) . '<br />';
		}
		else
		{
			@unlink($upload_dir . "/0_000000.000");
		}
	}

	if ($error)
	{
		$message .= $err_msg . '<br />';
	}

	$message .= $lang['Attach_config_updated'] . "<br /><br />" . sprintf($lang['Click_return_attach_config'], "<a href=\"" . append_sid("admin_attachments.$phpEx?mode=manage") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

	message_die(GENERAL_MESSAGE, $message);
}

$error = FALSE;

//
// Submit specific Operations
//
if ($submit && $mode == 'extensions')
{
	//
	// Store new extension or delete selected extensions
	//
	$extension = ( isset($HTTP_POST_VARS['extension_id_list']) ) ?  $HTTP_POST_VARS['extension_id_list'] : array();

	$extension_id_sql = '';
	for($i = 0; $i < count($extension); $i++)
	{
		if( $extension_id_sql != '' )
		{
			$extension_id_sql .= ', ';
		}
		$extension_id_sql .= $extension[$i];
	}

	if( $extension_id_sql != '' )
	{
		$sql = "DELETE 
		FROM " . ATTACH_EXTENSIONS_TABLE . " 
		WHERE ext_id IN ($extension_id_sql)";

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not delete extensions", "", __LINE__, __FILE__, $sql);
		}

	}
		
	$extension = ( isset($HTTP_POST_VARS['add_extension']) ) ? trim(strip_tags($HTTP_POST_VARS['add_extension'])) : '';
	$add = ( isset($HTTP_POST_VARS['add_extension_check']) ) ? TRUE : FALSE;
		
	if ($extension != '' && $add)
	{
		// check extension
		$sql = "SELECT extension 
		FROM " . ATTACH_EXTENSIONS_TABLE;

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not query extensions", "", __LINE__, __FILE__, $sql);
		}
			
		if( ( $db->sql_numrows($result) ) > 0 )
		{
			$row = $db->sql_fetchrowset($result);

			for ($i = 0; $i < count($row); $i++)
			{
				if ($row[$i]['extension'] == $extension)
				{
					$error = TRUE;
					if( isset($error_msg) )
					{
						$error_msg .= '<br />';
					}
					$error_msg .= sprintf($lang['Extension_exist'], $extension);
				}
			}
		}
			
		if (!$error)
		{
			$sql = "INSERT INTO " . ATTACH_EXTENSIONS_TABLE . " (extension)
			VALUES ('" . $extension . "')";

			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Could not add extension", "", __LINE__, __FILE__, $sql);
			}
		
		}
	}

	if (!$error)
	{
		$message = $lang['Attach_config_updated'] . "<br /><br />" . sprintf($lang['Click_return_attach_config'], "<a href=\"" . append_sid("admin_attachments.$phpEx?mode=extensions") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
	}

}
else if ($submit && $mode == 'mimetypes')
{
	//
	// Change Mime Types ?
	//
	$mime_change_list = ( isset($HTTP_POST_VARS['mime_change_list']) ) ? $HTTP_POST_VARS['mime_change_list'] : array();
	$mime_explain_list = ( isset($HTTP_POST_VARS['mime_explain_list']) ) ? $HTTP_POST_VARS['mime_explain_list'] : array();
	$group_select_list = ( isset($HTTP_POST_VARS['group_select']) ) ? $HTTP_POST_VARS['group_select'] : array();

	$mime_to_change = array();

/*
	$sql = "SELECT m.type_id, t.mime_id, t.type_string, t.explain_mimetype
	FROM " . ATTACH_TYPECONFIG_TABLE . " t, " . ATTACH_TYPES_TABLE . " m
	WHERE t.type_id = m.type_id
	GROUP BY t.type_string, m.type_id, t.mime_id, t.explain_mimetype
	ORDER BY 't.type_string'";
*/

	$sql = "SELECT m.type_id, m.type_name, t.mime_id, t.type_string, t.explain_mimetype
	FROM " . ATTACH_TYPECONFIG_TABLE . " t, " . ATTACH_TYPES_TABLE . " m
	WHERE t.type_id = m.type_id
	ORDER BY t.type_id";

	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Couldn't get mimetype informations", "", __LINE__, __FILE__, $sql);
	}

	if( ( $db->sql_numrows($result) ) > 0 )
	{
		$mimerow = $db->sql_fetchrowset($result);

		$mimerow = sort_multi_array ($mimerow, 'type_name', 'ASC');

		if (count($mimerow) != count($mime_change_list))
		{
			message_die(GENERAL_ERROR, "Couldn't get columns", "", __LINE__, __FILE__);
		}

		for ($i = 0; $i < count($mime_change_list); $i++)
		{
			//
			// if explain or grouptype changed
			//
			if ( ($mimerow[$i]['mime_id'] == $mime_change_list[$i]) )
			{
				if ( ($mimerow[$i]['explain_mimetype'] != $mime_explain_list[$i]) || ($mimerow[$i]['type_id'] != $group_select_list[$i]) )
				{
					$mime_to_change[] = $mime_change_list[$i];
				}
			}
		}
	}

	if (count($mime_to_change) > 0)
	{
		for ($i = 0; $i < count($mime_to_change); $i++)
		{
			for ($j = 0; $j < count($mime_change_list); $j++)
			{
				if ($mime_change_list[$j] == $mime_to_change[$i])
				{
					$sql = "UPDATE " . ATTACH_TYPECONFIG_TABLE . " 
					SET type_id = " . $group_select_list[$j] . ", explain_mimetype = '" . $mime_explain_list[$j] . "'
					WHERE mime_id = " . $mime_to_change[$i];
				
					if (!$db->sql_query($sql))
					{
						message_die(GENERAL_ERROR, "Couldn't update mimetype informations", "", __LINE__, __FILE__, $sql);
					}
				}
			}
		}
	}
	
	//
	// Delete Mime Types ?
	//
	$mime_id_list = ( isset($HTTP_POST_VARS['mime_id_list']) ) ?  $HTTP_POST_VARS['mime_id_list'] : array();

	$mime_id_sql = '';
	for($i = 0; $i < count($mime_id_list); $i++)
	{
		if( $mime_id_sql != '' )
		{
			$mime_id_sql .= ', ';
		}
		$mime_id_sql .= $mime_id_list[$i];
	}

	if( $mime_id_sql != '' )
	{
		$sql = "DELETE 
		FROM " . ATTACH_TYPECONFIG_TABLE . " 
		WHERE mime_id IN ($mime_id_sql)";

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not delete mime types", "", __LINE__, __FILE__, $sql);
		}

	}
		
	//
	// Add Mime Type ?
	//
	$mimetype = ( isset($HTTP_POST_VARS['add_mime_type']) ) ?  trim(strip_tags($HTTP_POST_VARS['add_mime_type'])) : '';
	$mimeexplain = ( isset($HTTP_POST_VARS['add_mime_explain']) ) ?  trim(strip_tags($HTTP_POST_VARS['add_mime_explain'])) : '';
	$mimegroup = ( isset($HTTP_POST_VARS['add_group_select']) ) ?  intval($HTTP_POST_VARS['add_group_select']) : '';
	$add = ( isset($HTTP_POST_VARS['add_mimetype_check']) ) ? TRUE : FALSE;

	if ($mimetype != '' && $add)
	{
		$template->assign_vars(array(
			"ADD_MIME_TYPE" => $mimetype,
			"ADD_MIME_EXPLAIN" => $mimeexplain)
		);
	
		if ( !strstr($mimetype, "/") )
		{
			$error = TRUE;
			if( isset($error_msg) )
			{
				$error_msg .= '<br />';
			}
			$error_msg .= $lang['Invalid_mimetype'];
		}

		if (!$error)
		{
			//
			// check mimetype
			//
			$sql = "SELECT type_string 
			FROM " . ATTACH_TYPECONFIG_TABLE;
	
			if( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Could not query typeconfig", "", __LINE__, __FILE__, $sql);
			}
			
			if( ( $db->sql_numrows($result) ) > 0 )
			{
				$row = $db->sql_fetchrowset($result);

				for ($i = 0; $i < count($row); $i++)
				{
					if ($row[$i]['type_string'] == $mimetype)
					{
						$error = TRUE;
						if( isset($error_msg) )
						{
							$error_msg .= '<br />';
						}
						$error_msg .= sprintf($lang['Mimetype_exist'], $mimetype);
					}
				}
			}
			
			if (!$error)
			{
				$sql = "INSERT INTO " . ATTACH_TYPECONFIG_TABLE . " (type_id, type_string, explain_mimetype) 
				VALUES (" . $mimegroup . ", '" . $mimetype . "', '" . $mimeexplain . "')";
	
				if( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, "Could not add mime type", "", __LINE__, __FILE__, $sql);
				}

			}
		}
	}

	if (!$error)
	{
		$message = $lang['Attach_config_updated'] . "<br /><br />" . sprintf($lang['Click_return_attach_config'], "<a href=\"" . append_sid("admin_attachments.$phpEx?mode=mimetypes") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
	}
}
else if ($submit && $mode == 'mimegroups')
{
	//
	// Change Mime Groups ?
	//
	$mime_change_list = ( isset($HTTP_POST_VARS['mime_change_list']) ) ? $HTTP_POST_VARS['mime_change_list'] : array();
	$mime_group_list = ( isset($HTTP_POST_VARS['mime_group_list']) ) ? $HTTP_POST_VARS['mime_group_list'] : array();
	$group_allowed_list = ( isset($HTTP_POST_VARS['allowed_list']) ) ? $HTTP_POST_VARS['allowed_list'] : array();
	$download_mode_list = ( isset($HTTP_POST_VARS['download_mode_list']) ) ? $HTTP_POST_VARS['download_mode_list'] : array();
	$category_list = ( isset($HTTP_POST_VARS['category_list']) ) ? $HTTP_POST_VARS['category_list'] : array();
	$upload_image_list = ( isset($HTTP_POST_VARS['upload_image_list']) ) ? $HTTP_POST_VARS['upload_image_list'] : array();
	$filesize_list = ( isset($HTTP_POST_VARS['max_filesize_list']) ) ? $HTTP_POST_VARS['max_filesize_list'] : array();
	$size_select_list = ( isset($HTTP_POST_VARS['size_select_list']) ) ? $HTTP_POST_VARS['size_select_list'] : array();

	$allowed_list = array();

	for ($i = 0; $i < count($group_allowed_list); $i++)
	{
		for ($j = 0; $j < count($mime_change_list); $j++)
		{
			if ($group_allowed_list[$i] == $mime_change_list[$j])
			{
				$allowed_list[$j] = '1';
			}
		}
	}

	for ($i = 0; $i < count($mime_change_list); $i++)
	{
		$allowed = ( isset($allowed_list[$i]) ) ? '1' : '0';
		
		$filesize_list[$i] = ( $size_select_list[$i] == "kb" ) ? round($filesize_list[$i] * 1024) : ( ($size_select_list[$i] == "mb") ? round($filesize_list[$i] * 1048576) : $filesize_list[$i] );

		$sql = "UPDATE " . ATTACH_TYPES_TABLE . " 
		SET type_name = '" . $mime_group_list[$i] . "', category = " . $category_list[$i] . ", allow_type = " . $allowed . ", download_mode = " . $download_mode_list[$i] . ", upload_image = '" . $upload_image_list[$i] . "', max_filesize = " . $filesize_list[$i] . "
		WHERE type_id = " . $mime_change_list[$i];
		
		if (!$db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, "Couldn't update mimegroup informations", "", __LINE__, __FILE__, $sql);
		}
	}
	
	//
	// Delete Mime Groups ?
	//
	$group_id_list = ( isset($HTTP_POST_VARS['group_id_list']) ) ?  $HTTP_POST_VARS['group_id_list'] : array();

	$group_id_sql = '';
	for($i = 0; $i < count($group_id_list); $i++)
	{
		if( $group_id_sql != '' )
		{
			$group_id_sql .= ', ';
		}
		$group_id_sql .= $group_id_list[$i];
	}

	if ($group_id_sql != '')
	{
		$sql = "DELETE 
		FROM " . ATTACH_TYPES_TABLE . " 
		WHERE type_id IN ($group_id_sql)";

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not delete mime groups", "", __LINE__, __FILE__, $sql);
		}

		//
		// Delete corresponding mime types (i think of a pending group for this in next versions)
		//
		$sql = "DELETE
		FROM " . ATTACH_TYPECONFIG_TABLE . "
		WHERE type_id IN ($group_id_sql)";

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not delete mime types", "", __LINE__, __FILE__, $sql);
		}

	}
		
	//
	// Add Mime Group ?
	//
	$mimegroup = ( isset($HTTP_POST_VARS['add_mimegroup']) ) ?  trim(strip_tags($HTTP_POST_VARS['add_mimegroup'])) : '';
	$download_mode = ( isset($HTTP_POST_VARS['add_download_mode']) ) ?  $HTTP_POST_VARS['add_download_mode'] : '';
	$category = ( isset($HTTP_POST_VARS['add_category']) ) ?  $HTTP_POST_VARS['add_category'] : '';
	$upload_image = ( isset($HTTP_POST_VARS['add_upload_image']) ) ?  $HTTP_POST_VARS['add_upload_image'] : '';
	$filesize = ( isset($HTTP_POST_VARS['add_max_filesize']) ) ?  $HTTP_POST_VARS['add_max_filesize'] : '';
	$size_select = ( isset($HTTP_POST_VARS['add_size_select']) ) ?  $HTTP_POST_VARS['add_size_select'] : '';
	$is_allowed = ( isset($HTTP_POST_VARS['add_allowed']) ) ? '1' : '0';
	$add = ( isset($HTTP_POST_VARS['add_mimegroup_check']) ) ? TRUE : FALSE;

	if ($mimegroup != '' && $add)
	{
		//
		// check mimegroup
		//
		$sql = "SELECT type_name 
		FROM " . ATTACH_TYPES_TABLE;
	
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not query types table", "", __LINE__, __FILE__, $sql);
		}
			
		if( ( $db->sql_numrows($result) ) > 0 )
		{
			$row = $db->sql_fetchrowset($result);

			for ($i = 0; $i < count($row); $i++)
			{
				if ($row[$i]['type_name'] == $mimegroup)
				{
					$error = TRUE;
					if( isset($error_msg) )
					{
						$error_msg .= '<br />';
					}
					$error_msg .= sprintf($lang['Mimegroup_exist'], $mimegroup);
				}
			}
		}
			
		if (!$error)
		{
			$filesize = ( $size_select == "kb" ) ? round($filesize * 1024) : ( ($size_select == "mb") ? round($filesize * 1048576) : $filesize );
		
			$sql = "INSERT INTO " . ATTACH_TYPES_TABLE . " (type_name, category, allow_type, download_mode, upload_image, max_filesize) 
			VALUES ('" . $mimegroup . "', " . $category . ", " . $is_allowed . ", " . $download_mode . ", '" . $upload_image . "', " . $filesize . ")";
	
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Could not add mime group", "", __LINE__, __FILE__, $sql);
			}
		}

	}

	if (!$error)
	{
		$message = $lang['Attach_config_updated'] . '<br /><br />' . sprintf($lang['Click_return_attach_config'], '<a href="' . append_sid("admin_attachments.$phpEx?mode=mimegroups") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

		message_die(GENERAL_MESSAGE, $message);
	}
}
else if ($submit && $mode='shadow')
{
	//
	// Delete Attachments from file system...
	//
	$attach_file_list = ( isset($HTTP_POST_VARS['attach_file_list']) ) ?  $HTTP_POST_VARS['attach_file_list'] : array();
	
	for ($i = 0; $i < count($attach_file_list); $i++)
	{
		@unlink($upload_dir . "/" . $attach_file_list[$i]);
	}
	
	//
	// Delete Attachments from table...
	//
	$attach_id_list = ( isset($HTTP_POST_VARS['attach_id_list']) ) ?  $HTTP_POST_VARS['attach_id_list'] : array();

	$attach_id_sql = '';

	for($i = 0; $i < count($attach_id_list); $i++)
	{
		if( $attach_id_sql != '' )
		{
			$attach_id_sql .= ', ';
		}
		$attach_id_sql .= $attach_id_list[$i];
	}

	if( $attach_id_sql != '' )
	{
		$sql = "DELETE 
		FROM " . ATTACH_DESC_TABLE . " 
		WHERE attach_id IN ($attach_id_sql)";

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not delete mime groups", "", __LINE__, __FILE__, $sql);
		}

	}

	$message = $lang['Attach_config_updated'] . "<br /><br />" . sprintf($lang['Click_return_attach_config'], "<a href=\"" . append_sid("admin_attachments.$phpEx?mode=shadow") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

	message_die(GENERAL_MESSAGE, $message);
}

//
// Mode specific Operations
//
if ($mode == 'manage')
{
	$template->set_filenames(array(
		"body" => "admin/attach_manage_body.tpl")
	);

	$disable_mod_yes = ( $new_attach['disable_mod'] != '0' ) ? 'checked="checked"' : '';
	$disable_mod_no = ( $new_attach['disable_mod'] == '0' ) ? 'checked="checked"' : '';

	$template->assign_vars(array(
		"L_MANAGE_TITLE" => $lang['Attach_settings'],
		"L_MANAGE_EXPLAIN" => $lang['Manage_attachments_explain'],
		"L_ATTACHMENT_SETTINGS" => $lang['Attach_settings'],
		"L_UPLOAD_DIR" => $lang['Upload_directory'],
		"L_ATTACHMENT_IMG_PATH" => $lang['Attach_img_path'],
		"L_ATTACHMENT_TOPIC_ICON" => $lang['Attach_topic_icon'],
		"L_TOPIC_ICON_EXPLAIN" => $lang['Attach_topic_icon_explain'],
		"L_YES" => $lang['Yes'],
		"L_NO" => $lang['No'],
		"L_MAX_FILESIZE" => $lang['Max_filesize_attach'],
		"L_MAX_FILESIZE_EXPLAIN" => $lang['Max_filesize_attach_explain'],
		"L_ATTACH_QUOTA" => $lang['Attach_quota'],
		"L_ATTACH_QUOTA_EXPLAIN" => $lang['Attach_quota_explain'],
		"L_MAX_ATTACHMENTS" => $lang['Max_attachments'],
		"L_MAX_ATTACHMENTS_EXPLAIN" => $lang['Max_attachments_explain'],
		"L_SUBMIT" => $lang['Submit'],
		"L_RESET" => $lang['Reset'],
		"L_DISABLE_MOD" => $lang['Disable_mod'],
		"L_DISABLE_MOD_EXPLAIN" => $lang['Disable_mod_explain'],
		
		"S_ATTACH_ACTION" => append_sid("admin_attachments.$phpEx?mode=manage"),
		"S_FILESIZE" => $select_size_mode,
		"S_FILESIZE_QUOTA" => $select_quota_size_mode,

		"UPLOAD_DIR" => $new_attach['upload_dir'],
		"ATTACHMENT_IMG_PATH" => $new_attach['upload_img'],
		"TOPIC_ICON" => $new_attach['topic_icon'],
		"MAX_FILESIZE" => $new_attach['max_filesize'],
		"ATTACHMENT_QUOTA" => $new_attach['attachment_quota'],
		"MAX_ATTACHMENTS" => $new_attach['max_attachments'],
		"DISABLE_MOD_YES" => $disable_mod_yes,
		"DISABLE_MOD_NO" => $disable_mod_no)
	);

} 
else if ($mode == 'extensions')
{
	//
	// Extensions
	//
	$template->set_filenames(array(
		"body" => "admin/attach_extensions.tpl")
	);

	$template->assign_vars(array(
		"S_ATTACH_ACTION" => append_sid("admin_attachments.$phpEx?mode=extensions"),

		"L_EXTENSIONS_TITLE" => $lang['Manage_forbidden_extensions'],
		"L_EXTENSIONS_EXPLAIN" => $lang['Manage_forbidden_extensions_explain'],
		"L_EXTENSION" => $lang['Extension'],
		"L_ADD_NEW" => $lang['Add_new'],
		"L_DELETE" => $lang['Delete'])
	);

	$sql = "SELECT *
	FROM " . ATTACH_EXTENSIONS_TABLE . "
	ORDER BY 'extension'";
	
	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Can't get extensions informations", "", __LINE__, __FILE__, $sql);
	}

	if( ( $db->sql_numrows($result) ) > 0 )
	{
		$extensionrow = $db->sql_fetchrowset($result);
	
		for ($i = 0; $i < count($extensionrow); $i++)
		{
			if (!strstr($extensionrow[$i]['extension'], "php"))
			{
				$template->assign_block_vars("extensionrow", array(
					"EXTENSION_ID" => $extensionrow[$i]['ext_id'],
					"EXTENSION_NAME" => $extensionrow[$i]['extension'])
				);
			}
		}
	}

}
else if ($mode == 'mimetypes')
{
	//
	// Mime Types
	//
	$template->set_filenames(array(
		"body" => "admin/attach_mimetypes.tpl")
	);

	$template->assign_vars(array(
		"L_MIMETYPES_TITLE" => $lang['Manage_mime_types'],
		"L_MIMETYPES_EXPLAIN" => $lang['Manage_mime_types_explain'],
		"L_SELECT" => $lang['Select'],
		"L_EXPLANATION" => $lang['Explanation'],
		"L_MIME_TYPE" => $lang['Mimetype'],
		"L_MIME_GROUP" => $lang['Mimegroup'],
		"L_ADD_NEW" => $lang['Add_new'],
		"L_DELETE" => $lang['Delete'],
		"L_CANCEL" => $lang['Cancel'],
		"L_SUBMIT" => $lang['Submit'],

		"S_CANCEL_ACTION" => append_sid("admin_attachments.$phpEx?mode=mimetypes"),
		"S_ATTACH_ACTION" => append_sid("admin_attachments.$phpEx?mode=mimetypes"))
	);

	if ($submit)
	{
		$template->assign_vars(array(
			"S_ADD_GROUP_SELECT" => group_select('add_group_select', $mimegroup))
		);
	}
	else
	{
		$template->assign_vars(array(
			"S_ADD_GROUP_SELECT" => group_select('add_group_select'))
		);
	}

/*
	$sql = "SELECT m.type_id, t.mime_id, t.type_string, t.explain_mimetype
	FROM " . ATTACH_TYPECONFIG_TABLE . " t, " . ATTACH_TYPES_TABLE . " m
	WHERE t.type_id = m.type_id
	GROUP BY t.type_string, m.type_id, t.mime_id, t.explain_mimetype
	ORDER BY 't.type_string'";
*/
	$sql = "SELECT m.type_id, m.type_name, t.mime_id, t.type_string, t.explain_mimetype
	FROM " . ATTACH_TYPECONFIG_TABLE . " t, " . ATTACH_TYPES_TABLE . " m
	WHERE t.type_id = m.type_id
	ORDER BY t.type_id";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't get mimetype informations", "", __LINE__, __FILE__, $sql);
	}

	if( ( $db->sql_numrows($result) ) > 0 )
	{
		$mimerow = $db->sql_fetchrowset($result);

		$mimerow = sort_multi_array ($mimerow, 'type_name', 'ASC');
		
		for ($i = 0; $i < count($mimerow); $i++)
		{

			if ($submit)
			{
				$template->assign_block_vars("mimerow", array(
					"MIME_ID" => $mimerow[$i]['mime_id'],
					"MIME_TYPE" => $mimerow[$i]['type_string'],
					"MIME_EXPLAIN" => $mime_explain_list[$i], 
					"S_GROUP_SELECT" => group_select('group_select[]', $group_select_list[$i]))
				);
			}
			else
			{
				$template->assign_block_vars("mimerow", array(
					"MIME_ID" => $mimerow[$i]['mime_id'],
					"MIME_TYPE" => $mimerow[$i]['type_string'],
					"MIME_EXPLAIN" => $mimerow[$i]['explain_mimetype'],
					"S_GROUP_SELECT" => group_select('group_select[]', $mimerow[$i]['type_id']))
				);
			}
		}
	}

}
else if ($mode == 'mimegroups')
{
	//
	// Mime Groups
	//
	$template->set_filenames(array(
		"body" => "admin/attach_mimegroups.tpl")
	);

	$viewgroup = (!empty($HTTP_GET_VARS[POST_GROUPS_URL])) ? $HTTP_GET_VARS[POST_GROUPS_URL] : -1;

	$template->assign_vars(array(
		"L_MIMEGROUPS_TITLE" => $lang['Manage_mime_groups'],
		"L_MIMEGROUPS_EXPLAIN" => $lang['Manage_mime_groups_explain'],
		"L_MIME_GROUP" => $lang['Mimegroup'],
		"L_ADD_NEW" => $lang['Add_new'],
		"L_ALLOWED" => $lang['Allowed'],
		"L_DELETE" => $lang['Delete'],
		"L_CANCEL" => $lang['Cancel'],
		"L_SUBMIT" => $lang['Submit'],
		"L_SPECIAL_CATEGORY" => $lang['Special_category'],	
		"L_DOWNLOAD_MODE" => $lang['Download_mode'],
		"L_UPLOAD_IMAGE" => $lang['Upload_image'],
		"L_MAX_FILESIZE" => $lang['Max_filesize'],

		"ADD_GROUP_NAME" => ( isset($submit) ) ? $mimegroup : '',
		"MAX_FILESIZE" => $new_attach['max_filesize'],

		"S_FILESIZE" => size_select('add_size_select', $size),
		"S_ADD_DOWNLOAD_MODE" => download_select('add_download_mode'),
		"S_SELECT_CAT" => category_select('add_category'),
		"S_CANCEL_ACTION" => append_sid("admin_attachments.$phpEx?mode=mimegroups"),
		"S_ATTACH_ACTION" => append_sid("admin_attachments.$phpEx?mode=mimegroups"))
	);

	$sql = "SELECT * FROM " . ATTACH_TYPES_TABLE;

	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Couldn't get mime group informations", "", __LINE__, __FILE__, $sql);
	}

	if( ( $db->sql_numrows($result) ) > 0 )
	{
		$mimegroup = $db->sql_fetchrowset($result);

		for ($i = 0; $i < count($mimegroup); $i++)
		{
			//
			// Format the filesize
			//
			if ( $mimegroup[$i]['max_filesize'] == 0 )
			{
				$mimegroup[$i]['max_filesize'] = $attach_config['max_filesize'];
			}

			$size_format = ($mimegroup[$i]['max_filesize'] >= 1048576) ? "mb" : ( ($mimegroup[$i]['max_filesize'] >= 1024) ? "kb" : "b" );

			if($mimegroup[$i]['max_filesize'] >= 1048576)
			{
				$mimegroup[$i]['max_filesize'] = round($mimegroup[$i]['max_filesize'] / 1048576 * 100) / 100;
			}
			else if($mimegroup[$i]['max_filesize'] >= 1024)
			{
				$mimegroup[$i]['max_filesize'] = round($mimegroup[$i]['max_filesize'] / 1024 * 100) / 100;
			}

			$s_allowed = ($mimegroup[$i]['allow_type'] == 1) ? 'checked="checked"' : '';
			
			$template->assign_block_vars("grouprow", array(
				"GROUP_ID" => $mimegroup[$i]['type_id'],
				"MIME_GROUP" => $mimegroup[$i]['type_name'],
				"UPLOAD_IMAGE" => $mimegroup[$i]['upload_image'],

				"S_ALLOW_SELECTED" => $s_allowed,
				"S_SELECT_CAT" => category_select('category_list[]', $mimegroup[$i]['type_id']),
				"S_DOWNLOAD_MODE" => download_select('download_mode_list[]', $mimegroup[$i]['type_id']),
				"S_FILESIZE" => size_select('size_select_list[]', $size_format),
				
				"MAX_FILESIZE" => $mimegroup[$i]['max_filesize'],
				"CAT_BOX" => ( $viewgroup == $mimegroup[$i]['type_id'] ) ? $lang['Decollapse'] : $lang['Collapse'],
				"U_VIEWGROUP" => ( $viewgroup == $i+1 ) ? append_sid("admin_attachments.$phpEx?mode=mimegroups") : append_sid("admin_attachments.$phpEx?mode=mimegroups&" . POST_GROUPS_URL . "=" . $mimegroup[$i]['type_id']))
			);

			if ( ($viewgroup != -1) && ($viewgroup == $mimegroup[$i]['type_id']))
			{
				$sql = "SELECT explain_mimetype, type_string FROM " . ATTACH_TYPECONFIG_TABLE . "
				WHERE type_id = " . $viewgroup;

				if (!$result = $db->sql_query($sql))
				{
					message_die(GENERAL_ERROR, "Couldn't get mime group informations", "", __LINE__, __FILE__, $sql);
				}

				if( ( $total_mimetypes = $db->sql_numrows($result) ) > 0 )
				{
					$mimetype = $db->sql_fetchrowset($result);

					for ($j = 0; $j < $total_mimetypes; $j++)
					{
						$template->assign_block_vars("grouprow.mimerow", array(
							"EXPLANATION" => $mimetype[$j]['explain_mimetype'],
							"MIME_TYPE" => $mimetype[$j]['type_string'])
						);
					}
				}
			}

		}
	}
}
else if ($mode == 'shadow')
{
	//
	// Shadow Attachments
	//
	$template->set_filenames(array(
		"body" => "admin/attach_shadow.tpl")
	);

	$template->assign_vars(array(
		"L_SHADOW_TITLE" => $lang['Shadow_attachments_title'],
		"L_SHADOW_EXPLAIN" => $lang['Shadow_attachments_explain'],
		"L_EXPLAIN_FILE" => $lang['Shadow_attachments_file_explain'],
		"L_EXPLAIN_ROW" => $lang['Shadow_attachments_row_explain'],
		"L_ATTACHMENT" => $lang['Attachment'],
		"L_COMMENT" => $lang['File_comment'],
		"L_DELETE" => $lang['Delete'],
		"L_SUBMIT" => $lang['Submit'],
		
		"S_ATTACH_ACTION" => append_sid("admin_attachments.$phpEx?mode=shadow"))
	);

	$table_attachments = array();
	$file_attachments = array();

	//
	// collect all attachments in attach-table
	//
	$sql = "SELECT attach_id, attach_filename, comment, post_id
	FROM " . ATTACH_DESC_TABLE;

	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not get attachment informations", "", __LINE__, __FILE__, $sql);
	}

	if( ( $db->sql_numrows($result) ) > 0 )
	{
		$row = $db->sql_fetchrowset($result);

		for ($i = 0; $i < count($row); $i++)
		{
			$table_attachments['attach_id'][] = $row[$i]['attach_id'];
			$table_attachments['attach_filename'][] = $row[$i]['attach_filename'];
			$table_attachments['comment'][] = $row[$i]['comment'];
			$table_attachments['post_id'][] = $row[$i]['post_id'];
		}
	}

	//
	// collect all attachments on file-system
	//
	$dir = opendir($upload_dir);

	while($file = readdir($dir))
	{
		if( ($file != "index.htm") && ($file != "index.html") && ($file != ".htaccess") && (!is_dir($upload_dir . "/" . $file)) && (!is_link($upload_dir . "/" . $file)) )
		{
			$file_attachments[] = $file;
		}
	}

	closedir($dir);

	$shadow_attachments = array();
	$shadow_row = array();	

	//
	// attachments on file-system, that are not assigned to any existing post
	//
	for ($i = 0; $i < count($file_attachments); $i++)
	{
		if (count($table_attachments['attach_filename']) > 0)
		{
			if (!in_array($file_attachments[$i], $table_attachments['attach_filename']) )
			{	
				$shadow_attachments[] = $file_attachments[$i];
			}
		}
		else
		{
			$shadow_attachments[] = $file_attachments[$i];
		}
	}

	for ($i = 0; $i < count($table_attachments['attach_id']); $i++)
	{
		if (!existing_post($table_attachments['post_id'][$i]))
		{
			$shadow_attachments[] = $table_attachments['attach_filename'][$i];
		}
	}
	
	for ($i = 0; $i < count($shadow_attachments); $i++)
	{
		$template->assign_block_vars("shadowattachrow", array(
			"ATTACH_ID" => $shadow_attachments[$i],
			"ATTACH_FILENAME" => $shadow_attachments[$i],
			"ATTACH_COMMENT" => $lang['No_file_comment_available'],
			"U_ATTACHMENT" => $upload_dir . "/" . $shadow_attachments[$i])
		);
	}

	//
	// attachments in attach_desc_table, that are not on the file-system or assigned to an non existing post
	//
	for ($i = 0; $i < count($table_attachments['attach_id']); $i++)
	{
		if ( !in_array($table_attachments['attach_filename'][$i], $file_attachments))
		{	
			$shadow_row['attach_id'][] = $table_attachments['attach_id'][$i];
			$shadow_row['attach_filename'][] = $table_attachments['attach_filename'][$i];
			$shadow_row['comment'][] = $table_attachments['comment'][$i];
		}
	}

	for ($i = 0; $i < count($table_attachments['attach_id']); $i++)
	{
		if (!existing_post($table_attachments['post_id'][$i]))
		{
			$shadow_row['attach_id'][] = $table_attachments['attach_id'][$i];
			$shadow_row['attach_filename'][] = $table_attachments['attach_filename'][$i];
			$shadow_row['comment'][] = $table_attachments['comment'][$i];
		}
	}

	for ($i = 0; $i < count($shadow_row['attach_id']); $i++)
	{
		$template->assign_block_vars("shadowrow", array(
			"ATTACH_ID" => $shadow_row['attach_id'][$i],
			"ATTACH_FILENAME" => $shadow_row['attach_filename'][$i],
			"ATTACH_COMMENT" => ( empty($shadow_row['comment'][$i]) ) ? $lang['No_file_comment_available'] : $shadow_row['comment'][$i])
		);
	}

}

if ($error)
{
	$template->set_filenames(array(
		"reg_header" => "error_body.tpl")
	);
	
	$template->assign_vars(array(
		"ERROR_MESSAGE" => $error_msg)
	);
	
	$template->assign_var_from_handle("ERROR_BOX", "reg_header");
}

$template->pparse("body");

include('page_footer_admin.'.$phpEx);

?>