<?php
/***************************************************************************
 *							   attachment_mod.php
 *                            -------------------
 *   begin                : Monday, Jan 07, 2002
 *   copyright            : (C) 2002 Meik Sievertsen
 *   email                : acyd.burn@gmx.de
 *
 *   $Id: attachment_mod.php,v 2.1.1 2002/03/25 meik Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

$download = ( empty($download) ) ? $HTTP_GET_VARS['download'] : $download;

if ( $download )
{
	define('IN_PHPBB', true);
	$phpbb_root_path = "./";
	include($phpbb_root_path . 'extension.inc');
	include($phpbb_root_path . 'common.'.$phpEx);
}
else
{
	//
	// check if we were called directly
	//
	if (!defined('IN_PHPBB'))
	{
		define('IN_PHPBB', true);
		$phpbb_root_path = "./";
		include($phpbb_root_path . 'extension.inc');
		include($phpbb_root_path . 'common.'.$phpEx);

		$userdata = session_pagestart($user_ip, PAGE_INDEX);
		init_userprefs($userdata);
	
		message_die(GENERAL_ERROR, $lang['No_attachment_selected']);
	}
}

// Have not put them into constants for now...
define('INLINE_LINK', 1);
define('PHYSICAL_LINK', 2);
define('NONE_CAT', 0);
define('IMAGE_CAT', 1);
define('WMA_CAT', 2);
define('SWF_CAT', 3);

$attach_config = array();

$sql = "SELECT * 
FROM " . ATTACH_CONFIG_TABLE;
	 
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not query attachment information", "", __LINE__, __FILE__, $sql);
}

while ($row = $db->sql_fetchrow($result))
{
	$attach_config[$row['config_name']] = $row['config_value'];
}

//
// VIEWTOPIC
//
class Attach_viewtopic 
{
	//
	// Variables
	//
	var $mimetype = array();
	var $mimecategory = array();

	//
	// Constructor
	//
	function Attach_viewtopic()
	{
	}

	function get_attach_info()
	{
		global $attach_config, $db, $is_auth, $template;

		if ($attach_config['disable_mod'] == '1')
		{
			return;
		}

		//
		// Handle Attachment Information
		//
		if ($is_auth['auth_read'])
		{
			// a small workaround... body must be defined
			// do it this way, because set_filenames don't work if we have an incremental assignment (here postrow.)
			// i think i need a deeper look at the template-class and adjust it, so it parse external files better. ;) but not now.

			// load template file, very crapy, because i assume it's the body (we are in viewtopic...)
			$template->loadfile('body');
			
			// set_filename (get complete path)
			$viewtopic_attach_body = $template->make_filename('viewtopic_attach_body.tpl');

			// loadfile for viewtopic_attach_body.tpl
			$str = implode('', @file($viewtopic_attach_body));
			if (empty($str))
			{
				die("Template->loadfile(): File $viewtopic_attach_body is empty");
			}

			// replace postrow.ATTACHMENTS with uncompiled code in viewtopic_attach_body.tpl
			$template->uncompiled_code['body'] = str_replace('{postrow.ATTACHMENTS}', $str, $template->uncompiled_code['body']);

			// Get Information on currently allowed mime-types and their respective category
			$sql = "SELECT m.type_string, t.category 
			FROM " . ATTACH_TYPECONFIG_TABLE . " m, " . ATTACH_TYPES_TABLE . " t 
			WHERE (t.allow_type = '1') AND (m.type_id = t.type_id)";

			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query attachment information', '', __LINE__, __FILE__, $sql);
			}

			while($row = $db->sql_fetchrow($result))
			{
				$this->mimetype[] = $row['type_string'];
				$this->mimecategory[$row['type_string']] = $row['category'];
			}

		}
	}

	//
	// display Attachments
	//
	function display_attachments($post_id)
	{
	    global $attach_config, $db, $is_auth, $lang, $phpEx, $template;
		
		if ($attach_config['disable_mod'] == '1')
		{
			return;
		}

		//
		// Handle Attachment Information
		//
		if ($is_auth['auth_read']) 
		{
			$template->assign_vars(array(
				"L_POSTED_ATTACHMENTS" => $lang['Posted_attachments'],
				"L_KILOBYTE" => $lang['KB'])
			);

			//
			// Find out if we have attachements in this post ($postrow[$i]['post_id'])
			//
			$sql = "SELECT *
			FROM " . ATTACH_DESC_TABLE . " 
			WHERE post_id = " . $post_id . "
			ORDER BY filetime DESC";

			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query attachment information', '', __LINE__, __FILE__, $sql);
			}

			$num_attachments = $db->sql_numrows($result);
			$attachrow = array();
			
			if ($num_attachments > 0)
			{
				$template->assign_block_vars('postrow.attach', array());
			
				$attachrow = $db->sql_fetchrowset($result);
			}

			for ($i = 0; $i < $num_attachments; $i++)
			{
				$filename = $attach_config['upload_dir'] . '/' . $attachrow[$i]['attach_filename'];
				$filesize = intval($attachrow[$i]['filesize'] / 1024);
				$display_name = ( empty($attachrow[$i]['comment']) ) ? $attachrow[$i]['filename'] : $attachrow[$i]['comment'];

				//
				// disallowed ?
				//
				if (!in_array($attachrow[$i]['mimetype'], $this->mimetype)) 
				{

					$template->assign_block_vars("postrow.attach.denyrow", array(
						"L_DENIED" => sprintf($lang['Mime_type_disallowed_post'], $attachrow[$i]['mimetype']))
					);

				} 
				else 
				{
					//
					// define category
					//
					if ($this->mimecategory[$attachrow[$i]['mimetype']] == IMAGE_CAT)
					{

						//
						// Images
						//
						$template->assign_block_vars("postrow.attach.cat_images", array(
							"DOWNLOAD_NAME" => $display_name,
							"IMG_SRC" => $filename,
							"FILESIZE" => $filesize,
							"L_DOWNLOAD_COUNT" => sprintf($lang['Download_number'], $attachrow[$i]['download_count']))
						);

						//
						// Viewed Image ... update the download count
						//
						$sql = "UPDATE " . ATTACH_DESC_TABLE . " 
						SET download_count = download_count + 1 
						WHERE attach_id = " . $attachrow[$i]['attach_id'];
	
						if( !$db->sql_query($sql) )
						{
							message_die(GENERAL_MESSAGE, "Couldn't update attachment download count", "", __LINE__, __FILE__, $sql);
						}

					}
					else if ($this->mimecategory[$attachrow[$i]['mimetype']] == WMA_CAT)
					{
						//
						// Windows Media Audio Files
						//
						$template->assign_block_vars("postrow.attach.cat_wma", array(
							"U_DOWNLOAD_LINK" => $attach_config['upload_dir'] . '/' . $attachrow[$i]['attach_filename'],
							"DOWNLOAD_NAME" => $display_name,
							"FILESIZE" => $filesize,
							"L_DOWNLOAD_COUNT" => sprintf($lang['Download_number'], $attachrow[$i]['download_count']))
						);

						//
						// Viewed/Heared File ... update the download count
						//
						$sql = "UPDATE " . ATTACH_DESC_TABLE . " 
						SET download_count = download_count + 1 
						WHERE attach_id = " . $attachrow[$i]['attach_id'];
	
						if( !$db->sql_query($sql) )
						{
							message_die(GENERAL_MESSAGE, "Couldn't update attachment download count", "", __LINE__, __FILE__, $sql);
						}

					}
					else if ($this->mimecategory[$attachrow[$i]['mimetype']] == SWF_CAT)
					{
						//
						// Macromedia Flash Files
						//
						list($width, $height) = @getimagesize ( $attach_config['upload_dir'] . '/' . $attachrow[$i]['attach_filename'] );
						
						$template->assign_block_vars("postrow.attach.cat_swf", array(
							"U_DOWNLOAD_LINK" => $attach_config['upload_dir'] . '/' . $attachrow[$i]['attach_filename'],
							"DOWNLOAD_NAME" => $display_name,
							"FILESIZE" => $filesize,
							"L_DOWNLOAD_COUNT" => sprintf($lang['Download_number'], $attachrow[$i]['download_count']),

							"WIDTH" => $width,
							"HEIGHT" => $height)
						);

						//
						// Viewed/Heared File ... update the download count
						//
						$sql = "UPDATE " . ATTACH_DESC_TABLE . " 
						SET download_count = download_count + 1 
						WHERE attach_id = " . $attachrow[$i]['attach_id'];
	
						if( !$db->sql_query($sql) )
						{
							message_die(GENERAL_MESSAGE, "Couldn't update attachment download count", "", __LINE__, __FILE__, $sql);
						}
					}
					else
					{
						$upload_image = '';
						
						//
						// What Icon to display ? any special one ?
						//
						$sql = "SELECT a.upload_image
						FROM " . ATTACH_TYPECONFIG_TABLE . " t, " . ATTACH_TYPES_TABLE . " a
						WHERE (a.type_id = t.type_id) AND (t.type_string = '" . $attachrow[$i]['mimetype'] . "')
						LIMIT 1";

						if( !$result = $db->sql_query($sql) )
						{
							message_die(GENERAL_ERROR, "Couldn't obtain upload image", "", __LINE__, __FILE__, $sql);
						}

						$row = $db->sql_fetchrow($result);

						if (!empty($attach_config['upload_img']) && empty($row['upload_image']))
						{
							$upload_image = '<img src="' . $attach_config['upload_img'] . '" alt="" />';
						}
						else if (!empty($row['upload_image']))
						{
							$upload_image = '<img src="' . $row['upload_image'] . '" alt="" />';
						}

						//
						// display attachment
						//
						$template->assign_block_vars("postrow.attach.attachrow", array(
							"U_DOWNLOAD_LINK" => append_sid("attachment_mod." . $phpEx . "?download=" . $attachrow[$i]['attach_id']),
							"S_UPLOAD_IMAGE" => $upload_image,
						
							"DOWNLOAD_NAME" => $display_name,
							"FILESIZE" => $filesize,
							"L_DOWNLOAD_COUNT" => sprintf($lang['Download_number'], $attachrow[$i]['download_count']))
						);
						
					}
				}
			} // while row in attach_desc_table
		} // if $is_auth['auth_read']
	}

}

//
// VIEWFORUM
//
class Attach_viewforum 
{

	//
	// Constructor
	//
	function Attach_viewforum()
	{
	}

	//
	// return image if attachments posted in topic
	//
	function get_attachments_img($topic_id)
	{
		global $attach_config, $db, $is_auth;

		$topic_attachments_img = '';
		
		if ( (!$is_auth['auth_read']) || ($attach_config['disable_mod'] == '1') || (empty($attach_config['topic_icon'])) )
		{
			return ('');
		}

		//
		// get all attachments posted at this topic
		//
		$sql = "SELECT a.attach_id
		FROM " . ATTACH_DESC_TABLE . " a, " . POSTS_TABLE . " p, " . TOPICS_TABLE . " t
		WHERE (t.topic_id = " . $topic_id . ") AND (a.post_id = p.post_id) AND (t.topic_id = p.topic_id)";

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Can't obtain Attachment Informations", "", __LINE__, __FILE__, $sql);
		}

		if ( ( $db->sql_numrows($result) ) > 0 )
		{
			$topic_attachments_img = "<img src=\"" . $attach_config['topic_icon'] . "\" alt=\"\" border=\"0\" /> ";
		}

		return $topic_attachments_img;
	}

}

//
// MODCP
//
class Attach_modcp 
{

	var $attach_id_sql = "";
	
	//
	// Constructor
	//
	function Attach_modcp()
	{
	}

	function get_attachment_id_list($post_id_sql)
	{
		global $db;
		
		$sql = "SELECT attach_id 
		FROM " . ATTACH_DESC_TABLE . " 
		WHERE post_id IN ($post_id_sql)";

		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not get attachment id information", "", __LINE__, __FILE__, $sql);
		}

		$this->attach_id_sql = "";

		if( ( $db->sql_numrows($result) ) > 0 )
		{
			$rowset = $db->sql_fetchrowset($result);

			for($i = 0; $i < count($rowset); $i++)
			{
				if( $this->attach_id_sql != "" )
				{
					$this->attach_id_sql .= ", ";
				}
				$this->attach_id_sql .= $rowset[$i]['attach_id'];
			}
		}
	}

	function delete_attachments_from_posts($post_id_sql)
	{
		global $attach_config, $db;

		if ($this->attach_id_sql != '')
		{
			//
			// See if we have attachments in our post
			//
			$sql = "SELECT attach_filename 
			FROM " . ATTACH_DESC_TABLE . "
			WHERE post_id IN ($post_id_sql)";

			if(!$result = $db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, "Could not find Attachment descriptions", "", __LINE__, __FILE__, $sql);
			}

			if( ( $db->sql_numrows($result) ) > 0 )
			{
				$rowset = $db->sql_fetchrowset($result);

				for($i = 0; $i < count($rowset); $i++)
				{
					@unlink($attach_config['upload_dir'] . '/' . $rowset[$i]['attach_filename']);
				}
			}

			$sql = "DELETE 
			FROM " . ATTACH_DESC_TABLE . " 
			WHERE attach_id IN ($this->attach_id_sql)";

			if( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Could not delete Attachment descriptions", "", __LINE__, __FILE__, $sql);
			}
		}
	}

}

//
// POSTING
//
class Attach_posting 
{

	var $post_attach = FALSE;
	var $attach_filename = '';
	var $filename = '';
	var $type = '';
	var $file_comment = '';
	var $num_attachments = 0; // number of attachments in post
	var $filesize = 0;
	var $filetime = 0;

	//
	// Constructor
	//
	function Attach_posting()
	{
		global $HTTP_POST_VARS, $HTTP_POST_FILES;
		
		$this->file_comment = ( isset($HTTP_POST_VARS['filecomment']) ) ? trim( strip_tags($HTTP_POST_VARS['filecomment'])) : "";
		$this->filename = ( $HTTP_POST_FILES['fileupload']['name'] != 'none' ) ? trim( $HTTP_POST_FILES['fileupload']['name'] ) : "";
		
		$this->attachment_list = ( isset($HTTP_POST_VARS['attachment_list']) ) ? $HTTP_POST_VARS['attachment_list'] : array();
		$this->attachment_comment_list = ( isset($HTTP_POST_VARS['comment_list']) ) ? $HTTP_POST_VARS['comment_list'] : array();
		$this->attachment_filename_list = ( isset($HTTP_POST_VARS['filename_list']) ) ? $HTTP_POST_VARS['filename_list'] : array();
		$this->attachment_mimetype_list = ( isset($HTTP_POST_VARS['mimetype_list']) ) ? $HTTP_POST_VARS['mimetype_list'] : array();
		$this->attachment_filesize_list = ( isset($HTTP_POST_VARS['filesize_list']) ) ? $HTTP_POST_VARS['filesize_list'] : array();
		$this->attachment_filetime_list = ( isset($HTTP_POST_VARS['filetime_list']) ) ? $HTTP_POST_VARS['filetime_list'] : array();
		$this->attachment_id_list = ( isset($HTTP_POST_VARS['attach_id_list']) ) ? $HTTP_POST_VARS['attach_id_list'] : array();
	}
	
	//
	// Handle Attachments (Add/Delete/Edit/Show) - This is the first function called from posting.php
	//
	function posting_attachment_mod()
	{
		global $mode, $confirm, $is_auth, $post_id, $delete;

		$result = $this->handle_attachments($mode);

		if ($result == FALSE)
		{
			return;
		}
			
		if ( ($confirm) && ($delete || $mode == "delete" || $mode == "editpost") && ($is_auth['auth_delete'] || $is_auth['auth_mod']) )
		{
			if (!empty($post_id))
			{
				$this->delete_attachment($post_id);
			}
		}

		$this->display_attachment($post_id);

	}

	//
	// Handle all modes... (intern)
	//
	function handle_attachments($mode)
	{
		global $is_auth, $attach_config, $refresh, $HTTP_POST_VARS, $post_id, $submit, $preview, $error, $error_msg, $lang;
		
		// 
		// ok, what shall we do ;)
		//

		//
		// nothing, if the user is not authorized or attachment mod disabled
		//
		if ( (!$is_auth['auth_attachments']) || ($attach_config['disable_mod'] == '1') )
		{
			return (FALSE);
		}
		
		//
		// Init Vars
		//
		$attachments = array();

		if (!$refresh)
		{
			$add = ( isset($HTTP_POST_VARS['add_attachment']) ) ? TRUE : FALSE;
			$delete = ( isset($HTTP_POST_VARS['del_attachment']) ) ? TRUE : FALSE;
			$edit = ( isset($HTTP_POST_VARS['edit_comment']) ) ? TRUE : FALSE;

			$refresh = $add || $delete || $edit;
		}

		//
		// Get Attachments
		//
		if (!empty($post_id))
		{
			$attachments = $this->get_attachments_from_post($post_id);
		}

		if ( (!$submit) && ($mode == 'editpost') && ( ( $is_auth['auth_edit'] || $is_auth['auth_mod'] ) ))
		{
			if ( (!$refresh) && (!$preview) && (!$error) && (!isset($HTTP_POST_VARS['del_poll_option'])) )
			{
				for ($i = 0; $i < count($attachments); $i++)
				{
					$this->attachment_list[] = $attachments[$i]['attach_filename'];
					$this->attachment_comment_list[] = $attachments[$i]['comment'];
					$this->attachment_filename_list[] = $attachments[$i]['filename'];
					$this->attachment_mimetype_list[] = $attachments[$i]['mimetype'];
					$this->attachment_filesize_list[] = $attachments[$i]['filesize'];
					$this->attachment_filetime_list[] = $attachments[$i]['filetime'];
					$this->attachment_id_list[] = $attachments[$i]['attach_id'];
				}
			}
		}

		$this->num_attachments = count($this->attachment_list);
		
		if( $submit && $mode != 'vote' )
		{
			if ( $mode == 'newtopic' || $mode == 'reply' || $mode == 'editpost' )
			{
				if ( $this->filename != '' )
				{
					if ( $this->num_attachments < intval($attach_config['max_attachments']) )
					{
						$this->upload_attachment();
					}
					else
					{
						$error = TRUE;
						if(!empty($error_msg))
						{
							$error_msg .= '<br />';
						}
						$error_msg .= sprintf($lang['Too_many_attachments'], intval($attach_config['max_attachments']));
					}
				}
			}
		}

		if( $preview || $refresh || $error )
		{
			//
			// Perform actions on temporary attachments
			//
			if( isset($HTTP_POST_VARS['del_attachment']) )
			{
				// store old values
				$actual_list = ( isset($HTTP_POST_VARS['attachment_list']) ) ? $HTTP_POST_VARS['attachment_list'] : array();
				$actual_comment_list = ( isset($HTTP_POST_VARS['comment_list']) ) ? $HTTP_POST_VARS['comment_list'] : array();
				$actual_filename_list = ( isset($HTTP_POST_VARS['filename_list']) ) ? $HTTP_POST_VARS['filename_list'] : array();
				$actual_mimetype_list = ( isset($HTTP_POST_VARS['mimetype_list']) ) ? $HTTP_POST_VARS['mimetype_list'] : array();
				$actual_filesize_list = ( isset($HTTP_POST_VARS['filesize_list']) ) ? $HTTP_POST_VARS['filesize_list'] : array();
				$actual_filetime_list = ( isset($HTTP_POST_VARS['filetime_list']) ) ? $HTTP_POST_VARS['filetime_list'] : array();
				$actual_id_list = ( isset($HTTP_POST_VARS['attach_id_list']) ) ? $HTTP_POST_VARS['attach_id_list'] : array();

				// clean values
				$this->attachment_list = array();
				$this->attachment_comment_list = array();
				$this->attachment_filename_list = array();
				$this->attachment_mimetype_list = array();
				$this->attachment_filesize_list = array();
				$this->attachment_filetime_list = array();
				$this->attachment_id_list = array();

				// restore values :)
				if( isset($HTTP_POST_VARS['attachment_list']) )
				{
					for ($i = 0; $i < count($actual_list); $i++)
					{
						if( !isset($HTTP_POST_VARS['del_attachment'][$actual_list[$i]]) )
						{
							$this->attachment_list[] = $actual_list[$i];
							$this->attachment_comment_list[] = $actual_comment_list[$i];
							$this->attachment_filename_list[] = $actual_filename_list[$i];
							$this->attachment_mimetype_list[] = $actual_mimetype_list[$i];
							$this->attachment_filesize_list[] = $actual_filesize_list[$i];
							$this->attachment_filetime_list[] = $actual_filetime_list[$i];
							$this->attachment_id_list[] = $actual_id_list[$i];
						}
						else
						{
							//
							// delete selected attachment
							//
							if ( $actual_id_list[$i] == '-1' )
							{
								@unlink($attach_config['upload_dir'] . '/' . $actual_list[$i]);
							}
							else
							{
								$id = array();
								$id[] = $actual_id_list[$i];
								$this->delete_attachment($post_id, $id);
							}
						}
					}
				}
			}
			else 
			{
				$actual_comment_list = ( isset($HTTP_POST_VARS['comment_list']) ) ? $HTTP_POST_VARS['comment_list'] : "";
				
				$this->attachment_comment_list = array();

				for ($i = 0; $i < count($this->attachment_list); $i++)
				{
					$this->attachment_comment_list[$i] = $actual_comment_list[$i];
				}
		
				if( isset($HTTP_POST_VARS['add_attachment']) && ($this->filename != "") )
				{
					if( $this->num_attachments < intval($attach_config['max_attachments']) ) 
					{
						$this->upload_attachment();

						if (!$error)
						{
							$this->attachment_list[] = $this->attach_filename;
							$this->attachment_comment_list[] = $this->file_comment;
							$this->attachment_filename_list[] = $this->filename;
							$this->attachment_mimetype_list[] = $this->type;
							$this->attachment_filesize_list[] = $this->filesize;
							$this->attachment_filetime_list[] = $this->filetime;
							$this->attachment_id_list[] = '-1';

							$this->file_comment = '';
						}
					}
					else
					{
						$error = TRUE;
						if(!empty($error_msg))
						{
							$error_msg .= "<br />";
						}
						$error_msg .= sprintf($lang['Too_many_attachments'], intval($attach_config['max_attachments'])); 
					}
				}
			}
		}

		return (TRUE);
	}

	//
	// Insert an Attachment into a post (this is the second function called from posting.php)
	//
	function insert_attachment($a_post_id)
	{
		global $db, $is_auth, $mode;

		//
		// Insert Attachment ?
		//
		if ((!empty($a_post_id)) && ( $mode == "newtopic" || $mode == "reply" || $mode == "editpost" ) && ( $is_auth['auth_attachments'] ))
		{
			for ($i = 0; $i < count($this->attachment_list); $i++)
			{
				if ($this->attachment_id_list[$i] != "-1")
				{
					//
					// update entry in db if attachment already stored in db and filespace
					//
					$a_sql = "UPDATE " . ATTACH_DESC_TABLE . " 
					SET comment = '" . $this->attachment_comment_list[$i] . "'
					WHERE attach_id = " . $this->attachment_id_list[$i];
				}
				else
				{
					//
					// insert attachment into db 
					//
					$a_sql = "INSERT INTO " . ATTACH_DESC_TABLE . " (post_id, attach_filename, filename, comment, mimetype, filesize, filetime) 
					VALUES ( " . $a_post_id . ", '" . $this->attachment_list[$i] . "', '" . $this->attachment_filename_list[$i] . "', '" . $this->attachment_comment_list[$i] . "', '" . $this->attachment_mimetype_list[$i] . "', '" . $this->attachment_filesize_list[$i] . "', '" . $this->attachment_filetime_list[$i] . "')";
				}

				if (!$db->sql_query($a_sql))
				{
					message_die(GENERAL_ERROR, "Couldn't store Attachment.<br />Your Post has be stored.", "", __LINE__, __FILE__, $a_sql);
				}
			}

			if ($this->post_attach)
			{
				//
				// insert attachment into db, here the user submit it directly 
				//
				$a_sql = "INSERT INTO " . ATTACH_DESC_TABLE . " (post_id, attach_filename, filename, comment, mimetype, filesize, filetime) 
				VALUES ( " . $a_post_id . ", '" . $this->attach_filename . "', '" . $this->filename . "', '" . $this->file_comment . "', '" . $this->type . "', '" . $this->filesize . "', '" . $this->filetime . "')";
	
				//
				// Inform the user that his post has been created, but nothing is attached
				//
				if (!$db->sql_query($a_sql))
				{
					message_die(GENERAL_ERROR, "Couldn't store Attachment.<br />Your Post has been stored.", "", __LINE__, __FILE__, $a_sql);
				}
			}
		}
	}

	//
	// get all attachments from one post (intern)
	//
	function get_attachments_from_post($post_id)
	{
		global $db;		

		$attachments = array();

		$sql = "SELECT *
		FROM " . ATTACH_DESC_TABLE . "
		WHERE post_id = " . $post_id;
	
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Could not get attachment informations for specific posts", __LINE__, __FILE__, $sql);
		}

		if ( ($db->sql_numrows($result)) > 0 )
		{
			$attachments = $db->sql_fetchrowset($result);
		}
		
		return ($attachments);
		
	}

	//
	// Delete Attachment(s) from post(s) (intern)
	//
	function delete_attachment($a_post_id, $attach_id = -1)
	{
		global $attach_config, $db;

		$attachments = array();

		$whereclause = "WHERE post_id = " . $a_post_id;

		if ($attach_id != -1)
		{
			$whereclause = "WHERE attach_id IN ( ";
			$whereclause .= implode(", ", $attach_id);
			$whereclause .= " )";
		}

		// See if we have attachments in our post
		$sql = "SELECT attach_filename 
		FROM " . ATTACH_DESC_TABLE . " " .
		$whereclause;
	
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Can't query attach description table", "", __LINE__, __FILE__, $sql);
		}

		while ($row = $db->sql_fetchrow($result))
		{
			$attachments[] = $row['attach_filename'];
		}

		if ( count($attachments) > 0)
		{
			//
			// delete attachments
			//
			for ($i = 0; $i < count($attachments); $i++)
			{
				@unlink($attach_config['upload_dir'] . "/" . $attachments[$i]);
			}

			//
			// Delete rows
			//
			$sql = "DELETE FROM " . ATTACH_DESC_TABLE . " " . $whereclause;

			$result = $db->sql_query($sql);
		}

	}

	//
	// Attachment Mod entry switch/output (intern)
	//
	function display_attachment($post_id)
	{
		global $attach_config, $db, $is_auth, $lang, $mode, $phpEx, $template;
	
		$form_enctype = 'enctype="multipart/form-data"';
	
		$template->set_filenames(array(
			"attachbody" => "posting_attach_body.tpl")
		);
	
		$template->assign_vars(array(
			"L_ADD_ATTACH_TITLE" => $lang['Add_attachment_title'],
			"L_ADD_ATTACH_EXPLAIN" => $lang['Add_attachment_explain'],
			"L_ADD_ATTACHMENT" => $lang['Add_attachment'],
			"L_FILE_NAME" => $lang['File_name'],
			"L_FILE_COMMENT" => $lang['File_comment'],

			"FILE_COMMENT" => $this->file_comment,
			"FILESIZE" => $attach_config['max_filesize'],
			"FILENAME" => $this->filename,

			"S_FORM_ENCTYPE" => $form_enctype)	
		);

		$attachments = array();

		if  ( count($this->attachment_list) > 0 )
		{
			$template->assign_block_vars("switch_posted_attachments", array());

			$template->assign_vars(array(
				"L_POSTED_ATTACHMENTS" => $lang['Posted_attachments'],
				"L_UPDATE_COMMENT" => $lang['Update_comment'],
				"L_DELETE_ATTACHMENT" => $lang['Delete_attachment'])
			);

			for ($i = 0; $i < count($this->attachment_list); $i++)
			{
				$this->attachment_filename_list[$i] = stripslashes($this->attachment_filename_list[$i]);

				$hidden =  "<input type=\"hidden\" name=\"attachment_list[]\" value=\"" . $this->attachment_list[$i] . "\" />\n";
				$hidden .= "<input type=\"hidden\" name=\"filename_list[]\" value=\"" . $this->attachment_filename_list[$i] . "\" />\n";
				$hidden .= "<input type=\"hidden\" name=\"mimetype_list[]\" value=\"" . $this->attachment_mimetype_list[$i] . "\" />\n";
				$hidden .= "<input type=\"hidden\" name=\"filesize_list[]\" value=\"" . $this->attachment_filesize_list[$i] . "\" />\n";
				$hidden .= "<input type=\"hidden\" name=\"filetime_list[]\" value=\"" . $this->attachment_filetime_list[$i] . "\" />\n";
				$hidden .= "<input type=\"hidden\" name=\"attach_id_list[]\" value=\"" . $this->attachment_id_list[$i] . "\" />\n";
	
				if ( $this->attachment_id_list[$i] == "-1" )
				{
					$download_link = $attach_config['upload_dir'] . "/" . $this->attachment_list[$i];
				}
				else
				{
					$download_link = append_sid("attachment_mod." . $phpEx . "?download=" . $this->attachment_id_list[$i]);
				}

				$template->assign_block_vars("attach_row", array(
					"FILE_NAME" => $this->attachment_filename_list[$i],
					"ATTACH_FILENAME" => $this->attachment_list[$i],
					"FILE_COMMENT" => stripslashes(htmlspecialchars($this->attachment_comment_list[$i])),

					"U_VIEW_ATTACHMENT" => $download_link,
					"S_HIDDEN" => $hidden)
				);
			}
		}
		
		$template->assign_var_from_handle("ATTACHBOX", "attachbody");
	}

	//
	// Upload an Attachment to Filespace (intern)
	//
	function upload_attachment()
	{
		global $HTTP_POST_FILES, $db, $HTTP_POST_VARS, $error, $error_msg, $lang, $attach_config, $userdata, $HTTP_RAW_POST_DATA;
		
		$this->post_attach = ($this->filename != '') ? TRUE : FALSE;

		if ($this->post_attach) 
		{
			$file = $HTTP_POST_FILES['fileupload']['tmp_name'];
			$this->type = $HTTP_POST_FILES['fileupload']['type'];
		
			// Opera add the name to the mime type
			$this->type = ( strstr($this->type, "; name") ) ? str_replace(strstr($this->type, "; name"), '', $this->type) : $this->type;

			$extension = array(); 
			$mimetype = array();
			$mimeexplain = array();
			$allowed_filesize = 0;

			$sql = "SELECT extension 
			FROM " . ATTACH_EXTENSIONS_TABLE;

			if(!$result = $db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, "Could not query attachment information", "", __LINE__, __FILE__, $sql);
			}

			while($row = $db->sql_fetchrow($result))
			{
				$extension[] = '.' . $row['extension'];
			}
				
			$sql = "SELECT m.type_string, m.explain_mimetype
			FROM " . ATTACH_TYPECONFIG_TABLE . " m, " . ATTACH_TYPES_TABLE . " t 
			WHERE (t.allow_type = 1) AND (m.type_id = t.type_id)";

			if(!$result = $db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, "Could not query attachment information", "", __LINE__, __FILE__, $sql);
			}

			while($row = $db->sql_fetchrow($result))
			{
				$mimetype[] = $row['type_string'];
				$mimeexplain[] = $row['explain_mimetype'];
			}
				
			$sql = "SELECT t.max_filesize
			FROM " . ATTACH_TYPECONFIG_TABLE . " m, " . ATTACH_TYPES_TABLE . " t 
			WHERE (m.type_string = '" . $this->type . "') AND (m.type_id = t.type_id)";

			if(!$result = $db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, "Could not query attachment information", "", __LINE__, __FILE__, $sql);
			}

			$row = $db->sql_fetchrow($result);
			$allowed_filesize = ( $row['max_filesize'] != 0 ) ? $row['max_filesize'] : $attach_config['max_filesize'];

			$this->filesize = @filesize($file); 

			//
			// First of all, check our quota
			//
			if ($attach_config['attachment_quota'])
			{
				$sql = "SELECT sum(filesize) as total FROM " . ATTACH_DESC_TABLE;

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, "Could not query total filesize", "", __LINE__, __FILE__, $sql);
				}

				$row = $db->sql_fetchrow($result);
				$total_filesize = $row['total'];

				if ($total_filesize + $this->filesize > $attach_config['attachment_quota'])
				{
					$error = TRUE;
					if(!empty($error_msg))
					{
						$error_msg .= '<br />';
					}
					$error_msg .= $lang['Attach_quota_reached'];
				}
			}
			
			//
			// check Filename
			//
			if ( preg_match("/[\\/:*?\"<>|]/i", $this->filename) )
			{ 
				$error = TRUE;
				if(!empty($error_msg))
				{
					$error_msg .= '<br />';
				}
				$error_msg .= sprintf($lang['Invalid_filename'], $this->filename);
			}

			//
			// check php upload-size
			//
			if ( (!$error) && ($file == 'none') ) 
			{
				$error = TRUE;
				if(!empty($error_msg))
				{
					$error_msg .= '<br />';
				}
				$error_msg .= sprintf($lang['Attachment_php_size_overrun'], ini_get('upload_max_filesize')); 
			}

			//
			// check Filesize 
			//
			if ( (!$error) && ($allowed_filesize != 0) && ($this->filesize > $allowed_filesize) )
			{
				$size_lang = ($allowed_filesize >= 1048576) ? $lang['MB'] : ( ($allowed_filesize >= 1024) ? $lang['KB'] : $lang['Bytes'] );

				if ($allowed_filesize >= 1048576)
				{
					$allowed_filesize = round($allowed_filesize / 1048576 * 100) / 100;
				}
				else if($allowed_filesize >= 1024)
				{
					$allowed_filesize = round($allowed_filesize / 1024 * 100) / 100;
				}
			
				$error = TRUE;
				if(!empty($error_msg))
				{
					$error_msg .= '<br />';
				}
				$error_msg .= sprintf($lang['Attachment_too_big'], $allowed_filesize, $size_lang); 
			}

			//
			// Check Extension 
			//
			if ( (!$error) && (in_array(strrchr($this->filename, '.'), $extension))) 
			{ 
				$error = TRUE;
				if(!empty($error_msg))
				{
					$error_msg .= '<br />';
				}
				$error_msg .= sprintf($lang['Disallowed_extension'], strrchr($this->filename, '.'));
			} 

			//
			// Check Mime Type 
			//
			if ((!$error) && (!in_array($this->type, $mimetype))) 
			{
				$values = ''; 
		
				for ($i = 0; $i < sizeof($mimetype); $i++) 
				{
					$values .= $mimetype[$i];
					if (!empty($mimeexplain[$i])) 
					{
						$values .= ' ( ' . $mimeexplain[$i] . ' )';
					}
					$values .= '<br />';
				}

				$error = TRUE;
				if(!empty($error_msg))
				{
					$error_msg .= '<br />';
				}
				$error_msg .= sprintf($lang['Disallowed_Mime_Type'], $this->type, $values);
			} 
   
			if (!$error) 
			{
				//
				// Prepare Values
				//
				$this->filetime = time(); 
	
				$this->filename = stripslashes($this->filename);
				$this->filename = str_replace("'", "''", $this->filename);

				$this->filename = strtolower($this->filename);
				$this->attach_filename = str_replace(' ', '_', $userdata['user_id']) . '_' . $this->filetime . strrchr($this->filename, '.'); 
				$this->attach_filename = strtolower($this->attach_filename); 
			}

			//
			// Upload Attachment
			//
			if (!$error) 
			{
				if ( !($attach_config['ftp_upload']) )
				{
					//
					// Does the target directory exist ...
					//
					if ( !file_exists($attach_config['upload_dir']) )
					{
						$error = TRUE;
						if(!empty($error_msg))
						{
							$error_msg .= '<br />';
						}
						$error_msg .= sprintf($lang['Directory_does_not_exist'], $attach_config['upload_dir']);
					}

					//
					// Descide the Upload method
					//
					$ini_val = ( phpversion() >= '4.0.0' ) ? 'ini_get' : 'get_cfg_var';
				
					if ( @$ini_val('open_basedir') != '' )
					{
						if ( @phpversion() < '4.0.3' )
						{
							$upload_mode = 'copy';
						}
						else
						{
							$upload_mode = 'move';
						}
					}
					else
					{
						$upload_mode = 'copy';
					}
				}
				else
				{
					$upload_mode = 'ftp';
				}

				// 
				// Ok, upload the Attachment
				//
				if (!$error)
				{
					$this->move_uploaded_attachment($upload_mode, $file);
				}
			}

			if ($error) 
			{
				$this->post_attach = FALSE;
			}
		}
	}
	
	//
	// Copy the temporary attachment to the right location (copy, move_uploaded_file or ftp)
	//
	function move_uploaded_attachment($upload_mode, $file)
	{
		global $attach_config, $error, $error_msg, $lang;
				
		switch ($upload_mode)
		{
			case 'copy':
				if ( !@copy($file, $attach_config['upload_dir'] . "/" . $this->attach_filename) ) 
				{
					$error = TRUE;
					if(!empty($error_msg))
					{
						$error_msg .= "<br />";
					}
					$error_msg .= sprintf($lang['General_upload_error'], './' . $attach_config['upload_dir'] . '/' . $this->attach_filename);
					return;
				} 
				@chmod($attach_config['upload_dir'] . '/' . $this->attach_filename, 0777);
				break;

			case 'move':
				if ( !@move_uploaded_file($file, $attach_config['upload_dir'] . "/" . $this->attach_filename) ) 
				{ 
					$error = TRUE;
					if(!empty($error_msg))
					{
						$error_msg .= '<br />';
					}
					$error_msg .= sprintf($lang['General_upload_error'], './' . $attach_config['upload_dir'] . '/' . $this->attach_filename);
					return;
				} 
				@chmod($attach_config['upload_dir'] . '/' . $this->attach_filename, 0777);
				break;

			case 'ftp':
				break;
		}
	}

}

//
// Download Attachments
//
if ( $download )
{
	$mimetypes = array();

	//
	// Start session management
	//
	$userdata = session_pagestart($user_ip, PAGE_INDEX);
	init_userprefs($userdata);
	//
	// End session management
	//

	if (($attach_config['disable_mod'] == '1') && ($userdata['user_level'] != ADMIN))
	{
		message_die(GENERAL_MESSAGE, $lang['Attachment_feature_disabled']);
	}
	
	$sql = "SELECT * 
	FROM " . ATTACH_DESC_TABLE . "
	WHERE attach_id = " . intval($download);

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not query attachment informations", "", __LINE__, __FILE__, $sql);
	}

	if ($db->sql_numrows($result) == 0)
	{
		message_die(GENERAL_MESSAGE, $lang['Error_no_attachment']);
	}

	$attachment = $db->sql_fetchrow($result);

	// get forum_id for attachment authorization
	$sql = "SELECT forum_id
	FROM " . POSTS_TABLE . "
	WHERE post_id = " . $attachment['post_id'];

	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not query post information", "", __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	$forum_id = $row['forum_id'];

	//
	// Start session management the second
	//
	$userdata = session_pagestart($user_ip, $forum_id);
	init_userprefs($userdata);
	//
	// End session management the second
	//

	//
	// Start auth check
	//
	$is_auth = array();
	$is_auth = auth(AUTH_READ, $forum_id, $userdata); 
	//
	// End auth check
	//

	if (!$is_auth['auth_read'])
	{
		message_die(GENERAL_MESSAGE, $lang['Sorry_auth_view_attach']);
	}

	//
	// Get Information on currently allowed mime-types and their respective image-tag
	//
	$sql = "SELECT m.type_string 
	FROM " . ATTACH_TYPECONFIG_TABLE . " m, " . ATTACH_TYPES_TABLE . " t 
	WHERE (t.allow_type = '1') AND (m.type_id = t.type_id)";

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not query attachment information", "", __LINE__, __FILE__, $sql);
	}

	while($row = $db->sql_fetchrow($result))
	{
		$mimetypes[] = $row['type_string'];
	}

	//
	// disallowed ?
	//
	if (!in_array($attachment['mimetype'], $mimetypes)) 
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['Mime_type_disallowed_post'], $attachment['mimetype']));
	} 

	//
	// Some informations from the mime group
	//
	$sql = "SELECT m.type_id, t.download_mode
	FROM " . ATTACH_TYPECONFIG_TABLE . " m, " . ATTACH_TYPES_TABLE . " t 
	WHERE (m.type_id = t.type_id) AND (m.type_string = '" . $attachment['mimetype'] . "')";

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not query attachment information", "", __LINE__, __FILE__, $sql);
	}
	
	$row = $db->sql_fetchrow($result);
	$download_mode = intval($row['download_mode']);

	//
	// Update download count
	//
	$sql = "UPDATE " . ATTACH_DESC_TABLE . " 
	SET download_count = download_count + 1 
	WHERE attach_id = " . $attachment['attach_id'];
	
	if( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't update attachment download count", "", __LINE__, __FILE__, $sql);
	}

	if( !@file_exists($attach_config['upload_dir'] . "/" . $attachment['attach_filename']) )
	{
		message_die(GENERAL_MESSAGE, $lang['Error_no_attachment']);
	}
	
	//
	// Determine the 'presenting'-method
	//
	if ($download_mode == PHYSICAL_LINK)
	{
 		$header_location = ( @preg_match("/Microsoft|WebSTAR/", getenv("SERVER_SOFTWARE")) ) ? "Refresh: 0; URL=" : "Location: ";
 		header($header_location . $attach_config['upload_dir'] . "/" . $attachment['attach_filename']);
	}
	else
	{
		header("Content-Disposition: inline; filename=" . $attachment['filename']);
		header("Content-type: " . $attachment['mimetype']);
		readfile($attach_config['upload_dir'] . "/" . $attachment['attach_filename']); 
	}
}

//
// Create an object
//
$from_script = $SCRIPT_FILENAME;

if (empty($from_script) || $from_script == "")
{
	// all
	$attachment_mod['viewtopic'] = new Attach_viewtopic();
	$attachment_mod['viewforum'] = new Attach_viewforum();
	$attachment_mod['modcp'] = new Attach_modcp();
	$attachment_mod['posting'] = new Attach_posting();
} 
else
{
	if (strstr($from_script, "viewtopic"))
	{
		$attachment_mod['viewtopic'] = new Attach_viewtopic();
	}
	else if (strstr($from_script, "viewforum"))
	{
		$attachment_mod['viewforum'] = new Attach_viewforum();
	}
	else if (strstr($from_script, "modcp"))
	{
		$attachment_mod['modcp'] = new Attach_modcp();
	}
	else if (strstr($from_script, "posting"))
	{
		$attachment_mod['posting'] = new Attach_posting();
	}
	else
	{
		// all
		$attachment_mod['viewtopic'] = new Attach_viewtopic();
		$attachment_mod['viewforum'] = new Attach_viewforum();
		$attachment_mod['modcp'] = new Attach_modcp();
		$attachment_mod['posting'] = new Attach_posting();
	}
}

?>