/*
 phpBB2 - attach_mod schema in mssql (F. Javier Lancharro)

 $Id: attach_mssql_schema.sql,v 2.0.9 2002/03/01 meik Exp $

*/

BEGIN TRANSACTION
GO

CREATE TABLE [phpbb_attach_types] (
	[type_id] [int] IDENTITY (1, 1) NOT NULL ,
	[type_name] [char] (20) NOT NULL ,
	[category] [tinyint] NOT NULL ,
	[allow_type] [tinyint] NOT NULL ,
	[download_mode] [tinyint] NOT NULL ,
        [upload_image] [varchar] (100) NOT NULL ,
        [max_filesize] [int] NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE [phpbb_attach_config] (
	[config_name] [varchar] (100) NOT NULL ,
	[config_value] [varchar] (100) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [phpbb_attach_desc] (
	[attach_id] [int] IDENTITY (1, 1) NOT NULL ,
	[post_id] [int] NOT NULL ,
	[attach_filename] [text] NOT NULL ,
	[download_count] [int] NOT NULL ,
	[filename] [text] NOT NULL ,
	[comment] [text] NULL ,
	[mimetype] [text] NULL ,
	[filesize] [int] NOT NULL ,
	[filetime] [int] NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE [phpbb_attach_extensions] (
	[ext_id] [int] IDENTITY (1, 1) NOT NULL ,
	[extension] [char] (10) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [phpbb_attach_typeconfig] (
	[mime_id] [int] IDENTITY (1, 1) NOT NULL ,
	[type_id] [int] NOT NULL ,
	[type_string] [varchar] (100) NOT NULL ,
	[explain_mimetype] [varchar] (100) NOT NULL 
) ON [PRIMARY] 
GO

ALTER TABLE [phpbb_attach_config] WITH NOCHECK ADD 
	CONSTRAINT [PK_phpbb_attach_config] PRIMARY KEY  CLUSTERED 
	(
		[config_name]
	)  ON [PRIMARY] 
GO

ALTER TABLE [phpbb_attach_desc] WITH NOCHECK ADD 
	CONSTRAINT [PK_phpbb_attach_desc] PRIMARY KEY  CLUSTERED 
	(
		[attach_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [phpbb_attach_types] WITH NOCHECK ADD 
	CONSTRAINT [PK_phpbb_attach_types] PRIMARY KEY  CLUSTERED 
	(
		[type_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [phpbb_attach_desc] WITH NOCHECK ADD 
	CONSTRAINT [DF_phpbb_attach_desc_post_id] DEFAULT (0) FOR [post_id],
	CONSTRAINT [DF_phpbb_attach_desc_download_count] DEFAULT (0) FOR [download_count]
GO

ALTER TABLE [phpbb_attach_typeconfig] WITH NOCHECK ADD 
	CONSTRAINT [DF_phpbb_attach_typeconfig_type_id] DEFAULT (0) FOR [type_id]
GO

ALTER TABLE [phpbb_attach_types] WITH NOCHECK ADD 
	CONSTRAINT [DF_phpbb_attach_types_category] DEFAULT (0) FOR [category],
	CONSTRAINT [DF_phpbb_attach_types_allow_type] DEFAULT (0) FOR [allow_type]
	CONSTRAINT [DF_phpbb_attach_types_download_mode] DEFAULT (1) FOR [download_mode]
	CONSTRAINT [DF_phpbb_attach_types_max_filesize] DEFAULT (0) FOR [max_filesize]
GO

CREATE  INDEX [IX_phpbb_attach_typeconfig] ON [phpbb_attach_typeconfig]([type_id], [type_string]) ON [PRIMARY]
GO

CREATE  INDEX [IX_phpbb_attach_desc] ON [phpbb_attach_desc]([post_id]) ON [PRIMARY]
GO

COMMIT
GO