#
# phpBB2 - attach_mod schema
#
# $Id: attach_mysql_schema.sql,v 2.0.7 2002/02/23 meik Exp $
#

#
# Table structure for table 'phpbb_attach_types'
#
CREATE TABLE phpbb_attach_types (
  type_id mediumint(8) NOT NULL auto_increment,
  type_name char(20) NOT NULL,
  category tinyint(1) DEFAULT '0' NOT NULL, 
  allow_type tinyint(1) DEFAULT '0' NOT NULL,
  download_mode tinyint(1) UNSIGNED DEFAULT '1' NOT NULL,
  upload_image varchar(100),
  max_filesize int(20) DEFAULT '0' NOT NULL,
  PRIMARY KEY type_id (type_id)
);

#
# Table structure for table 'phpbb_attach_typeconfig'
#
CREATE TABLE phpbb_attach_typeconfig (
  mime_id mediumint(8) NOT NULL auto_increment,
  type_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  type_string varchar(100) NOT NULL,
  explain_mimetype varchar(100),
  PRIMARY KEY mime_id (mime_id),
  KEY type_id_type_string (type_id, type_string)
);

#
# Table structure for table 'phpbb_attach_extensions'
#
CREATE TABLE phpbb_attach_extensions (
  ext_id mediumint(8) UNSIGNED NOT NULL auto_increment, 
  extension char(10) NOT NULL, 
  PRIMARY KEY (ext_id)
);

#
# Table structure for table 'phpbb_attach_config'
#
CREATE TABLE phpbb_attach_config (
  config_name varchar(255) NOT NULL,
  config_value varchar(255) NOT NULL,
  PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_attach_desc'
#
CREATE TABLE phpbb_attach_desc (
  attach_id mediumint(8) UNSIGNED NOT NULL auto_increment,
  post_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  attach_filename varchar(255) NOT NULL,
  download_count mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  filename varchar(255) NOT NULL,
  comment char(60),
  mimetype char(60),
  filesize int(20) NOT NULL,
  filetime int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (attach_id),
  KEY post_id (post_id)
);
