#!/bin/sh
# install.sh
#
#
#
# Please actually read the README for once in your life!!  :-)
# 
#

clear
echo -e "\033[3;035m.....................................................................\033[0m"
echo "                                                                     "
echo "             Welcome to the pmfirewall setup script.                 "
echo -e "\033[3;035m.....................................................................\033[0m"
echo ""

# WELL ARE YOU ROOT?
if [ "$UID" != "0" ]
 then
   echo "Nice Try, The install script must be run as root"
   echo ""
   exit 1
fi

### ASK FOR CONFIG DIR
echo "You will now be prompted for your system configuration. Normally the"
echo "defaults are sufficient, but be sure they are correct!"
echo ""
printf "Directory to place config files [/usr/local/pmfirewall]: "
read CONFIG_DIR
if [ "$CONFIG_DIR" = "" ]
 then
   CONFIG_DIR=/usr/local/pmfirewall
fi
ABSPATH=`echo $CONFIG_DIR | grep "^/"`
if [ "$ABSPATH" = "" ]
 then
   echo "Config directory must be an absolute path"
   echo ""
   exit 2
fi
if [ ! -d $CONFIG_DIR ]
 then
   mkdir $CONFIG_DIR
   if [ $? != 0 ]
     then
       echo "ERROR: Failed to create directory $CONFIG_DIR"
       echo ""
     exit 2
  fi
fi

if [ -r "$CONFIG_DIR/pmfirewall.rules.local" ]
 then
    echo ""
    echo "An old version of pmfirewall has been detected. Due to major changes"
    echo "in the file structure, the current files will be moved to the backup"
    echo "location: $CONFIG_DIR/backup"
    mkdir $CONFIG_DIR/backup 1> /dev/null 2> /dev/null
    mv -f $CONFIG_DIR/* $CONFIG_DIR/backup 1> /dev/null 2> /dev/null

# COMMENTED OUT FOR FUTURE USE
#    if grep ver.PM1 $CONFIG_DIR/pmfirewall.rules.local > /dev/null 2>&1
#     then
#     echo ""
#     echo "Keeping current $CONFIG_DIR/pmfirewall.rules.local file."
#     cp -fp $CONFIG_DIR/backup/pmfirewall.rules.local  $CONFIG_DIR/ 1> /dev/null 2> /dev/null
#     echo ""
#    else
     echo ""
     sleep 1
     echo "Any custom settings contained in the pmfirewall.rules.local file will"
     echo "need to be added back into the local file.."
     echo ""
#  fi
fi

### REMOVE OLD SYMLINKS
rm -f /pmfirewall >/dev/null 2>&1
rm -f /etc/rc.d/init.d/pmfirewall >/dev/null 2>&1
rm -f /etc/init.d/pmfirewall >/dev/null 2>&1
rm -f /etc/rc.d/rc*.d/*pmfirewall >/dev/null 2>&1
rm -f /etc/rc*.d/*pmfirewall >/dev/null 2>&1   


### ASK FOR LOCATION OF IPCHAINS
echo ""
if [ -x /sbin/ipchains ]
 then
   IPCDEF=/sbin/ipchains
 else
   IPCDEF=""
fi
if [ "$IPCDEF" = "" ]
 then
   echo "Ipchains was not found on your system. If you are sure it is installed,"
   echo "please enter the full path below."
   echo ""
   printf "Full path to ipchains: "
   read IPC
   if [ "$IPC" = "" ]
    then
      echo "ERROR: No path entered!"
      echo ""
    exit 4
  fi
 else
  sleep 1
  echo "Using ipchains found at: $IPCDEF."
  echo ""
  IPC=$IPCDEF
fi


### ASK FOR EXTERNAL INTERFACE
echo ""
echo "What is your External Interface?"
echo ""
printf "External Interface [eth0]: "
read OUTERIF
if [ "$OUTERIF" = "" ]
 then
   OUTERIF=eth0
fi
echo ""


### CREATE FIREWALL RULES

## These are appended to the pmfirewall.rules.local file.

cp -f pmfirewall.rules.local $CONFIG_DIR/pmfirewall.rules.local

FWRULES=$CONFIG_DIR/pmfirewall.rules.local
echo  "     ### AUTOMATICALLY GENERATED BY THE INSTALL SCRIPT ###" >> $FWRULES
echo  "" >> $FWRULES

echo -e "\033[3;035m.....................................................................\033[0m"
echo ""
echo "You will now be asked questions which will help customize PMFirewall."
echo -e "\033[3;035m.....................................................................\033[0m"
echo ""
sleep 1

### FULL ACCESS
echo ""
echo ""
echo "Some networks may need to bypass your firewall."
echo "While this is not recommended, you have the option below."
echo ""
sleep 1
echo "WARNING: An entry of 0/0 will open your firewall to everyone and"
echo "render it useless!"
echo ""
sleep 1
printf "Are there any IP ranges which require unrestricted access? (y/N): "
read OPENYORN
while echo "$OPENYORN" | grep -iE '(y)' > /dev/null 2>&1
 do
  echo ""
  echo "The IP range must be entered in the ADDRESS/NETMASK format."
  echo "(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
  echo ""
  printf "Enter the IP Range or press ENTER to skip: "
  read OPENIP
  if [ "$OPENIP" != "" ]
   then
     echo "#UNRESTRICTED ACCESS " >> $FWRULES
     echo '$IPCHAINS -A input -s '"$OPENIP"' -d $REMOTENET -j ACCEPT' >> $FWRULES
  echo ""
     echo "Full access has been granted to $OPENIP."
   else
     echo ""
     echo "Nothing was entered. Rule has been skipped."
  fi
  echo ""
  printf "Do you wish to add others? (y/N): "
  read OPENYORN
done

sleep 1
### FULL DENY
echo ""
echo ""
echo ""
echo "Some hostile networks may need to be totally blocked."
echo "Only add an IP range here if you wish to block them completely."
echo ""
sleep 1
echo "WARNING: An entry of 0/0 will block access to everyone and make"
echo "all rules added after this useless."
echo ""
sleep 1
printf "Are there any IP ranges which should be blocked completely? (y/N): "
read CLOSEDYORN
while echo "$CLOSEDYORN" | grep -iE '(y)' > /dev/null 2>&1
 do
  echo ""
  echo "The IP range must be entered in the ADDRESS/NETMASK format."
  echo "(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
  echo ""
  printf "Enter the IP Range or press ENTER to skip: "
  read CLOSEDIP
  if [ "$CLOSEDIP" != "" ]
   then
     echo ""
     printf "Should access attempts from this IP range be logged? (Y/n): "
     read CLOSEDLOGYORN
     if  echo "$CLOSEDLOGYORN" | grep -iE '(y)' > /dev/null 2>&1
      then 
        echo "#BLOCKED " >> $FWRULES
        echo '$IPCHAINS -A input -s '"$CLOSEDIP"' -d $REMOTENET -j DENY -l' >> $FWRULES
      else
        echo "#BLOCKED " >> $FWRULES
        echo '$IPCHAINS -A input -s '"$CLOSEDIP"' -d $REMOTENET -j DENY' >> $FWRULES
     fi
     echo ""
     echo "The IP range $CLOSEDIP has been blocked."
   else
     echo ""
     echo "Nothing was entered. Rule has been skipped."
  fi
  echo ""
  printf "Do you wish to add others? (y/N): "
  read CLOSEDYORN
done

sleep 1

### IS YOUR IP ASSIGNED VIA DHCP?
echo ""
printf "Is your IP address assigned via DHCP?  (y/N): "
read DHCPIPYORN
if echo "$DHCPIPYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo "#DHCP CLIENT ALLOW " >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 67:68 -i $OUTERIF -j ACCEPT' >> $FWRULES
   DHCPIP=1
 else
   echo "#DHCP CLIENT BLOCK " >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 67:68 -i $OUTERIF -j DENY' >> $FWRULES
fi


### FTP?
echo ""
printf "Are you running a FTP Server on ports: 20/21 (y/N): "
read FTPYORN
if echo "$FTPYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to ports 20/21 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read FTPIP
    if [ "$FTPIP" = "" ]
     then
      echo "#FTP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 20 -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 21 -j ACCEPT' >> $FWRULES
     else
      echo "#FTP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$FTPIP"' -d $OUTERNET 20 -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$FTPIP"' -d $OUTERNET 21 -j ACCEPT' >> $FWRULES
    fi
fi

### SSH?
echo ""
printf "Are you running a SSH Server on port: 22 (y/N): "
read SSHYORN
if echo "$SSHYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 22 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read SSHIP
    if [ "$SSHIP" = "" ]
     then
      echo "#SSH " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 22 -j ACCEPT' >> $FWRULES
     else
      echo "#SSH " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$SSHIP"' -d $OUTERNET 22 -j ACCEPT' >> $FWRULES
    fi
fi

### TELNET?
echo ""
printf "Are you running a Telnet Server on port: 23 (y/N): "
read TELNETYORN
if echo "$TELNETYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 23 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read TELNETIP
    if [ "$TELNETIP" = "" ]
     then
      echo "#TELNET " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 23 -j ACCEPT' >> $FWRULES
     else
      echo "#TELNET " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$TELNETIP"' -d $OUTERNET 23 -j ACCEPT' >> $FWRULES
    fi
fi

### SMTP?
echo ""
printf "Are you running a SMTP Server on port: 25 (y/N): "
read SMTPYORN
if echo "$SMTPYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 25 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read SMTPIP
    if [ "$SMTPIP" = "" ]
     then
      echo "#SMTP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 25 -j ACCEPT' >> $FWRULES
     else 
      echo "#SMTP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$SMTPIP"' -d $OUTERNET 25 -j ACCEPT' >> $FWRULES
   fi
fi

### DNS?
echo ""
printf "Are you running a DNS Server on port: 53 (y/N): "
read DNSYORN
if echo "$DNSYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 53 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read DNSIP
    if [ "$DNSIP" = "" ]
     then
      echo "#DNS " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 53 -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $OUTERNET 53 -j ACCEPT' >> $FWRULES
     else
      echo "#DNS " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 53 -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s '"$DNSIP"' -d $OUTERNET 53 -j ACCEPT' >> $FWRULES
   fi
fi

### FINGER?
echo ""
printf "Are you running a Finger Server on port: 79 (y/N): "
read FINGERYORN
if echo "$FINGERYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 79 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read FINGERIP
    if [ "$FINGERIP" = "" ]
     then
      echo "#FINGER " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 79 -j ACCEPT' >> $FWRULES
     else
      echo "#FINGER " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$FINGERIP"' -d $OUTERNET 79 -j ACCEPT' >> $FWRULES
   fi
fi


### Webserver?
echo ""
printf "Are you running a Web Server on port: 80 (y/N): "
read WEBYORN
if echo "$WEBYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 80 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read WEBIP
    if [ "$WEBIP" = "" ]
     then
      echo "#HTTPD " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 80 -j ACCEPT' >> $FWRULES
     else
      echo "#HTTPD " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$WEBIP"' -d $OUTERNET 80 -j ACCEPT' >> $FWRULES
   fi
fi

### POP?
echo ""
printf "Are you running a POP Server on port: 110 (y/N): "
read POPYORN
if echo "$POPYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 110 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read POPIP
    if [ "$POPIP" = "" ]
     then
      echo "#POP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 110 -j ACCEPT' >> $FWRULES
     else
      echo "#POP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$POPIP"' -d $OUTERNET 110 -j ACCEPT' >> $FWRULES
   fi
fi

### IDENTD?
echo ""
printf "Allow IDENT connections on port: 113 (y/N): "
read IDENTYORN
if echo "$IDENTYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
      echo "#IDENTD " >> $FWRULES
   echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 113 -j ACCEPT' >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $OUTERNET 113 -j ACCEPT' >> $FWRULES
 else
      echo "#IDENTD " >> $FWRULES
   echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 113 -j REJECT' >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $OUTERNET 113 -j REJECT' >> $FWRULES
fi

### NNTP?
echo ""
printf "Are you running a NNTP Server port: 119 (y/N): "
read NNTPYORN
if echo "$NNTPYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 119 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read NNTPIP
    if [ "$NNTPIP" = "" ]
     then
      echo "#NNTP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 119 -j ACCEPT' >> $FWRULES
     else
      echo "#NNTP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$NNTPIP"' -d $OUTERNET 119 -j ACCEPT' >> $FWRULES
   fi
fi

### NTP?
echo ""
printf "Are you using NTP, it requires port: 123 (y/N): "
read NTPYORN
if echo "$NTPYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 123 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read NTPIP
    if [ "$NTPIP" = "" ]
     then
      echo "#NTP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 123 -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $OUTERNET 123 -j ACCEPT' >> $FWRULES
     else
      echo "#NTP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$NTPIP"' -d $OUTERNET 123 -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s '"$NTPIP"' -d $OUTERNET 123 -j ACCEPT' >> $FWRULES
   fi
fi

### NETBIOS/SAMBA?
echo ""
printf "Do you wish to open NetBIOS/SAMBA ports 137-139 (not recommended)? (y/N): "
read SAMBAYORN
if echo "$SAMBAYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to ports 137-139 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read SAMBAIP
    if [ "$SAMBAIP" = "" ]
     then
      echo "#NETBIOS " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $REMOTENET 137:139 -i $OUTERIF -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 137:139 -i $OUTERIF -j ACCEPT' >> $FWRULES
     else
      echo "#NETBIOS " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$SAMBAIP"' -d $REMOTENET 137:139 -i $OUTERIF -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s '"$SAMBAIP"' -d $REMOTENET 137:139 -i $OUTERIF -j ACCEPT' >> $FWRULES
   fi
 else
   echo "#NETBIOS " >> $FWRULES
   echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $REMOTENET 137:139 -i $OUTERIF -j DENY' >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 137:139 -i $OUTERIF -j DENY' >> $FWRULES 
fi

### IMAP?
echo ""
printf "Are you running an IMAP Server on port: 143 (y/N): "
read IMAPYORN
if echo "$IMAPYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 143 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read IMAPIP
    if [ "$IMAPIP" = "" ]
     then
      echo "#IMAP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 143 -j ACCEPT' >> $FWRULES
     else
      echo "#IMAP " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$IMAPIP"' -d $OUTERNET 143 -j ACCEPT' >> $FWRULES
   fi
fi

### SSL?
echo ""
printf "Are you running a SSL Web Server on port: 443 (y/N): "
read SSLYORN
if echo "$SSLYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 443 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read SSLIP
    if [ "$SSLIP" = "" ]
     then
      echo "#SSL " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 443 -j ACCEPT' >> $FWRULES
     else
      echo "#SSL " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$SSLIP"' -d $OUTERNET 443 -j ACCEPT' >> $FWRULES
   fi
fi

### RIP?
echo ""
printf "Are you running Routed (RIP) on port: 520 (y/N): "
read RIPYORN
if echo "$RIPYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo "#RIP " >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 520 -j ACCEPT' >> $FWRULES
 else
   echo "#RIP " >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 520 -i $OUTERIF -j REJECT' >> $FWRULES
fi

### NFS?
echo ""
printf "Do you wish to open NFS port 2049 (not recommended)? (y/N): "
read NFSYORN
if echo "$NFSYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to port 2049 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read NFSIP
    if [ "$NFSIP" = "" ]
     then
      echo "#NFS " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $REMOTENET 2049 -i $OUTERIF -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 2049 -i $OUTERIF -j ACCEPT' >> $FWRULES
     else
      echo "#NFS " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$NFSIP"' -d $REMOTENET 2049 -i $OUTERIF -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s '"$NFSIP"' -d $REMOTENET 2049 -i $OUTERIF -j ACCEPT' >> $FWRULES
   fi
 else
   echo "#NFS " >> $FWRULES
   echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $REMOTENET 2049 -i $OUTERIF -j DENY -l' >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 2049 -i $OUTERIF -j DENY -l' >> $FWRULES
fi

### XSERVER?
echo ""
printf "Do you wish to open X-Server ports 5999-6003 (not recommended)? (y/N): "
read XSERVERYORN
if echo "$XSERVERYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   echo ""
   echo "You may allow connections to ports 5999-6003 from any IP address on the"
   echo "Internet, or just a specific IP range. Please enter the IP range in the"
   echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
   echo ""
   printf "Enter the IP Range or press ENTER for any IP address: "
   read XSERVERIP
    if [ "$XSERVERIP" = "" ]
     then
      echo "#XSERVER " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $REMOTENET 5999:6003 -i $OUTERIF -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 5999:6003 -i $OUTERIF -j ACCEPT' >> $FWRULES
     else
      echo "#XSERVER " >> $FWRULES
      echo '$IPCHAINS -A input -p tcp -s '"$XSERVERIP"' -d $REMOTENET 5999:6003 -i $OUTERIF -j ACCEPT' >> $FWRULES
      echo '$IPCHAINS -A input -p udp -s '"$XSERVERIP"' -d $REMOTENET 5999:6003 -i $OUTERIF -j ACCEPT' >> $FWRULES
   fi
 else
   echo "#XSERVER " >> $FWRULES
   echo '$IPCHAINS -A input -p tcp -s $REMOTENET -d $REMOTENET 5999:6003 -i $OUTERIF -j DENY' >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET -d $REMOTENET 5999:6003 -i $OUTERIF -j DENY' >> $FWRULES
fi

### CUSTOM RULES?
echo ""
printf "Are there any other ports you wish to open to the outside? (y/N): "
read CUSTOMYORN
while echo "$CUSTOMYORN" | grep -iE '(y)' > /dev/null 2>&1 
 do
   echo "Please only enter one service at a time. This will repeat."
   printf "Port number: "
   read CUSTOMPORT
 until  [ "$CUSTOMPORT" -le "65535" ]  > /dev/null 2>&1
   do
    echo "Not a valid port, try again."
    printf "Port number: "
    read CUSTOMPORT
   done
  printf "tcp, udp or both: "
  read CUSTOMPROT
 until  [ "$CUSTOMPROT" != "" ]  > /dev/null 2>&1
   do
    echo "Not a valid protocol, try again."
    printf "tcp, udp or both: "
    read CUSTOMPROT
   done
  echo ""
  echo "You may allow connections to port $CUSTOMPORT from any IP address on the"
  echo "Internet, or just a specific IP range. Please enter the IP range in the"
  echo "ADDRESS/NETMASK format.(ex. 1.2.3.0/24 or 1.2.3.0/255.255.255.0)."
  echo ""
  printf "Enter the IP Range or press ENTER for any IP address: "    
  read CUSTOMIP
  if [ "$CUSTOMIP" = "" ]
   then 
   CUSTOMIP='$OUTERNET'
  fi
  if echo "$CUSTOMPROT" | grep -iE '(tcp|udp)' > /dev/null 2>&1
   then
     echo "#CUSTOM " >> $FWRULES
     echo '$IPCHAINS -A input -p'" $CUSTOMPROT -s $CUSTOMIP"' -d $REMOTENET '"$CUSTOMPORT"' -i $OUTERIF -j ACCEPT' >> $FWRULES
  elif echo "$CUSTOMPROT" | grep -iE '(both)' > /dev/null 2>&1 
  then
     CUSTOMPROT=tcp
     CUSTOMPROT2=udp
     echo "#CUSTOM " >> $FWRULES
     echo '$IPCHAINS -A input -p'" $CUSTOMPROT -s $CUSTOMIP"' -d $REMOTENET '"$CUSTOMPORT"' -i $OUTERIF -j ACCEPT' >> $FWRULES
     echo '$IPCHAINS -A input -p'" $CUSTOMPROT2 -s $CUSTOMIP"' -d $REMOTENET '"$CUSTOMPORT"' -i $OUTERIF -j ACCEPT' >> $FWRULES
   else
     echo "Rule not added, the protocol was not valid."
  fi
  printf "Do you wish to add others? (y/N): "
  read CUSTOMYORN
done


### START AT BOOT?
ATBOOT=1
echo ""
printf "Start PMFirewall on bootup? (Y/n): "
read ATBOOTYORN
if echo "$ATBOOTYORN" | grep -iE '(n)' > /dev/null 2>&1
 then
  ATBOOT=0
fi


### CREATE CONFIG FILE
CFILE=$CONFIG_DIR/pmfirewall.conf
echo '#!/bin/sh' > $CFILE
echo '# pmfirewall.conf - used by pmfirewall package' >> $CFILE
echo "IPCHAINS=$IPC" >> $CFILE
echo "ATBOOT=$ATBOOT" >> $CFILE
echo "CONFIG_DIR=$CONFIG_DIR" >> $CFILE
echo "OUTERIF=$OUTERIF" >> $CFILE
echo 'REMOTENET=0/0' >> $CFILE

### AUTODETECT IP OR NOT?
echo ""
echo "PMFirewall has the ability to autodetect your IP address information. You"
echo "may override the atuodetection and specify your IP information here."
echo "Overriding is not recommended if you are assigned a different IP address"
echo "each time you connect to the outside world."
echo ""
printf "Do you want pmfirewall to autodetect your IP address? (Y/n): "
read AUTOIPYORN
if echo "$AUTOIPYORN" | grep -iE '(n)' > /dev/null 2>&1
 then        
   echo ""
   printf "Please enter your IP address without the subnet mask (ex. 1.2.3.4): "
   read STATICIP
   until  [ "$STATICIP" != "" ]
     do
      echo ""
      echo "You must enter an IP address. Try again."
      printf "IP Address: "
      read STATICIP
     done                     
   echo ""
   printf "Please enter your subnet mask (ex. 255.255.255.255): "
   read STATICMASK
   until  [ "$STATICMASK" != "" ]
     do
      echo ""
      echo "You must enter a subnet mask. Try again."
      printf "Subnet Mask: "
      read STATICMASK
     done       
   echo "OUTERIP=$STATICIP" >> $CFILE  
   echo "OUTERMASK=$STATICMASK" >> $CFILE  
   echo 'OUTERNET=$OUTERIP/$OUTERMASK' >> $CFILE      
 else
   echo 'OUTERIP=`ifconfig $OUTERIF | grep inet | cut -d : -f 2 | cut -d \  -f 1`' >> $CFILE
   echo 'OUTERMASK=`ifconfig $OUTERIF | grep Mas | cut -d : -f 4`' >> $CFILE
   echo 'OUTERNET=$OUTERIP/$OUTERMASK' >> $CFILE     
fi

### WILL THEY USE MASQUERADING?
MASQ=0
echo ""
printf "Will this box Masquerade connections for other PC's (y/N): "
read MASQYORN
if echo "$MASQYORN" | grep -iE '(y)' > /dev/null 2>&1
 then
   MASQ=1
fi
echo ""	
if [ "$MASQ" = "1" ]
 then
   ### ASK FOR INTERNAL INTERFACE
   INTERNALIF=""
   echo ""
   echo "What is your Internal Interface?"
   echo ""
    if echo "$OUTERIF" | grep -iE '(ppp)' > /dev/null 2>&1
     then 
        printf "Internal Interface [eth0]: "
        read INTERNALIF
        if [ "$INTERNALIF" = "" ]; then
            INTERNALIF=eth0
        fi
    else
        printf "Internal Interface [eth1]: "
        read INTERNALIF
        if [ "$INTERNALIF" = "" ]; then
            INTERNALIF=eth1
        fi
    fi

   printf "Do you want pmfirewall to autodetect your internal IP address? (Y/n): "
   read INAUTOIPYORN
   if echo "$INAUTOIPYORN" | grep -iE '(n)' > /dev/null 2>&1
    then        
      echo ""
      printf "Please enter your IP address (ex. 1.2.3.4): "
      read INSTATICIP
      until  [ "$INSTATICIP" != "" ]
        do
         echo ""
         echo "You must enter an IP address. Try again."
         printf "IP Address: "
         read INSTATICIP
        done                     
      echo ""
      printf "Please enter your subnet mask (ex. 255.255.255.255): "
      read INSTATICMASK
      until  [ "$INSTATICMASK" != "" ]
        do
         echo ""
         echo "You must enter a subnet mask. Try again."
         printf "Subnet Mask: "
         read INSTATICMASK
        done       
      echo "INTERNALIF=$INTERNALIF" >> $CFILE
      echo "INTERNALIP=$INSTATICIP" >> $CFILE
      echo "INTERNALMASK=$INSTATICMASK" >> $CFILE
      echo 'INTERNALNET=$INTERNALIP/$INTERNALMASK' >> $CFILE
      echo ""
     else
      echo "INTERNALIF=$INTERNALIF" >> $CFILE
      echo 'INTERNALIP=`ifconfig $INTERNALIF | grep inet | cut -d : -f 2 | cut -d \  -f 1`' >> $CFILE
      echo 'INTERNALMASK=`ifconfig $INTERNALIF | grep Mas | cut -d : -f 4`' >> $CFILE
      echo 'INTERNALNET=$INTERNALIP/$INTERNALMASK' >> $CFILE
      echo ""
   fi
fi

if [ "$MASQ" = "1" ]
 then
  printf "Will you be running a DHCP Server (y/N): "
  read DHCPYORN
  if echo "$DHCPYORN" | grep -iE '(y)' > /dev/null 2>&1
   then
   echo "#DCHP SERVER " >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET 67 -i $INTERNALIF -j ACCEPT' >> $FWRULES
   echo '$IPCHAINS -A input -p udp -s $REMOTENET 68 -i $INTERNALIF -j ACCEPT' >> $FWRULES
  fi
  echo ""
fi


### CREATE pmfirewall CONTROL SCRIPT
CONTROLFILE=$CONFIG_DIR/pmfirewall 
echo '#!/bin/sh' > $CONTROLFILE
echo "# pmfirewall" >> $CONTROLFILE
echo "# chkconfig: 2345 50 80" >> $CONTROLFILE
echo "# description: Control script for pmfirewall package." >> $CONTROLFILE
echo "#"  >> $CONTROLFILE
echo ""  >> $CONTROLFILE
echo "CONFIG_DIR=$CONFIG_DIR" >> $CONTROLFILE
if [ -r "/etc/rc.d/init.d/functions" ]
 then
   echo "# Source function library."  >> $CONTROLFILE
   echo ". /etc/rc.d/init.d/functions"  >> $CONTROLFILE
fi
if [ "$MASQ" = "1" ]
 then
   cat pmfirewall.ctl.masq >> $CONTROLFILE
 else
   cat pmfirewall.ctl >> $CONTROLFILE
fi


### COPY FILES TO CONFIG DIR
echo -n "Copying files to $CONFIG_DIR"
cp -f pmfirewall.rules.1 $CONFIG_DIR/pmfirewall.rules.1
cp -f pmfirewall.rules.masq  $CONFIG_DIR/pmfirewall.rules.masq
cp -f README $CONFIG_DIR/README.pmfirewall
cp -f IPCHAINS-HOWTO $CONFIG_DIR/IPCHAINS-HOWTO
cp -f pmfirewall.8.bz2 /usr/man/man8/pmfirewall.8.bz2
echo "			Done!"
echo ""
sleep 2


## CHANGE OWNERSHIP
echo -n "Changing ownership of pmfirewall to root:bin"
chown 0:0 $CONFIG_DIR/pmfirewall.rules.1
chown 0:0 $CONFIG_DIR/pmfirewall.rules.local
chown 0:0 $CONFIG_DIR/pmfirewall.rules.masq
chown 0:0 $CONFIG_DIR/pmfirewall.conf
chown 0:0 $CONFIG_DIR/pmfirewall
chown 0:0 $CONFIG_DIR/README.pmfirewall
echo "		Done!"
echo ""
sleep 2

# CHANGE PERMISSIONS
echo -n "Changing permissions of pmfirewall to 700"
chmod 700 $CONFIG_DIR/pmfirewall.rules.1
chmod 700 $CONFIG_DIR/pmfirewall.rules.local
chmod 700 $CONFIG_DIR/pmfirewall.rules.masq
chmod 700 $CONFIG_DIR/pmfirewall.conf
chmod 700 $CONFIG_DIR/pmfirewall
echo "		Done!"
echo ""
sleep 2

## ADD AND SETUP init.d control files
if [ -d "/etc/rc.d/init.d/" ]
 then
  ln -sf $CONFIG_DIR/pmfirewall /etc/rc.d/init.d/pmfirewall
fi
if [ -d "/etc/init.d/" ]
 then
  ln -sf $CONFIG_DIR/pmfirewall /etc/init.d/pmfirewall
fi


### BOOT STARTUP CONFIGURE

if [ "$ATBOOT" = "1" ]
 then
  BOOTSET=1
fi

## Covers some with SYS V init (Redhat, Mandrake, OpenLinux, SuSE)
if [ "$ATBOOT" = "1"  -a -r "/etc/rc.d/init.d/pmfirewall" ]
 then
   echo "Adding to init structure at /etc/rc.d/init.d/"
   echo -n "Configuring to start at boot time"
   ln -sf /etc/rc.d/init.d/pmfirewall /etc/rc.d/rc0.d/K80pmfirewall
   ln -sf /etc/rc.d/init.d/pmfirewall /etc/rc.d/rc1.d/K80pmfirewall
   ln -sf /etc/rc.d/init.d/pmfirewall /etc/rc.d/rc2.d/S50pmfirewall
   ln -sf /etc/rc.d/init.d/pmfirewall /etc/rc.d/rc3.d/S50pmfirewall
   ln -sf /etc/rc.d/init.d/pmfirewall /etc/rc.d/rc4.d/S50pmfirewall
   ln -sf /etc/rc.d/init.d/pmfirewall /etc/rc.d/rc5.d/S50pmfirewall
   ln -sf /etc/rc.d/init.d/pmfirewall /etc/rc.d/rc6.d/K80pmfirewall
   echo "			Done!"
   echo ""
   BOOTSET=0
   sleep 2

## Covers some with SYS V init (Debian)
elif [ "$ATBOOT" = "1"  -a -r "/etc/init.d/pmfirewall" ]
 then
   echo "Adding to init structure at /etc/init.d/"
   echo -n "Configuring to start at boot time"
   ln -sf /etc/init.d/pmfirewall /etc/rc0.d/K80pmfirewall
   ln -sf /etc/init.d/pmfirewall /etc/rc1.d/K80pmfirewall
   ln -sf /etc/init.d/pmfirewall /etc/rc2.d/S50pmfirewall
   ln -sf /etc/init.d/pmfirewall /etc/rc3.d/S50pmfirewall
   ln -sf /etc/init.d/pmfirewall /etc/rc4.d/S50pmfirewall
   ln -sf /etc/init.d/pmfirewall /etc/rc5.d/S50pmfirewall
   ln -sf /etc/init.d/pmfirewall /etc/rc6.d/K80pmfirewall
   echo "			Done!"
   echo ""
   BOOTSET=0
   sleep 2

## Covers any with /etc/rc.d/rc.local (Slackware)
elif [ "$ATBOOT" = "1"  -a ! -d "/etc/rc.d/init.d/" -a -r "/etc/rc.d/rc.local" ]
 then
   echo "Adding to /etc/rc.d/rc.local"
   echo -n "Configuring to start at boot time"
   echo "" >> /etc/rc.d/rc.local
   echo "#Start PMFirewall" >> /etc/rc.d/rc.local
   echo "[ -x "$CONFIG_DIR/pmfirewall" ] && $CONFIG_DIR/pmfirewall start" >> /etc/rc.d/rc.local
   echo "			Done!"
   echo ""
   BOOTSET=0
   sleep 2

## Covers any with /etc/rc.local (unknown)
elif [ "$ATBOOT" = "1"  -a ! -d "/etc/init.d/" -a -r "/etc/rc.local" ]
 then
   echo "Adding to /etc/rc.local"
   echo -n "Configuring to start at boot time"
   echo "" >> /etc/rc.local
   echo "#Start PMFirewall" >> /etc/rc.local
   echo "[ -x "$CONFIG_DIR/pmfirewall" ] && $CONFIG_DIR/pmfirewall start" >> /etc/rc.local
   echo "			Done!"
   echo ""
   BOOTSET=0
   sleep 2
fi

## UNABLE TO START AT BOOT
if [ "$BOOTSET" = "1" ]
 then
   echo "Unable to automatically start at boot."
   echo "Please add to bootup manually."
   echo ""
   sleep 2
fi

## PPP SETUP

PPPBOOT=0
if echo "$OUTERIF" | grep -iE '(ppp)' > /dev/null 2>&1
 then
  echo ""
  printf "Start PMFirewall upon successful PPP Connection (y/N): "
  read PPPBOOTYORN
   if echo "$PPPBOOTYORN" | grep -iE '(y)' > /dev/null 2>&1
    then
     PPPBOOT=1
   fi
fi

if [ "$PPPBOOT" = "1" ]
 then
  echo ""
  echo "Adding PMFirewall to PPP startup."
  if grep /etc/ppp/ip-up.local /etc/ppp/ip-up >/dev/null 2>&1
   then
    if [ ! -f /etc/ppp/ip-up.local ]
     then
       echo '#!/bin/sh' > /etc/ppp/ip-up.local
       chmod 755 /etc/ppp/ip-up.local
    fi
    if grep pmfirewall /etc/ppp/ip-up.local >/dev/null 2>&1
     then
       echo "PMFirewall entry found in /etc/ppp/ip-up.local."
       echo "ip-up.local will not be changed."
       echo ""
       sleep 2
     else
       echo "" >> /etc/ppp/ip-up.local
       echo "[ -x "$CONFIG_DIR/pmfirewall" ] && $CONFIG_DIR/pmfirewall start" >> /etc/ppp/ip-up.local
       sleep 2
    fi
   else
     echo "Unable to start upon PPP activation." 
     echo "Please start manually after each connection."
     echo ""
     sleep 2
  fi
fi

### DCHP SETUP
if [ "$DHCPIP" = "1" -a "$ATBOOT" = "1" ]
 then
  echo ""
  echo "Starting DCHP Setup."
  if [ ! -d /etc/dhcpc/ ]
   then
    mkdir /etc/dhcpc/
  fi
  if [ ! -f /etc/dhcpc/dhcpcd-$OUTERIF.exe ]
   then
     echo '#!/bin/sh' > /etc/dhcpc/dhcpcd-$OUTERIF.exe
     chmod 755 /etc/dhcpc/dhcpcd-$OUTERIF.exe
  fi
  if grep $CONFIG_DIR/pmfirewall /etc/dhcpc/dhcpcd-$OUTERIF.exe >/dev/null 2>&1
   then
     echo "PMFirewall entry found in /etc/dhcpc/dhcpcd-$OUTERIF.exe."
     echo "dhcpcd-$OUTERIF.exe will not be changed."
     echo ""
     DHCPIP=0
     sleep 2
   else
     echo "" >> /etc/dhcpc/dhcpcd-$OUTERIF.exe
     echo "[ -x "$CONFIG_DIR/pmfirewall" ] && $CONFIG_DIR/pmfirewall start" >> /etc/dhcpc/dhcpcd-$OUTERIF.exe
     echo "Adding PMFirewall entry to /etc/dhcpc/dhcpcd-$OUTERIF.exe."
     echo ""
     DHCPIP=0
     sleep 2
  fi
fi

if [ "$DHCPIP" = "1" ]; then
   echo "Unable to add PMFirewall to DHCP Startup." 
   echo "Please start manually after each new IP assignment."
   echo ""
   sleep 2
fi

if [ "$ATBOOT" = "0" ]
 then
   echo "Skipping startup configuration."
   echo ""
   sleep 2
fi

### CREATE pmfirewall uninstall script
echo -n "Creating uninstall script"
UNINFILE=$CONFIG_DIR/uninstall
echo '#!/bin/sh' > $UNINFILE
echo "# uninstall" >> $UNINFILE
echo "# description: Uninstall script for pmfirewall package." >> $UNINFILE
echo "#"  >> $UNINFILE
echo ""  >> $UNINFILE
echo "CONFIG_DIR=$CONFIG_DIR" >> $UNINFILE
cat uninstall.make >> $UNINFILE
chown 0:0 $CONFIG_DIR/uninstall
chmod 700 $CONFIG_DIR/uninstall
echo "				Done!"
echo ""
sleep 2
echo -e "\a"
echo -e "\033[3;035m.......................................................................\033[0m"
echo ""
echo "        PMFirewall has been successfully installed!      "
echo ""      
echo "        Configuration Directory: $CONFIG_DIR "
echo ""      
echo "        For a list of PMFirewall commands type:   "      
echo ""      
echo "        $CONFIG_DIR/pmfirewall help   "      
echo ""      
echo "        For the man page type: man pmfirewall "      
echo ""      
echo "        Please visit http://www.pointman.org"      
echo "            for updates and information. "     
echo ""
echo -e "\033[3;035m.......................................................................\033[0m"
echo ""

# EOF

