/*
 *  $Id: demo.c,v 1.4 1999/10/14 13:34:09 martin Exp martin $
 *
 *  $Log: demo.c,v $
 *  Revision 1.4  1999/10/14 13:34:09  martin
 *  Fix unintialised char ptr.
 *
 *  Revision 1.3  1999/10/14 10:50:34  martin
 *  Chnages for Windows.
 *
 *  Revision 1.2  1999/06/11 09:36:20  martin
 *  Update.
 *
 *  Revision 1.1  1999/03/15 15:03:03  martin
 *  Initial revision
 *
 */
#ifdef WIN32
#include <windows.h>
#include <io.h>
#define F_OK 0
#define R_OK 4
#define access _access
#endif

#include <stdio.h>
#ifndef WIN32
#include <unistd.h>
#endif

#include <sql.h>
#include <sqlext.h>

static void notice(void);
static unsigned char menu(int redisplay);
static void requirements(void);
static SQLRETURN test(void);
static SQLRETURN contact(void);
static int check_for_ini(void);
static void extract_error(char *fn, SQLHANDLE handle, SQLSMALLINT type);
static void press_key(void);
    
int main(int argc, char *argv[])
{
    unsigned char       choice;
    int                 redisplay = 1;
    SQLRETURN           ret;
    
    notice();
    while(1)
    {
        choice = menu(redisplay);
        switch(choice)
        {
          case '1':
          {
              notice();
              redisplay = 1;
              break;
          }
          case '2':
          {
              requirements();
              redisplay = 1;
              break;
          }
          case '3':
          {
              ret = test();
              redisplay = 1;              
              break;
          }
          case '4':
          {
              ret = contact();
              redisplay = 1;
              break;
          }
          case '5':
          {
              printf("Bye\n");
              return 0;
          }
          default:
          {
              printf("\nInvalid choice\n");
              redisplay = 0;
          }
        }
    }
    
    return 0;
}


static SQLRETURN test(void)
{
    SQLHENV             env;
    SQLHDBC             dbc;
    SQLRETURN           ret;
    char                outstr[1024];
    SQLSMALLINT         outstr_len;
    char                info[100];
    SQLSMALLINT         info_len;
    struct xinfo
    {
        SQLUSMALLINT    attr;
        char            *attr_name;
        char            *heading;
    };
    unsigned int        i;
    
    struct xinfo xinfo[] =
    {
        {SQL_DATABASE_NAME, "SQL_DATABASE_NAME", "Connected to database: "},
        {SQL_DBMS_NAME, "SQL_DBMS_NAME", "DBMS Name: "},
        {SQL_DRIVER_NAME, "SQL_DRIVER_NAME", "Driver Name: "},
        {SQL_DRIVER_VER, "SQL_DRIVER_VER", "Driver Version: "}
    };
    
    if (check_for_ini() != 0) return SQL_ERROR;
    
    ret = SQLAllocHandle(SQL_HANDLE_ENV, 0, &env);
    if (!SQL_SUCCEEDED(ret))
    {
        fprintf(stderr, "Failed to allocate environment handle\n");
        return ret;
    }

    SQLSetEnvAttr(env, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3, 0);
    ret = SQLAllocHandle(SQL_HANDLE_DBC, env, &dbc);
    if (!SQL_SUCCEEDED(ret))
    {
        fprintf(stderr, "Failed to allocate connection handle\n");
        return ret;
    }

    ret = SQLDriverConnect(dbc, NULL, (unsigned char *)
                           "DSN=demo", SQL_NTS,
                           outstr, 256, &outstr_len, SQL_DRIVER_COMPLETE);
    if (ret != SQL_SUCCESS)
    {
        extract_error("SQLDriverConnect", dbc, SQL_HANDLE_DBC);
    }
    if (!SQL_SUCCEEDED(ret)) return ret;
    printf("\nConnected\n\n");
    
    for (i = 0; i < (sizeof(xinfo) / sizeof(xinfo[0])); i++)
    {
        ret = SQLGetInfo(dbc, xinfo[i].attr, info, sizeof(info),
                         &info_len);
        if (!SQL_SUCCEEDED(ret))
        {
            char            err[256];

            sprintf(err, "SQLGetInfo(...,%s,...)", xinfo[i].attr_name);
            extract_error(err, dbc, SQL_HANDLE_DBC);
        }
        else
        {
            info[info_len] = '\0';
            printf("%s %s\n", xinfo[i].heading, info);
        }
    }
    printf("Disconnecting\n");
    
    SQLDisconnect(dbc);
    SQLFreeHandle(SQL_HANDLE_DBC, dbc);
    dbc = NULL;
    SQLFreeHandle(SQL_HANDLE_ENV, env);
    env = NULL;
    
    press_key();
    return SQL_SUCCESS;
}


static SQLRETURN contact(void)
{
    SQLHENV             env;
    SQLHDBC             dbc;
    SQLHSTMT            stmt;
    SQLRETURN           ret;
    char                outstr[1024];
    SQLSMALLINT         outstr_len;
    unsigned int        i;
    SQLSMALLINT         columns;
    
    if (check_for_ini() != 0) return SQL_ERROR;
    
    ret = SQLAllocHandle(SQL_HANDLE_ENV, 0, &env);
    if (!SQL_SUCCEEDED(ret))
    {
        fprintf(stderr, "Failed to allocate environment handle\n");
        return ret;
    }

    SQLSetEnvAttr(env, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3, 0);
    ret = SQLAllocHandle(SQL_HANDLE_DBC, env, &dbc);
    if (!SQL_SUCCEEDED(ret))
    {
        fprintf(stderr, "Failed to allocate connection handle\n");
        return ret;
    }

    ret = SQLDriverConnect(dbc, NULL, (unsigned char *)
                           "DSN=demo", SQL_NTS,
                           outstr, 256, &outstr_len, SQL_DRIVER_COMPLETE);
    if (ret != SQL_SUCCESS)
    {
        extract_error("SQLDriverConnect", dbc, SQL_HANDLE_DBC);
    }
    if (!SQL_SUCCEEDED(ret)) return ret;
    printf("\nConnected\n\n");

    ret = SQLAllocHandle(SQL_HANDLE_STMT, dbc, &stmt);
    if (!SQL_SUCCEEDED(ret))
    {
        extract_error("SQLAllocHandle", dbc, SQL_HANDLE_DBC);
        return ret;
    }

    ret = SQLExecDirect(stmt, "select * from oobdist_contact", SQL_NTS);
    if (!SQL_SUCCEEDED(ret))
    {
        extract_error("SQLExecDirect", stmt, SQL_HANDLE_STMT);
        return ret;
    }

    ret = SQLNumResultCols(stmt, &columns);
    if (!SQL_SUCCEEDED(ret))
    {
        extract_error("SQLNumResultCols", stmt, SQL_HANDLE_STMT);
        return ret;
    }
    
    while(SQL_SUCCEEDED(ret = SQLFetch(stmt)))
    {
        char            cbuf[1024];
        SQLINTEGER      clen;
        
        for (i = 1; i <= columns; i++)
        {
            
            ret = SQLGetData(stmt, i, SQL_C_CHAR, cbuf, sizeof(cbuf), &clen);
            if (!SQL_SUCCEEDED(ret))
            {
                extract_error("SQLGetData", stmt, SQL_HANDLE_STMT);
                return ret;
            }
            if (i == 1)
                printf("%s\n", cbuf);
            else
                printf("\t%s\n", cbuf);                
        }
        printf("\n");
        
    }
    
            
    printf("Disconnecting\n");
    
    SQLDisconnect(dbc);
    SQLFreeHandle(SQL_HANDLE_DBC, dbc);
    dbc = NULL;
    SQLFreeHandle(SQL_HANDLE_ENV, env);
    env = NULL;
    
    press_key();
    return SQL_SUCCESS;
}


static int check_for_ini(void)
{
#ifndef WIN32
    if (access("odbc.ini", F_OK) != 0)
    {
        fprintf(stderr,
                "\nFailed to find an odbc.ini file in the current directory\n");
        fprintf(stderr,
"You need an odbc.ini file to describe the DSN used by this demo.\n"
"It should look like this:\n"
"\n"
"[demo]\n"
"SERVER = demo.easysoft.com\n"
"PORT = 8888\n"
"TRANSPORT = tcpip\n"
"TARGETDSN = demo\n"
"LOGONUSER = demo\n"
"LOGONAUTH = easysoft\n"
"TARGETUSER = demo\n"
"TARGTEAUTH = easysoft\n\n"
                );
        return 1;
    }
    else if (access("odbc.ini", R_OK) != 0)
    {
        fprintf(stderr, "\nFound an odbc.ini file but cannot read it.\n");
        fprintf(stderr, "Please check the permissions on odbc.ini\n\n");
        return 1;
    }
#endif
    return 0;
}


static void requirements(void)
{
    printf(
"\n"
"You must be connected to the Internet to successfully run this demonstration.\n"
"\n"
);
}


static unsigned char menu(int redisplay)
{
    unsigned char       buf[5];

    if (redisplay)
    {
        printf("\n");
        printf("[1] Read the initial notice.\n");
        printf("[2] Requirements for the demo.\n");
        printf("[3] Test Connection.\n");
        printf("[4] Get Easysoft contact information from remote database.\n");
        printf("[5] Exit.\n");
    }
    printf("\nChoose an option: ");
    fgets(buf, sizeof(buf), stdin);
    return buf[0];

}


static void notice(void)
{
    printf(
"Easysoft Ltd (c) 1999\n\n"
"Demonstration of the Easysoft ODBC-ODBC Bridge\n\n"
"This is a demonstration of the Easysoft ODBC-ODBC Bridge. The best way\n"
"to follow this small demonstration is to select the menu options one at\n"
"a time. The demo connects your machine through the ODBC-ODBC Bridge to\n"
"MS SQLServer running on a the demo machine (demo.easysoft.com) at Easysoft\n"
"and downloads data from it. Easysoft respect your privacy and so NO data\n"
"whatsoever from your machine is uploaded to Easysoft. The source code for\n"
"this program is available in the ODBC-ODBC Bridge distribution should you\n"
"want to inspect it before continuing with the demonstration.\n"
);
    return;
}


static void extract_error(
    char *fn,
    SQLHANDLE handle,
    SQLSMALLINT type)
{
    SQLINTEGER i = 0, native;
    char state[ 7 ];
    SQLCHAR text[256];
    SQLSMALLINT len;
    int ret;

    fprintf(stderr,
            "\n"
            "The driver reported the following diagnostics whilst running "
            "%s\n\n",
            fn);
    
    do 
    {
        ret = SQLGetDiagRec(type, handle, ++i, state, &native, text,
                            sizeof(text), &len );
        if (SQL_SUCCEEDED(ret))
            printf( "%s:%ld:%ld:%s\n", state, i, native, text );
    }
    while( ret == SQL_SUCCESS );
}


static void press_key(void)
{
    char        buf[5];
    
    printf("\nPress enter to continue\n");
    
    fgets(buf, sizeof(buf), stdin);
}
