#!/usr/bin/perl

use POSIX qw(strftime);

# LIDS ACL_DISCOVERYING log analyzer
# Copyright (C) 2003 Huagang XIE (xie [at] www dot lids dot org)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Plac<B2>e - Suite 330, Boston, MA  02111-1307, USA.

# $Id: lids_acl_discovery.pl,v 1.1.1.1 2004/02/17 06:20:19 xie Exp $


my $log_file = '/var/log/messages';
my $pid_file = "/var/run/lidslog.pid";
my $line=0;
my $start=$end=0;

open(LOG_FILE,"$log_file") or die "Unable to open log file $log_file : $!\n";

print STDERR "about to read $log_file\n";

while(<LOG_FILE>) {
	$line++; 
	$buf[$line]=$_;
	if($_=~/kernel\: Linux version 2\./) {
		if($start==0) {
			$start=$line;
			next;
		}
		if($end!=0) {
			$start=$end;
			$end=$line;
			next;
		}else {
			$end=$line;
			next;
		} 
	}
}
close(LOG_FILE);

print "start=$start, end=$end\n";

for($i=$start;$i<$end;$i++){
	chop($_);
# Jul 15 21:52:27 lids kernel: LIDS_ACL_DISCOVERY:^I177756:770:touch:4:0:16343:770:a:0-0
  	if($buf[$i]=~/kernel\: LIDS_ACL_DISCOVERY\:\[state (\d)\](.*?)0-0/ ) {
		$state = $1;
		$acl = $2;
		@arr = split(/\:/,$acl);
		$s_ino = $arr[0];
		$s_dev = $arr[1];
		$type = $arr[3];
		$o_ino = $arr[5];
		$o_dev = $arr[6];
		
		$str = $s_ino.":".$s_dev.":".$o_ino.":".$o_dev;

		if( $acls->{$state}->{$str}->{"status"} != 1) { 
			$acls->{$state}->{$str}->{"status"}=1;
			$acls->{$state}->{$str}->{"type"}=$type;
			$acls->{$state}->{$str}->{"acl"}=$acl;
				
			print "state = $state\n";
			print "$acl"."0-0\n";
		}else{
			if($type> $acls->{$state}->{$str}->{"type"}) { 
				$acls->{$state}->{$str}->{"type"}=$type;
				$acls->{$state}->{$str}->{"acl"}=$acl;
				print "same rules found with high type, overwrite\n";
			}else {
			}
		}
	}
}
########################################################################
####################### Write to each file #############################
########################################################################
print "hehe\n";

@acl_file = ("","lids.boot.conf","lids.postboot.conf",
	"lids.shutdown.conf") ;

foreach $state (keys %$acls) {
	$strs = $acls->{$state};
	$file=$acl_file[$state];
	open(FD,">$file") || die "open $file failed\n";
	foreach $str (keys %$strs) {
		$acl = $strs->{$str}->{"acl"};
		print FD "$acl"."0-0\n";
	}
}


