/* $Id: lids_capflag.c,v 1.3 2004/03/16 18:58:37 purna Exp $ */

#include <linux/capability.h>	/* Capabilities values */
#include "lidsif.h"		/* LIDS falgs values */
#include "lids_capflag.h"	/* Types */

/* Used by the getflag routines only */

static int errno;

entry_t flag_list[] = {
	{NULL, "LIDS", LIDS_FLAGS_LIDS_LOCAL_ON,
	 "de-/activate LIDS locally (the shell & childs)", 0},
	{NULL, "LIDS_GLOBAL", LIDS_FLAGS_LIDS_ON, "de-/activate LIDS entirely",
	 1},
	{NULL, "RELOAD_CONF", LIDS_FLAGS_RELOAD_CONF,
	 "reload config. file and inode/dev of protected programs", 2},
	{NULL, "POSTBOOT", LIDS_FLAGS_POSTBOOT,
	 "'lidsadm -I' will switch to POSTBOOT state ",
	 3},
	{NULL, "SHUTDOWN", LIDS_FLAGS_SHUTDOWN,
	 "switch to SHUTDOWN state",
	 4},
	{NULL, "ACL_DISCOVERY", LIDS_FLAGS_ACL_DISCOVERY_ON,
	 "de-/activate LIDS learning mode",
	 5},
	{NULL, "TPE", LIDS_FLAGS_TPE_ON,
	 "de-/activate LIDS TPE mode",
	 6},
	{NULL, NULL, -1, NULL, -1}
};

entry_t cap_list[] = {
	{NULL, "CAP_CHOWN", CAP_CHOWN, "chown(2)/chgrp(2)", 0},
	{NULL, "CAP_DAC_OVERRIDE", CAP_DAC_OVERRIDE, "DAC access", 1},
	{NULL, "CAP_DAC_READ_SEARCH", CAP_DAC_READ_SEARCH, "DAC read", 2},
	{NULL, "CAP_FOWNER", CAP_FOWNER, "owner ID not equal user ID", 3},
	{NULL, "CAP_FSETID", CAP_FSETID, "effective user ID not equal owner ID",
	 4},
	{NULL, "CAP_KILL", CAP_KILL, "real/effective ID not equal process ID",
	 5},
	{NULL, "CAP_SETGID", CAP_SETGID, "set*gid(2)", 6},
	{NULL, "CAP_SETUID", CAP_SETUID, "set*uid(2)", 7},
	{NULL, "CAP_SETPCAP", CAP_SETPCAP, "transfer capability", 8},
	{NULL, "CAP_LINUX_IMMUTABLE", CAP_LINUX_IMMUTABLE,
	 "immutable and append file attributes", 9},
	{NULL, "CAP_NET_BIND_SERVICE", CAP_NET_BIND_SERVICE,
	 "binding to ports below 1024", 10},
	{NULL, "CAP_NET_BROADCAST", CAP_NET_BROADCAST,
	 "broadcasting/listening to multicast", 11},
	{NULL, "CAP_NET_ADMIN", CAP_NET_ADMIN,
	 "interface/firewall/routing changes", 12},
	{NULL, "CAP_NET_RAW", CAP_NET_RAW, "raw sockets", 13},
	{NULL, "CAP_IPC_LOCK", CAP_IPC_LOCK,
	 "locking of shared memory segments", 14},
	{NULL, "CAP_IPC_OWNER", CAP_IPC_OWNER, "IPC ownership checks", 15},
	{NULL, "CAP_SYS_MODULE", CAP_SYS_MODULE,
	 "insertion and removal of kernel modules", 16},
	{NULL, "CAP_SYS_RAWIO", CAP_SYS_RAWIO, "ioperm(2)/iopl(2) access", 17},
	{NULL, "CAP_SYS_CHROOT", CAP_SYS_CHROOT, "chroot(2)", 18},
	{NULL, "CAP_SYS_PTRACE", CAP_SYS_PTRACE, "ptrace(2)", 19},
	{NULL, "CAP_SYS_PACCT", CAP_SYS_PACCT,
	 "configuration of process accounting", 20},
	{NULL, "CAP_SYS_ADMIN", CAP_SYS_ADMIN, "tons of admin stuff", 21},
	{NULL, "CAP_SYS_BOOT", CAP_SYS_BOOT, "reboot(2)", 22},
	{NULL, "CAP_SYS_NICE", CAP_SYS_NICE, "nice(2)", 23},
	{NULL, "CAP_SYS_RESOURCE", CAP_SYS_RESOURCE, "setting resource limits",
	 24},
	{NULL, "CAP_SYS_TIME", CAP_SYS_TIME, "setting system time", 25},
	{NULL, "CAP_SYS_TTY_CONFIG", CAP_SYS_TTY_CONFIG, "tty configuration",
	 26},
	{NULL, "CAP_MKNOD", CAP_MKNOD, "mknod operation", 27},
	{NULL, "CAP_LEASE", CAP_LEASE, "taking leases on files", 28},
	{NULL, "CAP_HIDDEN", CAP_HIDDEN, "hidden process", 29},
	{NULL, "CAP_KILL_PROTECTED", CAP_KILL_PROTECTED,
	 "kill protected programs", 30},
	{NULL, "CAP_PROTECTED", CAP_PROTECTED,
	 "Protect the process from signals", 31},
	{NULL, NULL, -1, NULL, -1}
};

entry_t socket_list[] = {
	{NULL, "LIDS_SOCKET_CREATE", LIDS_SOCKET_CREATE, "socket()", 0},
	{NULL, "LIDS_SOCKET_CONNECT", LIDS_SOCKET_CONNECT, "connect()", 1},
	{NULL, "LIDS_SOCKET_BIND", LIDS_SOCKET_BIND, "bind()()", 2},
	{NULL, "LIDS_SOCKET_LISTEN", LIDS_SOCKET_LISTEN, "listen()", 3},
	{NULL, "LIDS_SOCKET_ACCEPT", LIDS_SOCKET_ACCEPT, "accept()", 4},
	{NULL, "LIDS_SOCKET_SENDMSG", LIDS_SOCKET_SENDMSG, "sendmsg()", 5},
	{NULL, "LIDS_SOCKET_RECVMSG", LIDS_SOCKET_RECVMSG, "recvmsg()", 6},
	{NULL, "LIDS_SOCKET_GETSOCKNAME", LIDS_SOCKET_GETSOCKNAME,
	 "getsockname()", 7},
	{NULL, "LIDS_SOCKET_GETPEERNAME", LIDS_SOCKET_GETPEERNAME,
	 "setpeername()", 8},
	{NULL, "LIDS_SOCKET_GETSOCKOPT", LIDS_SOCKET_GETSOCKOPT, "getsockopt()",
	 9},
	{NULL, "LIDS_SOCKET_SETSOCKOPT", LIDS_SOCKET_SETSOCKOPT, "setsockopt()",
	 10},
	{NULL, "LIDS_SOCKET_SHUTDOWN", LIDS_SOCKET_SHUTDOWN, "shutdown()", 11},
	{NULL, "LIDS_SOCKET_CREATE_TCP", LIDS_SOCKET_CREATE_TCP, "socket() tcp",
	 12},
	{NULL, "LIDS_SOCKET_CREATE_UDP", LIDS_SOCKET_CREATE_UDP, "socket() udp",
	 13},
	{NULL, "LIDS_SOCKET_NF_MARK", LIDS_SOCKET_NF_MARK,
	 "netfilter packet mark", 14},
	{NULL, "LIDS_EXEC", LIDS_EXEC, "Execution", 15},
	{NULL, NULL, -1, NULL, -1}
};

static entry_t *current;	/* current capability entry */

entry_t *
getentrybyname(entry_t * list, const char *name)
{
	if (name == NULL) {
		errno = EINVAL;
		return NULL;
	}

	for_each_entry(list, current)
	    if (strcmp(current->name, name) == 0)
		return current;

	errno = ENOENT;
	return NULL;
}

entry_t *
getentrybyval(entry_t * list, int val)
{
	if (val < 0) {
		errno = EINVAL;
		return NULL;
	}

	for_each_entry(list, current)
	    if (current->val == val)
		return current;

	errno = ENOENT;
	return NULL;
}

entry_t *
getentrybypos(entry_t * list, int pos)
{
	if (pos == 0) {
		errno = EINVAL;
		return NULL;
	}

	for_each_entry(list, current)
	    if (current->pos == pos)
		return current;

	errno = ENOENT;
	return NULL;
}

void
setentry(entry_t * list)
{
	short int count = 0;

	/* Set up the entire flag pointer system */
	for (count = 0; list[count].pos != -1; count++)
		list[count].next = &list[count + 1];

	current = list;
	return;
}

void
endentry(entry_t * list)
{
	short int count = 0;

	/* Delete the pointers for each element */
	for (count = 0; list[count].pos != -1; count++)
		list[count].next = NULL;

	current = NULL;
	return;
}
