/*
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
*/
/* $Id: lidstools.h,v 1.2 2004/02/21 22:41:22 xie Exp $ */

#ifndef LIDSADM_H
#define LIDSADM_H

#define LIDS_PORT_ITEM  16
#define LIDS_TIME_ITEM  2

/* LIDSTools error codes */
#define LIDS_SUCCESS            0
#define LIDS_OOM_FAIL           1
#define LIDS_OPT_FAIL           2
#define LIDS_PROG_FAIL          3
#define LIDS_FILE_FAIL          4

/* LIDStools commands */
#define LIDS_NONE               -1
#define LIDS_ADD                1
#define LIDS_DELETE             2
#define LIDS_LIST               3
#define LIDS_DELETE_ALL         4
#define LIDS_MK_PASSWD          5
#define LIDS_SWITCH             6
#define LIDS_INIT               7
#define LIDS_UPDATE             8
#define LIDS_VIEW               9
#define LIDS_EXTEND             10
#define LIDS_STATUS		11
#define LIDS_CHECK		12

#define LIDS_DELETE_FLAG   100

#define LIDS_BOOT	0
#define LIDS_POSTBOOT	1

/* File paths */
#define LIDS_LOCKS         "/proc/sys/lids/locks"

/* Misc macros */
#define LIDS_CONF_COMMENT  "#\n# \tThis file is auto generated by lidsconf \n#\tPlease do not modify this file by hand\n#\n"

typedef struct lids_s {
	int type;		/* access control type */
	unsigned long int s_ino;	/* subject inode number */
	unsigned int s_dev;	/* subject dev number */
	char s_file[1024];	/* subject filename */
	unsigned long int o_ino;	/* object inode number */
	unsigned int o_dev;	/* object dev number */
	char o_file[1024];	/* oject filename */
	int inherit;		/* inherit level */
	int mark;		/* netfilter mark */
	int time[LIDS_TIME_ITEM][2];	/* from-to time */
	int port[LIDS_PORT_ITEM][2];	/* bind port */
	int state;		/* STATE */
} lids_t;

extern char *disp_multi_data(int data[][2], int type);

#endif
