# hostSentry - Login Anomaly Detector Logging Functions
#
# Author: Craig H. Rowland <crowland@psionic.com>
# Created: 10-6-98
#
# Send all changes/modifications/bugfixes to the above address.  
# 
# This software is Copyright(c) 1997-98 Craig H. Rowland
# 
# Disclaimer:
# 
# All software distributed by Craig H. Rowland ("the author") and
# Psionic Systems is distributed AS IS and carries NO WARRANTY or
# GUARANTEE OF ANY KIND. End users of the software acknowledge that         
# they will not hold the author, Psionic Systems, and any employer of    
# the author liable for failure or non-function of a software
# product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK
# 
# Licensing restrictions apply. See the license that came with this
# file for more information or visit http://www.psionic.com for more
# information.
# 
# This software is NOT GPL NOR PUBLIC DOMAIN so please read the license   
# before modifying or distributing. Contact the above address if you have
# any questions.
# 
# $Id: hostSentryLog.py,v 1.1 1999/03/22 04:56:44 crowland Exp crowland $

from hostSentryCore import *
import sys
import syslog
import hostSentryConfig

############################################
# These are the basic log functions. This will
# eventuall expand greatly to support many
# logging functions.
############################################
def log(message):
	logSyslog(message)

def logSyslog(message = '', priority = ''):

	if priority == '':
		priority = syslog.LOG_INFO

	syslog.openlog('hostSentry', syslog.LOG_PID, priority)
	syslog.syslog(message)
	syslog.closelog()


if __name__ == '__main__':
	log('Test log message')
