# Module: moduleLoginLogout
# Author: Craig H. Rowland <crowland@psionic.com>
# Created: 10-6-98
#
# Send all changes/modifications/bugfixes to the above address.  
# 
# This software is Copyright(c) 1997-98 Craig H. Rowland
# 
# Disclaimer:
# 
# All software distributed by Craig H. Rowland ("the author") and
# Psionic Systems is distributed AS IS and carries NO WARRANTY or
# GUARANTEE OF ANY KIND. End users of the software acknowledge that         
# they will not hold the author, Psionic Systems, and any employer of    
# the author liable for failure or non-function of a software
# product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK
# 
# Licensing restrictions apply. See the license that came with this
# file for more information or visit http://www.psionic.com for more
# information.
# 
# This software is NOT GPL NOR PUBLIC DOMAIN so please read the license   
# before modifying or distributing. Contact the above address if you have
# any questions.
# 
# Description:
# 
# This module simply writes whenever a user does a login or logout.
# 
# $Id: moduleLoginLogout.py,v 1.3 1999/03/22 04:57:06 crowland Exp crowland $


from hostSentryCore import *
import hostSentryConfig
import hostSentryUser
import hostSentryLog
import hostSentryDB

import sys
import string

class moduleLoginLogout(hostSentryCore):

	def __init__(self):
		self.setLogLevel()
		self.__result = None

	def login(self, userObj, loginStamp):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: moduleLoginLogout: login: processing user: ' + userObj.getUsername())		

		loginIP, loginHostname, loginTTY, loginTime, logoutTime =  string.split(loginStamp, '@')
		
		hostSentryLog.log('securityalert: LOGIN User: ' + \
		userObj.getUsername() + ' TTY: ' + loginTTY + ' Host: ' + \
		loginHostname)

	def logout(self, userObj, logoutStamp):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: moduleLoginLogout: logout: processing user: ' + userObj.getUsername())		

		loginIP, loginHostname, loginTTY, loginTime, logoutTime = \
		string.split(logoutStamp, '@')
		
		hostSentryLog.log('securityalert: LOGOUT User: ' + \
		userObj.getUsername() + ' TTY: ' + loginTTY + ' Host: ' + \
		loginHostname)

	def setResult(self, result):
		self.__result = result

	def getResult(self):
		return self.__result


if __name__ == '__main__':

	test = moduleLoginLogout()
	user = hostSentryUser.hostSentryUser()
	user.setUsername('hostSentrytest')
	user.setTotalLogins(1)

	config = hostSentryConfig.hostSentryConfig()
	config.configInit()
	dbFile = config.parseToken('DB_FILE')

	db = hostSentryDB.hostSentryDB(dbFile)
	db.store(user)
	db.close()

	test.login(user, '192.168.2.1@somewhere.com@tty0001@999999999@')
	test.logout(user, '192.168.2.1@somewhere.com@tty0001@999999999@98989898')

	db = hostSentryDB.hostSentryDB(dbFile)
	db.delete(user.getUsername())
	db.close()
