# Module: moduleOddDirnames
# Author: Craig H. Rowland <crowland@psionic.com>
# Created: 11-1-98
#
# Send all changes/modifications/bugfixes to the above address.  
# 
# This software is Copyright(c) 1997-98 Craig H. Rowland
# 
# Disclaimer:
# 
# All software distributed by Craig H. Rowland ("the author") and
# Psionic Systems is distributed AS IS and carries NO WARRANTY or
# GUARANTEE OF ANY KIND. End users of the software acknowledge that         
# they will not hold the author, Psionic Systems, and any employer of    
# the author liable for failure or non-function of a software
# product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK
# 
# Licensing restrictions apply. See the license that came with this
# file for more information or visit http://www.psionic.com for more
# information.
# 
# This software is NOT GPL NOR PUBLIC DOMAIN so please read the license   
# before modifying or distributing. Contact the above address if you have
# any questions.
# 
# Description:
# 
# This module checks the user's home directory for "suspicious" directory
# names.
# 
# $Id: moduleOddDirnames.py,v 1.3 1999/03/22 04:57:24 crowland Exp crowland $


from hostSentryCore import *
import hostSentryConfig
import hostSentryUser
import hostSentryLog
import hostSentryDB

import sys
import string
import re
import pwd
import posix
import posixpath

class moduleOddDirnames(hostSentryCore):

	def __init__(self):
		self.setLogLevel()
		self.__result = None

	def login(self, userObj, loginStamp):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: moduleOddDirnames: login: processing user: ' + userObj.getUsername())

	def logout(self, userObj, logoutStamp):

		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: moduleOddDirnames: logout: processing user: ' + userObj.getUsername())		

		loginIP, loginHostname, loginTTY, loginTime, logoutTime =  string.split(logoutStamp, '@')

		try:
			pwInfo = pwd.getpwnam(userObj.getUsername())
			userPath = pwInfo[5]
		except:
			hostSentryLog.log('adminalert: moduleOddDirnames: logout: Cannot find user: ' + userObj.getUsername() + ' in passwd database: ' + sys.exc_value[0])
			raise hostSentryError('adminalert: moduleOddDirnames: logout: Cannot find user: ' + userObj.getUsername() + ' in passwd database: ' + sys.exc_value[0])

		try:
			listing =  posix.listdir(userPath)

			# Check all the file listings for odd ball dir names
			for x in range(len(listing)):
				# Only check directories. We only do a few basic
				# checks right now. This can be much improved later
				# and probably will be. 
				if posixpath.isdir(userPath + '/' + listing[x]):
					# listdir doesn't return '.' or '..' directories
					# so anything with '..' as a leading character is
					# suspect.
					if listing[x][:2] == '..':
						hostSentryLog.log('securityalert: moduleOddDirnames: home directory for user: %s has a suspicious directory name: \"%s\"' % (userObj.getUsername(), listing[x]))
						self.setResult('securityalert: moduleOddDirnames: home directory for user: %s has a suspicious directory name: \"%s\"' % (userObj.getUsername(), listing[x]))
					# Dot space is bad too
					elif listing[x][:2] == '. ':
						hostSentryLog.log('securityalert: moduleOddDirnames: home directory for user: %s has a suspicious directory name: \"%s\"' % (userObj.getUsername(), listing[x]))
						self.setResult('securityalert: moduleOddDirnames: home directory for user: %s has a suspicious directory name: \"%s\"' % (userObj.getUsername(), listing[x]))
		except:			
			hostSentryLog.log('adminalert: moduleOddDirnames: logout: Error reading history file for processing: ' + sys.exc_value[0])
			raise hostSentryError('adminalert: moduleOddDirnames: logout: Error reading history file for processing: ' + sys.exc_value[0])

	def setResult(self, result):
		self.__result = result

	def getResult(self):
		return self.__result


if __name__ == '__main__':

	test = moduleOddDirnames()
	test.setLogLevel(99)
	user = hostSentryUser.hostSentryUser()
	user.setUsername('test')
#	user.setUsername('hostSentrytest')
	user.setTotalLogins(1)

	config = hostSentryConfig.hostSentryConfig()
	config.configInit()
	dbFile = config.parseToken('DB_FILE')

	db = hostSentryDB.hostSentryDB(dbFile)
	db.store(user)
	db.close()

	test.login(user, '192.168.2.1@somewhere.com@tty0001@999999999@')
	test.logout(user, '192.168.2.1@somewhere.com@tty0001@999999999@98989898')

	db = hostSentryDB.hostSentryDB(dbFile)
	db.delete(user.getUsername())
	db.close()
