/*
  
  authc-kerberos-tgt.h

  Author: Tatu Ylonen <ylo@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Kerberos authentication using TGT (passing to server), client side.
  
*/

#ifndef AUTHC_KERBEROS_TGT_H
#define AUTHC_KERBEROS_TGT_H

/* Password authentication, client-side. */

void ssh_client_auth_kerberos_tgt(SshAuthClientOperation op,
                                  const char *user,
                                  unsigned int packet_type,
                                  SshBuffer packet_in,
                                  const unsigned char *session_id,
                                  size_t session_id_len,
                                  void **state_placeholder,
                                  SshAuthClientCompletionProc completion,
                                  void *completion_context,
                                  void *method_context);

#endif /* AUTHC_KERBEROS_TGT_H */
