/*

  sshsftpcwd.h

  Author: Tomi Salo <ttsalo@ssh.com>

  Copyright (C) 1999-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Created Wed Jan  5 21:51:33 2000.

  Auxiliary stuff implementing CWD (current working directory)
  in sftp2. (When using sshfilecopy).
  
  */

#ifndef SFTPCWD_H
#define SFTPCWD_H

#include "sshincludes.h"
#include "sshfilexfer.h"

typedef struct SshSftpCwdContextRec *SshSftpCwdContext;

typedef enum
{
  /* Directory change was successful */
  SSH_SFTP_CWD_OK,
  /* Directory change was not successful */
  SSH_SFTP_CWD_ERROR
} SshSftpCwdResult;

/* Initialize the cwd stuff and get your very own context!
   Needs a valid file_client object. */
SshSftpCwdContext
ssh_sftp_cwd_init(SshFileClient file_client);

/* Destroy the context. Do not use it after this.
   Does not touch the fileclient object given in initialization. */
void
ssh_sftp_cwd_uninit(SshSftpCwdContext cwd_context);

/* Adds the cwd in front of the given string.
   Returns an xmallocated string. */
char *
ssh_sftp_cwd_add(const char *path,
                 SshSftpCwdContext cwd_context);

/* Strips the cwd from the front of the given path.
   Returns an xmallocated string or NULL if the given
   path did not contain the cwd. */
char *
ssh_sftp_cwd_strip(const char *path,
                   SshSftpCwdContext cwd_context,
                   Boolean strip_dot_prefix);

/* Callback definition for the change_cwd function.
   If result == TRUE, the cwd was adjusted successfully.
   If result == FALSE, the given path was invalid and
   error_message contains a text describing the problem. */
typedef void (*SshSftpChangeCwdCb)(SshSftpCwdResult result,
                                   void *context);

/* Tries to change the cwd. Calls the callback when ready. */
void
ssh_sftp_cwd_change(char *path,
                    SshSftpCwdContext cwd_context,
                    SshSftpChangeCwdCb cwd_cb,
                    void *context);

#endif /* SFTPCWD_H */
