/*

  sftphelp.c

  Author: Tomi Salo <ttsalo@ssh.com>

  Copyright (c) 1999 SSH Communications Security, Finland
  All rights reserved.

  Created Thu Feb  3 16:39:33 2000.

  Help-command implementation for sftp2.
  
  */

#include "sshincludes.h"

char *main_help =
"Secure FTP client Sftp2\r\n"
"Copyright (c) 1999, 2000 SSH Communications Security, Finland.\r\n\r\n"
"Type 'help <topic>', where <topic> is one of the following commands:\r\n\r\n"
"open\t\tlocalopen\tclose\t\tquit\t\tcd\r\n"
"lcd\t\tpwd\t\tlpwd\t\tls\t\tlls\r\n"
"get\t\tmget\t\tput\t\tmput\t\trm\r\n"
"lrm\t\tmkdir\t\tlmkdir\t\trmdir\t\tlrmdir\r\n"
"rename\t\tlrename\t\thelp\t\t\r\n"
"\r\n";

char *helps[][2] = {
  { "open",
    "open <hostname>\r\n"
    "Tries to connect to the host <hostname>.\r\n" },
  { "localopen",
    "localopen\r\n"
    "Opens a local connection. Does not need an sshd2 daemon.\r\n"},
  { "close",
    "close\r\n"
    "Closes the current session.\r\n" },
  { "quit",
    "quit\r\n"
    "Quits from the application.\r\n" },
  { "cd",
    "cd <directory>\r\n"
    "Changes the current remote working directory.\r\n" },
  { "lcd",
    "lcd <directory>\r\n"
    "Changes the current local working directory.\r\n" },
  { "pwd",
    "pwd\r\n"
    "Prints the name of the current remote working directory.\r\n" },
  { "lpwd",
    "lpwd\r\n"
    "Prints the name of the current local working directory.\r\n" },
  { "ls",
    "ls [ -R ] [ -l ] [ <file> ... ]\r\n"
    "Lists the names of files on the remote server. For directories,\r\n"
    "contents are listed. When the -R is given, directory trees are\r\n"
    "listed recursively. (By default, subdirectories of the arguments\r\n"
    "are not visited.) When the -l option is given, permissions, owners,\r\n"
    "sizes and modification times are also shown. When given no\r\n"
    "arguments, assumes that the contents of . are being listed.\r\n"
    "Currently the options -R and -l are mutually incompatible.\r\n" },
  { "lls",
    "lls [ -R ] [ -l ] [ <file> ... ]\r\n"
    "Same as ls, but operates on the local files.\r\n" },
  { "get",
    "get [ <file> ... ]\r\n"
    "Transfers the specified files from the remote end to the local end.\r\n"
    "Directories are recursively copied with their contents.\r\n" },
  { "mget",
    "mget [ <file> ... ]\r\n"
    "Synonymous to get.\r\n" },
  { "put",
    "put [ <file> ... ]\r\n"
    "Transfers the specified files from the local end to the remote end.\r\n"
    "Directories are recursively copied with their contents.\r\n" },
  { "mput",
    "mput [ <file> ... ]\r\n"
    "Synonymous to put.\r\n" },
  { "rm",
    "rm <file>\r\n"
    "Tries to delete the file specified in <file>\r\n." },
  { "lrm",
    "lrm <file>\r\n"
    "Same as rm, but operates on the local files.\r\n" },
  { "mkdir",
    "mkdir <directory>\r\n"
    "Tries to create the directory specified in <directory>\r\n" },
  { "lmkdir",
    "Same as mkdir, but operates on the local files.\r\n" },
  { "rmdir",
    "rmdir <directory>\r\n"
    "Tries to delete the directory specified in <directory>\r\n" },
  { "lrmdir",
    "Same as rmdir, but operates on the local files.\r\n" },
  { "rename",
    "rename <oldfile> <newfile>\r\n"
    "Tries to rename the <oldfile> to <newfile>. If <newfile> already\r\n"
    "exists, the files are left intact.\r\n" },
  { "lrename",
    "Same as rename, but operates on the local files.\r\n" },
  { "help",
    "help [ <topic> ]\r\n"
    "If <topic> is not given, lists the available topics. If <topic> is\r\n"
    "given, outputs available online help about the topic.\r\n" },
  { NULL, NULL }
};

void
ssh_sftp_print_help(char *topic)
{
  int i = 0;
  if (topic == NULL)
    {
      printf(main_help);
      return;
    }
  do {
    if (!strcmp(topic, helps[i][0]))
    {
      printf(helps[i][1]);
      return;
    }
    i++;
  } while (helps[i][0] != NULL);
  printf("Sorry, no help about topic '%s' available.\r\n", topic);
}
