/*

ssh2includes.h

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

*/

#ifndef SSH2INCLUDES_H
#define SSH2INCLUDES_H

#include "sshincludes.h"
#include "sshsessionincludes.h"
#include "ssh2version.h"








































/* File executed in user's home directory during login. */
#define SSH_USER_RC             "rc"
#define SSH_USER_ENV_FILE       "environment"
#define SSH_SYSTEM_RC           ETCDIR "/sshrc"

/* Default tcp/udp port */
#define SSH_DEFAULT_PORT        "22"

/* Definitions for authentication method names. */
#define SSH_AUTH_PUBKEY       "publickey"
#define SSH_AUTH_PASSWD       "password"
#define SSH_AUTH_HOSTBASED    "hostbased"
#define SSH_AUTH_PAM          "pam-1@ssh.com"
#define SSH_AUTH_KERBEROS     "kerberos-1@ssh.com"
#define SSH_AUTH_KERBEROS_TGT "kerberos-tgt-1@ssh.com"
#define SSH_AUTH_SECURID      "securid-1@ssh.com"

/* Path to ssh-signer2 */
#define SSH_SIGNER_PATH       "ssh-signer2"

/* Path to ssh-pam-client */
#define SSH_PAM_CLIENT_PATH   "ssh-pam-client"

/* Default idle timeout in minutes for the server. 0 = disabled */
#define SSH_SERVER_DEFAULT_IDLE_TIMEOUT   0

/* arguments to ssh2 */
#define SSH2_GETOPT_ARGUMENTS "ac:C::vd:e:f::F:hi:l:L:no:p:PqR:s:Stx8gVkw1:m:"

/* protocol version numbers */














#define SSH2_VERSION_STRING "SSH Secure Shell " SSH2_VERSION \
                            " (non-commercial version)"
#define SSH2_PROTOCOL_VERSION_STRING SSH2_VERSION \
                                     " SSH Secure Shell (non-commercial)"

















#endif /* SSH2INCLUDES_H */
