/*

  naf.h

  Author: Mika Kojo <mkojo@ssh.fi>

  Copyright (c) 1999 SSH Communications Security, Finland
  All rights reserved.

  Created Wed Mar  8 22:33:06 2000.

  */

#ifndef NAF_H
#define NAF_H

/* Routines to compute NAFs (Non-adjacent forms), and
   other representations of integer "exponents". */

/* The Morain-Olivos signed digit {-1,0,1} NAF. */
unsigned int ssh_mp_transform_mo(const SshMPIntStruct *k,
                                 signed char **transform_table);

/* Standard binary expansion. */
unsigned int ssh_mp_transform_binary(const SshMPIntStruct *k,
                                     signed char **transform_table);

/* KMOV NAF-expansions. */
unsigned int ssh_mp_transform_kmov(const SshMPIntStruct *k,
                                   signed char **transform_table);


#endif /* NAF_H */
