/*

  sshadt_conv.h

  Author: Antti Huima <huima@ssh.fi>
          Matthias Fischmann <fis@ssh.fi>

  Copyright (c) 2000 SSH Communications Security, Finland
  All rights reserved.

  Created Wed Sep 20 04:58:43 2000.

  */

#ifndef SSHADT_CONV_I_H_INCLUDED
#define SSHADT_CONV_I_H_INCLUDED


/******************************************** Convenience callbacks: General */

/* destroy by simply freeing the object */
void ssh_adt_callback_destroy_free(void *obj, void *context);

/* destroy by freeing, but leave NULL objects untouched */
void ssh_adt_callback_destroy_free_null(void *obj, void *context);


/******************************************** Convenience callbacks: Strings */

/* call to strcmp */
int ssh_adt_callback_compare_str(const void *obj1, const void *obj2, void *ctx);

/* call to strdup */
void *ssh_adt_callback_duplicate_str(const void *obj, void *ctx);

/* Iteration over a string with some shifts and additions. */
unsigned long ssh_adt_callback_hash_str(const void *obj, void *ctx);


/******************************************* Convenience callbacks: Integers */

/* compare objects that are integers and not void pointers */
int ssh_adt_callback_compare_int(const void *obj1, const void *obj2,
                                 void *context);

/* returns `*(unsigned long *)obj' */
unsigned long ssh_adt_callback_hash_int(const void *obj, void *ctx);



#endif /* !SSHADT_CONV_I_H_INCLUDED */
