/*

  ssheprintf.c

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999 SSH Communications Security, Finland
  All rights reserved.

  Created Wed Oct 13 15:16:58 1999.

  */

#define SSH_MAKING_EPRINTF
#undef  NO_SNPRINTF

#include "snprintf.c"

#ifndef _KERNEL

/* XXX: These are quick hacks to get the idea off the ground. These
   need to be converted into more efficient versions which won't do
   unnecessary allocation and copying.

   This is probably best accomplised by using a "driver" function or
   macro which handles the parsing, and separate auxillary
   functions/macros that handle the actual string/buffer modify
   functions, so that the actual formatting engine is the same for
   both strings and buffers to avoid code forking, but the code itself
   would be duplicated verbatim. */

int ssh_vbprintf(SshBuffer buf, const char *format, va_list ap)
{
  unsigned char *tmp;
  size_t len, size;

  tmp = NULL;
  size = 0;

  do {
    size += 512;
    SSH_MEM_FREE(tmp);

    if (!(tmp = SSH_MEM_ALLOC(size)))
      return 0;

    len = ssh_evsnprintf(tmp, size, format, ap);
  } while (len >= size);

  ssh_buffer_append(buf, tmp, len);
  SSH_MEM_FREE(tmp);

  return len;
}

int ssh_bprintf(SshBuffer buf, const char *format, ...)
{
  int ret;
  va_list ap;
  va_start(ap, format);
  ret = ssh_vbprintf(buf, format, ap);
  va_end(ap);

  return ret;
}

#endif /* _KERNEL */
