/*
 *
 * t-ipaddr-print.c
 *
 * Author: Markku Rossi <mtr@ssh.fi>
 *
 * Copyright (c) 2000 SSH Communications Security, Finland
 *               All rights reserved.
 *
 * Testing IP address printing.
 *
 */

#include "sshincludes.h"
#include "sshinet.h"

#define SSH_DEBUG_MODULE "t-ipaddr-print"

char *addresses[] =
{
  "3ffe:501:ffff::33",
  "3ffe:501:ffff:0:200:e8ff:fe6f:c2e0",
  "3ffe:501:0:0:1:0:0:33",
  "::",
  "::1",
  "1::",
  "1::1",
  "::1.2.3.4",
  "1:2:3:4::ff",
  NULL,
};

int
main(int argc, char *argv[])
{
  int i;
  SshIpAddrStruct ip;

  for (i = 0; addresses[i]; i++)
    {
      (void) ssh_ipaddr_parse(&ip, addresses[i]);
      SSH_DEBUG(0, ("%@", ssh_ipaddr_render, &ip));
    }

  return 0;
}
