/******************************************************************************
 *                                                                            *
 * File:   loadtab .c         Version  1.20            Date: 1997-07-27       *
 *                                                                            *
 * Copyright (c) 1997 by kosta@kostis.net (Kosta Kostis)                      *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - Read xlt Character Translation Table (to ISO/IEC 10646-1:1993)    *
 *        - Read Unicode Format A Table                                       *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-07-27: KK V1.20                                                   *
 *        - added LoadUnicode () function                                     *
 *     1997-06-14: KK V1.13                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "datatype.h"
#include "os-stuff.h"
#include "tab.h"
#include "taberr.h"
#include "gettrans.h"

#include "loadtab.h"

/******************************************************************************

	Function:
		load table from file

	Parameters:
		char	*Encoding
		ushort	*bintab

	Returns:

 *****************************************************************************/

int	LoadTable
(
	char	*Encoding,
	ushort	*bintab
)
{
	FILE	*Fin ;
	char	FileName	[PATHNAME_MAX + 1] ;
	char	*Help ;

	Help = GetTrans () ;
	sprintf (FileName, EXT_BINARY, Help, CHR_DIR, Encoding) ;

	Fin = fopen (FileName, "rb") ;
	if (Fin == (FILE *) NULL)
		return (ERR_TAB) ;

	fread (bintab, sizeof (ushort), MAX_TABLE_ENTRIES, Fin) ;	
	fclose (Fin) ;

	return (ERR_NONE) ;
}

/******************************************************************************

	Function:
                load Unicode table from file

        Parameters:
                char    *Encoding
                ushort  *bintab

        Returns:

 *****************************************************************************/

int	LoadUnicode
(
	char	*Encoding,
	ushort	*bintab
)
{
        FILE    *Fin ;
	char	FileName	[PATHNAME_MAX + 1] ;
	char	UnicodeA	[MAX_UNI_NAME_LENGTH + 1] ;
	unsigned int	Index ;
	unsigned int	Unicode ;
	char	*Help ;

	Help = getenv (ENV_UNICODE) ;
	if (Help == (char *) NULL)
		Help = "" ;

	sprintf (FileName, EXT_UNICODE, Help, Encoding) ;

	Fin = fopen (FileName, "r") ;
	if (Fin == (FILE *) NULL)
		return (ERR_TAB) ;

	for (Index = 0 ; Index < MAX_TABLE_ENTRIES ; ++Index)
		bintab [Index] = BAD ;

	do
	{
		fgets (UnicodeA, MAX_UNI_NAME_LENGTH, Fin) ;
		if (strncmp (UnicodeA, "0x", 2) == 0)
		{
			Index = 0 ; Unicode = BAD ;
			sscanf (UnicodeA, "0x%x\t0x%x\t", &Index, &Unicode) ;
			bintab [Index] = (ushort) Unicode ;
		}
	}
	while (feof (Fin) == 0) ;

	fclose (Fin) ;
	return (ERR_NONE) ;
}

