/*
 * DOS interrupt 34->3e handlers.  All FPU interrupt code should be
 * moved into this file.
 *  int 3d is not activated yet...
 *
 * Copyright 2002 Robert 'Admiral' Coeyman
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "msdos.h"
#include "miscemu.h"
#include "wine/debug.h"

WINE_DEFAULT_DEBUG_CHANNEL(int);

/*
 *  The actual work is done by a single routine.
 */

static void FPU_ModifyCode(CONTEXT86 *context, BYTE Opcode);



/**********************************************************************
 *          INT_Int34Handler (WPROCS.152)
 *
 * Handler for int 34 (FLOATING POINT EMULATION - Opcode 0xd8).
 *
 *  The interrupt list isn't specific about what this interrupt
 *  actually does. [ interrup.m ]
 */
void WINAPI INT_Int34Handler(CONTEXT86 *context)
{

	TRACE("Int 0x34 called-- FP opcode 0xd8");
	FPU_ModifyCode(context, 0xd8);

}

/**********************************************************************
 *          INT_Int35Handler (WPROCS.153)
 *
 * Handler for int 35 (FLOATING POINT EMULATION - Opcode 0xd9).
 *
 *  The interrupt list isn't specific about what this interrupt
 *  actually does. [ interrup.m ]
 */
void WINAPI INT_Int35Handler(CONTEXT86 *context)
{
	TRACE("Int 0x35 called-- FP opcode 0xd9");
	FPU_ModifyCode(context, 0xd9);

}


/**********************************************************************
 *          INT_Int36Handler (WPROCS.154)
 *
 * Handler for int 36 (FLOATING POINT EMULATION - Opcode 0xda).
 *
 *  The interrupt list isn't specific about what this interrupt
 *  actually does. [ interrup.m ]
 */
void WINAPI INT_Int36Handler(CONTEXT86 *context)
{
	TRACE("Int 0x36 called-- FP opcode 0xda");
	FPU_ModifyCode(context, 0xda);

}

/**********************************************************************
 *          INT_Int37Handler (WPROCS.155)
 *
 * Handler for int 37 (FLOATING POINT EMULATION - Opcode 0xdb).
 *
 *  The interrupt list isn't specific about what this interrupt
 *  actually does. [ interrup.m ]
 */
void WINAPI INT_Int37Handler(CONTEXT86 *context)
{
	TRACE("Int 0x37 called-- FP opcode 0xdb");
	FPU_ModifyCode(context, 0xdb);

}

/**********************************************************************
 *          INT_Int38Handler (WPROCS.156)
 *
 * Handler for int 38 (FLOATING POINT EMULATION - Opcode 0xdc).
 *
 *  Between versions 3.0 and 5.01, the original PC-MOS API call that
 *  was here was moved to int 0xd4.
 *
 *  The interrupt list isn't specific about what this interrupt
 *  actually does. [ interrup.m ]
 */
void WINAPI INT_Int38Handler(CONTEXT86 *context)
{
	TRACE("Int 0x38 called-- FP opcode 0xdc");
	FPU_ModifyCode(context, 0xdc);

}

/**********************************************************************
 *          INT_Int39Handler (WPROCS.157)
 *
 * Handler for int 39 (FLOATING POINT EMULATION - Opcode 0xdd).
 *
 *  The interrupt list isn't specific about what this interrupt
 *  actually does. [ interrup.m ]
 */
void WINAPI INT_Int39Handler(CONTEXT86 *context)
{
	TRACE("Int 0x39 called-- FP opcode 0xdd");
	FPU_ModifyCode(context, 0xdd);

}

/**********************************************************************
 *          INT_Int3aHandler (WPROCS.158)
 *
 * Handler for int 3a (FLOATING POINT EMULATION - Opcode 0xde).
 *
 *  The interrupt list isn't specific about what this interrupt
 *  actually does. [ interrup.m ]
 */
void WINAPI INT_Int3aHandler(CONTEXT86 *context)
{
	TRACE("Int 0x3a called-- FP opcode 0xde");
	FPU_ModifyCode(context, 0xde);

}

/**********************************************************************
 *          INT_Int3bHandler (WPROCS.159)
 *
 * Handler for int 3B (FLOATING POINT EMULATION - Opcode 0xdf).
 *
 *  The interrupt list isn't specific about what this interrupt
 *  actually does. [ interrup.m ]
 */
void WINAPI INT_Int3bHandler(CONTEXT86 *context)
{
	TRACE("Int 0x3b called-- FP opcode 0xdf");
	FPU_ModifyCode(context, 0xdf);

}



/**********************************************************************
 *          INT_Int3cHandler (WPROCS.160)
 *
 * Handler for int 3C (FLOATING POINT EMULATION - INSTRUCTIONS WITH SEGMENT OVERRIDE).
 *
 *  Generated code is CD 3C xy mm ... (CD = int | 3C = this interrupt)
 *   xy is a modified ESC code and mm is the modR/M byte.
 *   xy byte seems to be encoded as ss011xxx  or ss000xxx
 *   ss= segment override.
 *	00 -> DS
 *	01 -> SS
 *	10 -> CS
 *	11 -> ES
 *
 *  11011xxx should be the opcode instruction.
 */
void WINAPI INT_Int3cHandler(CONTEXT86 *context)
{
	FIXME("Int 3C NOT Implemented");
	INT_BARF(context, 0x3c);
}

/**********************************************************************
 *          INT_Int3dHandler (WPROCS.161)
 *
 * Handler for int 3D (FLOATING POINT EMULATION - Standalone FWAIT).
 *
 *  Opcode 0x90 is a NOP.  It just fills space where the 3D was.
 */
void WINAPI INT_Int3dHandler(CONTEXT86 *context)
{
	TRACE("Int 0x3d called-- Standalone FWAIT");
	FPU_ModifyCode(context, 0x90);

}



/**********************************************************************
 *          INT_Int3eHandler (WPROCS.162)
 *
 * FLOATING POINT EMULATION -- Borland "Shortcut" call.
 *  The two bytes following the int 3E instruction are
 *  the subcode and a NOP ( 0x90 ), except for subcodes DC and DE
 *  where the second byte is the register count.
 *
 *  Direct access 4.0 modifies and does not restore this vector.
 *
 */
void WINAPI INT_Int3eHandler(CONTEXT86 *context)
{
	FIXME("Int 3E NOT Implemented");
	INT_BARF(context, 0x3e);
}

/**********************************************************************
 *          FPU_ModifyCode
 *
 *   This is the function that inserts the 0x9b fwait instruction
 *   and the actual FPU opcode into the program.
 *           -A.C.
 *
 *               Code thanks to Ove Kaaven
 */
static void FPU_ModifyCode(CONTEXT86 *context, BYTE Opcode)
{
  WORD *stack = CTX_SEG_OFF_TO_LIN(context, context->SegSs, context->Esp);
  BYTE *code =  CTX_SEG_OFF_TO_LIN(context, stack[1], stack[0]);

/*
 * All *NIX systems should have a real or kernel emulated FPU.
 */

  code[-2] = 0x9b;          /* The fwait instruction */
  code[-1] = Opcode;        /* Insert the opcode     */

  if ( stack[0] < 2 ) FIXME("Backed up over a segment boundry in FPU code.");

  stack[0] -= 2;             /* back up the return address 2 bytes */

  TRACE("Modified code in FPU int call to 0x9b 0x%x",Opcode);
}
