package advapi32;

use strict;

require Exporter;

use wine;
use vars qw(@ISA @EXPORT @EXPORT_OK);

@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();

my $module_declarations = {
    "AbortSystemShutdownA" => ["long",  ["str"]],
    "AbortSystemShutdownW" => ["long",  ["wstr"]],
    "AccessCheck" => ["long",  ["ptr", "long", "long", "ptr", "ptr", "ptr", "ptr", "ptr"]],
    "AddAccessAllowedAce" => ["long",  ["ptr", "long", "long", "ptr"]],
    "AdjustTokenPrivileges" => ["long",  ["long", "long", "ptr", "long", "ptr", "ptr"]],
    "AllocateAndInitializeSid" => ["long",  ["ptr", "long", "long", "long", "long", "long", "long", "long", "long", "long", "ptr"]],
    "AllocateLocallyUniqueId" => ["long",  ["ptr"]],
    "BackupEventLogA" => ["long",  ["long", "str"]],
    "BackupEventLogW" => ["long",  ["long", "wstr"]],
    "CheckTokenMembership" => ["long",  ["long", "ptr", "ptr"]],
    "ClearEventLogA" => ["long",  ["long", "str"]],
    "ClearEventLogW" => ["long",  ["long", "wstr"]],
    "CloseEventLog" => ["long",  ["long"]],
    "CloseServiceHandle" => ["long",  ["long"]],
    "ControlService" => ["long",  ["long", "long", "ptr"]],
    "CopySid" => ["long",  ["long", "ptr", "ptr"]],
    "CreateServiceA" => ["long",  ["long", "str", "str", "long", "long", "long", "long", "str", "str", "ptr", "str", "str", "str"]],
    "CreateServiceW" => ["long",  ["long", "wstr", "wstr", "long", "long", "long", "long", "wstr", "wstr", "ptr", "wstr", "wstr", "wstr"]],
    "CryptAcquireContextA" => ["long",  ["ptr", "str", "str", "long", "long"]],
    "CryptAcquireContextW" => ["long",  ["ptr", "wstr", "wstr", "long", "long"]],
    "CryptContextAddRef" => ["long",  ["long", "ptr", "long"]],
    "CryptCreateHash" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "CryptDecrypt" => ["long",  ["long", "long", "long", "long", "ptr", "ptr"]],
    "CryptDeriveKey" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "CryptDestroyHash" => ["long",  ["long"]],
    "CryptDestroyKey" => ["long",  ["long"]],
    "CryptDuplicateHash" => ["long",  ["long", "ptr", "long", "ptr"]],
    "CryptDuplicateKey" => ["long",  ["long", "ptr", "long", "ptr"]],
    "CryptEncrypt" => ["long",  ["long", "long", "long", "long", "ptr", "ptr", "long"]],
    "CryptEnumProviderTypesA" => ["long",  ["long", "ptr", "long", "ptr", "str", "ptr"]],
    "CryptEnumProviderTypesW" => ["long",  ["long", "ptr", "long", "ptr", "wstr", "ptr"]],
    "CryptEnumProvidersA" => ["long",  ["long", "ptr", "long", "ptr", "str", "ptr"]],
    "CryptEnumProvidersW" => ["long",  ["long", "ptr", "long", "ptr", "wstr", "ptr"]],
    "CryptExportKey" => ["long",  ["long", "long", "long", "long", "ptr", "ptr"]],
    "CryptGenKey" => ["long",  ["long", "long", "long", "ptr"]],
    "CryptGenRandom" => ["long",  ["long", "long", "ptr"]],
    "CryptGetDefaultProviderA" => ["long",  ["long", "ptr", "long", "str", "ptr"]],
    "CryptGetDefaultProviderW" => ["long",  ["long", "ptr", "long", "wstr", "ptr"]],
    "CryptGetHashParam" => ["long",  ["long", "long", "ptr", "ptr", "long"]],
    "CryptGetKeyParam" => ["long",  ["long", "long", "ptr", "ptr", "long"]],
    "CryptGetProvParam" => ["long",  ["long", "long", "ptr", "ptr", "long"]],
    "CryptGetUserKey" => ["long",  ["long", "long", "ptr"]],
    "CryptHashData" => ["long",  ["long", "ptr", "long", "long"]],
    "CryptHashSessionKey" => ["long",  ["long", "long", "long"]],
    "CryptImportKey" => ["long",  ["long", "ptr", "long", "long", "long", "ptr"]],
    "CryptReleaseContext" => ["long",  ["long", "long"]],
    "CryptSetHashParam" => ["long",  ["long", "long", "ptr", "long"]],
    "CryptSetKeyParam" => ["long",  ["long", "long", "ptr", "long"]],
    "CryptSetProvParam" => ["long",  ["long", "long", "ptr", "long"]],
    "CryptSetProviderA" => ["long",  ["str", "long"]],
    "CryptSetProviderExA" => ["long",  ["str", "long", "ptr", "long"]],
    "CryptSetProviderExW" => ["long",  ["wstr", "long", "ptr", "long"]],
    "CryptSetProviderW" => ["long",  ["wstr", "long"]],
    "CryptSignHashA" => ["long",  ["long", "long", "str", "long", "ptr", "ptr"]],
    "CryptSignHashW" => ["long",  ["long", "long", "str", "long", "ptr", "ptr"]],
    "CryptVerifySignatureA" => ["long",  ["long", "ptr", "long", "long", "str", "long"]],
    "CryptVerifySignatureW" => ["long",  ["long", "ptr", "long", "long", "str", "long"]],
    "DeleteService" => ["long",  ["long"]],
    "DeregisterEventSource" => ["long",  ["long"]],
    "EnumServicesStatusA" => ["long",  ["long", "long", "long", "ptr", "long", "ptr", "ptr", "ptr"]],
    "EnumServicesStatusW" => ["long",  ["long", "long", "long", "ptr", "long", "ptr", "ptr", "ptr"]],
    "EqualPrefixSid" => ["long",  ["ptr", "ptr"]],
    "EqualSid" => ["long",  ["ptr", "ptr"]],
    "FreeSid" => ["ptr",  ["ptr"]],
    "GetAce" => ["long",  ["ptr", "long", "ptr"]],
    "GetCurrentHwProfileA" => ["long",  ["ptr"]],
    "GetFileSecurityA" => ["long",  ["str", "long", "ptr", "long", "ptr"]],
    "GetFileSecurityW" => ["long",  ["wstr", "long", "ptr", "long", "ptr"]],
    "GetLengthSid" => ["long",  ["ptr"]],
    "GetNumberOfEventLogRecords" => ["long",  ["long", "ptr"]],
    "GetOldestEventLogRecord" => ["long",  ["long", "ptr"]],
    "GetSecurityDescriptorControl" => ["long",  ["ptr", "ptr", "ptr"]],
    "GetSecurityDescriptorDacl" => ["long",  ["ptr", "ptr", "ptr", "ptr"]],
    "GetSecurityDescriptorGroup" => ["long",  ["ptr", "ptr", "ptr"]],
    "GetSecurityDescriptorLength" => ["long",  ["ptr"]],
    "GetSecurityDescriptorOwner" => ["long",  ["ptr", "ptr", "ptr"]],
    "GetSecurityDescriptorSacl" => ["long",  ["ptr", "ptr", "ptr", "ptr"]],
    "GetSidIdentifierAuthority" => ["ptr",  ["ptr"]],
    "GetSidLengthRequired" => ["long",  ["long"]],
    "GetSidSubAuthority" => ["ptr",  ["ptr", "long"]],
    "GetSidSubAuthorityCount" => ["ptr",  ["ptr"]],
    "GetTokenInformation" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "GetUserNameA" => ["long",  ["str", "ptr"]],
    "GetUserNameW" => ["long",  ["wstr", "ptr"]],
    "ImpersonateLoggedOnUser" => ["long",  ["long"]],
    "ImpersonateSelf" => ["long",  ["long"]],
    "InitializeAcl" => ["long",  ["ptr", "long", "long"]],
    "InitializeSecurityDescriptor" => ["long",  ["ptr", "long"]],
    "InitializeSid" => ["long",  ["ptr", "ptr", "long"]],
    "IsValidSecurityDescriptor" => ["long",  ["ptr"]],
    "IsValidSid" => ["long",  ["ptr"]],
    "LookupAccountNameA" => ["long",  ["str", "str", "ptr", "ptr", "str", "ptr", "ptr"]],
    "LookupAccountSidA" => ["long",  ["str", "ptr", "str", "ptr", "str", "ptr", "ptr"]],
    "LookupAccountSidW" => ["long",  ["wstr", "ptr", "wstr", "ptr", "wstr", "ptr", "ptr"]],
    "LookupPrivilegeValueA" => ["long",  ["str", "str", "ptr"]],
    "LookupPrivilegeValueW" => ["long",  ["wstr", "wstr", "ptr"]],
    "LsaClose" => ["long",  ["long"]],
    "LsaFreeMemory" => ["long",  ["ptr"]],
    "LsaLookupSids" => ["long",  ["long", "long", "ptr", "ptr", "ptr"]],
    "LsaOpenPolicy" => ["long",  ["ptr", "ptr", "long", "ptr"]],
    "LsaQueryInformationPolicy" => ["long",  ["long", "long", "ptr"]],
    "MakeSelfRelativeSD" => ["long",  ["ptr", "ptr", "ptr"]],
    "NotifyBootConfigStatus" => ["long",  ["long"]],
    "NotifyChangeEventLog" => ["long",  ["long", "long"]],
    "OpenBackupEventLogA" => ["long",  ["str", "str"]],
    "OpenBackupEventLogW" => ["long",  ["wstr", "wstr"]],
    "OpenEventLogA" => ["long",  ["str", "str"]],
    "OpenEventLogW" => ["long",  ["wstr", "wstr"]],
    "OpenProcessToken" => ["long",  ["long", "long", "ptr"]],
    "OpenSCManagerA" => ["long",  ["str", "str", "long"]],
    "OpenSCManagerW" => ["long",  ["wstr", "wstr", "long"]],
    "OpenServiceA" => ["long",  ["long", "str", "long"]],
    "OpenServiceW" => ["long",  ["long", "wstr", "long"]],
    "OpenThreadToken" => ["long",  ["long", "long", "long", "ptr"]],
    "PrivilegeCheck" => ["long",  ["long", "ptr", "ptr"]],
    "QueryServiceStatus" => ["long",  ["long", "ptr"]],
    "QueryWindows31FilesMigration" => ["long",  ["long"]],
    "ReadEventLogA" => ["long",  ["long", "long", "long", "ptr", "long", "ptr", "ptr"]],
    "ReadEventLogW" => ["long",  ["long", "long", "long", "ptr", "long", "ptr", "ptr"]],
    "RegCloseKey" => ["long",  ["long"]],
    "RegConnectRegistryA" => ["long",  ["str", "long", "ptr"]],
    "RegConnectRegistryW" => ["long",  ["wstr", "long", "ptr"]],
    "RegCreateKeyA" => ["long",  ["long", "str", "ptr"]],
    "RegCreateKeyExA" => ["long",  ["long", "str", "long", "str", "long", "long", "ptr", "ptr", "ptr"]],
    "RegCreateKeyExW" => ["long",  ["long", "wstr", "long", "wstr", "long", "long", "ptr", "ptr", "ptr"]],
    "RegCreateKeyW" => ["long",  ["long", "wstr", "ptr"]],
    "RegDeleteKeyA" => ["long",  ["long", "str"]],
    "RegDeleteKeyW" => ["long",  ["long", "wstr"]],
    "RegDeleteValueA" => ["long",  ["long", "str"]],
    "RegDeleteValueW" => ["long",  ["long", "wstr"]],
    "RegEnumKeyA" => ["long",  ["long", "long", "str", "long"]],
    "RegEnumKeyExA" => ["long",  ["long", "long", "str", "ptr", "ptr", "str", "ptr", "ptr"]],
    "RegEnumKeyExW" => ["long",  ["long", "long", "wstr", "ptr", "ptr", "wstr", "ptr", "ptr"]],
    "RegEnumKeyW" => ["long",  ["long", "long", "wstr", "long"]],
    "RegEnumValueA" => ["long",  ["long", "long", "str", "ptr", "ptr", "ptr", "ptr", "ptr"]],
    "RegEnumValueW" => ["long",  ["long", "long", "wstr", "ptr", "ptr", "ptr", "ptr", "ptr"]],
    "RegFlushKey" => ["long",  ["long"]],
    "RegGetKeySecurity" => ["long",  ["long", "long", "ptr", "ptr"]],
    "RegLoadKeyA" => ["long",  ["long", "str", "str"]],
    "RegLoadKeyW" => ["long",  ["long", "wstr", "wstr"]],
    "RegNotifyChangeKeyValue" => ["long",  ["long", "long", "long", "long", "long"]],
    "RegOpenCurrentUser" => ["long",  ["long", "ptr"]],
    "RegOpenKeyA" => ["long",  ["long", "str", "ptr"]],
    "RegOpenKeyExA" => ["long",  ["long", "str", "long", "long", "ptr"]],
    "RegOpenKeyExW" => ["long",  ["long", "wstr", "long", "long", "ptr"]],
    "RegOpenKeyW" => ["long",  ["long", "wstr", "ptr"]],
    "RegQueryInfoKeyA" => ["long",  ["long", "str", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr"]],
    "RegQueryInfoKeyW" => ["long",  ["long", "wstr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr", "ptr"]],
    "RegQueryMultipleValuesA" => ["long",  ["long", "ptr", "long", "str", "ptr"]],
    "RegQueryMultipleValuesW" => ["long",  ["long", "ptr", "long", "wstr", "ptr"]],
    "RegQueryValueA" => ["long",  ["long", "str", "str", "ptr"]],
    "RegQueryValueExA" => ["long",  ["long", "str", "ptr", "ptr", "ptr", "ptr"]],
    "RegQueryValueExW" => ["long",  ["long", "wstr", "ptr", "ptr", "ptr", "ptr"]],
    "RegQueryValueW" => ["long",  ["long", "wstr", "wstr", "ptr"]],
    "RegReplaceKeyA" => ["long",  ["long", "str", "str", "str"]],
    "RegReplaceKeyW" => ["long",  ["long", "wstr", "wstr", "wstr"]],
    "RegRestoreKeyA" => ["long",  ["long", "str", "long"]],
    "RegRestoreKeyW" => ["long",  ["long", "wstr", "long"]],
    "RegSaveKeyA" => ["long",  ["long", "str", "ptr"]],
    "RegSaveKeyW" => ["long",  ["long", "wstr", "ptr"]],
    "RegSetKeySecurity" => ["long",  ["long", "long", "ptr"]],
    "RegSetValueA" => ["long",  ["long", "str", "long", "str", "long"]],
    "RegSetValueExA" => ["long",  ["long", "str", "long", "long", "ptr", "long"]],
    "RegSetValueExW" => ["long",  ["long", "wstr", "long", "long", "ptr", "long"]],
    "RegSetValueW" => ["long",  ["long", "wstr", "long", "wstr", "long"]],
    "RegUnLoadKeyA" => ["long",  ["long", "str"]],
    "RegUnLoadKeyW" => ["long",  ["long", "wstr"]],
    "RegisterEventSourceA" => ["long",  ["str", "str"]],
    "RegisterEventSourceW" => ["long",  ["wstr", "wstr"]],
    "RegisterServiceCtrlHandlerA" => ["long",  ["str", "ptr"]],
    "RegisterServiceCtrlHandlerW" => ["long",  ["wstr", "ptr"]],
    "ReportEventA" => ["long",  ["long", "long", "long", "long", "ptr", "long", "long", "ptr", "ptr"]],
    "ReportEventW" => ["long",  ["long", "long", "long", "long", "ptr", "long", "long", "ptr", "ptr"]],
    "RevertToSelf" => ["long",  []],
    "SetFileSecurityA" => ["long",  ["str", "long", "ptr"]],
    "SetFileSecurityW" => ["long",  ["wstr", "long", "ptr"]],
    "SetKernelObjectSecurity" => ["long",  ["long", "long", "ptr"]],
    "SetSecurityDescriptorDacl" => ["long",  ["ptr", "long", "ptr", "long"]],
    "SetSecurityDescriptorGroup" => ["long",  ["ptr", "ptr", "long"]],
    "SetSecurityDescriptorOwner" => ["long",  ["ptr", "ptr", "long"]],
    "SetSecurityDescriptorSacl" => ["long",  ["ptr", "long", "ptr", "long"]],
    "SetServiceStatus" => ["long",  ["long", "ptr"]],
    "SetThreadToken" => ["long",  ["ptr", "long"]],
    "SetTokenInformation" => ["long",  ["long", "long", "ptr", "long"]],
    "StartServiceA" => ["long",  ["long", "long", "ptr"]],
    "StartServiceCtrlDispatcherA" => ["long",  ["ptr"]],
    "StartServiceCtrlDispatcherW" => ["long",  ["ptr"]],
    "StartServiceW" => ["long",  ["long", "long", "ptr"]],
    "SynchronizeWindows31FilesAndWindowsNTRegistry" => ["long",  ["long", "long", "long", "long"]]
};

&wine::declare("advapi32",%$module_declarations);
push @EXPORT, map { "&" . $_; } sort(keys(%$module_declarations));
1;
