package kernel32;

use strict;

require Exporter;

use wine;
use vars qw(@ISA @EXPORT @EXPORT_OK);

@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();

my $module_declarations = {
    "k32CharToOemA" => ["long",  ["str", "str"]],
    "k32CharToOemBuffA" => ["long",  ["str", "str", "long"]],
    "k32OemToCharA" => ["long",  ["str", "str"]],
    "k32OemToCharBuffA" => ["long",  ["str", "str", "long"]],
    "k32LoadStringA" => ["long",  ["long", "long", "str", "long"]],
    "k32wvsprintfA" => ["long",  ["str", "str", "ptr"]],
    "CommonUnimpStub" => ["void",  ["ptr"]],
    "GetProcessDword" => ["long",  ["long", "long"]],
    "DosFileHandleToWin32Handle" => ["long",  ["long"]],
    "Win32HandleToDosFileHandle" => ["long",  ["long"]],
    "DisposeLZ32Handle" => ["void",  ["long"]],
    "GlobalAlloc16" => ["long",  ["long", "long"]],
    "GlobalLock16" => ["ptr",  ["long"]],
    "GlobalUnlock16" => ["long",  ["long"]],
    "GlobalFix16" => ["long",  ["long"]],
    "GlobalUnfix16" => ["void",  ["long"]],
    "GlobalWire16" => ["ptr",  ["long"]],
    "GlobalUnWire16" => ["long",  ["long"]],
    "GlobalFree16" => ["long",  ["long"]],
    "GlobalSize16" => ["long",  ["long"]],
    "HouseCleanLogicallyDeadHandles" => ["void",  []],
    "GetWin16DOSEnv" => ["long",  ["undef"]],
    "LoadLibrary16" => ["long",  ["str"]],
    "FreeLibrary16" => ["void",  ["long"]],
    "GetProcAddress16" => ["ptr",  ["long", "str"]],
    "AllocMappedBuffer" => ["void",  ["ptr"]],
    "FreeMappedBuffer" => ["void",  ["ptr"]],
    "OT_32ThkLSF" => ["void",  ["ptr"]],
    "ThunkInitLSF" => ["ptr",  ["ptr", "str", "long", "str", "str"]],
    "LogApiThkLSF" => ["void",  ["str", "ptr"]],
    "ThunkInitLS" => ["long",  ["ptr", "str", "long", "str", "str"]],
    "LogApiThkSL" => ["void",  ["str", "ptr"]],
    "Common32ThkLS" => ["void",  ["ptr"]],
    "ThunkInitSL" => ["void",  ["ptr", "str", "long", "str", "str"]],
    "LogCBThkSL" => ["void",  ["str", "ptr"]],
    "ReleaseThunkLock" => ["void",  ["ptr"]],
    "RestoreThunkLock" => ["void",  ["long"]],
    "W32S_BackTo32" => ["void",  ["ptr"]],
    "GetThunkBuff" => ["ptr",  []],
    "GetThunkStuff" => ["ptr",  ["str", "str"]],
    "K32WOWCallback16" => ["long",  ["long", "long"]],
    "K32WOWCallback16Ex" => ["long",  ["long", "long", "long", "ptr", "ptr"]],
    "K32WOWGetVDMPointer" => ["ptr",  ["long", "long", "long"]],
    "K32WOWHandle32" => ["long",  ["long", "long"]],
    "K32WOWHandle16" => ["long",  ["long", "long"]],
    "K32WOWGlobalAlloc16" => ["long",  ["long", "long"]],
    "K32WOWGlobalLock16" => ["ptr",  ["long"]],
    "K32WOWGlobalUnlock16" => ["long",  ["long"]],
    "K32WOWGlobalFree16" => ["long",  ["long"]],
    "K32WOWGlobalAllocLock16" => ["long",  ["long", "long", "ptr"]],
    "K32WOWGlobalUnlockFree16" => ["long",  ["long"]],
    "K32WOWGlobalLockSize16" => ["long",  ["long", "ptr"]],
    "K32WOWYield16" => ["void",  []],
    "K32WOWDirectedYield16" => ["void",  ["long"]],
    "K32WOWGetVDMPointerFix" => ["ptr",  ["long", "long", "long"]],
    "K32WOWGetVDMPointerUnfix" => ["void",  ["long"]],
    "K32WOWGetDescriptor" => ["long",  ["ptr", "ptr"]],
    "SSOnBigStack" => ["long",  ["undef"]],
    "FT_PrologPrime" => ["void",  ["ptr"]],
    "QT_ThunkPrime" => ["void",  ["ptr"]],
    "PK16FNF" => ["void",  ["str"]],
    "GetPK16SysVar" => ["ptr",  []],
    "GetpWin16Lock" => ["void",  ["ptr"]],
    "_CheckNotSysLevel" => ["void",  ["ptr"]],
    "_ConfirmSysLevel" => ["long",  ["ptr"]],
    "_ConfirmWin16Lock" => ["long",  []],
    "_EnterSysLevel" => ["void",  ["ptr"]],
    "_LeaveSysLevel" => ["void",  ["ptr"]],
    "AddAtomA" => ["long",  ["str"]],
    "AddAtomW" => ["long",  ["wstr"]],
    "AllocConsole" => ["long",  []],
    "AllocSLCallback" => ["long",  ["long", "long"]],
    "AreFileApisANSI" => ["long",  []],
    "BackupRead" => ["long",  ["long", "ptr", "long", "ptr", "long", "long", "ptr"]],
    "BackupSeek" => ["long",  ["long", "long", "long", "ptr", "ptr", "ptr"]],
    "BackupWrite" => ["long",  ["long", "ptr", "long", "ptr", "long", "long", "ptr"]],
    "Beep" => ["long",  ["long", "long"]],
    "BuildCommDCBA" => ["long",  ["str", "ptr"]],
    "BuildCommDCBAndTimeoutsA" => ["long",  ["str", "ptr", "ptr"]],
    "BuildCommDCBAndTimeoutsW" => ["long",  ["wstr", "ptr", "ptr"]],
    "BuildCommDCBW" => ["long",  ["wstr", "ptr"]],
    "CallNamedPipeA" => ["long",  ["str", "ptr", "long", "ptr", "long", "ptr", "long"]],
    "CallNamedPipeW" => ["long",  ["wstr", "ptr", "long", "ptr", "long", "ptr", "long"]],
    "CancelIo" => ["long",  ["long"]],
    "CancelWaitableTimer" => ["long",  ["long"]],
    "ClearCommBreak" => ["long",  ["long"]],
    "ClearCommError" => ["long",  ["long", "ptr", "ptr"]],
    "CloseHandle" => ["long",  ["long"]],
    "CloseProfileUserMapping" => ["long",  []],
    "CommConfigDialogA" => ["long",  ["str", "long", "ptr"]],
    "CommConfigDialogW" => ["long",  ["wstr", "long", "ptr"]],
    "CompareFileTime" => ["long",  ["ptr", "ptr"]],
    "CompareStringA" => ["long",  ["long", "long", "str", "long", "str", "long"]],
    "CompareStringW" => ["long",  ["long", "long", "wstr", "long", "wstr", "long"]],
    "ConnectNamedPipe" => ["long",  ["long", "ptr"]],
    "ContinueDebugEvent" => ["long",  ["long", "long", "long"]],
    "ConvertDefaultLocale" => ["long",  ["long"]],
    "ConvertDialog32To16" => ["void",  ["ptr", "long", "ptr"]],
    "ConvertToGlobalHandle" => ["long",  ["long"]],
    "CopyFileA" => ["long",  ["str", "str", "long"]],
    "CopyFileExA" => ["long",  ["str", "str", "ptr", "ptr", "ptr", "long"]],
    "CopyFileExW" => ["long",  ["wstr", "wstr", "ptr", "ptr", "ptr", "long"]],
    "CopyFileW" => ["long",  ["wstr", "wstr", "long"]],
    "CreateConsoleScreenBuffer" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "CreateDirectoryA" => ["long",  ["str", "ptr"]],
    "CreateDirectoryExA" => ["long",  ["str", "str", "ptr"]],
    "CreateDirectoryExW" => ["long",  ["wstr", "wstr", "ptr"]],
    "CreateDirectoryW" => ["long",  ["wstr", "ptr"]],
    "CreateEventA" => ["long",  ["ptr", "long", "long", "str"]],
    "CreateEventW" => ["long",  ["ptr", "long", "long", "wstr"]],
    "CreateFileA" => ["long",  ["str", "long", "long", "ptr", "long", "long", "long"]],
    "CreateFileMappingA" => ["long",  ["long", "ptr", "long", "long", "long", "str"]],
    "CreateFileMappingW" => ["long",  ["long", "ptr", "long", "long", "long", "wstr"]],
    "CreateFileW" => ["long",  ["wstr", "long", "long", "ptr", "long", "long", "long"]],
    "CreateIoCompletionPort" => ["long",  ["long", "long", "long", "long"]],
    "CreateMailslotA" => ["long",  ["str", "long", "long", "ptr"]],
    "CreateMailslotW" => ["long",  ["wstr", "long", "long", "ptr"]],
    "CreateMutexA" => ["long",  ["ptr", "long", "str"]],
    "CreateMutexW" => ["long",  ["ptr", "long", "wstr"]],
    "CreateNamedPipeA" => ["long",  ["str", "long", "long", "long", "long", "long", "long", "ptr"]],
    "CreateNamedPipeW" => ["long",  ["wstr", "long", "long", "long", "long", "long", "long", "ptr"]],
    "CreatePipe" => ["long",  ["ptr", "ptr", "ptr", "long"]],
    "CreateProcessA" => ["long",  ["str", "str", "ptr", "ptr", "long", "long", "ptr", "str", "ptr", "ptr"]],
    "CreateProcessW" => ["long",  ["wstr", "wstr", "ptr", "ptr", "long", "long", "ptr", "wstr", "ptr", "ptr"]],
    "CreateSemaphoreA" => ["long",  ["ptr", "long", "long", "str"]],
    "CreateSemaphoreW" => ["long",  ["ptr", "long", "long", "wstr"]],
    "CreateSocketHandle" => ["long",  []],
    "CreateTapePartition" => ["long",  ["long", "long", "long", "long"]],
    "CreateThread" => ["long",  ["ptr", "long", "ptr", "ptr", "long", "ptr"]],
    "CreateToolhelp32Snapshot" => ["long",  ["long", "long"]],
    "CreateWaitableTimerA" => ["long",  ["ptr", "long", "str"]],
    "CreateWaitableTimerW" => ["long",  ["ptr", "long", "wstr"]],
    "DebugActiveProcess" => ["long",  ["long"]],
    "DebugActiveProcessStop" => ["long",  ["long"]],
    "DebugBreak" => ["void",  []],
    "DebugBreakProcess" => ["long",  ["long"]],
    "DebugSetProcessKillOnExit" => ["long",  ["long"]],
    "DefineDosDeviceA" => ["long",  ["long", "str", "str"]],
    "DeleteAtom" => ["long",  ["long"]],
    "DeleteFileA" => ["long",  ["str"]],
    "DeleteFileW" => ["long",  ["wstr"]],
    "DeviceIoControl" => ["long",  ["long", "long", "ptr", "long", "ptr", "long", "ptr", "ptr"]],
    "DisableThreadLibraryCalls" => ["long",  ["long"]],
    "DisconnectNamedPipe" => ["long",  ["long"]],
    "DosDateTimeToFileTime" => ["long",  ["long", "long", "ptr"]],
    "DuplicateHandle" => ["long",  ["long", "long", "long", "ptr", "long", "long", "long"]],
    "EnumCalendarInfoA" => ["long",  ["ptr", "long", "long", "long"]],
    "EnumDateFormatsA" => ["long",  ["ptr", "long", "long"]],
    "EnumDateFormatsW" => ["long",  ["ptr", "long", "long"]],
    "EnumResourceLanguagesA" => ["long",  ["long", "str", "str", "ptr", "long"]],
    "EnumResourceLanguagesW" => ["long",  ["long", "wstr", "wstr", "ptr", "long"]],
    "EnumResourceNamesA" => ["long",  ["long", "str", "ptr", "long"]],
    "EnumResourceNamesW" => ["long",  ["long", "wstr", "ptr", "long"]],
    "EnumResourceTypesA" => ["long",  ["long", "ptr", "long"]],
    "EnumResourceTypesW" => ["long",  ["long", "ptr", "long"]],
    "EnumSystemCodePagesA" => ["long",  ["ptr", "long"]],
    "EnumSystemCodePagesW" => ["long",  ["ptr", "long"]],
    "EnumSystemLocalesA" => ["long",  ["ptr", "long"]],
    "EnumSystemLocalesW" => ["long",  ["ptr", "long"]],
    "EnumTimeFormatsA" => ["long",  ["ptr", "long", "long"]],
    "EnumTimeFormatsW" => ["long",  ["ptr", "long", "long"]],
    "EraseTape" => ["long",  ["long", "long", "long"]],
    "EscapeCommFunction" => ["long",  ["long", "long"]],
    "ExitProcess" => ["void",  ["long"]],
    "ExitThread" => ["void",  ["long"]],
    "ExpandEnvironmentStringsA" => ["long",  ["str", "str", "long"]],
    "ExpandEnvironmentStringsW" => ["long",  ["wstr", "wstr", "long"]],
    "FT_Exit0" => ["void",  ["ptr"]],
    "FT_Exit12" => ["void",  ["ptr"]],
    "FT_Exit16" => ["void",  ["ptr"]],
    "FT_Exit20" => ["void",  ["ptr"]],
    "FT_Exit24" => ["void",  ["ptr"]],
    "FT_Exit28" => ["void",  ["ptr"]],
    "FT_Exit32" => ["void",  ["ptr"]],
    "FT_Exit36" => ["void",  ["ptr"]],
    "FT_Exit4" => ["void",  ["ptr"]],
    "FT_Exit40" => ["void",  ["ptr"]],
    "FT_Exit44" => ["void",  ["ptr"]],
    "FT_Exit48" => ["void",  ["ptr"]],
    "FT_Exit52" => ["void",  ["ptr"]],
    "FT_Exit56" => ["void",  ["ptr"]],
    "FT_Exit8" => ["void",  ["ptr"]],
    "FT_Prolog" => ["void",  ["ptr"]],
    "FT_Thunk" => ["void",  ["ptr"]],
    "FatalAppExitA" => ["void",  ["long", "str"]],
    "FatalAppExitW" => ["void",  ["long", "wstr"]],
    "FileTimeToDosDateTime" => ["long",  ["ptr", "ptr", "ptr"]],
    "FileTimeToLocalFileTime" => ["long",  ["ptr", "ptr"]],
    "FileTimeToSystemTime" => ["long",  ["ptr", "ptr"]],
    "FillConsoleOutputAttribute" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "FillConsoleOutputCharacterA" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "FillConsoleOutputCharacterW" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "FindAtomA" => ["long",  ["str"]],
    "FindAtomW" => ["long",  ["wstr"]],
    "FindClose" => ["long",  ["long"]],
    "FindCloseChangeNotification" => ["long",  ["long"]],
    "FindFirstChangeNotificationA" => ["long",  ["str", "long", "long"]],
    "FindFirstChangeNotificationW" => ["long",  ["wstr", "long", "long"]],
    "FindFirstFileA" => ["long",  ["str", "ptr"]],
    "FindFirstFileExA" => ["long",  ["str", "ptr", "ptr", "ptr", "ptr", "long"]],
    "FindFirstFileExW" => ["long",  ["wstr", "ptr", "ptr", "ptr", "ptr", "long"]],
    "FindFirstFileW" => ["long",  ["wstr", "ptr"]],
    "FindNextChangeNotification" => ["long",  ["long"]],
    "FindNextFileA" => ["long",  ["long", "ptr"]],
    "FindNextFileW" => ["long",  ["long", "ptr"]],
    "FindResource16" => ["long",  ["long", "str", "str"]],
    "FindResourceA" => ["long",  ["long", "str", "str"]],
    "FindResourceExA" => ["long",  ["long", "str", "str", "long"]],
    "FindResourceExW" => ["long",  ["long", "wstr", "wstr", "long"]],
    "FindResourceW" => ["long",  ["long", "wstr", "wstr"]],
    "FlushConsoleInputBuffer" => ["long",  ["long"]],
    "FlushFileBuffers" => ["long",  ["long"]],
    "FlushInstructionCache" => ["long",  ["long", "ptr", "long"]],
    "FlushViewOfFile" => ["long",  ["ptr", "long"]],
    "FormatMessageA" => ["long",  ["long", "ptr", "long", "long", "str", "long", "ptr"]],
    "FormatMessageW" => ["long",  ["long", "ptr", "long", "long", "wstr", "long", "ptr"]],
    "FreeConsole" => ["long",  []],
    "FreeEnvironmentStringsA" => ["long",  ["str"]],
    "FreeEnvironmentStringsW" => ["long",  ["wstr"]],
    "FreeLibrary" => ["long",  ["long"]],
    "FreeLibraryAndExitThread" => ["void",  ["long", "long"]],
    "FreeResource" => ["long",  ["long"]],
    "FreeResource16" => ["long",  ["long"]],
    "FreeSLCallback" => ["void",  ["long"]],
    "GenerateConsoleCtrlEvent" => ["long",  ["long", "long"]],
    "Get16DLLAddress" => ["ptr",  ["long", "str"]],
    "GetACP" => ["long",  []],
    "GetAtomNameA" => ["long",  ["long", "str", "long"]],
    "GetAtomNameW" => ["long",  ["long", "wstr", "long"]],
    "GetBinaryType" => ["long",  ["str", "ptr"]],
    "GetBinaryTypeA" => ["long",  ["str", "ptr"]],
    "GetBinaryTypeW" => ["long",  ["wstr", "ptr"]],
    "GetCPInfo" => ["long",  ["long", "ptr"]],
    "GetCalendarInfoA" => ["long",  ["long", "long", "long", "str", "long", "ptr"]],
    "GetCalendarInfoW" => ["long",  ["long", "long", "long", "wstr", "long", "ptr"]],
    "GetCommConfig" => ["long",  ["long", "ptr", "ptr"]],
    "GetCommMask" => ["long",  ["long", "ptr"]],
    "GetCommModemStatus" => ["long",  ["long", "ptr"]],
    "GetCommProperties" => ["long",  ["long", "ptr"]],
    "GetCommState" => ["long",  ["long", "ptr"]],
    "GetCommTimeouts" => ["long",  ["long", "ptr"]],
    "GetCommandLineA" => ["str",  []],
    "GetCommandLineW" => ["wstr",  []],
    "GetCompressedFileSizeA" => ["long",  ["str", "ptr"]],
    "GetCompressedFileSizeW" => ["long",  ["wstr", "ptr"]],
    "GetComputerNameA" => ["long",  ["str", "ptr"]],
    "GetComputerNameExA" => ["long",  ["ptr", "str", "ptr"]],
    "GetComputerNameExW" => ["long",  ["ptr", "wstr", "ptr"]],
    "GetComputerNameW" => ["long",  ["wstr", "ptr"]],
    "GetConsoleCP" => ["long",  []],
    "GetConsoleCursorInfo" => ["long",  ["long", "ptr"]],
    "GetConsoleMode" => ["long",  ["long", "ptr"]],
    "GetConsoleOutputCP" => ["long",  []],
    "GetConsoleScreenBufferInfo" => ["long",  ["long", "ptr"]],
    "GetConsoleTitleA" => ["long",  ["str", "long"]],
    "GetConsoleTitleW" => ["long",  ["wstr", "long"]],
    "GetCurrencyFormatA" => ["long",  ["long", "long", "str", "ptr", "str", "long"]],
    "GetCurrencyFormatW" => ["long",  ["long", "long", "wstr", "ptr", "wstr", "long"]],
    "GetCurrentDirectoryA" => ["long",  ["long", "str"]],
    "GetCurrentDirectoryW" => ["long",  ["long", "wstr"]],
    "GetCurrentProcess" => ["long",  []],
    "GetCurrentProcessId" => ["long",  []],
    "GetCurrentTask" => ["long",  []],
    "GetCurrentThread" => ["long",  []],
    "GetCurrentThreadId" => ["long",  []],
    "GetDOSEnvironment16" => ["ptr",  []],
    "GetDateFormatA" => ["long",  ["long", "long", "ptr", "str", "str", "long"]],
    "GetDateFormatW" => ["long",  ["long", "long", "ptr", "wstr", "wstr", "long"]],
    "GetDefaultCommConfigA" => ["long",  ["str", "ptr", "ptr"]],
    "GetDefaultCommConfigW" => ["long",  ["wstr", "ptr", "ptr"]],
    "GetDiskFreeSpaceA" => ["long",  ["str", "ptr", "ptr", "ptr", "ptr"]],
    "GetDiskFreeSpaceExA" => ["long",  ["str", "ptr", "ptr", "ptr"]],
    "GetDiskFreeSpaceExW" => ["long",  ["wstr", "ptr", "ptr", "ptr"]],
    "GetDiskFreeSpaceW" => ["long",  ["wstr", "ptr", "ptr", "ptr", "ptr"]],
    "GetDriveTypeA" => ["long",  ["str"]],
    "GetDriveTypeW" => ["long",  ["wstr"]],
    "GetEnvironmentStrings" => ["str",  []],
    "GetEnvironmentStringsA" => ["str",  []],
    "GetEnvironmentStringsW" => ["wstr",  []],
    "GetEnvironmentVariableA" => ["long",  ["str", "str", "long"]],
    "GetEnvironmentVariableW" => ["long",  ["wstr", "wstr", "long"]],
    "GetExitCodeProcess" => ["long",  ["long", "ptr"]],
    "GetExitCodeThread" => ["long",  ["long", "ptr"]],
    "GetFileAttributesA" => ["long",  ["str"]],
    "GetFileAttributesExA" => ["long",  ["str", "ptr", "ptr"]],
    "GetFileAttributesExW" => ["long",  ["wstr", "ptr", "ptr"]],
    "GetFileAttributesW" => ["long",  ["wstr"]],
    "GetFileInformationByHandle" => ["long",  ["long", "ptr"]],
    "GetFileSize" => ["long",  ["long", "ptr"]],
    "GetFileTime" => ["long",  ["long", "ptr", "ptr", "ptr"]],
    "GetFileType" => ["long",  ["long"]],
    "GetFullPathNameA" => ["long",  ["str", "long", "str", "ptr"]],
    "GetFullPathNameW" => ["long",  ["wstr", "long", "wstr", "ptr"]],
    "GetHandleContext" => ["long",  ["long"]],
    "GetHandleInformation" => ["long",  ["long", "ptr"]],
    "GetLastError" => ["long",  []],
    "GetLocalTime" => ["void",  ["ptr"]],
    "GetLocaleInfoA" => ["long",  ["long", "long", "str", "long"]],
    "GetLocaleInfoW" => ["long",  ["long", "long", "wstr", "long"]],
    "GetLogicalDriveStringsA" => ["long",  ["long", "str"]],
    "GetLogicalDriveStringsW" => ["long",  ["long", "wstr"]],
    "GetLogicalDrives" => ["long",  []],
    "GetLongPathNameA" => ["long",  ["str", "str", "long"]],
    "GetLongPathNameW" => ["long",  ["wstr", "wstr", "long"]],
    "GetMailslotInfo" => ["long",  ["long", "ptr", "ptr", "ptr", "ptr"]],
    "GetModuleFileName16" => ["long",  ["long", "str", "long"]],
    "GetModuleFileNameA" => ["long",  ["long", "str", "long"]],
    "GetModuleFileNameW" => ["long",  ["long", "wstr", "long"]],
    "GetModuleHandle16" => ["long",  ["str"]],
    "GetModuleHandleA" => ["long",  ["str"]],
    "GetModuleHandleW" => ["long",  ["wstr"]],
    "GetNamedPipeHandleStateA" => ["long",  ["long", "ptr", "ptr", "ptr", "ptr", "str", "long"]],
    "GetNamedPipeHandleStateW" => ["long",  ["long", "ptr", "ptr", "ptr", "ptr", "wstr", "long"]],
    "GetNamedPipeInfo" => ["long",  ["long", "ptr", "ptr", "ptr", "ptr"]],
    "GetNumberFormatA" => ["long",  ["long", "long", "str", "ptr", "str", "long"]],
    "GetNumberFormatW" => ["long",  ["long", "long", "wstr", "ptr", "wstr", "long"]],
    "GetNumberOfConsoleInputEvents" => ["long",  ["long", "ptr"]],
    "GetNumberOfConsoleMouseButtons" => ["long",  ["ptr"]],
    "GetOEMCP" => ["long",  []],
    "GetOverlappedResult" => ["long",  ["long", "ptr", "ptr", "long"]],
    "GetPriorityClass" => ["long",  ["long"]],
    "GetPrivateProfileIntA" => ["long",  ["str", "str", "long", "str"]],
    "GetPrivateProfileIntW" => ["long",  ["wstr", "wstr", "long", "wstr"]],
    "GetPrivateProfileSectionA" => ["long",  ["str", "str", "long", "str"]],
    "GetPrivateProfileSectionNamesA" => ["long",  ["str", "long", "str"]],
    "GetPrivateProfileSectionNamesW" => ["long",  ["wstr", "long", "wstr"]],
    "GetPrivateProfileSectionW" => ["long",  ["wstr", "wstr", "long", "wstr"]],
    "GetPrivateProfileStringA" => ["long",  ["str", "str", "str", "str", "long", "str"]],
    "GetPrivateProfileStringW" => ["long",  ["wstr", "wstr", "wstr", "wstr", "long", "wstr"]],
    "GetPrivateProfileStructA" => ["long",  ["str", "str", "ptr", "long", "str"]],
    "GetPrivateProfileStructW" => ["long",  ["wstr", "wstr", "ptr", "long", "wstr"]],
    "GetProcAddress" => ["ptr",  ["long", "str"]],
    "GetProcessAffinityMask" => ["long",  ["long", "ptr", "ptr"]],
    "GetProcessFlags" => ["long",  ["long"]],
    "GetProcessHeap" => ["long",  []],
    "GetProcessHeaps" => ["long",  ["long", "ptr"]],
    "GetProcessShutdownParameters" => ["long",  ["ptr", "ptr"]],
    "GetProcessTimes" => ["long",  ["long", "ptr", "ptr", "ptr", "ptr"]],
    "GetProcessVersion" => ["long",  ["long"]],
    "GetProcessWorkingSetSize" => ["long",  ["long", "ptr", "ptr"]],
    "GetProfileIntA" => ["long",  ["str", "str", "long"]],
    "GetProfileIntW" => ["long",  ["wstr", "wstr", "long"]],
    "GetProfileSectionA" => ["long",  ["str", "str", "long"]],
    "GetProfileSectionW" => ["long",  ["wstr", "wstr", "long"]],
    "GetProfileStringA" => ["long",  ["str", "str", "str", "str", "long"]],
    "GetProfileStringW" => ["long",  ["wstr", "wstr", "wstr", "wstr", "long"]],
    "GetQueuedCompletionStatus" => ["long",  ["long", "ptr", "ptr", "ptr", "long"]],
    "GetShortPathNameA" => ["long",  ["str", "str", "long"]],
    "GetShortPathNameW" => ["long",  ["wstr", "wstr", "long"]],
    "GetStartupInfoA" => ["void",  ["ptr"]],
    "GetStartupInfoW" => ["void",  ["ptr"]],
    "GetStdHandle" => ["long",  ["long"]],
    "GetStringTypeA" => ["long",  ["long", "long", "str", "long", "ptr"]],
    "GetStringTypeExA" => ["long",  ["long", "long", "str", "long", "ptr"]],
    "GetStringTypeExW" => ["long",  ["long", "long", "wstr", "long", "ptr"]],
    "GetStringTypeW" => ["long",  ["long", "wstr", "long", "ptr"]],
    "GetSystemDefaultLCID" => ["long",  []],
    "GetSystemDefaultLangID" => ["long",  []],
    "GetSystemDirectoryA" => ["long",  ["str", "long"]],
    "GetSystemDirectoryW" => ["long",  ["wstr", "long"]],
    "GetSystemInfo" => ["void",  ["ptr"]],
    "GetSystemPowerStatus" => ["long",  ["ptr"]],
    "GetSystemTime" => ["void",  ["ptr"]],
    "GetSystemTimeAdjustment" => ["long",  ["ptr", "ptr", "ptr"]],
    "GetSystemTimeAsFileTime" => ["void",  ["ptr"]],
    "GetSystemWindowsDirectoryA" => ["long",  ["str", "long"]],
    "GetSystemWindowsDirectoryW" => ["long",  ["wstr", "long"]],
    "GetTapeParameters" => ["long",  ["long", "long", "ptr", "ptr"]],
    "GetTapePosition" => ["long",  ["long", "long", "ptr", "ptr", "ptr"]],
    "GetTapeStatus" => ["long",  ["long"]],
    "GetTempFileNameA" => ["long",  ["str", "str", "long", "str"]],
    "GetTempFileNameW" => ["long",  ["wstr", "wstr", "long", "wstr"]],
    "GetTempPathA" => ["long",  ["long", "str"]],
    "GetTempPathW" => ["long",  ["long", "wstr"]],
    "GetThreadContext" => ["long",  ["long", "ptr"]],
    "GetThreadLocale" => ["long",  []],
    "GetThreadPriority" => ["long",  ["long"]],
    "GetThreadPriorityBoost" => ["long",  ["long", "ptr"]],
    "GetThreadSelectorEntry" => ["long",  ["long", "long", "ptr"]],
    "GetThreadTimes" => ["long",  ["long", "ptr", "ptr", "ptr", "ptr"]],
    "GetTickCount" => ["long",  []],
    "GetTimeFormatA" => ["long",  ["long", "long", "ptr", "str", "str", "long"]],
    "GetTimeFormatW" => ["long",  ["long", "long", "ptr", "wstr", "wstr", "long"]],
    "GetTimeZoneInformation" => ["long",  ["ptr"]],
    "GetUserDefaultLCID" => ["long",  []],
    "GetUserDefaultLangID" => ["long",  []],
    "GetVersion" => ["long",  []],
    "GetVersionExA" => ["long",  ["ptr"]],
    "GetVersionExW" => ["long",  ["ptr"]],
    "GetVolumeInformationA" => ["long",  ["str", "str", "long", "ptr", "ptr", "ptr", "str", "long"]],
    "GetVolumeInformationW" => ["long",  ["wstr", "wstr", "long", "ptr", "ptr", "ptr", "wstr", "long"]],
    "GetWindowsDirectoryA" => ["long",  ["str", "long"]],
    "GetWindowsDirectoryW" => ["long",  ["wstr", "long"]],
    "GlobalAddAtomA" => ["long",  ["str"]],
    "GlobalAddAtomW" => ["long",  ["wstr"]],
    "GlobalAlloc" => ["long",  ["long", "long"]],
    "GlobalCompact" => ["long",  ["long"]],
    "GlobalDeleteAtom" => ["long",  ["long"]],
    "GlobalFindAtomA" => ["long",  ["str"]],
    "GlobalFindAtomW" => ["long",  ["wstr"]],
    "GlobalFix" => ["void",  ["long"]],
    "GlobalFlags" => ["long",  ["long"]],
    "GlobalFlags16" => ["long",  ["long"]],
    "GlobalFree" => ["long",  ["long"]],
    "GlobalGetAtomNameA" => ["long",  ["long", "str", "long"]],
    "GlobalGetAtomNameW" => ["long",  ["long", "wstr", "long"]],
    "GlobalHandle" => ["long",  ["ptr"]],
    "GlobalLock" => ["ptr",  ["long"]],
    "GlobalMemoryStatus" => ["void",  ["ptr"]],
    "GlobalReAlloc" => ["long",  ["long", "long", "long"]],
    "GlobalReAlloc16" => ["long",  ["long", "long", "long"]],
    "GlobalSize" => ["long",  ["long"]],
    "GlobalUnWire" => ["long",  ["long"]],
    "GlobalUnfix" => ["void",  ["long"]],
    "GlobalUnlock" => ["long",  ["long"]],
    "GlobalWire" => ["ptr",  ["long"]],
    "HeapCompact" => ["long",  ["long", "long"]],
    "HeapCreate" => ["long",  ["long", "long", "long"]],
    "HeapDestroy" => ["long",  ["long"]],
    "HeapLock" => ["long",  ["long"]],
    "HeapUnlock" => ["long",  ["long"]],
    "HeapValidate" => ["long",  ["long", "long", "ptr"]],
    "HeapWalk" => ["long",  ["long", "ptr"]],
    "InitAtomTable" => ["long",  ["long"]],
    "InitializeCriticalSection" => ["void",  ["ptr"]],
    "InitializeCriticalSectionAndSpinCount" => ["long",  ["ptr", "long"]],
    "InterlockedCompareExchange" => ["long",  ["ptr", "long", "long"]],
    "InterlockedDecrement" => ["long",  ["ptr"]],
    "InterlockedExchange" => ["long",  ["ptr", "long"]],
    "InterlockedExchangeAdd" => ["long",  ["ptr", "long"]],
    "InterlockedIncrement" => ["long",  ["ptr"]],
    "IsBadCodePtr" => ["long",  ["ptr"]],
    "IsBadHugeReadPtr" => ["long",  ["ptr", "long"]],
    "IsBadHugeWritePtr" => ["long",  ["ptr", "long"]],
    "IsBadReadPtr" => ["long",  ["ptr", "long"]],
    "IsBadStringPtrA" => ["long",  ["str", "long"]],
    "IsBadStringPtrW" => ["long",  ["wstr", "long"]],
    "IsBadWritePtr" => ["long",  ["ptr", "long"]],
    "IsDBCSLeadByte" => ["long",  ["long"]],
    "IsDBCSLeadByteEx" => ["long",  ["long", "long"]],
    "IsDebuggerPresent" => ["long",  []],
    "IsProcessorFeaturePresent" => ["long",  ["long"]],
    "IsTask16" => ["long",  ["long"]],
    "IsValidCodePage" => ["long",  ["long"]],
    "IsValidLocale" => ["long",  ["long", "long"]],
    "K32Thk1632Epilog" => ["void",  ["ptr"]],
    "K32Thk1632Prolog" => ["void",  ["ptr"]],
    "LCMapStringA" => ["long",  ["long", "long", "str", "long", "str", "long"]],
    "LCMapStringW" => ["long",  ["long", "long", "wstr", "long", "wstr", "long"]],
    "LoadLibraryA" => ["long",  ["str"]],
    "LoadLibraryExA" => ["long",  ["str", "long", "long"]],
    "LoadLibraryExW" => ["long",  ["wstr", "long", "long"]],
    "LoadLibraryW" => ["long",  ["wstr"]],
    "LoadModule" => ["long",  ["str", "ptr"]],
    "LoadModule16" => ["long",  ["str", "ptr"]],
    "LoadResource" => ["long",  ["long", "long"]],
    "LoadResource16" => ["long",  ["long", "long"]],
    "LocalAlloc" => ["long",  ["long", "long"]],
    "LocalCompact" => ["long",  ["long"]],
    "LocalFileTimeToFileTime" => ["long",  ["ptr", "ptr"]],
    "LocalFlags" => ["long",  ["long"]],
    "LocalFree" => ["long",  ["long"]],
    "LocalHandle" => ["long",  ["ptr"]],
    "LocalLock" => ["ptr",  ["long"]],
    "LocalReAlloc" => ["long",  ["long", "long", "long"]],
    "LocalShrink" => ["long",  ["long", "long"]],
    "LocalSize" => ["long",  ["long"]],
    "LocalUnlock" => ["long",  ["long"]],
    "LockFile" => ["long",  ["long", "long", "long", "long", "long"]],
    "LockFileEx" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "LockResource" => ["ptr",  ["long"]],
    "LockResource16" => ["ptr",  ["long"]],
    "MakeCriticalSectionGlobal" => ["void",  ["ptr"]],
    "MapHInstLS" => ["void",  ["ptr"]],
    "MapHInstLS_PN" => ["void",  ["ptr"]],
    "MapHInstSL" => ["void",  ["ptr"]],
    "MapHInstSL_PN" => ["void",  ["ptr"]],
    "MapHModuleLS" => ["long",  ["long"]],
    "MapHModuleSL" => ["long",  ["long"]],
    "MapLS" => ["ptr",  ["ptr"]],
    "MapSL" => ["ptr",  ["ptr"]],
    "MapSLFix" => ["ptr",  ["ptr"]],
    "MapViewOfFile" => ["ptr",  ["long", "long", "long", "long", "long"]],
    "MapViewOfFileEx" => ["ptr",  ["long", "long", "long", "long", "long", "ptr"]],
    "Module32First" => ["long",  ["long", "ptr"]],
    "Module32Next" => ["long",  ["long", "ptr"]],
    "MoveFileA" => ["long",  ["str", "str"]],
    "MoveFileExA" => ["long",  ["str", "str", "long"]],
    "MoveFileExW" => ["long",  ["wstr", "wstr", "long"]],
    "MoveFileW" => ["long",  ["wstr", "wstr"]],
    "MulDiv" => ["long",  ["long", "long", "long"]],
    "MultiByteToWideChar" => ["long",  ["long", "long", "str", "long", "wstr", "long"]],
    "OpenEventA" => ["long",  ["long", "long", "str"]],
    "OpenEventW" => ["long",  ["long", "long", "wstr"]],
    "OpenFile" => ["long",  ["str", "ptr", "long"]],
    "OpenFileMappingA" => ["long",  ["long", "long", "str"]],
    "OpenFileMappingW" => ["long",  ["long", "long", "wstr"]],
    "OpenMutexA" => ["long",  ["long", "long", "str"]],
    "OpenMutexW" => ["long",  ["long", "long", "wstr"]],
    "OpenProcess" => ["long",  ["long", "long", "long"]],
    "OpenSemaphoreA" => ["long",  ["long", "long", "str"]],
    "OpenSemaphoreW" => ["long",  ["long", "long", "wstr"]],
    "OpenVxDHandle" => ["long",  ["long"]],
    "OpenWaitableTimerA" => ["long",  ["long", "long", "str"]],
    "OpenWaitableTimerW" => ["long",  ["long", "long", "wstr"]],
    "OutputDebugStringA" => ["void",  ["str"]],
    "OutputDebugStringW" => ["void",  ["wstr"]],
    "PeekConsoleInputA" => ["long",  ["long", "ptr", "long", "ptr"]],
    "PeekConsoleInputW" => ["long",  ["long", "ptr", "long", "ptr"]],
    "PeekNamedPipe" => ["long",  ["long", "ptr", "long", "ptr", "ptr", "ptr"]],
    "PrepareTape" => ["long",  ["long", "long", "long"]],
    "PrivateFreeLibrary" => ["void",  ["long"]],
    "PrivateLoadLibrary" => ["long",  ["str"]],
    "Process32First" => ["long",  ["long", "ptr"]],
    "Process32Next" => ["long",  ["long", "ptr"]],
    "ProcessIdToSessionId" => ["long",  ["long", "ptr"]],
    "PulseEvent" => ["long",  ["long"]],
    "PurgeComm" => ["long",  ["long", "long"]],
    "QT_Thunk" => ["void",  ["ptr"]],
    "QueryDosDeviceA" => ["long",  ["str", "str", "long"]],
    "QueryDosDeviceW" => ["long",  ["wstr", "wstr", "long"]],
    "QueryPerformanceCounter" => ["long",  ["ptr"]],
    "QueryPerformanceFrequency" => ["long",  ["ptr"]],
    "QueueUserAPC" => ["long",  ["ptr", "long", "long"]],
    "RaiseException" => ["void",  ["long", "long", "long", "ptr"]],
    "ReadConsoleA" => ["long",  ["long", "ptr", "long", "ptr", "ptr"]],
    "ReadConsoleInputA" => ["long",  ["long", "ptr", "long", "ptr"]],
    "ReadConsoleInputW" => ["long",  ["long", "ptr", "long", "ptr"]],
    "ReadConsoleOutputA" => ["long",  ["long", "ptr", "long", "long", "ptr"]],
    "ReadConsoleOutputAttribute" => ["long",  ["long", "ptr", "long", "long", "ptr"]],
    "ReadConsoleOutputCharacterA" => ["long",  ["long", "str", "long", "long", "ptr"]],
    "ReadConsoleOutputCharacterW" => ["long",  ["long", "wstr", "long", "long", "ptr"]],
    "ReadConsoleOutputW" => ["long",  ["long", "ptr", "long", "long", "ptr"]],
    "ReadConsoleW" => ["long",  ["long", "ptr", "long", "ptr", "ptr"]],
    "ReadFile" => ["long",  ["long", "ptr", "long", "ptr", "ptr"]],
    "ReadFileEx" => ["long",  ["long", "ptr", "long", "ptr", "ptr"]],
    "ReadProcessMemory" => ["long",  ["long", "ptr", "ptr", "long", "ptr"]],
    "RegisterServiceProcess" => ["long",  ["long", "long"]],
    "ReinitializeCriticalSection" => ["void",  ["ptr"]],
    "ReleaseMutex" => ["long",  ["long"]],
    "ReleaseSemaphore" => ["long",  ["long", "long", "ptr"]],
    "RemoveDirectoryA" => ["long",  ["str"]],
    "RemoveDirectoryW" => ["long",  ["wstr"]],
    "ResetEvent" => ["long",  ["long"]],
    "ResumeThread" => ["long",  ["long"]],
    "SMapLS" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_12" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_16" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_20" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_24" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_28" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_32" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_36" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_40" => ["void",  ["ptr"]],
    "SMapLS_IP_EBP_8" => ["void",  ["ptr"]],
    "SUnMapLS" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_12" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_16" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_20" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_24" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_28" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_32" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_36" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_40" => ["void",  ["ptr"]],
    "SUnMapLS_IP_EBP_8" => ["void",  ["ptr"]],
    "ScrollConsoleScreenBufferA" => ["long",  ["long", "ptr", "ptr", "long", "ptr"]],
    "SearchPathA" => ["long",  ["str", "str", "str", "long", "str", "ptr"]],
    "SearchPathW" => ["long",  ["wstr", "wstr", "wstr", "long", "wstr", "ptr"]],
    "SetCalendarInfoA" => ["long",  ["long", "long", "long", "str"]],
    "SetCalendarInfoW" => ["long",  ["long", "long", "long", "wstr"]],
    "SetCommBreak" => ["long",  ["long"]],
    "SetCommConfig" => ["long",  ["long", "ptr", "long"]],
    "SetCommMask" => ["long",  ["long", "long"]],
    "SetCommState" => ["long",  ["long", "ptr"]],
    "SetCommTimeouts" => ["long",  ["long", "ptr"]],
    "SetComputerNameA" => ["long",  ["str"]],
    "SetComputerNameW" => ["long",  ["wstr"]],
    "SetConsoleActiveScreenBuffer" => ["long",  ["long"]],
    "SetConsoleCP" => ["long",  ["long"]],
    "SetConsoleCursorInfo" => ["long",  ["long", "ptr"]],
    "SetConsoleCursorPosition" => ["long",  ["long", "long"]],
    "SetConsoleInputExeNameA" => ["long",  ["str"]],
    "SetConsoleInputExeNameW" => ["long",  ["wstr"]],
    "SetConsoleMode" => ["long",  ["long", "long"]],
    "SetConsoleOutputCP" => ["long",  ["long"]],
    "SetConsoleScreenBufferSize" => ["long",  ["long", "long"]],
    "SetConsoleTextAttribute" => ["long",  ["long", "long"]],
    "SetConsoleTitleA" => ["long",  ["str"]],
    "SetConsoleTitleW" => ["long",  ["wstr"]],
    "SetConsoleWindowInfo" => ["long",  ["long", "long", "ptr"]],
    "SetCriticalSectionSpinCount" => ["long",  ["ptr", "long"]],
    "SetCurrentDirectoryA" => ["long",  ["str"]],
    "SetCurrentDirectoryW" => ["long",  ["wstr"]],
    "SetDefaultCommConfigA" => ["long",  ["str", "ptr", "long"]],
    "SetDefaultCommConfigW" => ["long",  ["wstr", "ptr", "long"]],
    "SetEndOfFile" => ["long",  ["long"]],
    "SetEnvironmentVariableA" => ["long",  ["str", "str"]],
    "SetEnvironmentVariableW" => ["long",  ["wstr", "wstr"]],
    "SetErrorMode" => ["long",  ["long"]],
    "SetEvent" => ["long",  ["long"]],
    "SetFileApisToANSI" => ["void",  []],
    "SetFileApisToOEM" => ["void",  []],
    "SetFileAttributesA" => ["long",  ["str", "long"]],
    "SetFileAttributesW" => ["long",  ["wstr", "long"]],
    "SetFilePointer" => ["long",  ["long", "long", "ptr", "long"]],
    "SetFileTime" => ["long",  ["long", "ptr", "ptr", "ptr"]],
    "SetHandleContext" => ["long",  ["long", "long"]],
    "SetHandleCount" => ["long",  ["long"]],
    "SetHandleInformation" => ["long",  ["long", "long", "long"]],
    "SetLastError" => ["void",  ["long"]],
    "SetLocalTime" => ["long",  ["ptr"]],
    "SetLocaleInfoA" => ["long",  ["long", "long", "str"]],
    "SetLocaleInfoW" => ["long",  ["long", "long", "wstr"]],
    "SetNamedPipeHandleState" => ["long",  ["long", "ptr", "ptr", "ptr"]],
    "SetPriorityClass" => ["long",  ["long", "long"]],
    "SetProcessAffinityMask" => ["long",  ["long", "long"]],
    "SetProcessPriorityBoost" => ["long",  ["long", "long"]],
    "SetProcessShutdownParameters" => ["long",  ["long", "long"]],
    "SetProcessWorkingSetSize" => ["long",  ["long", "long", "long"]],
    "SetStdHandle" => ["long",  ["long", "long"]],
    "SetSystemPowerState" => ["long",  ["long", "long"]],
    "SetSystemTime" => ["long",  ["ptr"]],
    "SetTapeParameters" => ["long",  ["long", "long", "ptr"]],
    "SetTapePosition" => ["long",  ["long", "long", "long", "long", "long", "long"]],
    "SetThreadAffinityMask" => ["long",  ["long", "long"]],
    "SetThreadContext" => ["long",  ["long", "ptr"]],
    "SetThreadExecutionState" => ["long",  ["long"]],
    "SetThreadIdealProcessor" => ["long",  ["long", "long"]],
    "SetThreadLocale" => ["long",  ["long"]],
    "SetThreadPriority" => ["long",  ["long", "long"]],
    "SetThreadPriorityBoost" => ["long",  ["long", "long"]],
    "SetTimeZoneInformation" => ["long",  ["ptr"]],
    "SetUnhandledExceptionFilter" => ["ptr",  ["ptr"]],
    "SetVolumeLabelA" => ["long",  ["str", "str"]],
    "SetVolumeLabelW" => ["long",  ["wstr", "wstr"]],
    "SetWaitableTimer" => ["long",  ["long", "ptr", "long", "ptr", "ptr", "long"]],
    "SetupComm" => ["long",  ["long", "long", "long"]],
    "SizeofResource" => ["long",  ["long", "long"]],
    "SizeofResource16" => ["long",  ["long", "long"]],
    "Sleep" => ["void",  ["long"]],
    "SleepEx" => ["long",  ["long", "long"]],
    "SuspendThread" => ["long",  ["long"]],
    "SwitchToThread" => ["long",  []],
    "SystemTimeToFileTime" => ["long",  ["ptr", "ptr"]],
    "SystemTimeToTzSpecificLocalTime" => ["long",  ["ptr", "ptr", "ptr"]],
    "TerminateProcess" => ["long",  ["long", "long"]],
    "TerminateThread" => ["long",  ["long", "long"]],
    "Thread32First" => ["long",  ["long", "ptr"]],
    "Thread32Next" => ["long",  ["long", "ptr"]],
    "ThunkConnect32" => ["long",  ["ptr", "str", "str", "str", "long", "long"]],
    "TlsAlloc" => ["long",  []],
    "TlsFree" => ["long",  ["long"]],
    "TlsGetValue" => ["ptr",  ["long"]],
    "TlsSetValue" => ["long",  ["long", "ptr"]],
    "TransactNamedPipe" => ["long",  ["long", "ptr", "long", "ptr", "long", "ptr", "ptr"]],
    "TransmitCommChar" => ["long",  ["long", "long"]],
    "UTRegister" => ["long",  ["long", "str", "str", "str", "ptr", "ptr", "ptr"]],
    "UTUnRegister" => ["void",  ["long"]],
    "UnMapLS" => ["void",  ["ptr"]],
    "UnMapSLFixArray" => ["void",  ["ptr", "long", "ptr"]],
    "UnhandledExceptionFilter" => ["long",  ["ptr"]],
    "UninitializeCriticalSection" => ["void",  ["ptr"]],
    "UnlockFile" => ["long",  ["long", "long", "long", "long", "long"]],
    "UnlockFileEx" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "UnmapViewOfFile" => ["long",  ["ptr"]],
    "UpdateResourceA" => ["long",  ["long", "str", "str", "long", "ptr", "long"]],
    "UpdateResourceW" => ["long",  ["long", "wstr", "wstr", "long", "ptr", "long"]],
    "VerLanguageNameA" => ["long",  ["long", "str", "long"]],
    "VerLanguageNameW" => ["long",  ["long", "wstr", "long"]],
    "VerifyVersionInfoA" => ["long",  ["ptr", "long", "long", "long"]],
    "VerifyVersionInfoW" => ["long",  ["ptr", "long", "long", "long"]],
    "VirtualAlloc" => ["ptr",  ["ptr", "long", "long", "long"]],
    "VirtualAllocEx" => ["ptr",  ["long", "ptr", "long", "long", "long"]],
    "VirtualFree" => ["long",  ["ptr", "long", "long"]],
    "VirtualLock" => ["long",  ["ptr", "long"]],
    "VirtualProtect" => ["long",  ["ptr", "long", "long", "ptr"]],
    "VirtualProtectEx" => ["long",  ["long", "ptr", "long", "long", "ptr"]],
    "VirtualQuery" => ["long",  ["ptr", "ptr", "long"]],
    "VirtualQueryEx" => ["long",  ["long", "ptr", "ptr", "long"]],
    "VirtualUnlock" => ["long",  ["ptr", "long"]],
    "WaitCommEvent" => ["long",  ["long", "ptr", "ptr"]],
    "WaitForDebugEvent" => ["long",  ["ptr", "long"]],
    "WaitForMultipleObjects" => ["long",  ["long", "ptr", "long", "long"]],
    "WaitForMultipleObjectsEx" => ["long",  ["long", "ptr", "long", "long", "long"]],
    "WaitForSingleObject" => ["long",  ["long", "long"]],
    "WaitForSingleObjectEx" => ["long",  ["long", "long", "long"]],
    "WaitNamedPipeA" => ["long",  ["str", "long"]],
    "WaitNamedPipeW" => ["long",  ["wstr", "long"]],
    "WideCharToMultiByte" => ["long",  ["long", "long", "wstr", "long", "str", "long", "str", "ptr"]],
    "WinExec" => ["long",  ["str", "long"]],
    "WinExec16" => ["long",  ["str", "long"]],
    "WriteConsoleA" => ["long",  ["long", "ptr", "long", "ptr", "ptr"]],
    "WriteConsoleInputA" => ["long",  ["long", "ptr", "long", "ptr"]],
    "WriteConsoleInputW" => ["long",  ["long", "ptr", "long", "ptr"]],
    "WriteConsoleOutputA" => ["long",  ["long", "ptr", "long", "long", "ptr"]],
    "WriteConsoleOutputAttribute" => ["long",  ["long", "ptr", "long", "long", "ptr"]],
    "WriteConsoleOutputCharacterA" => ["long",  ["long", "str", "long", "long", "ptr"]],
    "WriteConsoleOutputCharacterW" => ["long",  ["long", "wstr", "long", "long", "ptr"]],
    "WriteConsoleOutputW" => ["long",  ["long", "ptr", "long", "long", "ptr"]],
    "WriteConsoleW" => ["long",  ["long", "ptr", "long", "ptr", "ptr"]],
    "WriteFile" => ["long",  ["long", "ptr", "long", "ptr", "ptr"]],
    "WriteFileEx" => ["long",  ["long", "ptr", "long", "ptr", "ptr"]],
    "WritePrivateProfileSectionA" => ["long",  ["str", "str", "str"]],
    "WritePrivateProfileSectionW" => ["long",  ["wstr", "wstr", "wstr"]],
    "WritePrivateProfileStringA" => ["long",  ["str", "str", "str", "str"]],
    "WritePrivateProfileStringW" => ["long",  ["wstr", "wstr", "wstr", "wstr"]],
    "WritePrivateProfileStructA" => ["long",  ["str", "str", "ptr", "long", "str"]],
    "WritePrivateProfileStructW" => ["long",  ["wstr", "wstr", "ptr", "long", "wstr"]],
    "WriteProcessMemory" => ["long",  ["long", "ptr", "ptr", "long", "ptr"]],
    "WriteProfileSectionA" => ["long",  ["str", "str"]],
    "WriteProfileSectionW" => ["long",  ["wstr", "wstr"]],
    "WriteProfileStringA" => ["long",  ["str", "str", "str"]],
    "WriteProfileStringW" => ["long",  ["wstr", "wstr", "wstr"]],
    "WriteTapemark" => ["long",  ["long", "long", "long", "long"]],
    "__wine_call_from_16_regs" => ["long",  ["ptr", "ptr", "ptr", "ptr"]],
    "_hread" => ["long",  ["long", "ptr", "long"]],
    "_hwrite" => ["long",  ["long", "str", "long"]],
    "_lclose" => ["long",  ["long"]],
    "_lcreat" => ["long",  ["str", "long"]],
    "_llseek" => ["long",  ["long", "long", "long"]],
    "_lopen" => ["long",  ["str", "long"]],
    "_lread" => ["long",  ["long", "ptr", "long"]],
    "_lwrite" => ["long",  ["long", "str", "long"]],
    "lstrcat" => ["str",  ["str", "str"]],
    "lstrcatA" => ["str",  ["str", "str"]],
    "lstrcatW" => ["wstr",  ["wstr", "wstr"]],
    "lstrcmp" => ["long",  ["str", "str"]],
    "lstrcmpA" => ["long",  ["str", "str"]],
    "lstrcmpW" => ["long",  ["wstr", "wstr"]],
    "lstrcmpi" => ["long",  ["str", "str"]],
    "lstrcmpiA" => ["long",  ["str", "str"]],
    "lstrcmpiW" => ["long",  ["wstr", "wstr"]],
    "lstrcpy" => ["str",  ["str", "str"]],
    "lstrcpyA" => ["str",  ["str", "str"]],
    "lstrcpyW" => ["wstr",  ["wstr", "wstr"]],
    "lstrcpyn" => ["str",  ["str", "str", "long"]],
    "lstrcpynA" => ["str",  ["str", "str", "long"]],
    "lstrcpynW" => ["wstr",  ["wstr", "wstr", "long"]],
    "lstrlen" => ["long",  ["str"]],
    "lstrlenA" => ["long",  ["str"]],
    "lstrlenW" => ["long",  ["wstr"]],
    "wine_call_to_16_long" => ["long",  ["ptr", "long"]],
    "wine_call_to_16_regs_long" => ["void",  ["ptr", "long"]],
    "wine_call_to_16_regs_short" => ["void",  ["ptr", "long"]],
    "wine_call_to_16_word" => ["long",  ["ptr", "long"]],
    "wine_get_unix_file_name" => ["long",  ["str", "str", "long"]]
};

&wine::declare("kernel32",%$module_declarations);
push @EXPORT, map { "&" . $_; } sort(keys(%$module_declarations));
1;
