package user32;

use strict;

require Exporter;

use wine;
use vars qw(@ISA @EXPORT @EXPORT_OK);

@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();

my $module_declarations = {
    "ActivateKeyboardLayout" => ["long",  ["long", "long"]],
    "AdjustWindowRect" => ["long",  ["ptr", "long", "long"]],
    "AdjustWindowRectEx" => ["long",  ["ptr", "long", "long", "long"]],
    "AllowSetForegroundWindow" => ["long",  ["long"]],
    "AnimateWindow" => ["long",  ["long", "long", "long"]],
    "AnyPopup" => ["long",  []],
    "AppendMenuA" => ["long",  ["long", "long", "long", "str"]],
    "AppendMenuW" => ["long",  ["long", "long", "long", "wstr"]],
    "ArrangeIconicWindows" => ["long",  ["long"]],
    "AttachThreadInput" => ["long",  ["long", "long", "long"]],
    "BeginDeferWindowPos" => ["long",  ["long"]],
    "BeginPaint" => ["long",  ["long", "ptr"]],
    "BringWindowToTop" => ["long",  ["long"]],
    "BroadcastSystemMessage" => ["long",  ["long", "ptr", "long", "long", "long"]],
    "BroadcastSystemMessageA" => ["long",  ["long", "ptr", "long", "long", "long"]],
    "CalcChildScroll" => ["void",  ["long", "long"]],
    "CallMsgFilterA" => ["long",  ["ptr", "long"]],
    "CallMsgFilterW" => ["long",  ["ptr", "long"]],
    "CallNextHookEx" => ["long",  ["long", "long", "long", "long"]],
    "CallNextHookEx16" => ["long",  ["long", "long", "long", "long"]],
    "CallWindowProc16" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "CallWindowProcA" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "CallWindowProcW" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "CascadeWindows" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "ChangeClipboardChain" => ["long",  ["long", "long"]],
    "ChangeDisplaySettingsA" => ["long",  ["ptr", "long"]],
    "ChangeDisplaySettingsExA" => ["long",  ["str", "ptr", "long", "long", "long"]],
    "ChangeMenuA" => ["long",  ["long", "long", "str", "long", "long"]],
    "ChangeMenuW" => ["long",  ["long", "long", "wstr", "long", "long"]],
    "CharLowerA" => ["str",  ["str"]],
    "CharLowerBuffA" => ["long",  ["str", "long"]],
    "CharLowerBuffW" => ["long",  ["wstr", "long"]],
    "CharLowerW" => ["wstr",  ["wstr"]],
    "CharNextA" => ["str",  ["str"]],
    "CharNextExA" => ["str",  ["long", "str", "long"]],
    "CharNextExW" => ["wstr",  ["long", "wstr", "long"]],
    "CharNextW" => ["wstr",  ["wstr"]],
    "CharPrevA" => ["str",  ["str", "str"]],
    "CharPrevExA" => ["str",  ["long", "str", "str", "long"]],
    "CharPrevExW" => ["str",  ["long", "wstr", "wstr", "long"]],
    "CharPrevW" => ["wstr",  ["wstr", "wstr"]],
    "CharToOemA" => ["long",  ["str", "str"]],
    "CharToOemBuffA" => ["long",  ["str", "str", "long"]],
    "CharToOemBuffW" => ["long",  ["wstr", "str", "long"]],
    "CharToOemW" => ["long",  ["wstr", "str"]],
    "CharUpperA" => ["str",  ["str"]],
    "CharUpperBuffA" => ["long",  ["str", "long"]],
    "CharUpperBuffW" => ["long",  ["wstr", "long"]],
    "CharUpperW" => ["wstr",  ["wstr"]],
    "CheckDlgButton" => ["long",  ["long", "long", "long"]],
    "CheckMenuItem" => ["long",  ["long", "long", "long"]],
    "CheckMenuRadioItem" => ["long",  ["long", "long", "long", "long", "long"]],
    "CheckRadioButton" => ["long",  ["long", "long", "long", "long"]],
    "ChildWindowFromPoint" => ["long",  ["long", "long", "long"]],
    "ChildWindowFromPointEx" => ["long",  ["long", "long", "long", "long"]],
    "ClientToScreen" => ["long",  ["long", "ptr"]],
    "ClipCursor" => ["long",  ["ptr"]],
    "CloseClipboard" => ["long",  []],
    "CloseDesktop" => ["long",  ["long"]],
    "CloseDriver16" => ["long",  ["long", "long", "long"]],
    "CloseWindow" => ["long",  ["long"]],
    "CloseWindowStation" => ["long",  ["long"]],
    "CopyAcceleratorTableA" => ["long",  ["long", "ptr", "long"]],
    "CopyAcceleratorTableW" => ["long",  ["long", "ptr", "long"]],
    "CopyIcon" => ["long",  ["long"]],
    "CopyImage" => ["long",  ["long", "long", "long", "long", "long"]],
    "CopyRect" => ["long",  ["ptr", "ptr"]],
    "CountClipboardFormats" => ["long",  []],
    "CreateAcceleratorTableA" => ["long",  ["ptr", "long"]],
    "CreateAcceleratorTableW" => ["long",  ["ptr", "long"]],
    "CreateCaret" => ["long",  ["long", "long", "long", "long"]],
    "CreateCursor" => ["long",  ["long", "long", "long", "long", "long", "ptr", "ptr"]],
    "CreateDesktopA" => ["long",  ["str", "str", "ptr", "long", "long", "ptr"]],
    "CreateDesktopW" => ["long",  ["wstr", "wstr", "ptr", "long", "long", "ptr"]],
    "CreateDialogIndirectParam16" => ["long",  ["long", "ptr", "long", "ptr", "long"]],
    "CreateDialogIndirectParamA" => ["long",  ["long", "ptr", "long", "ptr", "long"]],
    "CreateDialogIndirectParamAorW" => ["long",  ["long", "ptr", "long", "ptr", "long"]],
    "CreateDialogIndirectParamW" => ["long",  ["long", "ptr", "long", "ptr", "long"]],
    "CreateDialogParamA" => ["long",  ["long", "str", "long", "ptr", "long"]],
    "CreateDialogParamW" => ["long",  ["long", "wstr", "long", "ptr", "long"]],
    "CreateIcon" => ["long",  ["long", "long", "long", "long", "long", "ptr", "ptr"]],
    "CreateIconFromResource" => ["long",  ["ptr", "long", "long", "long"]],
    "CreateIconFromResourceEx" => ["long",  ["ptr", "long", "long", "long", "long", "long", "long"]],
    "CreateIconIndirect" => ["long",  ["ptr"]],
    "CreateMDIWindowA" => ["long",  ["str", "str", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "CreateMDIWindowW" => ["long",  ["wstr", "wstr", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "CreateMenu" => ["long",  []],
    "CreatePopupMenu" => ["long",  []],
    "CreateWindowExA" => ["long",  ["long", "str", "str", "long", "long", "long", "long", "long", "long", "long", "long", "ptr"]],
    "CreateWindowExW" => ["long",  ["long", "wstr", "wstr", "long", "long", "long", "long", "long", "long", "long", "long", "ptr"]],
    "CreateWindowStationW" => ["long",  ["wstr", "long", "long", "ptr"]],
    "DdeAbandonTransaction" => ["long",  ["long", "long", "long"]],
    "DdeAccessData" => ["ptr",  ["long", "ptr"]],
    "DdeAddData" => ["long",  ["long", "ptr", "long", "long"]],
    "DdeClientTransaction" => ["long",  ["ptr", "long", "long", "long", "long", "long", "long", "ptr"]],
    "DdeCmpStringHandles" => ["long",  ["long", "long"]],
    "DdeConnect" => ["long",  ["long", "long", "long", "ptr"]],
    "DdeConnectList" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "DdeCreateDataHandle" => ["long",  ["long", "ptr", "long", "long", "long", "long", "long"]],
    "DdeCreateStringHandleA" => ["long",  ["long", "str", "long"]],
    "DdeCreateStringHandleW" => ["long",  ["long", "wstr", "long"]],
    "DdeDisconnect" => ["long",  ["long"]],
    "DdeDisconnectList" => ["long",  ["long"]],
    "DdeEnableCallback" => ["long",  ["long", "long", "long"]],
    "DdeFreeDataHandle" => ["long",  ["long"]],
    "DdeFreeStringHandle" => ["long",  ["long", "long"]],
    "DdeGetData" => ["long",  ["long", "ptr", "long", "long"]],
    "DdeGetLastError" => ["long",  ["long"]],
    "DdeImpersonateClient" => ["long",  ["long"]],
    "DdeInitializeA" => ["long",  ["ptr", "ptr", "long", "long"]],
    "DdeInitializeW" => ["long",  ["ptr", "ptr", "long", "long"]],
    "DdeKeepStringHandle" => ["long",  ["long", "long"]],
    "DdeNameService" => ["long",  ["long", "long", "long", "long"]],
    "DdePostAdvise" => ["long",  ["long", "long", "long"]],
    "DdeQueryConvInfo" => ["long",  ["long", "long", "ptr"]],
    "DdeQueryNextServer" => ["long",  ["long", "long"]],
    "DdeQueryStringA" => ["long",  ["long", "long", "str", "long", "long"]],
    "DdeQueryStringW" => ["long",  ["long", "long", "wstr", "long", "long"]],
    "DdeReconnect" => ["long",  ["long"]],
    "DdeSetQualityOfService" => ["long",  ["long", "ptr", "ptr"]],
    "DdeSetUserHandle" => ["long",  ["long", "long", "long"]],
    "DdeUnaccessData" => ["long",  ["long"]],
    "DdeUninitialize" => ["long",  ["long"]],
    "DefDlgProcA" => ["long",  ["long", "long", "long", "long"]],
    "DefDlgProcW" => ["long",  ["long", "long", "long", "long"]],
    "DefDriverProc16" => ["long",  ["long", "long", "long", "long", "long"]],
    "DefFrameProcA" => ["long",  ["long", "long", "long", "long", "long"]],
    "DefFrameProcW" => ["long",  ["long", "long", "long", "long", "long"]],
    "DefMDIChildProcA" => ["long",  ["long", "long", "long", "long"]],
    "DefMDIChildProcW" => ["long",  ["long", "long", "long", "long"]],
    "DefWindowProcA" => ["long",  ["long", "long", "long", "long"]],
    "DefWindowProcW" => ["long",  ["long", "long", "long", "long"]],
    "DeferWindowPos" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long"]],
    "DeleteMenu" => ["long",  ["long", "long", "long"]],
    "DeregisterShellHookWindow" => ["long",  ["long"]],
    "DestroyAcceleratorTable" => ["long",  ["long"]],
    "DestroyCaret" => ["long",  []],
    "DestroyCursor" => ["long",  ["long"]],
    "DestroyIcon" => ["long",  ["long"]],
    "DestroyIcon32" => ["long",  ["long", "long"]],
    "DestroyMenu" => ["long",  ["long"]],
    "DestroyWindow" => ["long",  ["long"]],
    "DialogBoxIndirectParam16" => ["long",  ["long", "long", "long", "ptr", "long"]],
    "DialogBoxIndirectParamA" => ["long",  ["long", "ptr", "long", "ptr", "long"]],
    "DialogBoxIndirectParamAorW" => ["long",  ["long", "ptr", "long", "ptr", "long", "long"]],
    "DialogBoxIndirectParamW" => ["long",  ["long", "ptr", "long", "ptr", "long"]],
    "DialogBoxParamA" => ["long",  ["long", "str", "long", "ptr", "long"]],
    "DialogBoxParamW" => ["long",  ["long", "wstr", "long", "ptr", "long"]],
    "DispatchMessageA" => ["long",  ["ptr"]],
    "DispatchMessageW" => ["long",  ["ptr"]],
    "DlgDirListA" => ["long",  ["long", "str", "long", "long", "long"]],
    "DlgDirListComboBoxA" => ["long",  ["long", "str", "long", "long", "long"]],
    "DlgDirListComboBoxW" => ["long",  ["long", "wstr", "long", "long", "long"]],
    "DlgDirListW" => ["long",  ["long", "wstr", "long", "long", "long"]],
    "DlgDirSelectComboBoxExA" => ["long",  ["long", "str", "long", "long"]],
    "DlgDirSelectComboBoxExW" => ["long",  ["long", "wstr", "long", "long"]],
    "DlgDirSelectExA" => ["long",  ["long", "str", "long", "long"]],
    "DlgDirSelectExW" => ["long",  ["long", "wstr", "long", "long"]],
    "DragDetect" => ["long",  ["long", "long", "long"]],
    "DrawAnimatedRects" => ["long",  ["long", "long", "ptr", "ptr"]],
    "DrawCaption" => ["long",  ["long", "long", "ptr", "long"]],
    "DrawCaptionTempA" => ["long",  ["long", "long", "ptr", "long", "long", "str", "long"]],
    "DrawCaptionTempW" => ["long",  ["long", "long", "ptr", "long", "long", "wstr", "long"]],
    "DrawEdge" => ["long",  ["long", "ptr", "long", "long"]],
    "DrawFocusRect" => ["long",  ["long", "ptr"]],
    "DrawFrameControl" => ["long",  ["long", "ptr", "long", "long"]],
    "DrawIcon" => ["long",  ["long", "long", "long", "long"]],
    "DrawIconEx" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "DrawMenuBar" => ["long",  ["long"]],
    "DrawMenuBarTemp" => ["long",  ["long", "long", "ptr", "long", "long"]],
    "DrawStateA" => ["long",  ["long", "long", "ptr", "long", "long", "long", "long", "long", "long", "long"]],
    "DrawStateW" => ["long",  ["long", "long", "ptr", "long", "long", "long", "long", "long", "long", "long"]],
    "DrawTextA" => ["long",  ["long", "str", "long", "ptr", "long"]],
    "DrawTextExA" => ["long",  ["long", "str", "long", "ptr", "long", "ptr"]],
    "DrawTextExW" => ["long",  ["long", "wstr", "long", "ptr", "long", "ptr"]],
    "DrawTextW" => ["long",  ["long", "wstr", "long", "ptr", "long"]],
    "EditWndProc" => ["long",  ["long", "long", "long", "long"]],
    "EditWndProcW" => ["long",  ["long", "long", "long", "long"]],
    "EmptyClipboard" => ["long",  []],
    "EnableMenuItem" => ["long",  ["long", "long", "long"]],
    "EnableScrollBar" => ["long",  ["long", "long", "long"]],
    "EnableWindow" => ["long",  ["long", "long"]],
    "EndDeferWindowPos" => ["long",  ["long"]],
    "EndDialog" => ["long",  ["long", "long"]],
    "EndMenu" => ["void",  []],
    "EndPaint" => ["long",  ["long", "ptr"]],
    "EnumChildWindows" => ["long",  ["long", "ptr", "long"]],
    "EnumClipboardFormats" => ["long",  ["long"]],
    "EnumDesktopWindows" => ["long",  ["long", "ptr", "long"]],
    "EnumDisplayDevicesA" => ["long",  ["ptr", "long", "ptr", "long"]],
    "EnumDisplayDevicesW" => ["long",  ["ptr", "long", "ptr", "long"]],
    "EnumDisplayMonitors" => ["long",  ["long", "ptr", "ptr", "long"]],
    "EnumDisplaySettingsA" => ["long",  ["str", "long", "ptr"]],
    "EnumDisplaySettingsExA" => ["long",  ["str", "long", "ptr", "long"]],
    "EnumDisplaySettingsExW" => ["long",  ["wstr", "long", "ptr", "long"]],
    "EnumDisplaySettingsW" => ["long",  ["wstr", "long", "ptr"]],
    "EnumPropsA" => ["long",  ["long", "ptr"]],
    "EnumPropsExA" => ["long",  ["long", "ptr", "long"]],
    "EnumPropsExW" => ["long",  ["long", "ptr", "long"]],
    "EnumPropsW" => ["long",  ["long", "ptr"]],
    "EnumThreadWindows" => ["long",  ["long", "ptr", "long"]],
    "EnumWindows" => ["long",  ["ptr", "long"]],
    "EqualRect" => ["long",  ["ptr", "ptr"]],
    "ExcludeUpdateRgn" => ["long",  ["long", "long"]],
    "ExitWindowsEx" => ["long",  ["long", "long"]],
    "FillRect" => ["long",  ["long", "ptr", "long"]],
    "FindWindowA" => ["long",  ["str", "str"]],
    "FindWindowExA" => ["long",  ["long", "long", "str", "str"]],
    "FindWindowExW" => ["long",  ["long", "long", "wstr", "wstr"]],
    "FindWindowW" => ["long",  ["wstr", "wstr"]],
    "FlashWindow" => ["long",  ["long", "long"]],
    "FrameRect" => ["long",  ["long", "ptr", "long"]],
    "FreeDDElParam" => ["long",  ["long", "long"]],
    "GetActiveWindow" => ["long",  []],
    "GetAncestor" => ["long",  ["long", "long"]],
    "GetAppCompatFlags" => ["long",  ["long"]],
    "GetAsyncKeyState" => ["long",  ["long"]],
    "GetCapture" => ["long",  []],
    "GetCaretBlinkTime" => ["long",  []],
    "GetCaretPos" => ["long",  ["ptr"]],
    "GetClassInfoA" => ["long",  ["long", "str", "ptr"]],
    "GetClassInfoExA" => ["long",  ["long", "str", "ptr"]],
    "GetClassInfoExW" => ["long",  ["long", "wstr", "ptr"]],
    "GetClassInfoW" => ["long",  ["long", "wstr", "ptr"]],
    "GetClassLongA" => ["long",  ["long", "long"]],
    "GetClassLongW" => ["long",  ["long", "long"]],
    "GetClassNameA" => ["long",  ["long", "str", "long"]],
    "GetClassNameW" => ["long",  ["long", "wstr", "long"]],
    "GetClassWord" => ["long",  ["long", "long"]],
    "GetClientRect" => ["long",  ["long", "ptr"]],
    "GetClipCursor" => ["long",  ["ptr"]],
    "GetClipboardData" => ["long",  ["long"]],
    "GetClipboardFormatNameA" => ["long",  ["long", "str", "long"]],
    "GetClipboardFormatNameW" => ["long",  ["long", "wstr", "long"]],
    "GetClipboardOwner" => ["long",  []],
    "GetClipboardSequenceNumber" => ["long",  []],
    "GetClipboardViewer" => ["long",  []],
    "GetCursor" => ["long",  []],
    "GetCursorPos" => ["long",  ["ptr"]],
    "GetDC" => ["long",  ["long"]],
    "GetDCEx" => ["long",  ["long", "long", "long"]],
    "GetDesktopWindow" => ["long",  []],
    "GetDialogBaseUnits" => ["long",  []],
    "GetDlgCtrlID" => ["long",  ["long"]],
    "GetDlgItem" => ["long",  ["long", "long"]],
    "GetDlgItemInt" => ["long",  ["long", "long", "ptr", "long"]],
    "GetDlgItemTextA" => ["long",  ["long", "long", "str", "long"]],
    "GetDlgItemTextW" => ["long",  ["long", "long", "wstr", "long"]],
    "GetDoubleClickTime" => ["long",  []],
    "GetDriverModuleHandle16" => ["long",  ["long"]],
    "GetFocus" => ["long",  []],
    "GetForegroundWindow" => ["long",  []],
    "GetIconInfo" => ["long",  ["long", "ptr"]],
    "GetInputState" => ["long",  []],
    "GetInternalWindowPos" => ["long",  ["long", "ptr", "ptr"]],
    "GetKBCodePage" => ["long",  []],
    "GetKeyNameTextA" => ["long",  ["long", "str", "long"]],
    "GetKeyNameTextW" => ["long",  ["long", "wstr", "long"]],
    "GetKeyState" => ["long",  ["long"]],
    "GetKeyboardLayout" => ["long",  ["long"]],
    "GetKeyboardLayoutList" => ["long",  ["long", "ptr"]],
    "GetKeyboardLayoutNameA" => ["long",  ["str"]],
    "GetKeyboardLayoutNameW" => ["long",  ["wstr"]],
    "GetKeyboardState" => ["long",  ["ptr"]],
    "GetKeyboardType" => ["long",  ["long"]],
    "GetLastActivePopup" => ["long",  ["long"]],
    "GetMenu" => ["long",  ["long"]],
    "GetMenuCheckMarkDimensions" => ["long",  []],
    "GetMenuContextHelpId" => ["long",  ["long"]],
    "GetMenuDefaultItem" => ["long",  ["long", "long", "long"]],
    "GetMenuInfo" => ["long",  ["long", "ptr"]],
    "GetMenuItemCount" => ["long",  ["long"]],
    "GetMenuItemID" => ["long",  ["long", "long"]],
    "GetMenuItemInfoA" => ["long",  ["long", "long", "long", "ptr"]],
    "GetMenuItemInfoW" => ["long",  ["long", "long", "long", "ptr"]],
    "GetMenuItemRect" => ["long",  ["long", "long", "long", "ptr"]],
    "GetMenuState" => ["long",  ["long", "long", "long"]],
    "GetMenuStringA" => ["long",  ["long", "long", "str", "long", "long"]],
    "GetMenuStringW" => ["long",  ["long", "long", "wstr", "long", "long"]],
    "GetMessageA" => ["long",  ["ptr", "long", "long", "long"]],
    "GetMessageExtraInfo" => ["long",  []],
    "GetMessagePos" => ["long",  []],
    "GetMessageTime" => ["long",  []],
    "GetMessageW" => ["long",  ["ptr", "long", "long", "long"]],
    "GetMonitorInfoA" => ["long",  ["long", "ptr"]],
    "GetMonitorInfoW" => ["long",  ["long", "ptr"]],
    "GetNextDlgGroupItem" => ["long",  ["long", "long", "long"]],
    "GetNextDlgTabItem" => ["long",  ["long", "long", "long"]],
    "GetOpenClipboardWindow" => ["long",  []],
    "GetParent" => ["long",  ["long"]],
    "GetPriorityClipboardFormat" => ["long",  ["ptr", "long"]],
    "GetProcessDefaultLayout" => ["long",  ["ptr"]],
    "GetProcessWindowStation" => ["long",  []],
    "GetProgmanWindow" => ["long",  []],
    "GetPropA" => ["long",  ["long", "str"]],
    "GetPropW" => ["long",  ["long", "wstr"]],
    "GetQueueStatus" => ["long",  ["long"]],
    "GetScrollInfo" => ["long",  ["long", "long", "ptr"]],
    "GetScrollPos" => ["long",  ["long", "long"]],
    "GetScrollRange" => ["long",  ["long", "long", "ptr", "ptr"]],
    "GetShellWindow" => ["long",  []],
    "GetSubMenu" => ["long",  ["long", "long"]],
    "GetSysColor" => ["long",  ["long"]],
    "GetSysColorBrush" => ["long",  ["long"]],
    "GetSystemMenu" => ["long",  ["long", "long"]],
    "GetSystemMetrics" => ["long",  ["long"]],
    "GetTabbedTextExtentA" => ["long",  ["long", "str", "long", "long", "ptr"]],
    "GetTabbedTextExtentW" => ["long",  ["long", "wstr", "long", "long", "ptr"]],
    "GetTaskmanWindow" => ["long",  []],
    "GetThreadDesktop" => ["long",  ["long"]],
    "GetTopWindow" => ["long",  ["long"]],
    "GetUpdateRect" => ["long",  ["long", "ptr", "long"]],
    "GetUpdateRgn" => ["long",  ["long", "long", "long"]],
    "GetUserObjectInformationA" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "GetUserObjectInformationW" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "GetUserObjectSecurity" => ["long",  ["long", "ptr", "ptr", "long", "ptr"]],
    "GetWindow" => ["long",  ["long", "long"]],
    "GetWindowContextHelpId" => ["long",  ["long"]],
    "GetWindowDC" => ["long",  ["long"]],
    "GetWindowInfo" => ["long",  ["long", "ptr"]],
    "GetWindowLongA" => ["long",  ["long", "long"]],
    "GetWindowLongW" => ["long",  ["long", "long"]],
    "GetWindowModuleFileNameA" => ["long",  ["long", "str", "long"]],
    "GetWindowModuleFileNameW" => ["long",  ["long", "str", "long"]],
    "GetWindowPlacement" => ["long",  ["long", "ptr"]],
    "GetWindowRect" => ["long",  ["long", "ptr"]],
    "GetWindowRgn" => ["long",  ["long", "long"]],
    "GetWindowTextA" => ["long",  ["long", "str", "long"]],
    "GetWindowTextLengthA" => ["long",  ["long"]],
    "GetWindowTextLengthW" => ["long",  ["long"]],
    "GetWindowTextW" => ["long",  ["long", "wstr", "long"]],
    "GetWindowThreadProcessId" => ["long",  ["long", "ptr"]],
    "GetWindowWord" => ["long",  ["long", "long"]],
    "GrayStringA" => ["long",  ["long", "long", "ptr", "long", "long", "long", "long", "long", "long"]],
    "GrayStringW" => ["long",  ["long", "long", "ptr", "long", "long", "long", "long", "long", "long"]],
    "HideCaret" => ["long",  ["long"]],
    "HiliteMenuItem" => ["long",  ["long", "long", "long", "long"]],
    "ImpersonateDdeClientWindow" => ["long",  ["long", "long"]],
    "InSendMessage" => ["long",  []],
    "InSendMessageEx" => ["long",  ["ptr"]],
    "InflateRect" => ["long",  ["ptr", "long", "long"]],
    "InsertMenuA" => ["long",  ["long", "long", "long", "long", "str"]],
    "InsertMenuItemA" => ["long",  ["long", "long", "long", "ptr"]],
    "InsertMenuItemW" => ["long",  ["long", "long", "long", "ptr"]],
    "InsertMenuW" => ["long",  ["long", "long", "long", "long", "wstr"]],
    "InternalGetWindowText" => ["long",  ["long", "wstr", "long"]],
    "IntersectRect" => ["long",  ["ptr", "ptr", "ptr"]],
    "InvalidateRect" => ["long",  ["long", "ptr", "long"]],
    "InvalidateRgn" => ["long",  ["long", "long", "long"]],
    "InvertRect" => ["long",  ["long", "ptr"]],
    "IsCharAlphaA" => ["long",  ["long"]],
    "IsCharAlphaNumericA" => ["long",  ["long"]],
    "IsCharAlphaNumericW" => ["long",  ["long"]],
    "IsCharAlphaW" => ["long",  ["long"]],
    "IsCharLowerA" => ["long",  ["long"]],
    "IsCharLowerW" => ["long",  ["long"]],
    "IsCharUpperA" => ["long",  ["long"]],
    "IsCharUpperW" => ["long",  ["long"]],
    "IsChild" => ["long",  ["long", "long"]],
    "IsClipboardFormatAvailable" => ["long",  ["long"]],
    "IsDialogMessage" => ["long",  ["long", "ptr"]],
    "IsDialogMessageA" => ["long",  ["long", "ptr"]],
    "IsDialogMessageW" => ["long",  ["long", "ptr"]],
    "IsDlgButtonChecked" => ["long",  ["long", "long"]],
    "IsIconic" => ["long",  ["long"]],
    "IsMenu" => ["long",  ["long"]],
    "IsRectEmpty" => ["long",  ["ptr"]],
    "IsWinEventHookInstalled" => ["long",  ["long"]],
    "IsWindow" => ["long",  ["long"]],
    "IsWindowEnabled" => ["long",  ["long"]],
    "IsWindowUnicode" => ["long",  ["long"]],
    "IsWindowVisible" => ["long",  ["long"]],
    "IsZoomed" => ["long",  ["long"]],
    "KillSystemTimer" => ["long",  ["long", "long"]],
    "KillTimer" => ["long",  ["long", "long"]],
    "LoadAcceleratorsA" => ["long",  ["long", "str"]],
    "LoadAcceleratorsW" => ["long",  ["long", "wstr"]],
    "LoadBitmapA" => ["long",  ["long", "str"]],
    "LoadBitmapW" => ["long",  ["long", "wstr"]],
    "LoadCursorA" => ["long",  ["long", "str"]],
    "LoadCursorFromFileA" => ["long",  ["str"]],
    "LoadCursorFromFileW" => ["long",  ["wstr"]],
    "LoadCursorW" => ["long",  ["long", "wstr"]],
    "LoadIconA" => ["long",  ["long", "str"]],
    "LoadIconW" => ["long",  ["long", "wstr"]],
    "LoadImageA" => ["long",  ["long", "str", "long", "long", "long", "long"]],
    "LoadImageW" => ["long",  ["long", "wstr", "long", "long", "long", "long"]],
    "LoadKeyboardLayoutA" => ["long",  ["str", "long"]],
    "LoadKeyboardLayoutW" => ["long",  ["wstr", "long"]],
    "LoadLocalFonts" => ["void",  []],
    "LoadMenuA" => ["long",  ["long", "str"]],
    "LoadMenuIndirectA" => ["long",  ["ptr"]],
    "LoadMenuIndirectW" => ["long",  ["ptr"]],
    "LoadMenuW" => ["long",  ["long", "wstr"]],
    "LoadStringA" => ["long",  ["long", "long", "str", "long"]],
    "LoadStringW" => ["long",  ["long", "long", "wstr", "long"]],
    "LockSetForegroundWindow" => ["long",  ["long"]],
    "LockWindowUpdate" => ["long",  ["long"]],
    "LookupIconIdFromDirectory" => ["long",  ["ptr", "long"]],
    "LookupIconIdFromDirectoryEx" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "MapDialogRect" => ["long",  ["long", "ptr"]],
    "MapVirtualKeyA" => ["long",  ["long", "long"]],
    "MapVirtualKeyExA" => ["long",  ["long", "long", "long"]],
    "MapVirtualKeyExW" => ["long",  ["long", "long", "long"]],
    "MapVirtualKeyW" => ["long",  ["long", "long"]],
    "MapWindowPoints" => ["long",  ["long", "long", "ptr", "long"]],
    "MenuItemFromPoint" => ["long",  ["long", "long", "long", "long"]],
    "MessageBeep" => ["long",  ["long"]],
    "MessageBoxA" => ["long",  ["long", "str", "str", "long"]],
    "MessageBoxExA" => ["long",  ["long", "str", "str", "long", "long"]],
    "MessageBoxExW" => ["long",  ["long", "wstr", "wstr", "long", "long"]],
    "MessageBoxIndirectA" => ["long",  ["ptr"]],
    "MessageBoxIndirectW" => ["long",  ["ptr"]],
    "MessageBoxW" => ["long",  ["long", "wstr", "wstr", "long"]],
    "ModifyMenuA" => ["long",  ["long", "long", "long", "long", "str"]],
    "ModifyMenuW" => ["long",  ["long", "long", "long", "long", "wstr"]],
    "MonitorFromPoint" => ["long",  ["long", "long", "long"]],
    "MonitorFromRect" => ["long",  ["ptr", "long"]],
    "MonitorFromWindow" => ["long",  ["long", "long"]],
    "MoveWindow" => ["long",  ["long", "long", "long", "long", "long", "long"]],
    "MsgWaitForMultipleObjects" => ["long",  ["long", "ptr", "long", "long", "long"]],
    "MsgWaitForMultipleObjectsEx" => ["long",  ["long", "ptr", "long", "long", "long"]],
    "NotifyWinEvent" => ["void",  ["long", "long", "long", "long"]],
    "OemKeyScan" => ["long",  ["long"]],
    "OemToCharA" => ["long",  ["str", "str"]],
    "OemToCharBuffA" => ["long",  ["str", "str", "long"]],
    "OemToCharBuffW" => ["long",  ["str", "wstr", "long"]],
    "OemToCharW" => ["long",  ["str", "wstr"]],
    "OffsetRect" => ["long",  ["ptr", "long", "long"]],
    "OpenClipboard" => ["long",  ["long"]],
    "OpenDesktopA" => ["long",  ["str", "long", "long", "long"]],
    "OpenDriver16" => ["long",  ["str", "str", "long"]],
    "OpenIcon" => ["long",  ["long"]],
    "PackDDElParam" => ["long",  ["long", "long", "long"]],
    "PaintDesktop" => ["long",  ["long"]],
    "PeekMessageA" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "PeekMessageW" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "PostAppMessage16" => ["long",  ["long", "long", "long", "long"]],
    "PostMessageA" => ["long",  ["long", "long", "long", "long"]],
    "PostMessageW" => ["long",  ["long", "long", "long", "long"]],
    "PostQuitMessage" => ["void",  ["long"]],
    "PostThreadMessageA" => ["long",  ["long", "long", "long", "long"]],
    "PostThreadMessageW" => ["long",  ["long", "long", "long", "long"]],
    "PrivateExtractIconExA" => ["long",  ["str", "long", "ptr", "ptr", "long"]],
    "PrivateExtractIconExW" => ["long",  ["wstr", "long", "ptr", "ptr", "long"]],
    "PrivateExtractIconsA" => ["long",  ["str", "long", "long", "long", "ptr", "long", "long", "long"]],
    "PrivateExtractIconsW" => ["long",  ["wstr", "long", "long", "long", "ptr", "long", "long", "long"]],
    "PtInRect" => ["long",  ["ptr", "long", "long"]],
    "RedrawWindow" => ["long",  ["long", "ptr", "long", "long"]],
    "RegisterClassA" => ["long",  ["ptr"]],
    "RegisterClassExA" => ["long",  ["ptr"]],
    "RegisterClassExW" => ["long",  ["ptr"]],
    "RegisterClassW" => ["long",  ["ptr"]],
    "RegisterClipboardFormatA" => ["long",  ["str"]],
    "RegisterClipboardFormatW" => ["long",  ["wstr"]],
    "RegisterDeviceNotificationA" => ["long",  ["long", "ptr", "long"]],
    "RegisterHotKey" => ["long",  ["long", "long", "long", "long"]],
    "RegisterLogonProcess" => ["long",  ["long", "long"]],
    "RegisterShellHookWindow" => ["long",  ["long"]],
    "RegisterSystemThread" => ["void",  ["long", "long"]],
    "RegisterTasklist" => ["long",  ["long"]],
    "RegisterWindowMessageA" => ["long",  ["str"]],
    "RegisterWindowMessageW" => ["long",  ["wstr"]],
    "ReleaseCapture" => ["long",  []],
    "ReleaseDC" => ["long",  ["long", "long"]],
    "RemoveMenu" => ["long",  ["long", "long", "long"]],
    "RemovePropA" => ["long",  ["long", "str"]],
    "RemovePropW" => ["long",  ["long", "wstr"]],
    "ReplyMessage" => ["long",  ["long"]],
    "ReuseDDElParam" => ["long",  ["long", "long", "long", "long", "long"]],
    "ScreenToClient" => ["long",  ["long", "ptr"]],
    "ScrollChildren" => ["void",  ["long", "long", "long", "long"]],
    "ScrollDC" => ["long",  ["long", "long", "long", "ptr", "ptr", "long", "ptr"]],
    "ScrollWindow" => ["long",  ["long", "long", "long", "ptr", "ptr"]],
    "ScrollWindowEx" => ["long",  ["long", "long", "long", "ptr", "ptr", "long", "ptr", "long"]],
    "SendDlgItemMessageA" => ["long",  ["long", "long", "long", "long", "long"]],
    "SendDlgItemMessageW" => ["long",  ["long", "long", "long", "long", "long"]],
    "SendDriverMessage16" => ["long",  ["long", "long", "long", "long"]],
    "SendInput" => ["long",  ["long", "ptr", "long"]],
    "SendMessageA" => ["long",  ["long", "long", "long", "long"]],
    "SendMessageCallbackA" => ["long",  ["long", "long", "long", "long", "ptr", "long"]],
    "SendMessageCallbackW" => ["long",  ["long", "long", "long", "long", "ptr", "long"]],
    "SendMessageTimeoutA" => ["long",  ["long", "long", "long", "long", "long", "long", "ptr"]],
    "SendMessageTimeoutW" => ["long",  ["long", "long", "long", "long", "long", "long", "ptr"]],
    "SendMessageW" => ["long",  ["long", "long", "long", "long"]],
    "SendNotifyMessageA" => ["long",  ["long", "long", "long", "long"]],
    "SendNotifyMessageW" => ["long",  ["long", "long", "long", "long"]],
    "SetActiveWindow" => ["long",  ["long"]],
    "SetCapture" => ["long",  ["long"]],
    "SetCaretBlinkTime" => ["long",  ["long"]],
    "SetCaretPos" => ["long",  ["long", "long"]],
    "SetClassLongA" => ["long",  ["long", "long", "long"]],
    "SetClassLongW" => ["long",  ["long", "long", "long"]],
    "SetClassWord" => ["long",  ["long", "long", "long"]],
    "SetClipboardData" => ["long",  ["long", "long"]],
    "SetClipboardViewer" => ["long",  ["long"]],
    "SetCursor" => ["long",  ["long"]],
    "SetCursorPos" => ["long",  ["long", "long"]],
    "SetDebugErrorLevel" => ["void",  ["long"]],
    "SetDeskWallPaper" => ["long",  ["str"]],
    "SetDlgItemInt" => ["long",  ["long", "long", "long", "long"]],
    "SetDlgItemTextA" => ["long",  ["long", "long", "str"]],
    "SetDlgItemTextW" => ["long",  ["long", "long", "wstr"]],
    "SetDoubleClickTime" => ["long",  ["long"]],
    "SetFocus" => ["long",  ["long"]],
    "SetForegroundWindow" => ["long",  ["long"]],
    "SetInternalWindowPos" => ["void",  ["long", "long", "ptr", "ptr"]],
    "SetKeyboardState" => ["long",  ["ptr"]],
    "SetLastErrorEx" => ["void",  ["long", "long"]],
    "SetLogonNotifyWindow" => ["long",  ["long", "long"]],
    "SetMenu" => ["long",  ["long", "long"]],
    "SetMenuContextHelpId" => ["long",  ["long", "long"]],
    "SetMenuDefaultItem" => ["long",  ["long", "long", "long"]],
    "SetMenuInfo" => ["long",  ["long", "ptr"]],
    "SetMenuItemBitmaps" => ["long",  ["long", "long", "long", "long", "long"]],
    "SetMenuItemInfoA" => ["long",  ["long", "long", "long", "ptr"]],
    "SetMenuItemInfoW" => ["long",  ["long", "long", "long", "ptr"]],
    "SetMessageQueue" => ["long",  ["long"]],
    "SetParent" => ["long",  ["long", "long"]],
    "SetProcessDefaultLayout" => ["long",  ["long"]],
    "SetProcessWindowStation" => ["long",  ["long"]],
    "SetProgmanWindow" => ["long",  ["long"]],
    "SetPropA" => ["long",  ["long", "str", "long"]],
    "SetPropW" => ["long",  ["long", "wstr", "long"]],
    "SetRect" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "SetRectEmpty" => ["long",  ["ptr"]],
    "SetScrollPos" => ["long",  ["long", "long", "long", "long"]],
    "SetScrollRange" => ["long",  ["long", "long", "long", "long", "long"]],
    "SetShellWindow" => ["long",  ["long"]],
    "SetShellWindowEx" => ["long",  ["long", "long"]],
    "SetSysColors" => ["long",  ["long", "ptr", "ptr"]],
    "SetSysColorsTemp" => ["long",  ["ptr", "ptr", "long"]],
    "SetSystemCursor" => ["long",  ["long", "long"]],
    "SetSystemMenu" => ["long",  ["long", "long"]],
    "SetSystemTimer" => ["long",  ["long", "long", "long", "ptr"]],
    "SetTaskmanWindow" => ["long",  ["long"]],
    "SetThreadDesktop" => ["long",  ["long"]],
    "SetTimer" => ["long",  ["long", "long", "long", "ptr"]],
    "SetUserObjectInformationA" => ["long",  ["long", "long", "ptr", "long"]],
    "SetUserObjectSecurity" => ["long",  ["long", "ptr", "ptr"]],
    "SetWinEventHook" => ["long",  ["long", "long", "long", "ptr", "long", "long", "long"]],
    "SetWindowContextHelpId" => ["long",  ["long", "long"]],
    "SetWindowLongA" => ["long",  ["long", "long", "long"]],
    "SetWindowLongW" => ["long",  ["long", "long", "long"]],
    "SetWindowPlacement" => ["long",  ["long", "ptr"]],
    "SetWindowPos" => ["long",  ["long", "long", "long", "long", "long", "long", "long"]],
    "SetWindowRgn" => ["long",  ["long", "long", "long"]],
    "SetWindowStationUser" => ["long",  ["long", "long"]],
    "SetWindowText" => ["long",  ["long", "str"]],
    "SetWindowTextA" => ["long",  ["long", "str"]],
    "SetWindowTextW" => ["long",  ["long", "wstr"]],
    "SetWindowWord" => ["long",  ["long", "long", "long"]],
    "SetWindowsHookA" => ["long",  ["long", "ptr"]],
    "SetWindowsHookEx16" => ["long",  ["long", "ptr", "long", "long"]],
    "SetWindowsHookExA" => ["long",  ["long", "ptr", "long", "long"]],
    "SetWindowsHookExW" => ["long",  ["long", "ptr", "long", "long"]],
    "SetWindowsHookW" => ["long",  ["long", "ptr"]],
    "ShowCaret" => ["long",  ["long"]],
    "ShowCursor" => ["long",  ["long"]],
    "ShowOwnedPopups" => ["long",  ["long", "long"]],
    "ShowScrollBar" => ["long",  ["long", "long", "long"]],
    "ShowWindow" => ["long",  ["long", "long"]],
    "ShowWindowAsync" => ["long",  ["long", "long"]],
    "SubtractRect" => ["long",  ["ptr", "ptr", "ptr"]],
    "SwapMouseButton" => ["long",  ["long"]],
    "SwitchToThisWindow" => ["void",  ["long", "long"]],
    "SystemParametersInfoA" => ["long",  ["long", "long", "ptr", "long"]],
    "SystemParametersInfoW" => ["long",  ["long", "long", "ptr", "long"]],
    "TabbedTextOutA" => ["long",  ["long", "long", "long", "str", "long", "long", "ptr", "long"]],
    "TabbedTextOutW" => ["long",  ["long", "long", "long", "wstr", "long", "long", "ptr", "long"]],
    "TileWindows" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "ToAscii" => ["long",  ["long", "long", "ptr", "ptr", "long"]],
    "ToAsciiEx" => ["long",  ["long", "long", "ptr", "ptr", "long", "long"]],
    "ToUnicode" => ["long",  ["long", "long", "ptr", "wstr", "long", "long"]],
    "ToUnicodeEx" => ["long",  ["long", "long", "ptr", "wstr", "long", "long", "long"]],
    "TrackPopupMenu" => ["long",  ["long", "long", "long", "long", "long", "long", "ptr"]],
    "TrackPopupMenuEx" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "TranslateAccelerator" => ["long",  ["long", "long", "ptr"]],
    "TranslateAcceleratorA" => ["long",  ["long", "long", "ptr"]],
    "TranslateAcceleratorW" => ["long",  ["long", "long", "ptr"]],
    "TranslateCharsetInfo" => ["long",  ["ptr", "ptr", "long"]],
    "TranslateMDISysAccel" => ["long",  ["long", "ptr"]],
    "TranslateMessage" => ["long",  ["ptr"]],
    "UnhookWinEvent" => ["long",  ["long"]],
    "UnhookWindowsHook" => ["long",  ["long", "ptr"]],
    "UnhookWindowsHookEx" => ["long",  ["long"]],
    "UnionRect" => ["long",  ["ptr", "ptr", "ptr"]],
    "UnpackDDElParam" => ["long",  ["long", "long", "ptr", "ptr"]],
    "UnregisterClassA" => ["long",  ["str", "long"]],
    "UnregisterClassW" => ["long",  ["wstr", "long"]],
    "UnregisterHotKey" => ["long",  ["long", "long"]],
    "UpdateWindow" => ["void",  ["long"]],
    "UserClientDllInitialize" => ["long",  ["long", "long", "ptr"]],
    "UserRealizePalette" => ["long",  ["long"]],
    "UserSignalProc" => ["long",  ["long", "long", "long", "long"]],
    "UserYield16" => ["void",  []],
    "ValidateRect" => ["void",  ["long", "ptr"]],
    "ValidateRgn" => ["void",  ["long", "long"]],
    "VkKeyScanA" => ["long",  ["long"]],
    "VkKeyScanExA" => ["long",  ["long", "long"]],
    "VkKeyScanExW" => ["long",  ["long", "long"]],
    "VkKeyScanW" => ["long",  ["long"]],
    "WaitForInputIdle" => ["long",  ["long", "long"]],
    "WaitMessage" => ["long",  []],
    "WinHelpA" => ["long",  ["long", "str", "long", "long"]],
    "WinHelpW" => ["long",  ["long", "wstr", "long", "long"]],
    "WindowFromDC" => ["long",  ["long"]],
    "WindowFromPoint" => ["long",  ["long", "long"]],
    "keybd_event" => ["void",  ["long", "long", "long", "long"]],
    "mouse_event" => ["void",  ["long", "long", "long", "long", "long"]],
    "wvsprintfA" => ["long",  ["str", "str", "ptr"]],
    "wvsprintfW" => ["long",  ["wstr", "wstr", "ptr"]]
};

&wine::declare("user32",%$module_declarations);
push @EXPORT, map { "&" . $_; } sort(keys(%$module_declarations));
1;
