.\" t
.\" @(#)Audio.1	12/10/98
.TH Audio 1.6 "Dec 10 1998"
.UC
.SH NAME
\fBAudio\fP \- the AfterStep Sounds module

.SH SYNOPSIS
\fBAudio\fP is spawned by afterstep, so no command line invocation will
work.
.sp
From within the \fIautoexec\fP file or as a menu option, \fBAudio\fP is
spawned as follows:
.nf
.sp
	Module	"I"	Audio 
.sp
.nf
or from within an afterstep menu file by 'Audio':
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Audio"
	Module "Audio" Audio
	MiniPixmap "mini-as.xpm"
.fi

.SH DESCRIPTION
The \fBAudio\fP module communicates with the AfterStep window manager to
bind audio sounds to window manager actions. Different audio queues may be
assigned to any window manager action. \fBAudio\fP can be used with
any independent audio player, and therefore requires no special audio
library APIs of its own. Simple in its design, it merely binds the audio
filenames to particular actions and forks off the audio player program
with the appropriate filename when that action occurs. 

\fBAudio\fP can also have builtin support for the rplay library.

.SH INITIALIZATION
During initialization, \fBAudio\fP will search for a configuration file
which describes the audio player and sound files associated with actions,
to use. The configuration file is /usr/local/share/afterstep/audio; but can
be overriden by ~/GNUstep/Library/AfterStep/audio .

.SH INVOCATION
\fBAudio\fP can be invoked from the \fIautoexec\fP file or from a menu
item as shown in the Synopsis section above.

AfterStep will search through the directories specified in the
\fIModulePath\fP configuration in the \fIbase.#bpp\fP (where # is your
colordepth) to attempt to locate \fBAudio\fP.

.SH CONFIGURATION OPTIONS
\fBAudio\fP reads the \fIaudio\fP file when it starts up and looks for
its configuration options.

.IP "*AudioPath \fIpath\fP"
Specifies the \fIpath\fP to look for the audio files.  This option
is ignored when rplay is used.

.IP "*AudioPlayCmd \fIplayer\fP"
This determines the independent audio player program that will actually
play the sounds.  If the \fIplayer\fP is set to \fIbuiltin-rplay\fP
then the builtin rplay support will be used.

.IP "*AudioDelay \fIseconds\fP"
Specifies that sound events will only be played if they occur
at least so many \fIseconds\fP after the previous event.  Sound events that
occur during the delay period are ignored.  This option is useful if 
you don't want several sounds playing at the same time.  The default
delay is 0 which disables the audio delay.

.IP "*AudioRplayHost \fIhostname\fP"
Specifies what host the sounds will play on.  The \fIhostname\fP can also
be an environment variable such as $HOSTDISPLAY. This option is only valid
with builtin rplay support.

.IP "*AudioRplayPriority \fIpriority\fP"
Specifies what \fIpriority\fP will be assigned to the sounds when they
are played.  This option is only valid with builtin rplay support.

.IP "*AudioRplayVolume \fIlevel\fP"
Specifies what volume \fIlevel\fP will be assigned to the sounds when they
are played.  This option is only valid with builtin rplay support.

.IP "*Audio \fIaction filename\fP"
Binds the particular window manager \fIaction\fP that the sound
\fIfilename\fP is played for.

.RE
.PP
.RS
The following \fBaction\fPs are available for sounds:
.IP ""
.nf
startup 
shutdown
unknown
add_window
raise_window
lower_window
focus_change
destroy_window
iconify
deiconify
toggle_paging
new_page
new_desk
configure_window
window_name
icon_name
res_class
res_name
end_windowlist
.fi

.SH AUTHORS
Frank Fejes <frank@ssax.com>
.nf
Dan Weeks <dan@mango.sfasu.edu>
.nf
Szijarto Szabolcs <saby@sch.bme.hu>
.nf
Mark Boyns <boyns@sdsu.edu>
.nf
Mark Scott <mscott@mcd.mot.com>
.nf
Robert Nation
.nf
David Mihm <davemann@ionet.net> [man page]

.SH SEE ALSO
.BR afterstep (1),
.BR rplay (1),
.BR showaudio (1)
