#include "alarm_applet.h"

AlarmApplet* alarm_applet = NULL;
GtkWidget* applet = NULL;



static GtkTargetEntry drop_types[] = 
{
   {"text/plain", 0, 1},
   {"audio/x-wav", 0, 1}
};


/* Have to pre declare this one */
static void save_session_info(void);


static void quit_applet(GtkWidget* w, gpointer cbdata)
{
   if(alarm_applet->timeout_tag > 0)
	 gtk_timeout_remove(alarm_applet->timeout_tag);
   save_session_info();
   g_string_free(alarm_applet->sound_file, TRUE);
   g_string_free(alarm_applet->anim_file, TRUE);
   destroy_sound();
   destroy_popup();
   destroy_dialog();
   destroy_alarms();
   gdk_pixmap_unref(alarm_applet->alarm_pm);
   gdk_pixmap_unref(alarm_applet->alarm_pm2);
   gdk_bitmap_unref(alarm_applet->mask);
   applet_widget_gtk_main_quit();
}


static void change_orient(GtkWidget* w, PanelOrientType o, gpointer cbdata)
{
   ddebug("Called change_orient\n");
   if(alarm_applet->orient == o)
	 return;
   
   
   ddebug("Relaying out applet\n");
   switch(o)
   {
	  case ORIENT_UP:
	  case ORIENT_DOWN:
	  {
		 GtkWidget* new_box;
		 if(alarm_applet->box)
		   gtk_widget_hide(alarm_applet->box);
		 
		 new_box = gtk_hbox_new(FALSE, FALSE);
		 gtk_widget_show(new_box);
		 gtk_widget_reparent(alarm_applet->img_frame, new_box);
		 gtk_widget_reparent(alarm_applet->button_frame, new_box);
		 gtk_container_remove(GTK_CONTAINER(alarm_applet->box), 
							  alarm_applet->hbox);
		 //gtk_widget_ref(alarm_applet->hbox);
		 //gtk_widget_destroy(alarm_applet->hbox);
		 //gtk_widget_unref(alarm_applet->hbox);
		 alarm_applet->hbox = NULL;
		 gtk_container_add(GTK_CONTAINER(alarm_applet->box), new_box);
		 alarm_applet->hbox = new_box;
		 gtk_widget_show(alarm_applet->box);
	  }
	  break;
	  case ORIENT_LEFT:
	  case ORIENT_RIGHT:
	  {
		 GtkWidget* new_box;
		 
		 if(alarm_applet->box)
		   gtk_widget_hide(alarm_applet->box);
		 
		 new_box = gtk_vbox_new(FALSE, FALSE);
		 gtk_widget_show(new_box);
		 gtk_widget_reparent(alarm_applet->img_frame, new_box);
		 gtk_widget_reparent(alarm_applet->button_frame, new_box);
		 gtk_container_remove(GTK_CONTAINER(alarm_applet->box), 
							  alarm_applet->hbox);
		 //gtk_widget_ref(alarm_applet->hbox);
		 //gtk_widget_destroy(alarm_applet->hbox);
		 //gtk_widget_unref(alarm_applet->hbox);
		 alarm_applet->hbox = NULL;
		 gtk_container_add(GTK_CONTAINER(alarm_applet->box), new_box);
		 alarm_applet->hbox = new_box;
		 gtk_widget_show(alarm_applet->box);
	  }
	  break;
   }
}



static void redraw_window(void)
{
   static GdkGC* gc;
   static gboolean state_sem = TRUE;
   
   if(!gc)
	 gc = alarm_applet->drawing_area->style->fg_gc[GTK_STATE_NORMAL];
  
   gdk_gc_set_clip_mask(gc, alarm_applet->mask);
   gdk_gc_set_clip_origin(gc, 2, 0);
  
   
   if(alarm_applet->alarm_state == ALARM_STATE_VISUAL_RING)
   {
	  if(state_sem)
	  {
		 gdk_draw_pixmap(alarm_applet->drawing_area->window,
						 gc, alarm_applet->alarm_pm2,
						 0, 0, 2, 0, 41, 41);
		 ddebug("Drawing pixmap 2\n");
		 state_sem = !state_sem;
	  }
	  else
	  {
		 gdk_draw_pixmap(alarm_applet->drawing_area->window,
						 gc, alarm_applet->alarm_pm,
						 0, 0, 2, 0, 41, 41);
		 state_sem = !state_sem;
		 ddebug("Drawing pixmap 1\n");
	  }
   }
   else
   {
	  gdk_draw_pixmap(alarm_applet->drawing_area->window,
					  gc, alarm_applet->alarm_pm,
					  0, 0, 2, 0, 41, 41);
   }
   /* Do we need this or not ?? */
   gdk_flush();
}
						

gint redraw_timeout(gpointer data)
{
   ddebug("Called redraw_timeout\n");
   redraw_window();
   return TRUE;
}


static gint button_press_cb(GtkWidget* w, GdkEventButton* event, gpointer data)
{
   if(event->type == GDK_2BUTTON_PRESS)
   {
	  if((alarm_applet->alarm_state == ALARM_STATE_VISUAL_RING) 
		 && (alarm_applet->redraw_tag != -1))
	  {
		 alarm_applet->alarm_state = ALARM_STATE_NORMAL;
		 gtk_timeout_remove(alarm_applet->redraw_tag);
		 alarm_applet->redraw_tag = -1;
		 redraw_window();
	  }
	  else if((alarm_applet->alarm_state == ALARM_STATE_SOUND_RING))
	  {
		 alarm_applet->alarm_state = ALARM_STATE_NORMAL;
		 stop_sound_alarm();
	  }
   }
   return FALSE;
}


static void read_config_data(gchar* cfgpath)
{
   gchar* tmp;
   if(cfgpath == NULL)
	 return;
   gnome_config_push_prefix(cfgpath);
   alarm_applet->timeout_delay = gnome_config_get_int("timeout/sec=10");
   alarm_applet->redraw_delay = gnome_config_get_int("redraw/sec=1");
   tmp = gnome_config_get_string("sound/file=/usr/share/sounds/alarm_ring.wav");
   ddebug("Sound filename = %s\n", tmp);
   alarm_applet->sound_file = g_string_new(tmp);
   tmp = gnome_config_get_string("anim/file=anim.xpm");
   ddebug("Anim filename = %s\n", tmp);
   alarm_applet->anim_file = g_string_new(tmp);
   alarm_applet->vol_level = gnome_config_get_int("sound/level=0");
   alarm_applet->draw_image = gnome_config_get_bool("draw_image/value=true");
   ddebug("Alarm sound file = %s\n", alarm_applet->sound_file->str);
   ddebug("Alarm anim file = %s\n", alarm_applet->anim_file->str);
   ddebug("Alarm vol level = %d\n", alarm_applet->vol_level);
   ddebug("Alarm timeout delay = %d\n", alarm_applet->timeout_delay);
   ddebug("Alarm redraw delay = %d\n", alarm_applet->redraw_delay);
   ddebug("Alarm draw_image = %s\n", alarm_applet->draw_image ? "true" : "false");
   
   gnome_config_pop_prefix();
}


static void save_session_info(void)
{
   ddebug("save_session_info\n");
   save_persistant_alarms(APPLET_WIDGET(applet)->privcfgpath);
   gnome_config_push_prefix(APPLET_WIDGET(applet)->privcfgpath);
   gnome_config_set_int("timeout/sec", alarm_applet->timeout_delay);
   gnome_config_set_int("redraw/sec", alarm_applet->redraw_delay);
   gnome_config_set_string("sound/file", alarm_applet->sound_file->str);
   gnome_config_set_string("anim/file", alarm_applet->anim_file->str);
   gnome_config_set_int("sound/level", alarm_applet->vol_level);
   ddebug("Draw_image is %s\n", alarm_applet->draw_image ? "true" : "false");
   gnome_config_set_bool("draw_image/value", alarm_applet->draw_image);
   gnome_config_pop_prefix();
   gnome_config_sync();
   gnome_config_drop_all();
}




static gint applet_save_session(GtkWidget* w, const gchar* priv,
						 const gchar* global)
{
   save_session_info();
   return FALSE;
}



static void list_button_clicked(GtkWidget* w, gpointer cbdata)
{
   show_popup_dialog();
}



static gint expose_cb(GtkWidget* w, GdkEventExpose* event, gpointer data)
{
   if(!GTK_WIDGET_VISIBLE(alarm_applet->img_frame))
	 return FALSE;
   redraw_window();
   return FALSE;
}
   
   
	  


static void init_applet(void)
{
   GdkBitmap* mask;

   
   
   alarm_applet = g_new(AlarmApplet, 1);
   alarm_applet->drawing_area = gtk_drawing_area_new();
   gtk_widget_set_usize(alarm_applet->drawing_area, 45, 42);
   gtk_signal_connect(GTK_OBJECT(alarm_applet->drawing_area),
					  "expose_event",
					  GTK_SIGNAL_FUNC(expose_cb), NULL);
   gtk_widget_set_events(alarm_applet->drawing_area, 
						 GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK |
						 GDK_BUTTON_RELEASE_MASK);
   gtk_signal_connect(GTK_OBJECT(alarm_applet->drawing_area),
					  "button_press_event",
					  GTK_SIGNAL_FUNC(button_press_cb), NULL);

   gtk_signal_connect(GTK_OBJECT(alarm_applet->drawing_area),
					  "drag_data_received", 
					  GTK_SIGNAL_FUNC(drag_data_received), NULL);
   gtk_drag_dest_set(alarm_applet->drawing_area, GTK_DEST_DEFAULT_ALL,
					 drop_types, 2, GDK_ACTION_COPY);
   alarm_applet->box = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(alarm_applet->box), GTK_SHADOW_IN);
   gtk_signal_connect(GTK_OBJECT(alarm_applet->box), "drag_data_received",
					  GTK_SIGNAL_FUNC(drag_data_received), NULL);

   alarm_applet->hbox = gtk_hbox_new(FALSE, FALSE);
   /* Store the orientation */
   alarm_applet->orient = applet_widget_get_panel_orient(APPLET_WIDGET(applet));
   
   gtk_container_add(GTK_CONTAINER(alarm_applet->box), alarm_applet->hbox);
   
   ddebug("Got here\n");
   alarm_applet->img_frame = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(alarm_applet->img_frame), 
							 GTK_SHADOW_ETCHED_OUT);
   gtk_container_set_border_width(GTK_CONTAINER(alarm_applet->img_frame), 0);
   gtk_container_add(GTK_CONTAINER(alarm_applet->img_frame), 
					 alarm_applet->drawing_area);

   alarm_applet->timeout_tag = -1;
   alarm_applet->redraw_tag = -1;
   alarm_applet->vol_level = -1;
   alarm_applet->applet = applet;
#ifdef WITH_SOUND
   alarm_applet->with_sound = TRUE;
#else
   alarm_applet->with_sound = FALSE;
#endif
   
   /* Read the config for timeout secs etc */
   read_config_data(APPLET_WIDGET(applet)->privcfgpath);
   
   gdk_window_clear(applet->window);
   
   alarm_applet->alarm_pm = gdk_pixmap_create_from_xpm_d(applet->window,
														 &mask, NULL,
														 alarm_xpm);
   alarm_applet->alarm_pm2 = gdk_pixmap_create_from_xpm_d(applet->window,
														  &mask, NULL,
														  alarm2_xpm);
   
   alarm_applet->mask = mask;
   
   
   /* Frame round button */
   alarm_applet->button_frame = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(alarm_applet->button_frame), 
							 GTK_SHADOW_ETCHED_OUT);
   gtk_container_set_border_width(GTK_CONTAINER(alarm_applet->button_frame), 1);
   alarm_applet->list_button = gtk_button_new_with_label("?");
   gtk_signal_connect(GTK_OBJECT(alarm_applet->list_button), "clicked",
					  GTK_SIGNAL_FUNC(list_button_clicked), NULL);
   GTK_WIDGET_UNSET_FLAGS(alarm_applet->list_button, GTK_CAN_FOCUS);
   GTK_WIDGET_UNSET_FLAGS(alarm_applet->list_button, GTK_CAN_DEFAULT);
   gtk_widget_set_usize(alarm_applet->list_button, 20, 35);
   gtk_container_add(GTK_CONTAINER(alarm_applet->button_frame), 
					 alarm_applet->list_button);
   
   gtk_box_pack_start_defaults(GTK_BOX(alarm_applet->hbox), 
							   alarm_applet->img_frame);
   gtk_box_pack_start_defaults(GTK_BOX(alarm_applet->hbox), 
							   alarm_applet->button_frame);
 
   gtk_widget_show_all(alarm_applet->box);
   init_alarm_store();
   init_sound();

   /* If we don't want the image, hide it */
   if(!alarm_applet->draw_image)
	 gtk_widget_hide(alarm_applet->img_frame);
   
   load_persistant_alarms(APPLET_WIDGET(applet)->privcfgpath);
   if(alarm_applet->timeout_delay < 0)
	 alarm_applet->timeout_delay = 1;
   alarm_applet->timeout_tag = gtk_timeout_add(alarm_applet->timeout_delay * 1000, 
											   timeout_func, NULL);
}


gchar* get_sound_file_name(void)
{
   return alarm_applet->sound_file->str;
}

gchar* get_anim_file_name(void)
{
   return alarm_applet->anim_file->str;
}

void set_sound_file_name(gchar* file)
{
   /* Same file */
   if(!strcmp(file, alarm_applet->sound_file->str))
	 return;
   
   g_string_assign(alarm_applet->sound_file, file);
   save_session_info();
   load_new_sound_file(file);
}


void set_anim_file_name(gchar* file)
{
   g_string_assign(alarm_applet->anim_file, file);
   save_session_info();
}


gint get_sound_vol_level(void)
{
   return alarm_applet->vol_level;
}



void set_alarm_state(AlarmState state)
{
   if((state == ALARM_STATE_VISUAL_RING) && (alarm_applet->redraw_tag == -1))
   {
	  /* No point in setting up the alarm if we aren't visible */
	  if(!GTK_WIDGET_VISIBLE(alarm_applet->img_frame))
		return;
	  ddebug("Called this 4\n");
	  alarm_applet->redraw_tag = gtk_timeout_add(alarm_applet->redraw_delay * 1000, 
												 redraw_timeout, NULL);
   }
   else if((state != ALARM_STATE_VISUAL_RING) && (alarm_applet->redraw_tag > 0))
   {
	  /* Cancel a currently running visual alarm if another alarm
	   * gets called before we have acknowledged it
	   */
	  ddebug("Called this 1\n");
	  gtk_timeout_remove(alarm_applet->redraw_tag);
	  alarm_applet->redraw_tag = -1;
   }
   alarm_applet->alarm_state = state;
}


static void prop_apply_button_cb(GtkWidget* w, gpointer cbdata)
{
   GtkWidget* prop_box = (GtkWidget*)cbdata;
   GtkWidget* time_delay = gtk_object_get_data(GTK_OBJECT(prop_box),
											   "time_delay");
   GtkWidget* redraw_delay = gtk_object_get_data(GTK_OBJECT(prop_box),
												 "redraw_delay");
   gint timeout = alarm_applet->timeout_delay;
   
   GtkWidget* sound_entry = gtk_object_get_data(GTK_OBJECT(prop_box),
												"sound_entry");
   GtkWidget* anim_entry = gtk_object_get_data(GTK_OBJECT(prop_box),
											   "anim_entry");
   GtkWidget* vol_slider = gtk_object_get_data(GTK_OBJECT(prop_box),
											   "vol_slider");
   GtkWidget* draw_image = gtk_object_get_data(GTK_OBJECT(prop_box),
											   "draw_image");
   gchar* filename;
   filename = gtk_entry_get_text(GTK_ENTRY(sound_entry));
   ddebug("Filename = %s\n", filename);
   if(filename)
	 set_sound_file_name(filename);

#if 0
   filename = gtk_entry_get_text(GTK_ENTRY(anim_entry));
   ddebug("Filename = %s\n", filename);
   if(filename)
	 set_anim_file_name(filename);
#endif
   alarm_applet->vol_level = (gint)((GtkAdjustment*)gtk_range_get_adjustment(GTK_RANGE(vol_slider)))->value;
   ddebug("vol level = %d\n", alarm_applet->vol_level);
   change_volume(alarm_applet->vol_level);
   
   alarm_applet->timeout_delay = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(time_delay));
   alarm_applet->redraw_delay = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(redraw_delay));

   
   alarm_applet->draw_image = GTK_TOGGLE_BUTTON(draw_image)->active;
   if(alarm_applet->draw_image)
   {
	  if(!GTK_WIDGET_VISIBLE(alarm_applet->img_frame))
		gtk_widget_show(alarm_applet->img_frame);
   }
   else
   {
	  if(GTK_WIDGET_VISIBLE(alarm_applet->img_frame))
		gtk_widget_hide(alarm_applet->img_frame);
   }

   /* Save the new information */
   save_session_info();
   /* If the user changed the check speed then update immediately */
   if(alarm_applet->timeout_delay != timeout)
   {
	  gtk_timeout_remove(alarm_applet->timeout_tag);
	  alarm_applet->timeout_tag = gtk_timeout_add(alarm_applet->timeout_delay * 1000, 
												  timeout_func, NULL);
   }
}
   

static void prop_ok_button_cb(GtkWidget* w, gpointer cbdata)
{
   GtkWidget* prop_box = (GtkWidget*)cbdata;
   prop_apply_button_cb(w, cbdata);
   gtk_widget_destroy(prop_box);
}


static void prop_help_button_cb(GtkWidget* w, gpointer cbdata)
{
   show_msg_dialog("No help currently available. Sorry !!!", FALSE);
}



static void value_changed(GtkWidget* w, gpointer cbdata)
{
   ddebug("Called value changed\n");
   gnome_property_box_changed(GNOME_PROPERTY_BOX(cbdata));
}


static void sound_file_sel_ok_cb(GtkWidget* w, gpointer cbdata)
{
   GtkWidget* prop_box = (GtkWidget*)cbdata;
   GtkWidget* entry = gtk_object_get_data(GTK_OBJECT(prop_box), "sound_entry");
   GtkWidget* file_sel = gtk_object_get_data(GTK_OBJECT(prop_box), "file_sel");
   
   gnome_property_box_changed(GNOME_PROPERTY_BOX(prop_box));
   gtk_entry_set_text(GTK_ENTRY(entry),
					  gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_sel)));
   gtk_widget_destroy(file_sel);
}


static void anim_file_sel_ok_cb(GtkWidget* w, gpointer cbdata)
{
   GtkWidget* prop_box = (GtkWidget*)cbdata;
   GtkWidget* entry = gtk_object_get_data(GTK_OBJECT(prop_box), "anim_entry");
   GtkWidget* file_sel = gtk_object_get_data(GTK_OBJECT(prop_box), "file_sel");
   
   gnome_property_box_changed(GNOME_PROPERTY_BOX(prop_box));
   gtk_entry_set_text(GTK_ENTRY(entry),
					  gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_sel)));
   gtk_widget_destroy(file_sel);
}


static void sound_browse_button_cb(GtkWidget* w, gpointer cbdata)
{
   GtkWidget* prop_box = (GtkWidget*)cbdata;
   GtkWidget* file_sel;
   
   
   file_sel = gtk_file_selection_new("Choose a Sound File");
   gtk_object_set_data(GTK_OBJECT(prop_box), "file_sel", file_sel);
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->ok_button),
					  "clicked", 
					  GTK_SIGNAL_FUNC(sound_file_sel_ok_cb),
					  prop_box);
   gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->cancel_button),
							 "clicked",
							 GTK_SIGNAL_FUNC(gtk_widget_destroy),
							 GTK_OBJECT(file_sel));
   gtk_widget_show(file_sel);
}


static void anim_browse_button_cb(GtkWidget* w, gpointer cbdata)
{
   GtkWidget* prop_box = (GtkWidget*)cbdata;
   GtkWidget* file_sel;
   
   file_sel = gtk_file_selection_new("Choose an Animation File");
   gtk_object_set_data(GTK_OBJECT(prop_box), "file_sel", file_sel);
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->ok_button),
					  "clicked",
					  GTK_SIGNAL_FUNC(anim_file_sel_ok_cb),
					  prop_box);
   gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->cancel_button),
							 "clicked",
							 GTK_SIGNAL_FUNC(gtk_widget_destroy),
							 GTK_OBJECT(file_sel));
   gtk_widget_show(file_sel);  
}


static void properties_cb(AppletWidget* w, gpointer cbdata)
{
   GtkWidget* prop_box;
   GtkWidget* table;
   GtkWidget* time_delay;
   GtkWidget* redraw_delay;
   GtkWidget* browse_button;
   GtkWidget* sound_entry;
   GtkWidget* anim_entry;
   GtkWidget* vol_slider;
   GtkWidget* draw_image;
   GtkAdjustment* time_adj;
   GtkAdjustment* redraw_adj;
   GtkAdjustment* vol_adj;
   
   
   prop_box = gnome_property_box_new();
   
   table = gtk_table_new(5, 4, TRUE);
   gtk_container_set_border_width(GTK_CONTAINER(table), GNOME_PAD_SMALL);
   
   /* Timeout for checking alarms */
   time_adj = (GtkAdjustment*)gtk_adjustment_new(1, 1, 59, 1, 3, 3);
   time_delay = gtk_spin_button_new(time_adj, 0, 0);
   gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(time_delay), 
								   GTK_SHADOW_OUT);
   gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(time_delay), TRUE);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(time_delay), 
							 alarm_applet->timeout_delay);
   gtk_signal_connect(GTK_OBJECT(time_adj), "value_changed",
					  GTK_SIGNAL_FUNC(value_changed), prop_box);
   gtk_object_set_data(GTK_OBJECT(prop_box), "time_delay", time_delay);
   gtk_table_attach(GTK_TABLE(table), time_delay, 0, 2, 3, 4,
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   gtk_table_attach(GTK_TABLE(table), gtk_label_new("Alarm check timeout in secs"),
					2, 4, 3, 4, 
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   
   
   /* Redraw speed */
   redraw_adj = (GtkAdjustment*)gtk_adjustment_new(1, 1, 20, 1, 3, 3);
   redraw_delay = gtk_spin_button_new(redraw_adj, 0, 0);
   gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(redraw_delay),
								   GTK_SHADOW_OUT);
   gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(redraw_delay), TRUE);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(redraw_delay),
							 alarm_applet->redraw_delay);
   gtk_signal_connect(GTK_OBJECT(redraw_adj), "value_changed",
					  GTK_SIGNAL_FUNC(value_changed), prop_box);
   gtk_object_set_data(GTK_OBJECT(prop_box), "redraw_delay", redraw_delay);
   gtk_table_attach(GTK_TABLE(table), redraw_delay, 0, 2, 4, 5,
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   gtk_table_attach(GTK_TABLE(table), gtk_label_new("Alarm redraw timeout in secs"),
					2, 4, 4, 5, 
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   
   /* Sound file entry */
   sound_entry = gtk_entry_new();
   gtk_entry_set_text(GTK_ENTRY(sound_entry), alarm_applet->sound_file->str);
   gtk_entry_set_editable(GTK_ENTRY(sound_entry), FALSE);
   browse_button = gtk_button_new_with_label("Browse...");
   gtk_signal_connect(GTK_OBJECT(browse_button), "clicked",
					  GTK_SIGNAL_FUNC(sound_browse_button_cb), prop_box);
   gtk_object_set_data(GTK_OBJECT(prop_box), "sound_entry", sound_entry);
   gtk_table_attach(GTK_TABLE(table), sound_entry, 0, 2, 1, 2,
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   gtk_table_attach(GTK_TABLE(table), gtk_label_new("Sound file"),
					2, 3, 1, 2, 
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   gtk_table_attach(GTK_TABLE(table), browse_button, 3, 4, 1, 2,
					GTK_FILL, GTK_FILL, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   
#if 0
   /* Anim file */
   anim_entry = gtk_entry_new();
   gtk_entry_set_text(GTK_ENTRY(anim_entry), alarm_applet->anim_file->str);
   gtk_entry_set_editable(GTK_ENTRY(anim_entry), FALSE);
   browse_button = gtk_button_new_with_label("Browse...");
   gtk_signal_connect(GTK_OBJECT(browse_button), "clicked",
					  GTK_SIGNAL_FUNC(anim_browse_button_cb), prop_box);
   gtk_object_set_data(GTK_OBJECT(prop_box), "anim_entry", anim_entry);
   gtk_table_attach(GTK_TABLE(table), anim_entry, 0, 2, 2, 3,
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   gtk_table_attach(GTK_TABLE(table), gtk_label_new("Animation file"),
					2, 3, 2, 3, 
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   gtk_table_attach(GTK_TABLE(table), browse_button, 3, 4, 2, 3,
					GTK_FILL, GTK_FILL, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
  
#endif
   
   /* Draw image toggle button */
   draw_image = gtk_check_button_new();
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(draw_image), 
								alarm_applet->draw_image);
   gtk_object_set_data(GTK_OBJECT(prop_box), "draw_image", draw_image);
   gtk_signal_connect(GTK_OBJECT(draw_image), "toggled",
					  GTK_SIGNAL_FUNC(value_changed), prop_box);
   gtk_table_attach(GTK_TABLE(table), draw_image, 0, 2, 2, 3,
					GTK_FILL | GTK_EXPAND,
					GTK_FILL | GTK_EXPAND,
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   gtk_table_attach(GTK_TABLE(table), gtk_label_new("Display visual alarm image"),
					2, 4, 2, 3,
					GTK_FILL | GTK_EXPAND,
					GTK_FILL | GTK_EXPAND,
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   
   /* Vol slider */
   vol_adj = (GtkAdjustment*)gtk_adjustment_new(alarm_applet->vol_level,
												0, 100, 1, 1, 3);
   
   vol_slider = gtk_hscale_new(vol_adj);
   gtk_scale_set_draw_value(GTK_SCALE(vol_slider), TRUE);
   gtk_scale_set_value_pos(GTK_SCALE(vol_slider), GTK_POS_RIGHT);
   gtk_range_set_update_policy(GTK_RANGE(vol_slider), 
							   GTK_UPDATE_CONTINUOUS);
   gtk_scale_set_digits(GTK_SCALE(vol_slider), 0);
   gtk_signal_connect(GTK_OBJECT(vol_adj), "value_changed",
					  GTK_SIGNAL_FUNC(value_changed), prop_box);
   gtk_object_set_data(GTK_OBJECT(prop_box), "vol_slider", vol_slider);
   gtk_table_attach(GTK_TABLE(table), vol_slider, 0, 2, 0, 1,
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
   gtk_table_attach(GTK_TABLE(table), gtk_label_new("Sound alarm volume"),
					2, 4, 0, 1, 
					GTK_FILL | GTK_EXPAND, 
					GTK_FILL | GTK_EXPAND, 
					GNOME_PAD_SMALL, GNOME_PAD_SMALL);
				 
   gtk_window_set_title(GTK_WINDOW(prop_box), "Alarm Applet Properties");
   gtk_widget_show_all(table);
   gnome_property_box_append_page(GNOME_PROPERTY_BOX(prop_box), table,
								  gtk_label_new("Props"));
   gtk_signal_connect(GTK_OBJECT(GNOME_PROPERTY_BOX(prop_box)->ok_button),
					  "clicked", GTK_SIGNAL_FUNC(prop_ok_button_cb), 
					  prop_box);
   gtk_signal_connect(GTK_OBJECT(GNOME_PROPERTY_BOX(prop_box)->apply_button),
					  "clicked",
					  GTK_SIGNAL_FUNC(prop_apply_button_cb), prop_box);
   gtk_signal_connect(GTK_OBJECT(GNOME_PROPERTY_BOX(prop_box)->help_button),
					  "clicked",
					  GTK_SIGNAL_FUNC(prop_help_button_cb), NULL);
   gtk_widget_show(prop_box);
}
   
   


static void about_cb(AppletWidget* w, gpointer cbdata)
{
   GtkWidget* about_box;
   
   static const gchar* author[] = 
   {
	  "Iain Barnes (igbarn@yahoo.com)",
	  NULL
   };
   
   about_box = gnome_about_new(_("Alarm Applet"), VERSION,
							   _("(C) 1999 Iain Barnes"),
							   author,
							   _("A simple alarm to remind you that you"
							   " should be doing something else :))"),
							   NULL);

   gtk_widget_show(about_box);
}


int main(int argc, char** argv)
{
   bindtextdomain(PACKAGE, GNOMELOCALEDIR);
   textdomain(PACKAGE);
   
   applet_widget_init("alarm_applet", VERSION, argc, argv,
					  NULL, 0, NULL);
   
   applet = applet_widget_new("alarm_applet");
   if(!applet)
	 g_error("Unable to create applet\n");
   
   gtk_widget_realize(applet);
   
   init_applet();
   
   gtk_signal_connect(GTK_OBJECT(applet), "delete_event",
					  GTK_SIGNAL_FUNC(quit_applet), NULL);
   gtk_signal_connect(GTK_OBJECT(applet), "save_session",
					  GTK_SIGNAL_FUNC(applet_save_session), NULL);

   gtk_signal_connect(GTK_OBJECT(applet), "change_orient",
					  GTK_SIGNAL_FUNC(change_orient), NULL);
   
   applet_widget_register_stock_callback(APPLET_WIDGET(applet),
										 "about",
										 GNOME_STOCK_MENU_ABOUT,
										 _("About..."),
										 about_cb, NULL);

   applet_widget_register_stock_callback(APPLET_WIDGET(applet),
										 "props",
										 GNOME_STOCK_MENU_PROP,
										 _("Properties..."),
										 properties_cb, NULL);
   
   applet_widget_register_stock_callback(APPLET_WIDGET(applet),
										 "add",
										 GNOME_STOCK_MENU_INDEX,
										 _("Add an alarm..."),
										 GTK_SIGNAL_FUNC(show_add_alarm_dialog),
										 NULL);
   
   applet_widget_add(APPLET_WIDGET(applet), alarm_applet->box);
   gtk_widget_show(applet); 
   applet_widget_gtk_main();
   return 0;
}
