//////////////////////////////////////////////////////////////////////////
//
//  IGATOR Copyright (C) 1997-98 RIT Research Labs
//
//  This programs is free for commercial and non-commercial use as long as
//  the following conditions are aheared to.
//
//  Copyright remains RIT Research Labs, and as such any Copyright notices
//  in the code are not to be removed. If this package is used in a
//  product, RIT Research Labs should be given attribution as the RIT Research
//  Labs of the parts of the library used. This can be in the form of a textual
//  message at program startup or in documentation (online or textual)
//  provided with the package.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//
//  1. Redistributions of source code must retain the copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. All advertising materials mentioning features or use of this software
//     must display the following acknowledgement:
//     "Based on IGATOR by RIT Research Labs."
//
//  THIS SOFTWARE IS PROVIDED BY RIT RESEARCH LABS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
//  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
//  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
//  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
//  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//  The licence and distribution terms for any publically available
//  version or derivative of this code cannot be changed. i.e. this code
//  cannot simply be copied and put under another distribution licence
//  (including the GNU Public Licence).
//
//////////////////////////////////////////////////////////////////////////

unit SendMail;

interface
uses  Windows, SysUtils, WinSock, WSocket;

function SendMessage(const Smtp, Email, AddrFile, MsgFile: String): Boolean;


implementation
uses Logger, Classes, Utils;

function SendMessage;
  label Ex;
  var AF, F: Text;
      Sock: TSocket;
      I, N: Integer;
      S: String[255];
      LF: Boolean;
      TN: TStringList;
      Kludge: Boolean;

  procedure Send(S: String);
  begin
    if S <> '' then Sock.Write(S[1], Length(S));
  end;

  function Answer(const PosString, Next, Error: String): Boolean;
    label 1;
    var S,SS,Q: String[255];
        RCode: Integer;
        I, J: Integer;
  begin
    if PosString <> '' then WriteLn(PosString);
    if Next <> '' then Send(Next);
    SS := '';
    repeat
      I := Sock.Read(S[1], 200);
      S[0] := Char(I);
      RCode := 0;
      I := 1;
      while (I <= Length(S)) and (RCode = 0) do
        begin
          J := 1;
          while (I+J <= Length(S)) and (S[I+J] <> #13) and (S[I+J] <> #10) do Inc(J);
          Q := Copy(S, I, J); if SS <> '' then begin Insert(SS, Q, 1); SS := ''; end;
          if (S[I+J] in [#13,#10]) then
            begin
              Inc(I, J);
              while (I <= Length(S)) and (S[I] in [#13,#10]) do Inc(I);
              if (Length(Q) > 3) and (Q[4] <> '-') then
                begin
                  RCode := StrToIntDef(Copy(Q, 1, 3), 0);
                end;
            end else begin SS := Q; Break end;
        end;
      Sleep(20);
    until (RCode <> 0) or (Sock.Status <> 0);
  1:
    if (RCode = 0) and (SS <> '') then
      begin
        Q := SS;
        RCode := StrToIntDef(Copy(SS, 1, 3), 0);
      end;
    S := Q;
    if (RCode >= 100) and (RCode < 400) then Answer := True
          else begin
                 Log('ERROR: '+Error+', Answer - '+S, True);
                 Answer := False;
               end;
  end;


begin
  TN := nil;
  SendMessage := False;
  Sock := TSocket.Create(AF_INET);
//  Sock.SetOptions([soReuseAddr], True);
  if Sock.Status <> 0 then
    begin
      Log('ERROR: Could not open socket, Status - '+ItoS(Sock.Status), True);
Ex:
      Sock.Free;
      Exit;
    end;
  WriteLn('Connecting to SMTP server...');
  if Sock.Connect(Smtp, 25) then
    begin
      if Answer('', '', 'Server is not ready') then
      if Answer('Connected to '+Smtp, 'HELO '+Smtp+#13#10, 'Server is not ready') then
       if Answer('Sending FROM command...', 'MAIL FROM:<'+EMAIL+'>'#13#10, 'Server refused the message') then
         begin
           TN := TStringList.Create;
           Assign(F, AddrFile); I := IOResult;
           Reset(F);
           N := 0;
           while not SeekEOF(F) do
             begin
               ReadLn(F, S);
               if S <> '' then
                 if Answer('Sending TO address...', 'RCPT TO:<'+S+'>'#13#10, 'Server refused address '+S) then
                   begin
                     Inc(N);
                     TN.Add(S);
                   end;
             end;
           Close(F);
           if N > 0 then
             begin
               if Answer('Sending the message text', 'DATA'#13#10, 'Server refused the message') then
                 begin
                   Assign(F, MsgFile); I := IOResult;
                   Reset(F); Kludge := True;
                   while not EOF(F) and (IOResult = 0) do
                     begin
                       Read(F, S);
                       if S = '.' then S := '..';
                       if EOLn(F) then
                         begin
                           ReadLn(F);
                           if S = '' then Kludge := False else
                             if Kludge and (Copy(S, 1, 5) = 'From:') then
                               begin
                                 Send(S+#13#10); S := 'To: ';
                                 for I := 0 to TN.Count-1 do
                                   begin
                                     if Length(S) > 60 then
                                       begin
                                         Send(S+#13#10);
                                         S := #9;
                                       end;
                                     S := S+TN[I];
                                     if I < TN.Count - 1 then S := S+', ';
                                   end;
                               end;
                           S := S+#13#10;
                         end;
                       Send(S);
                     end;
                   Close(F);
                   if Answer('Waiting for the acceptation...', #13#10'.'#13#10, 'Server refused the message') then
                     begin
                       SendMessage := True;
                       Log('Message from <'+email+'> sent', True);
                       Answer('Logging off from the server...', 'QUIT'#13#10, 'Could not logoff from the server');
                     end;
                 end;
             end else Log('ERROR: No recepients recognised by the server', True);
           TN.Free;
         end;
    end else Log('ERROR: Could not connect to SMTP server', True);
  Sock.Free;
end;


end.
