/*********************************************************************
* ftlog.c
*
*   Copyright (C) 1999-2002	Promise Technology, Inc.
*   May be copied or modified under the terms of the
*   GNU Lesser General Public License
*
*********************************************************************/

#include <linux/kernel.h>
#include <linux/string.h>

#include "global.h"

// -------------------------------------------------------------------
void modelname(char *str,int size) {
   char	  *p;
   unchar uc;

   for( uc=0 ; uc< (size/2) ; uc++ ) {
	char	tmp;
	tmp = str[uc*2] ;
	str[uc*2]   = str[uc*2+1] ;
	str[uc*2+1] = tmp ;
   }
   p = str ;
   do {
	if( (*p == ' ') && (*(p+1) == ' ') ) {
	   *p = '\0';
	   break;
	}
   } while( ++p < (str+size-1) );
   return;
}
// -------------------------------------------------------------------       
void log_snmp_event (int sequence, int eventid, int arrayid, int diskid) {
   //don't log more than 50 events at a time to prevent running out of
   //space if ioctl is not called. ioctl resets snmp_log_index
   //once all events have been sent.
   if (snmp_log_index < 49) {
    	snmp_log[snmp_log_index].sequence  = sequence;
    	snmp_log[snmp_log_index].eventid   = eventid;
    	snmp_log[snmp_log_index].arrayid   = arrayid;
    	snmp_log[snmp_log_index++].diskid  = diskid;
   }    
}  
// -------------------------------------------------------------------
void log_event(int eventid, int ArrayID, int dev, unsigned long LBA, int percent, short command, short status) {
   static int num = 0;
   struct ft_driveid 	*id ; 
   char diskname[100], str[100];
   Event_t		*evt;

   num++;

/* Bennett & Hank
 * for FastCheck utility structure info */
   evt = &Event[EventPtr];
   evt->num		= num;
   evt->eventid 	= eventid;
   evt->ArrayID 	= ArrayID;
   evt->dev		= dev;
   evt->LBA          = LBA;
   evt->percent	= percent;
   evt->command	= command;
   evt->status	= status;

   EventPtr += 1;
   if( EventPtr >= MAX_EVENT )
	EventPtr = 0;

   ArrayID++;
   id = ft_drive[dev].identify ;
   strcpy(diskname, id->model);
   modelname((char *)&diskname,sizeof(id->model));
   diskname[sizeof(id->model)-1] = '\0' ; 
   sprintf( str, " (Channel %d/" , ft_drive[dev].pchannel->id+1 );
   strcat(diskname, str );
   strcat(diskname,(ft_drive[dev].select == 0xA0)?"Master)":"Slave)");
  
   //log the event for retreiva thru ioctl
   log_snmp_event(num,eventid, ArrayID, dev+1);

   switch (eventid) {
      case 4103: printk(KERN_ERR "FastTrak|%3d|4103|Warning|Disk Rebuild Started: Array %d, Disk %s\n", num, ArrayID, diskname);
                 break;
      case 4104: printk(KERN_ERR "FastTrak|%3d|4104|Information|Disk Synchronize Started: Array %d\n", num, ArrayID);
                 break;     
      case 4119: printk(KERN_ERR "FastTrak|%3d|4119|Error|ECC Error:Disk %s at LBA 0x%lx\n", num, diskname, LBA);
                 break; 
      case 4120: printk(KERN_ERR "FastTrak|%3d|4120|Error|Disk Set Down: %s\n", num, diskname);
                 break;     
      case 4121: printk(KERN_ERR "FastTrak|%3d|4121|Information|Disk Plugged in: %s\n", num, diskname);
                 break;     
      case 4122: printk(KERN_ERR "FastTrak|%3d|4122|Information|Reserved Sector Error: Disk %s at LBA 0x%lx\n", num, diskname, LBA);
                 break;     
      case 4123: printk(KERN_ERR "FastTrak|%3d|4123|Error|Disk Offline: %s\n", num, diskname);
                 break;     
      case 4124: printk(KERN_ERR "FastTrak|%3d|4124|Warning|Array %d has bad sector on Disk %s at LBA 0x%lx\n", num, ArrayID, diskname, LBA);
                 break;     
      case 4125: printk(KERN_ERR "FastTrak|%3d|4125|Warning|Retry Disk Access : Disk %s LBA 0x%lx\n", num, diskname, LBA);
                 break;     
      case 4126: printk(KERN_ERR "FastTrak|%3d|4126|Information|Array %d Rebuild Completed on Disk %s\n", num, ArrayID, diskname);
                 break;
      case 4127: printk(KERN_ERR "FastTrak|%3d|4127|Information|Array %d, Synchronize Completed\n", num, ArrayID);
                 break;     
      case 4128: printk(KERN_ERR "FastTrak|%3d|4128|Warning|Rebuild aborted on array %d, disk %s, at %d percent complete\n", num, ArrayID, diskname, percent);
                 break;
      case 4129: printk(KERN_ERR "FastTrak|%3d|4129|Warning|Synchronization aborted on array %d, at %d complete\n", num, ArrayID, percent);
                 break;     
      case 4130: printk(KERN_ERR "FastTrak|%3d|4130|Warning|Retry Disk Access : Disk %s LBA 0x%lx\n", num, diskname, LBA);
                 break;     
      case 4131: printk(KERN_ERR "FastTrak|%3d|4131|Error|Array %d, Status Offline\n", num, ArrayID);
                 break;     
      case 4132: printk(KERN_ERR "FastTrak|%3d|4132|Warning|Array %d, Status Critical\n", num, ArrayID);
                 break;     
      case 4133: printk(KERN_ERR "FastTrak|%3d|4133|Information|Array %d, Disk %s Disk Error at LBA 0x%lx cmd=0x%x status=0x%x\n", num, ArrayID, diskname, LBA, command, status);
                 break;     
      case 4134: printk(KERN_ERR "FastTrak|%3d|4134|Information|Synchronization Comparison Error on Array %d a LBA 0x%lx\n", num, ArrayID, LBA);
                 break;     
      case 4136: printk(KERN_ERR "FastTrak|%3d|4136|Warning|Disk %s has Error while startup\n", num, diskname);
                 break;     
      case 4137: printk(KERN_ERR "FastTrak|%3d|4137|Warning|Array %d is Critical while startup\n", num, ArrayID);
                 break;     
      case 4138: printk(KERN_ERR "FastTrak|%3d|4138|Error|ECC Error Fix Failed - Uncorrectable Error\n", num);
                 break;     
      case 4139: printk(KERN_ERR "FastTrak|%3d|4139|Warning|Plugged in Drive %s too small to rebuild.\n", num, diskname);
		 break;

   }
}
       
