/*
 * Application.java
 *
 * Created on February 3, 2001, 9:40 PM
 */


/**
 *
 * @author  Bo_Zimmerman
 * @version
 */
package com.planet_ink.sip;
import javax.swing.*;
import java.io.*;
import java.awt.*;
import java.util.*;
public class Sip extends javax.swing.JFrame 
{
	
	int width=580;
	int height=590;
	int wwidth=width-5;
	int pos=-1;
	Vector cmdList=new Vector();
	String[] hotkeys=new String[10];
    static final String filename="sip.ini";
			   
    Connector C=null;
    LoadNGo L=null;
    /** Creates new form Application */
    public Sip() {
        initComponents ();
        pack ();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width-width)/2;
        int y = (screen.height-height)/2;
        this.setBounds(x,y,width,height);
        setResizable(false);
        C=new Connector();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        textArea1 = new java.awt.TextArea("", wwidth,60,java.awt.TextArea.SCROLLBARS_BOTH);
        textArea2 = new java.awt.TextArea("", wwidth,height-85,java.awt.TextArea.SCROLLBARS_VERTICAL_ONLY);
        getContentPane().setLayout(null);
        setTitle("Sip v1.1                 (c) 2001 Bo Zimmerman");
        setFont(new java.awt.Font ("Courier New", 0, 10));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowActivated(java.awt.event.WindowEvent evt) {
                formWindowActivated(evt);
            }
        }
        );

        textArea1.setBackground(java.awt.Color.white);
        textArea1.setFont(new java.awt.Font ("Monospaced", 0, 12));
        textArea1.setForeground(java.awt.Color.black);
        textArea1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                textArea1KeyTyped(evt);
            }
            public void keyPressed(java.awt.event.KeyEvent evt) {
                textArea1KeyPressed(evt);
            }
        }
        );

        getContentPane().add(textArea1);
        textArea1.setBounds(0, 0, wwidth, height-85);


        textArea2.setBackground(java.awt.Color.white);
        textArea2.setFont(new java.awt.Font ("Monospaced", 0, 12));
        textArea2.setForeground(java.awt.Color.black);
        textArea2.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                textArea2KeyTyped(evt);
            }
        }
        );
        textArea2.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                textArea2KeyPressed(evt);
            }
			}
		);
        getContentPane().add(textArea2);
        textArea2.setBounds(0, height-85, wwidth, 60);
    }//GEN-END:initComponents

  private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
      // Add your handling code here:
  }//GEN-LAST:event_formWindowClosed

  private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
      lilboy();
      // Add your handling code here:
  }//GEN-LAST:event_formWindowOpened

  public void lilboy()
  {
        textArea1.setText("");
        textArea2.setText("");
        textArea2.requestFocus();
		if(L==null)
	        L=new com.planet_ink.sip.LoadNGo(this,true);
		L.setBackground(java.awt.Color.yellow);
		L.repaint();
		L.show();
  }

  private void textArea1KeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_textArea1KeyTyped
            if(((int)evt.getKeyChar())==24)
                evt.setKeyChar((char)3);
            else
            if(((int)evt.getKeyChar())!=3)
                evt.consume();
// Add your handling code here:
  }//GEN-LAST:event_textArea1KeyTyped

  private void textArea1KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_textArea1KeyPressed
            if(((int)evt.getKeyChar())==24)
                evt.setKeyChar((char)3);
            else
            if(((int)evt.getKeyChar())!=3)
                evt.consume();
      // Add your handling code here:
  }//GEN-LAST:event_textArea1KeyPressed

  private void doCommand(String toGo)
  {
	cmdList.addElement(toGo);
	if(cmdList.size()>100)
		cmdList.removeElementAt(0);
	pos=-1;
    writeOut(toGo+((char)10));
    textArea2.setText("");
    C.sendOut(toGo);
  }
  private void textArea2KeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_textArea2KeyTyped
        if((evt.getKeyChar()==10)||(evt.getKeyChar()==13))
        {
            String toGo=textArea2.getText();
			doCommand(toGo);
            evt.consume();
		}

      // Add your handling code here:
  }//GEN-LAST:event_textArea2KeyTyped

  private void textArea2KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_textArea2KeyPressed
		if(evt.getKeyCode()==evt.VK_UP)
		{
			if((pos<0)||(pos>=cmdList.size())) pos=cmdList.size()-1;
			if((pos>=0)&&(pos<cmdList.size()))
			{
				textArea2.setText((String)cmdList.elementAt(pos));
				pos--;
			}
            evt.consume();
		}
		else
		if(evt.getKeyCode()==evt.VK_DOWN)
		{
			if((pos<0)||(pos>=cmdList.size())) pos=-1;
			pos++;
			if((pos>=0)&&(pos<cmdList.size()))
				textArea2.setText((String)cmdList.elementAt(pos));
            evt.consume();
		}
		else
		{
			int hotkey=-1;
			switch(evt.getKeyCode())
			{
			case java.awt.event.KeyEvent.VK_F10: hotkey=0; break; 
			case java.awt.event.KeyEvent.VK_F1: hotkey=1; break; 
			case java.awt.event.KeyEvent.VK_F2: hotkey=2; break; 
			case java.awt.event.KeyEvent.VK_F3: hotkey=3; break; 
			case java.awt.event.KeyEvent.VK_F4: hotkey=4; break; 
			case java.awt.event.KeyEvent.VK_F5: hotkey=5; break; 
			case java.awt.event.KeyEvent.VK_F6: hotkey=6; break; 
			case java.awt.event.KeyEvent.VK_F7: hotkey=7; break; 
			case java.awt.event.KeyEvent.VK_F8: hotkey=8; break; 
			case java.awt.event.KeyEvent.VK_F9: hotkey=9; break; 
			}
			if(hotkey>=0)
			{
				if((evt.isShiftDown())||(evt.isControlDown())||(evt.isAltDown()))
				{
					if(textArea2.getText().trim().length()>0)
					{
						hotkeys[hotkey]=textArea2.getText();
						if(L!=null)
							save(L.theList,L.thePorts,L.listIndex,hotkeys);
					}
				}
				else
				if(hotkeys[hotkey]!=null)
				{
					String s=hotkeys[hotkey];
					for(int i=0;i<s.length();i++)
						if(s.charAt(i)=='~')
						{
							String cmd=s.substring(0,i);
							doCommand(cmd);
							s=s.substring(i+1);
						}
					textArea2.setText(s);
				}
				evt.consume();
			}
		}

      // Add your handling code here:
  }//GEN-LAST:event_textArea2KeyPressed

  private void formWindowActivated(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowActivated
        textArea2.requestFocus();
      // Add your handling code here:
  }//GEN-LAST:event_formWindowActivated

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit (0);
    }//GEN-LAST:event_exitForm

    public void writeOut(char c)
    {
		writeOut(""+c);
    }
    public void writeOut(String s)
    {
        if(textArea1.getText().length()>12240)
            textArea1.setText(textArea1.getText().substring(2048));
        textArea1.append(s);
    }
    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) {
        Sip myApp=new Sip ();
        myApp.show();
        myApp.textArea2.requestFocus();
   }

public void save(String[] theList, int[] thePorts, int listIndex, String[] hotkeys)
{
    try
    {
        FileWriter writer=new FileWriter(filename,false);
		for(int i=0;i<10;i++)
			if((hotkeys[i]==null)||(hotkeys[i].length()==0))
				writer.write("\r\n");
			else
				writer.write(hotkeys[i]+"\r\n");
        for(int i=0;i<listIndex;i++)
        {
            writer.write(theList[i]+"\r\n");
            writer.write(thePorts[i]+"\r\n");
        }
        writer.flush();
        writer.close();
    }
    catch(IOException e)
    {
        e.printStackTrace();
    }
}
   // Variables declaration - do not modify//GEN-BEGIN:variables
   private java.awt.TextArea textArea1;
   private java.awt.TextArea textArea2;
   // End of variables declaration//GEN-END:variables

}
