/*******************************************************************************

  
  Copyright(c) 1999 - 2002 Intel Corporation. All rights reserved.
  
  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Linux NICS <linux.nics@intel.com>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497
*******************************************************************************/

/**********************************************************************
*                                                                     *
* INTEL CORPORATION                                                   *
*                                                                     *
* This software is supplied under the terms of the license included   *
* above.  All use of this driver must be in accordance with the terms *
* of that license.                                                    *
*                                                                     *
* Module Name:  ans_hw.h                                              *
*                                                                     *
* Abstract: these are the hardware specific (not OS specific)         *
*       routines needed by the bd_ans module                          *
*                                                                     *
* Environment:                                                        *
*                                                                     *
**********************************************************************/

#ifndef _ANS_HW__H_
#define _ANS_HW__H_

#define BASE_10T        1
#define BASE_100T4      2
#define BASE_100TX      4
#define BASE_100FX      8

#define I82559_REV_ID                    8
#define I82558_REV_ID                                    4
#define EEPROM_COMPATIBILITY_FLAGS      3
#define EEPROM_COMPATIBILITY_BIT_4          0x0004
#define EEPROM_COMPATIBILITY_BIT_2          0x0002
#define IPCB_INSERT_VLAN_ENABLE         0x02

#define GAMLA_REV_ID                    12
#define D101B_REV_ID                    5

/* bit definitions of 8255x header */
typedef struct _cb_header_status_word {
    volatile unsigned status:12;
    volatile unsigned underrun:1;
    volatile unsigned ok:1;
    volatile unsigned pad:1;
    volatile unsigned c:1;
} cb_header_status_word;

/* definition of an IPCB - only the parts that I care about */
typedef struct _ipcb_bits {
    volatile unsigned ipcb_scheduling:20;
    volatile unsigned ipcb_activation:12;
    volatile UINT16 vlanid;
    volatile UINT8 ip_header_offset;
    volatile UINT8 tcp_header_offset;
} ipcb_bits;

#define HIGH_BYTE(word) ((UINT8)(word >> 8))
#define BD_ANS_HW_FLAGS(bps) \
            bd_ans_hw_flags(bps, BD_ANS_DRV_REVID(bps));
#define BD_ANS_HW_AVAILABLE_SPEEDS(bps) bd_ans_hw_AvailableSpeeds(BD_ANS_DRV_PHY_ID(bps))

/* function prototypes */
extern UINT32 bd_ans_hw_AvailableSpeeds(UINT32 phy);
extern UINT32 bd_ans_hw_flags(BOARD_PRIVATE_STRUCT *bps, UINT16 revid);
extern u16 e100_eeprom_read(struct e100_private *bdp, u16 reg);

#ifdef IANS_BASE_VLAN_TAGGING
void bd_ans_hw_ConfigEnableTagging(UINT8 *ConfigBytes, UINT16 rev_id);
#endif

#endif /* _ANS_HW__H_ */
