@echo off

REM BIOS Zip Batch file, Ver 0.6, 7/2/97

REM This batch file zips up BIOS files into a self-extracting file suitable
REM for posting on the web, BBS, Notes, the FTP server, etc.


REM Variable Description
REM %1 is the product name
REM %2 is the BIOS version e.g. 1.00.03.BT0
REM %3 is the name for the self-extracting zip file that will be posted,
REM    e.g. 10003BT0.  Note, no file extension.
REM %4 is the directory location of the files to be zipped

REM Sample command line is
REM BLD_BIOS ADVANCED/MN 1.00.03.BT0 10003BT0 C:\WORK\BIOS 

REM check for correct command line
IF "%3" == "" GOTO NOPARM

REM ask user if parameters are correct
ECHO.
ECHO The product name is %1
ECHO The BIOS version is %2
ECHO The BBS file name is %3.EXE
ECHO The directory location is %4
ECHO.
ECHO If these are not correct, hit the CTRL-C key combination to exit
ECHO the batch file. 
PAUSE

REM if specified directory is the current directory, take special steps
SET WDR=%4
IF "%4" == "" SET WDR=.

REM delete old files
IF EXIST BIOS.ZIP DEL BIOS.ZIP > NUL:
IF EXIST BIOS.EXE BIOS.EXE > NUL:
IF EXIST %3.ZIP DEL %3.ZIP > NUL:
IF EXIST %3.EXE DEL %3.EXE > NUL:

REM remove read only attribute from unused files
IF EXIST CUTUSER.* ATTRIB %WDR%\CUTUSER.BAT > NUL:
IF EXIST CHANGES.* ATTRIB %WDR%\CHANGES.TXT > NUL:

REM delete unused files
IF EXIST CUTUSER.* DEL %WDR%\CUTUSER.BAT > NUL:
IF EXIST CHANGES.* DEL %WDR%\CHANGES.TXT > NUL:

REM IF NOT "%4" == "" COPY README.TXT %WDR%\README.TXT

REM make sure that the license, readme and bioinstr files are included 
REM in the directory with the BIOS files
IF EXIST %WDR%\LICENSE.TXT GOTO :NEXT 
GOTO :MISSING
:NEXT
IF EXIST %WDR%\BIOINSTR.TXT GOTO :NEXT1
GOTO :MISSING
:NEXT1
IF EXIST %WDR%\README.TXT GOTO :NEXT2
GOTO :MISSING
:NEXT2
IF EXIST %WDR%\MK_BOOTZ.EXE GOTO :CONTINUE

:MISSING
ECHO One of the following files is not included in the same directory 
ECHO as the BIOS files: LICENSE.TXT, BIOINSTR.TXT, README.TXT, MK_BOOTZ.EXE
ECHO Please move the appropriate file(s) into that directory 
ECHO and rerun this batch file
GOTO :END

:CONTINUE
REM zip up the BIOS files, excluding the license, bios and mk_boot instruction files
PKZIP -X%WDR%\LICENSE.TXT -X%WDR%\BIOINSTR.TXT -X%WDR%\MK_BOOTZ.EXE BIOS %WDR%\*.* > NUL:

REM remove the BLD_BIOS.BAT file from the zip file
IF "%4" == "" PKZIP -D BIOS BLD_BIOS.BAT > NUL:

REM remove the message.txt from the zip file if it is present
IF EXIST %WDR%\MESSAGE.TXT PKZIP -D BIOS %WDR%\MESSAGE.TXT > NUL:

REM create AGREE.TXT file
ECHO  > AGREE.TXT
ECHO. >> AGREE.TXT
ECHO. >> AGREE.TXT
ECHO Unzip these files to a bootable floppy disk by typing "BIOS A:" >> AGREE.TXT
ECHO. >> AGREE.TXT
ECHO ͻ>> AGREE.TXT
ECHO                        INTEL END USER LICENSE AGREEMENT                      >> AGREE.TXT
ECHO  If you unzip this file, you will be bound by the terms of the agreement.    >> AGREE.TXT
ECHO ͼ>> AGREE.TXT
ECHO. >> AGREE.TXT
ECHO. >> AGREE.TXT
ECHO. >> AGREE.TXT


REM  Then, Zip the "Agree to license" text to the BIOS Zip file
PKZIP -z BIOS < AGREE.TXT > NUL:

REM Now make this BIOS file self extracting
@ZIP2EXE BIOS > NUL:

REM create COMMENTS.TXT file
ECHO  > COMMENTS.TXT
ECHO. >> COMMENTS.TXT
ECHO. >> COMMENTS.TXT
ECHO This is the %1 BIOS Update. >> COMMENTS.TXT
ECHO The files contained in this ZIP file allow you to update your  >> COMMENTS.TXT
ECHO %1 system BIOS to version %2. >> COMMENTS.TXT
ECHO. >> COMMENTS.TXT
ECHO For Instructions on how to update your BIOS, read BIOINSTR.TXT. >> COMMENTS.TXT
ECHO. >> COMMENTS.TXT

IF EXIST %WDR%\MESSAGE.TXT MORE < %WDR%\MESSAGE.TXT >>COMMENTS.TXT

ECHO ͻ>> COMMENTS.TXT
ECHO                        INTEL END USER LICENSE AGREEMENT                      >> COMMENTS.TXT
ECHO  Before you run the enclosed EXE file you must first read and agree to the   >> COMMENTS.TXT
ECHO  end-user license agreement enclosed in the file LICENSE.TXT included in     >> COMMENTS.TXT
ECHO  this ZIP file.  If you do not agree to the terms of this agreement,         >> COMMENTS.TXT
ECHO  promptly delete this ZIP file and the files it contained.                   >> COMMENTS.TXT
ECHO ͼ>> COMMENTS.TXT
ECHO. >> COMMENTS.TXT
ECHO. >> COMMENTS.TXT

REM OK, on the home stretch...Zip the BIOS.EXE, the instruction file,
REM the MK_BOOT file & the LICENSE file together
PKZIP %3 %WDR%\BIOINSTR.TXT %WDR%\LICENSE.TXT %WDR%\MK_BOOTZ.EXE BIOS.EXE > NUL:

REM And add the front end comments to it
PKZIP %3 -z < COMMENTS.TXT > NUL:

REM Finally, make this file self-extracting...
ZIP2EXE %3 > NUL:

REM Now clean up.
DEL AGREE.TXT
DEL COMMENTS.TXT
DEL BIOS.ZIP
DEL BIOS.EXE
DEL %3.ZIP

ECHO BIOS ZIP FILE IS NOW READY FOR EXPORT TO CUSTOMERS

GOTO END

:NOPARM
ECHO.
ECHO BLD_BIOS prod_name bios_ver bios_file_name bios_file_directory
ECHO.
GOTO END

:END

