#include "amiwrap.h"

//#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)

#define mem_map_reserve(p) set_bit(PG_reserved, &((p)->flags))
#define mem_map_unreserve(p) clear_bit(PG_reserved, &((p)->flags))

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
//MODULE_AUTHOR("American Megatrends Inc.");
//MODULE_DESCRIPTION("AMI Flash Update utility driver");
//MODULE_LICENSE("GPL");
#endif

int wrap_register_chrdev(unsigned int major, const char *name, struct file_operations *fops)
{
	return register_chrdev(major, name, fops);
}
int wrap_unregister_chrdev(unsigned int major, const char *name)
{
	return unregister_chrdev(major, name);
}

void wrap_mem_map_reserve(struct page *ptr)
{
	mem_map_reserve(ptr);
}

void wrap_mem_map_unreserve(struct page *ptr)
{
	mem_map_unreserve(ptr);
}

struct page *wrap_virt_to_page(unsigned long addr)
{
	return virt_to_page(addr);
}

int wrap_remap_page_range(struct vm_area_struct *vma, unsigned long from,
		unsigned long to, unsigned long size, pgprot_t prot)
{
//#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,3)) || defined(REMAP_VMA)

	return remap_page_range(vma, from, to, size, prot);
//#else
//	return remap_page_range(from, to, size, prot);
//#endif
}

void *wrap_kmalloc(size_t size, int nmemb)
{
	return kmalloc(size, nmemb);
}

void wrap_kfree(void *ptr)
{
	kfree(ptr);
}

int wrap_printk(const char *fmt, ...)
{
	va_list args;
	char buffer[1024];

	va_start(args, fmt);
	(void) vsnprintf(buffer, sizeof(buffer), fmt, args);
	va_end(args);

	return printk("%s", buffer);
}
