#!/bin/sh
USERS="root"
if [ `whoami` != "root" ]; then
	USERS="${USERS} `whoami`"
fi

cd `dirname $0`
CURDIR=`pwd`
export LD_LIBRARY_PATH=${CURDIR}/../lib
# Must be able to resolve certutil's library dependencies in order to move on
if ldd ./certutil | grep "not found" > /dev/null ; then
	exit 1
fi

chmod -f 600 /etc/opt/Adaptec/SMBE/ssl.conf
chmod -f 600 /etc/opt/Adaptec/SMBE/ssl.conf~
cd /opt/Adaptec/SMBE/sbin; ./arcpd /ssl > /dev/null 2>&1
cd /opt/Adaptec/SMBE/bin
for u in ${USERS}; do
	HOME_DIR=`grep "^$u" /etc/passwd | cut -d':' -f6`
	[ -d ${HOME_DIR}/.mozilla ] && CERT_DIRS=`find ${HOME_DIR}/.mozilla -name "cert7.db" | sed "s,/cert7\.db,,"`
	[ -d ${HOME_DIR}/.netscape ] && CERT_DIRS2=`find ${HOME_DIR}/.netscape -name "cert7.db" | sed "s,/cert7\.db,,"`
	for d in ${CERT_DIRS} ${CERT_DIRS2}; do
		if [ ! -d "$d" ]; then
			exit 2
		fi

		# Do not add the certificate if it is already there
		if LD_LIBRARY_PATH=../lib ./certutil -L -d "$d" | grep "Adaptec-SM-localhost" > /dev/null; then
			continue
		fi

		# add Certificate
		sed -n '/BEGIN CERTIFICATE/ s,\\n,\
,g p' /opt/Adaptec/SMBE/etc/ssl.conf |grep -v '\-\-\-\-\-' | ./b64 -d /dev/stdin > /tmp/tmp.crt ; LD_LIBRARY_PATH=../lib ./certutil -d "$d" -A -n "Adaptec-SM-localhost" -t "PTC,," -i /tmp/tmp.crt
		rm -f /tmp/tmp.crt
	done
done
