#!/bin/sh
USERS="root"
if [ `whoami` != "root" ]; then
	USERS="${USERS} `whoami`"
fi

cd `dirname $0`
CURDIR=`pwd`
export LD_LIBRARY_PATH=${CURDIR}/../lib
# Must be able to resolve certutil's library dependencies in order to move on
if ldd ./certutil | grep "not found" > /dev/null ; then
	exit 1
fi

cd /opt/Adaptec/SMBE/bin
for u in ${USERS}; do
	HOME_DIR=`grep "^$u" /etc/passwd | cut -d':' -f6`
	[ -d ${HOME_DIR}/.mozilla ] && CERT_DIRS=`find ${HOME_DIR}/.mozilla -name "cert7.db" | sed "s,/cert7\.db,,"`
	[ -d ${HOME_DIR}/.netscape ] && CERT_DIRS2=`find ${HOME_DIR}/.netscape -name "cert7.db" | sed "s,/cert7\.db,,"`
	for d in ${CERT_DIRS} ${CERT_DIRS2}; do
		if [ ! -d "$d" ]; then
			exit 2
		fi

	LD_LIBRARY_PATH=../lib ./certutil -D -d "$d" -n "Adaptec-SM-localhost" > /dev/null 2>&1
	done
done
