
//-------------
// HintObj
//-------------

function HintObj()
{
	var c = (this.childNodes) ? this.childNodes : this.children;
	var h = c[2].offsetHeight + 8;
	c[0].style.clip = "rect(0,330," + h + ",0)";
	if (gIsNS6) c[0].childNodes[0].style.height=h + "px"; //BRIAN: NS6 doesn't clip the hint background
	c[1].style.top = h + "px";
	this.ySize = h + 12;

	this.Hide = ObjHide;
	this.Show = ObjShow;
	this.cleanColor="#fef7c3"; //BRIAN: NS6 doesn't paint the hint correctly.
}


//---------
// WizDivObj()
//---------

function WizDivObj()
{
	var c;
	var h;
	var s;
	if (this.childNodes) {
		c = this.childNodes;
		h = c[0].childNodes;
		s = c[3].childNodes;
	}
	else {
		c = this.children;
		h = c[0].children;
		s = c[3].children;
	}

	var i;
	var iMax = h.length;
	for (i=0; i<iMax; i++) {
		h[i].hintObj = HintObj;
		h[i].hintObj();
	}
	this.r0Hint = h[0];
	this.r1Hint = h[1];
	this.r5Hint = h[2];
	this.r10Hint = h[3];
	this.r50Hint = h[4];
	this.svHint = h[5];
	this.hsAssignHint = h[6];

	gStrLimited = s[0].innerHTML;
	gStrDrivesSel = s[1].innerHTML;
}

function GetWizDivObj(objName)
{
	var obj = GetPageElement(objName, false);
	if (obj) {
		obj.wizDivObj = WizDivObj;
		obj.wizDivObj();
	}

	return obj;
}

//---------
// WizObj()
//---------

var gWizObj = null;
var gWizDiv = null;
var gWizDeltaY = gIsNS6||gIsIE4?1000:25; //BRIAN: Only IE5 is fast enough for gradual wizard appearance.
var gWizDeltaX = gIsNS6||gIsIE4?1000:35; //BRIAN: Only IE5 is fast enough for gradual wizard appearance.

function WizObj(inOwner)
{
	this.myOwner = inOwner;

	var c;
	var i;
	var iMax;
	if (this.childNodes) {
		c = this.childNodes;
		this.myWizards = c[1].childNodes;
		this.myBtns = c[2].childNodes;
		this.myStrings = c[3].childNodes;
	}
	else {
		c = this.children;
		this.myWizards = c[1].children;
		this.myBtns = c[2].children;
		this.myStrings = c[3].children;
	}

	this.clipDiv = c[1];
	this.btnDiv = c[2];
	this.myBkgd = c[0];
	var bkgdX = this.myBkgd.offsetWidth;
	this.smallX = bkgdX;
	this.largeX = (bkgdX << 1) - 1;

	this.clipX = bkgdX;
	this.tgtX = bkgdX;
	this.clipY = 0;
	this.tgtY = 0;

	this.curCtlr = null;
	this.curWiz = null;

	c = this.myBtns;
	var xSpace = 15;

	i = c[0];
	this.prevBtn = i;
	i.btn2Obj = Btn2Obj;
	i.btn2Obj();
	i.myOwner = this;
	i.topImg.myObj = this;
	var leftPos = i.xSize + xSpace;

	i = c[1];
	this.cancelBtn = i;
	i.btn2Obj = Btn2Obj;
	i.btn2Obj();
	i.myOwner = this;
	i.topImg.myObj = this;
	iMax = leftPos + "px";
	i.style.left = iMax;
	leftPos += i.xSize + xSpace;

	i = c[2];
	this.nextBtn = i;
	i.btn2Obj = Btn2Obj;
	i.btn2Obj();
	i.eMouseOver(); // init the tool-tip for this button
	i.eMouseOut();
	i.myOwner = this;
	i.topImg.myObj = this;
	i.style.left = leftPos + "px";
	i.strA = this.myStrings;
	i.Invalid = NextBtnInvalid;
	i.RTRequired = NextBtnRTRequired;
	i.MinNumDrives = NextBtnMinNumDrives;
	i.MinArraySize = NextBtnMinArraySize;
	i.ArrayRequired = NextBtnArrayRequired;
	i.isContent = false;
	i.myText = (i.childNodes) ? i.myTip.myContent.childNodes[1] : i.myTip.myContent.children[1];

	i = c[3];
	this.finishBtn = i;
	i.btn2Obj = Btn2Obj;
	i.btn2Obj();
	i.myOwner = this;
	i.topImg.myObj = this;
	i.style.left = leftPos + "px";

	i = c[4];
	this.advBtn = i;
	i.btn2Obj = Btn2Obj;
	i.btn2Obj();
	i.topImg.myObj = this;
	i.style.left = bkgdX - this.btnDiv.offsetLeft - i.xSize - 10 + "px";

	this.btnDiv.ySize = this.prevBtn.ySize;
	this.btnPadTop = 4;
	this.btnPadBtm = 6;

	this.basicOverhead = this.btnPadTop + this.btnPadBtm + this.btnDiv.ySize + gIconHeight;

	this.myCreateWiz = this.myWizards[0];
	this.myCreateWiz.createWizObj = CreateWizObj;
	this.myCreateWiz.createWizObj(this);

	this.myDeleteWiz = this.myWizards[1];
	this.myDeleteWiz.deleteWizObj = DeleteWizObj;
	this.myDeleteWiz.deleteWizObj(this);

	this.mySpareWiz = this.myWizards[2];
	this.mySpareWiz.spareWizObj = SpareWizObj;
	this.mySpareWiz.spareWizObj(this);

	this.myModifyWiz = this.myWizards[3];
	this.myModifyWiz.modifyWizObj = ModifyWizObj;
	this.myModifyWiz.modifyWizObj(this);

	this.OpenWiz = WizObjOpenWiz;
	this.CloseWiz = WizObjCloseWiz;
	this.eClosed = WizObjHClosed;
	this.eAdvBtnClick = hAdvBtnClick;
}

function GetWizObj(objName, inOwner)
{
	var obj = GetPageElement(objName, false);
	if (obj) {
		obj.wizObj = WizObj;
		obj.wizObj(inOwner);
	}

	return obj;
}

function WizObjOpenWiz(ctlr, wiz)
{
	this.curCtlr = ctlr;
	this.curWiz = wiz;
	gAction = wiz.myAction;

	ctlr.SetWizPos(gWizDiv);
	wiz.Show(ctlr);

	var ySize = wiz.ySize;
	var obj = this.myBkgd;
	obj.style.height = ySize + "px";
	this.btnDiv.style.top = ySize - this.btnDiv.ySize - this.btnPadBtm + "px";
	this.tgtY = ySize + 2;
	this.clipDiv.style.clip = "rect(0," + this.clipX + "," + this.tgtY + ",0)";
	if (gIsIE4) wiz.parentElement.style.height=this.style.height="300px"; //BRIAN: IE4 doesn't size the wizard correctly.
}

function WizObjCloseWiz()
{
	if (this.curWiz) {
		this.curWiz.eCancel();
	}
}

function WizObjHClosed()
{
	gWizDiv.style.left = "-1000px";
	this.curWiz.Hide();
	this.curCtlr = null;
	this.curWiz = null;
	gAction = gActNone;
}


function hAdvBtnClick(evt)
{
	var a = this.advBtn;
	gCmdTipMgr.Stop(a);
	if (a.isOn) {
		this.tgtX = this.smallX;
		a.SetOff();
		a.myTip.SetContent(this.myStrings[0].innerHTML);
	}
	else {
		this.tgtX = this.largeX;
		a.SetOn();
		a.myTip.SetContent(this.myStrings[1].innerHTML);
	}
}

function NextBtnInvalid()
{
	this.myText.innerHTML = this.strA[2].innerHTML;
	this.myTip.SyncSize();
	this.isContent = true;
}

function NextBtnRTRequired()
{
	this.myText.innerHTML = this.strA[3].innerHTML;
	this.myTip.SyncSize();
	this.isContent = true;
}

function NextBtnArrayRequired()
{
	this.myText.innerHTML = this.strA[6].innerHTML;
	this.myTip.SyncSize();
	this.isContent = true;
}

function NextBtnMinNumDrives(inMin)
{
	var dStr = this.strA[4].innerHTML.split(gSepChar);

	if (dStr.length == 2) this.myText.innerHTML = dStr[0] + inMin + dStr[1];
	else this.myText.innerHTML = this.strA[4].innerHTML;

	this.myTip.SyncSize();
	this.isContent = true;
}

function NextBtnMinArraySize(inMin)
{
	var dStr = this.strA[5].innerHTML.split(gSepChar);

	if (dStr.length == 2) this.myText.innerHTML = dStr[0] + inMin + dStr[1];
	else this.myText.innerHTML = this.strA[5].innerHTML;

	this.myTip.SyncSize();
	this.isContent = true;
}

function CWNextCheck() // Attached to "nextBtn.eMouseOver()"
{
	this.isContent = false;
	var cw = this.myOwner.curWiz;

	if (cw.curStep == 1) {
		if (!cw.raidType) this.RTRequired();
	}
	else if (cw.curStep == 2) {
		if (cw.curSegs.numItems < cw.minNumSegs) this.MinNumDrives(cw.minNumSegs);
		else if (cw.capBlks < cw.minArraySize) this.MinArraySize(cw.minArraySize);
	}
	else {
		this.Invalid();
	}

	if (this.isContent) this.myTip.style.visibility = "inherit";
	else this.myTip.style.visibility = "hidden";
}

//----------------
// CreateWizObj()
//----------------

var gStrLimited = null;
var gStrDrivesSel = null;

function CreateWizObj(inOwner)
{
	this.myOwner = inOwner;
	this.curStep = 0;
	this.raidType = null;
	this.myAction = gActCreateLog;
	this.curSegs = new Array();
	this.capBlks = 0;
	this.blkLimit = 0;
	this.sumSegs = 0;
	this.minSeg = 0;
	this.prevRTindex = 100;
	this.numR5s = 0;
	this.minNumSegs = 0;
	this.minSegSize = 0;
	this.minArraySize = 0;

	var c;
	var tw;
	if (this.childNodes) {
		c = this.childNodes;
		this.myTitle = c[0].childNodes[0];
		tw = this.myTitle.childNodes[0].offsetWidth;
		this.myStatus = c[0].childNodes[1];
		this.myForm = c[1];
		c = this.myForm.childNodes;
	}
	else {
		c = this.children;
		this.myTitle = c[0].children[0];
		tw = this.myTitle.children[0].offsetWidth;
		this.myStatus = c[0].children[1];
		this.myForm = c[1];
		c = this.myForm.children;
	}

	this.myStatus.cwStatusObj = CWStatusObj;
	this.myStatus.cwStatusObj();
	this.myStatus.style.left = tw + 4 + "px";
	this.capDiv = this.myStatus.textDiv;

	this.myStep1 = c[1];
	this.myStep1.cwStep1Obj = CWStep1Obj;
	this.myStep1.cwStep1Obj(this);
	var maxY = this.myStep1.ySize;

	this.myStep2 = c[2];
	this.myStep2.cwStep2Obj = CWStep2Obj;
	this.myStep2.cwStep2Obj(this);
	if (this.myStep2.ySize > maxY) maxY = this.myStep2.ySize;

	this.myStep3 = c[3];
	this.myStep3.cwStep3Obj = CWStep3Obj;
	this.myStep3.cwStep3Obj(this);
	if (this.myStep3.ySize > maxY) maxY = this.myStep3.ySize;

	this.ss16 = this.myForm.stripesize.options[0];

	this.ySize = maxY + 5;
	this.dsName = null;

	this.ePrev = CWPrev;
	this.eCancel = CWCancel;
	this.eNext = CWNext;
	this.eFinish = CWFinish;
	this.eClose = CWClose;

	this.eDevClick = CWDevClick;
	this.eSegClick = CWSegClick;

	this.SelRType = CWSelRType;
	this.CapLimitClick = CWCapLimitClick;
	this.NumR5Change = CWNumR5Change;
	this.ToggleReadCache = CWTogRdCache;

	this.batDiv1 = GetPageElement("cwBat1");
	this.batDiv2 = GetPageElement("cwBat2");
	this.batDiv3 = GetPageElement("cwBat3");

	this.Hide = ObjHide;
	this.Show = CWShow;
	this.AddSeg = CWAddSeg;
	this.RemSeg = CWRemSeg;
	this.RecompSegs = CWRecompSegs;
	this.SetCap = CWSetCap;
	this.DeselAll = CWDeselAll;
	this.DeselAllBut1 = CWDeselAllBut1;
	this.DeselAllBut2 = CWDeselAllBut2;
	this.DeselDups = CWDeselDups;
	this.DeselAllBlink = CWDeselAllBlink;
	this.BlinkLast = CWBlinkLast;
	this.Cleanup = CWCleanup;

}

function CWCapLimitClick(inIndex, checkIt)
{
	if (checkIt) {
		this.myForm.captype[inIndex].checked = true;
	}
	if (inIndex == 0) {
		this.blkLimit = 0;
	}
	else {
		var t= 0;
		switch (parseInt(this.myForm.caplimitunits.value)) {
			case 10:
				t = 2048;
				break;
			case 20:
				t = 2097152;
				break;
			case 30:
				t = 2.1474836e9;
				break;
			case 40:
				t = 2.1990233e12;
				break;
		}
		var lim = parseFloat(this.myForm.caplimit.value);
		if (lim != lim) { // isNaN()
			this.blkLimit = 0;
			this.myForm.caplimit.value = "";
		}
		else {
			var bl = lim * t;
			if (bl < this.myOwner.curCtlr.minArraySize) {
				bl = 0;
				this.myForm.caplimit.value = "";
			}
			this.blkLimit = bl;
		}
	}

	this.SetCap();
}

function CWNumR5Change()
{
	this.numR5s = parseInt(this.myForm.numr5.value);
	if (!this.numR5s) {
		this.numR5s = 2;
	}
	this.minNumSegs = this.numR5s * 3;
	this.myStep2.minDiv.innerHTML = this.minNumSegs;

	this.SetCap();
}

function CWSelRType(inIndex, checkIt)
{
	if (checkIt) {
		this.myForm.rtype[inIndex].checked = true;
	}
	var obj = this.myStatus;

	obj.raid0.style.visibility = "hidden";
	obj.raid1.style.visibility = "hidden";
	obj.raid10.style.visibility = "hidden";
	obj.raid5.style.visibility = "hidden";
	obj.raid50.style.visibility = "hidden";
	obj.vol.style.visibility = "hidden";

	var s3 = this.myStep3;
	var s2 = this.myStep2;
	var s1 = this.myStep1;

	if (inIndex == 7) {
		if (this.prevRTindex != 7) {
			this.DeselAll(); // Switch from non-RV to RV
		}
	}
	else if (this.prevRTindex == 7) {
		this.DeselAll(); // Switch from RV to non-RV
	}
	else if ((inIndex != 6) && (this.prevRTindex == 6)) {
		this.DeselDups(); // Switch from SPV to other
	}

	if (this.prevRTindex < 100) s2.basicDivs[this.prevRTindex+1].style.display = "none";
	s2.basicDivs[inIndex+1].style.display = "block";

	var so = this.myForm.stripesize;
	if (so.options[0].value!="5") { if (gIsNS6) { so.add(this.ss16, so.options[0]); }else so.add(this.ss16, 0); }

	switch (inIndex) {
		case 0:
			obj.raid0.style.visibility = "inherit";
			this.raidType = "r0";
			this.minNumSegs = 2;
			s3.HideBuild();
			s2.ssOn();
			break;
		case 1:
			obj.raid1.style.visibility = "inherit";
			this.raidType = "r1";
			this.minNumSegs = 2;
			s3.ShowBuild();
			s3.qiR1.style.display = "inline";
			s3.qiR5.style.display = "none";
			s2.ssOff();
			this.DeselAllBut2();
			break;
		case 2:
			obj.raid10.style.visibility = "inherit";
			this.raidType = "r10";
			this.minNumSegs = 4;
			s3.ShowBuild();
			s3.qiR1.style.display = "inline";
			s3.qiR5.style.display = "none";
			s2.ssOn();
			var s210 = (s2.basicDivs[3].childNodes) ? s2.basicDivs[3].childNodes : s2.basicDivs[3].children;
			if (this.myOwner.curCtlr.ctlrFlags & 0x400) {
				s210[0].style.display = "none";
				s210[1].style.display = "block";
			}
			else {
				s210[0].style.display = "block";
				s210[1].style.display = "none";
			}
			if (this.myOwner.curCtlr.ctlrFamily==0) so.remove(0);
			break;
		case 3:
			obj.raid5.style.visibility = "inherit";
			this.raidType = "r5";
			this.minNumSegs = 3;
			s3.ShowBuild();
			s3.qiR1.style.display = "none";
			s3.qiR5.style.display = "inline";
			s2.ssOn();
			break;
		case 4:
			obj.raid50.style.visibility = "inherit";
			this.raidType = "r50";
			this.numR5s = parseInt(this.myForm.numr5.value);
			if (!this.numR5s) {
				this.numR5s = 2;
			}
			this.minNumSegs = this.numR5s * 3;
			s3.ShowBuild();
			s3.qiR1.style.display = "none";
			s3.qiR5.style.display = "inline";
			s2.ssOn();
			break;
		case 5:
			obj.vol.style.visibility = "inherit";
			this.raidType = "sv";
			this.minNumSegs = 1;
			this.DeselAllBut1();
			s3.HideBuild();
			s2.ssOff();
			break;
		case 6:
			obj.vol.style.visibility = "inherit";
			this.raidType = "spv";
			this.minNumSegs = 2;
			s3.HideBuild();
			s2.ssOff();
			break;
		case 7:
			obj.vol.style.visibility = "inherit";
			this.raidType = "rv";
			this.minNumSegs = 2;
			s3.HideBuild();
			s2.ssOff();
			break;
	}

	this.prevRTindex = inIndex;

	this.SetCap();
}

function CWBlinkLast(inNum)
{
	if (inNum) {
		var iMax = this.curSegs.numItems;
		if (inNum > iMax) {
			inNum = iMax;
		}
		var numNoBlink = iMax - inNum;
		var i;
		var cs = this.curSegs;
		for (i=0; i < iMax; i++) {
		if (i < numNoBlink) cs[i].StopBlink();
		else cs[i].StartBlink();
		}
	}
}

function CWTogRdCache()
{
	var obj = this.myForm.rdcache;
	if (obj.checked) obj.checked = false;
	else obj.checked = true;
}

function forceRepaint(dirtyElement,cleanColor) //BRIAN: NS6 doesn't paint the wizard correctly.
{
	if (!gIsNS6)
	return;
	var elementStyle=dirtyElement.style;
	elementStyle.backgroundColor="cyan";
	elementStyle.backgroundColor=cleanColor;
}

function CWNext()
{
	var nb = this.myOwner.nextBtn;
	if (nb.isContent) return;

	if (this.curStep == 1) {
		this.myStep1.Hide();
		this.myStep2.Show();
	}
	else {
		nb.eMouseOver(); // In case the user just keeps clicking (no mouseover event generated since the mouse never left the "Next" button)
		if (nb.isContent) return;

		this.DeselAllBlink();
		this.SetCap();
		this.myStep2.Hide();
		this.myStep3.Show();
	}
	if (gIsNS6) forceRepaint(GetPageElement("wiz").childNodes[0],"#fef7c3"); //BRIAN: NS6 doesn't paint the wizard correctly.
}

function CWPrev()
{
	if (this.curStep == 2) {
		this.myStep2.Hide();
		this.myStep1.Show();
	}
	else if (this.curStep == 3) {
		this.myStep3.Hide();
		this.myStep2.Show();
	}
	else {
		gInfoBox.Reminder(gInfoBox.cwAlerts[11]); //alert("*** TEMP ALERT ***\nInvalid Previous Step");
	}
	if (gIsNS6) forceRepaint(GetPageElement("wiz").childNodes[0],"#fef7c3"); //BRIAN: NS6 doesn't paint the wizard correctly.
}

function CWCancel()
{
	var bQuit = false;
	if (this.curStep == 100) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[12]); //alert("***TEMP ALERT***\nYou cannot close Create Array when an array is being created in hardware.");
	}
	else {
		//bQuit = confirm("Click 'OK' if you are sure you want to leave the array creation wizard");
		//if (bQuit) {
			gWizObj.curCtlr.logMgr.createBtn.SetOff();
			gWizObj.tgtY = 0;
			gWizObj.curWiz.DeselAll();
			this.Cleanup();
		//}
	}

	return bQuit;
}

function CWCleanup()
{
	this.myStep2.ssOn();

	var i;
	var c = this.myStep2.basicDivs;
	var iMax = c.length;
	for (i=1; i<iMax; i++) c[i].style.display = "none";

	this.myStep3.adv1.style.display = "none";
	this.myStep3.adv2.style.display = "none";
}

function CWClose()
{
	this.curStep = 10;
	gWizObj.curCtlr.logMgr.createBtn.SetOff();
	gWizObj.finishBtn.SetOff();
	gWizObj.tgtY = 0;
	this.DeselAll();
	this.Cleanup();
}

function CWFinish()
{
	var wiz = this.myOwner;
	wiz.finishBtn.SetOn();

	gInfoBox.ReqSubmitting(gInfoBox.cwReqMsgs, 1);

	var i;
	var iMax = this.curSegs.numItems;
	var compStr = "";
	for (i=0; i<iMax; i++) {
		seg = this.curSegs[i];
		compStr += "#" + seg.myOwner.smbeId + "," + seg.startBlock + "," + seg.numBlocks;
	}
	this.myForm.ctlrObj.value = gWizObj.curCtlr.smbeId;
	this.myForm.expandObj.value = 0;
	this.myForm.comps.value = compStr;
	this.myForm.spares.value = "";

	gSubmitReq = gCWSubmitReq; // post the submit request
}

function CWShow(inCtlr)
{
	this.myStatus.Init();
	this.myForm.reset();
	this.myStep2.Hide();
	this.myStep3.Hide();
	this.myStep1.Show();
	this.raidType = null;
	this.blkLimit = 0;
	this.prevRTindex = 100;
	this.sumSegs = 0;
	this.minSeg = 0;
	this.minNumSegs = 0;
	this.dsName = null;

	var adv1 = false;
	var caps = inCtlr.raidTypes;
	// RAID-0
	var obj = GetPageElement("cwr0_row");
	if (caps & 0x0001) obj.style.display = "block";
	else obj.style.display = "none";
	// RAID-1
	obj = GetPageElement("cwr1_row");
	if (caps & 0x0002) {
		obj.style.display = "block";
		// RAID-10
		if (caps & 0x0200) {
			obj = GetPageElement("cwr10_1");
			obj.style.visibility = "inherit";
			obj = GetPageElement("cwr10_2");
			obj.style.visibility = "inherit";
			obj = GetPageElement("cwr10_3");
			obj.style.visibility = "inherit";
		}
		else {
			obj = GetPageElement("cwr10_1");
			obj.style.visibility = "hidden";
			obj = GetPageElement("cwr10_2");
			obj.style.visibility = "hidden";
			obj = GetPageElement("cwr10_3");
			obj.style.visibility = "hidden";
		}
	}
	else obj.style.display = "none";
	// RAID-5
	obj = GetPageElement("cwr5_row");
	if (caps & 0x0020) {
		obj.style.display = "block";
		// RAID-50
		if (caps & 0x0400) {
			obj = GetPageElement("cwr50_1");
			obj.style.visibility = "inherit";
			obj = GetPageElement("cwr50_2");
			obj.style.visibility = "inherit";
			obj = GetPageElement("cwr50_3");
			obj.style.visibility = "inherit";
		}
		else {
			obj = GetPageElement("cwr50_1");
			obj.style.visibility = "hidden";
			obj = GetPageElement("cwr50_2");
			obj.style.visibility = "hidden";
			obj = GetPageElement("cwr50_3");
			obj.style.visibility = "hidden";
		}
	}
	else obj.style.display = "none";
	// Simple Volume
	obj = GetPageElement("cwsv_row");
	if (caps & 0x1000) obj.style.display = "block";
	else obj.style.display = "none";
	// Spanned Volume
	obj = GetPageElement("cwspv_row");
	if (caps & 0x2000) {
		adv1 = true;
		obj.style.display = "block";
		obj = GetPageElement("cwspv_title");
		obj.style.display = "block";
		// RAID Volume
		if (caps & 0x4000) {
			obj = GetPageElement("cwrv_1");
			obj.style.visibility = "inherit";
			obj = GetPageElement("cwrv_2");
			obj.style.visibility = "inherit";
		}
		else {
			obj = GetPageElement("cwrv_1");
			obj.style.visibility = "hidden";
			obj = GetPageElement("cwrv_2");
			obj.style.visibility = "hidden";
		}
	}
	else {
		obj.style.display = "none";
		obj = GetPageElement("cwspv_title");
		obj.style.display = "none";
	}

	caps = inCtlr.ctlrFlags;
	obj = GetPageElement("cw_cache");
	if (caps & 0x80) {
		adv1 = true;
		obj.style.display = "block";
	}
	else obj.style.display = "none";

	obj = GetPageElement("cw_noadv1");
	if (adv1) obj.style.display = "none";
	else obj.style.display = "block";

	obj = GetPageElement("cw_limit");
	if (caps & 0x0100) {
		obj.style.display = "block";
		this.myStep2.isLimit = true;
	}
	else {
		obj.style.display = "none";
		this.myStep2.isLimit = false;
	}

	caps = inCtlr.buildCaps;
	obj = GetPageElement("cwBuild");
	var defInit = true;
	if (caps & 0x0001) {
		obj.style.display = "block";
		if (defInit) this.myForm.inittype[0].checked = true;
		defInit = false;
	}
	else obj.style.display = "none";
	obj = GetPageElement("cwClear");
	if (caps & 0x0002) {
		obj.style.display = "block";
		if (defInit) this.myForm.inittype[1].checked = true;
		defInit = false;
	}
	else obj.style.display = "none";
	obj = GetPageElement("cwQuick");
	if (caps & 0x0004) {
		obj.style.display = "block";
		if (defInit) this.myForm.inittype[2].checked = true;
		defInit = false;
	}
	else obj.style.display = "none";

	this.minSegSize = inCtlr.minSegSize;
	this.minArraySize = inCtlr.minArraySize;
	if (inCtlr.showBattery) {
		this.batDiv1.style.display = "none";
		this.batDiv2.style.display = "block";
		this.batDiv3.style.display = "block";
	}
	else {
		this.batDiv1.style.display = "block";
		this.batDiv2.style.display = "none";
		this.batDiv3.style.display = "none";
	}

	obj = GetPageElement("cwRdCache1");
	if (obj) obj.style.visibility = (inCtlr.ctlrFamily == 1) ? "hidden" : "inherit";

	obj = GetPageElement("cwRdCache2");
	if (obj) obj.style.visibility = (inCtlr.ctlrFamily == 1) ? "hidden" : "inherit";

	this.myOwner.nextBtn.eMouseOver = CWNextCheck;

	var so = this.myForm.stripesize;
	if (so.options[0].value!="5") { if (gIsNS6) so.add(this.ss16, so.options[0]); else so.add(this.ss16, 0); }

	this.style.visibility = "inherit";
}

function CWDevClick(dev)
{
	var c = true;

	if (dev.devType) return;

	if (this.curStep > 2) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[0]); //alert("***TEMP Reminder***\nYou must go to Step 1 or Step 2 to select drives.");
		return;
	}
	else if (dev.myCtlr != gWizObj.curCtlr) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[1]);//alert("***TEMP Reminder***\nCreate array is in progress on another controller.\nYou must select drives on the active controller to include them in the array.");
		return;
	}

	if (dev.numUsedSegs >= dev.myCtlr.maxUsedSegs) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[15]); //alert("***TEMP Reminder***\nThis drive is already used by the maximum number of arrays allowed per drive.");
		return;
	}


	if (dev.logType != "none") {
		if (this.raidType != "rv") {
			c = false;
		}
		else if (!this.curSegs.numItems) {
			if ((dev.logType != "r0") && (dev.logType != "r1") && (dev.logType != "r5")) {
				gInfoBox.Reminder(gInfoBox.cwAlerts[2]); //alert("***TEMP Reminder***\nRAID volumes can only be composed of RAID-0, RAID-1, and RAID-5 arrays.");
				c = false;
			}
		}
		else if (dev.logType != this.curSegs[0].myOwner.logType) {
			gInfoBox.Reminder(gInfoBox.cwAlerts[3]); //alert("***TEMP Reminder***\nRAID volumes must be composed of similar RAID type arrays. You have already selected one or more arrays of a different RAID type.");
			c = false;
		}
	}
	else if (this.raidType == "rv") {
		gInfoBox.Reminder(gInfoBox.cwAlerts[4]); //alert("***TEMP Reminder***\nYou must click array icons to create a RAID volume.");
		c = false;
	}
	else if (dev.isSpare) {
		//c = confirm("Caution: You clicked a hot-spare device.\nIncluding the hot-spare in the array may cause other logical drives to no longer be protected by the hot-spare.  Click 'OK' if you are sure you want to include the hot-spare in the array.");
		gInfoBox.Reminder(gInfoBox.cwAlerts[5]); //alert("***TEMP Reminder***\nHot-spare drives can not be included in arrays.");
		c = false;
	}
	else if (this.dsName && (this.dsName != dev.dsName)) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[14]);
		c = false;
	}

	if (c) {
		var seg = dev.bigFree;
		if (!seg) {
			gInfoBox.Reminder(gInfoBox.cwAlerts[6]); //alert("*** TEMP ALERT ***\nThis device has no free space");
		}
		else if (seg.numBlocks < this.minSegSize) {
			gInfoBox.Reminder(gInfoBox.cwAlerts[7]); //alert("*** TEMP ALERT ***\nThis drive does not have enough free space to use in an array.");
		}
		else {
			var rs = dev.rselSegs;
			if ((this.raidType == "sv") && (this.curSegs.numItems)) {
				var curSeg = this.curSegs[0];
				this.RemSeg(curSeg);
				if (curSeg != seg) {
					this.AddSeg(seg);
				}
			}
			else if (rs.numItems) {
				do {
					this.RemSeg(rs[0], true);
				} 
				while (rs.numItems);
				this.RecompSegs();
			}
			else {
				if ((this.raidType == "r1") && (this.curSegs.numItems >= 2)) this.RemSeg(this.curSegs[0]);
				this.AddSeg(seg);
			}

			this.SetCap();
		}
	}
}

function CWSegClick(seg)
{
	var c = true;
	var dev = seg.myOwner;

	if (seg.segType != 0) { // if not available segment type
		return;
	}
	else if (dev.myCtlr != gWizObj.curCtlr) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[1]); //alert("***TEMP Reminder***\nCreate array is in progress on another controller.\nYou must select drives on the active controller to include them in the array.");
		return;
	}

	if (dev.numUsedSegs >= dev.myCtlr.maxUsedSegs) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[15]); //alert("***TEMP Reminder***\nThis drive is already used by the maximum number of arrays allowed per drive.");
		return;
	}

	if (this.curStep > 2) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[8]); //alert("***TEMP Reminder***\nYou must go to Step 1 or Step 2 to select segments.");
		c = false;
	}
	else if (dev.isSpare) {
		//c = confirm("Caution: You clicked a hot-spare segment.\nIncluding the hot-spare in the array may cause other logical drives to no longer be protected by the hot-spare.  Click 'OK' if you are sure you want to include the hot-spare in the array.");
		gInfoBox.Reminder(gInfoBox.cwAlerts[9]); //alert("***TEMP Reminder***\nHot-spare segments can not be included in arrays.");
		c = false;
	}
	else if (this.raidType == "rv") {
		gInfoBox.Reminder(gInfoBox.cwAlerts[4]); //alert("***TEMP Reminder***\nYou must click array icons to create a RAID Volume");
		c = false;
	}
	else if (seg.numBlocks < this.minSegSize) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[10]); //alert("*** TEMP ALERT ***\nThis segment is not large enough to use in an array.");
		c = false;
	}
	else if (this.dsName && (this.dsName != dev.dsName)) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[14]);
		c = false;
	}

	if (c) {
		var curSeg = null;
		var rs = dev.rselSegs;
		if ((this.raidType == "sv") && (this.curSegs.numItems)) {
			curSeg = this.curSegs[0];
			this.RemSeg(curSeg);
		}
		else if (rs.numItems) {
			//if (this.raidType != "spv") {
				curSeg = rs[0];
				this.RemSeg(curSeg);
			//}
			//else {
			//	for (i=0; i<rs.numItems; i++) {
			//		if (rs[i] == seg) {
			//			curSeg = seg;
			//			this.RemSeg(curSeg);
			//			break;
			//		}
			//	}
			//}
		}
		else if ((this.raidType == "r1") && (this.curSegs.numItems >= 2)) {
			this.RemSeg(this.curSegs[0]);
		}
		if (curSeg != seg) {
			this.AddSeg(seg);
		}
		this.SetCap();
	}
	
}

function CWAddSeg(seg)
{
	this.curSegs.Append(seg);

	var dev = seg.myOwner;
	var iobj = dev.myIcon;
	dev.rselSegs.Append(seg);

	if (this.curSegs.numItems==1) this.dsName = dev.dsName;

	iobj.RSelOn();
	if (seg.myIcon) seg.myIcon.RSelOn();

	if (!this.minSeg) this.minSeg = seg.numBlocks;
	else if (seg.numBlocks < this.minSeg) this.minSeg = seg.numBlocks;

	if (this.curSegs.numItems < this.minNumSegs) seg.StartBlink();

	this.sumSegs += seg.numBlocks;
}

function CWRemSeg(seg, noRecomp)
{
	if (seg.myIcon) seg.myIcon.RSelOff();
	this.curSegs.Remove(seg);

	var dev = seg.myOwner;
	dev.rselSegs.Remove(seg);
	if (!dev.rselSegs.numItems) dev.myIcon.RSelOff();

	if (this.curSegs.numItems==0) this.dsName = null;

	if (!noRecomp) this.RecompSegs();
}

function CWRecompSegs()
{
	var i;
	var iMax = this.curSegs.numItems;
	this.minSeg = 0;
	this.sumSegs = 0;
	if (iMax) {
		var nb = this.curSegs[0].numBlocks;
		this.minSeg = nb;
		this.sumSegs = nb;
		for (i=1; i < iMax; i++) {
			nb = this.curSegs[i].numBlocks;
			this.sumSegs += nb;
			if (nb < this.minSeg) {
				this.minSeg = nb;
			}
		}
	}
}

function CWSetCap()
{
	var cs = this.curSegs;
	var ni = cs.numItems;
	var cap = 0;

	var i;

	if (ni >= this.minNumSegs) {
		var blinkNone = true;

		switch (this.raidType) {
			case "r0":
				cap = this.minSeg * ni;
				break;
			case "r1":
			case "r10":
				cap = this.minSeg * (ni >> 1);
				if (ni & 0x1) {
					this.BlinkLast(1);
					blinkNone = false;
				}
				break;
			case "r5":
				cap = this.minSeg * (ni - 1);
				break;
			case "r50":
				cap = this.minSeg * (ni - this.numR5s);
				var odd = ni % this.numR5s;
				if (odd) {
					this.BlinkLast(odd);
					blinkNone = false;
				}
				break;
			case "sv":
				cap = this.minSeg;
				break;
			case "spv":
				cap = this.sumSegs;
				break;
			case "rv":
				cap = this.sumSegs;
				break;
		}
		if (blinkNone) for (i=0; i < ni; i++) cs[i].StopBlink();
	}
	else for (i=0; i < ni; i++) cs[i].StartBlink();

	var qualStr = "";
	if (this.blkLimit && (cap > this.blkLimit)) {
		qualStr = "(" + gStrLimited + ")";
		cap = this.blkLimit;
	}
	this.capBlks = cap;
	var capStr = "<b>" + GetCapStr(cap) + "</b> " + qualStr + ", " + gStrDrivesSel;
	capStr = capStr.split("^");
	this.capDiv.innerHTML = capStr[0] + ni.toString();
	if (capStr.length > 1) this.capDiv.innerHTML += capStr[1];
}

function CWDeselAll()
{
	var cs = this.curSegs;
	while (cs.numItems) this.RemSeg(cs[0], true);
	this.minSeg = 0;
	this.sumSegs = 0;
}

function CWDeselAllBlink()
{
	var cs = this.curSegs;
	for (i=0; i < cs.numItems; i++) {
		if (cs[i].isBlinking) {
			do {
				this.RemSeg(cs[i], false);
			} 
		while (i < cs.numItems);
		}
	}
	this.RecompSegs();
}

function CWDeselAllBut1()
{
	var cs = this.curSegs;
	if (cs.numItems > 1) {
		while (cs.numItems > 1) {
			this.RemSeg(cs[0], true);
		}
		this.minSeg = cs[0].numBlocks;
		this.sumSegs = cs[0].numBlocks;
	}
}

function CWDeselAllBut2()
{
	var cs = this.curSegs;
	if (cs.numItems > 2) {
		while (cs.numItems > 2) {
			this.RemSeg(cs[0], true);
		}
		var sz0 = cs[0].numBlocks;
		var sz1 = cs[1].numBlocks;
		this.minSeg = sz0;
		if (sz1 < this.minSeg) this.minSeg = sz1;
		this.sumSegs = sz0 + sz1;
	}
}

function CWDeselDups()
{
	var cs = this.curSegs;
	var rs;
	var i;
	var dupFound;
	do {
		dupFound = false;
		for (i=0; i<cs.numItems; i++) {
			rs = cs[i].myOwner.rselSegs;
			if (rs.numItems > 1) {
				dupFound = true;
				while (rs.numItems > 1) {
					this.RemSeg(rs[0], true);
				}
				break;
			}
		}
	} 
	while (dupFound);

	this.RecompSegs();
}

//----------------
// CWStep1Obj()
//----------------

function CWStep1Obj(inOwner)
{
	this.myOwner = inOwner;
	this.isInit = false;

	var c = (this.childNodes) ? this.childNodes : this.children;

	var wiz = inOwner.myOwner;

	var bsz = c[0].offsetHeight + wiz.basicOverhead;
	var asz = c[1].offsetHeight + wiz.btnPadBtm;
	if (bsz > asz) this.ySize = bsz;
	else this.ySize = asz;

	this.Show = CWStep1Show;
	this.Hide = ObjHide;
}

function CWStep1Show()
{
	this.myOwner.curStep = 1;
	gWizObj.prevBtn.style.visibility = "hidden";
	gWizObj.cancelBtn.style.visibility = "inherit";
	gWizObj.nextBtn.style.visibility = "inherit";
	gWizObj.advBtn.style.visibility = "inherit";
	gWizObj.finishBtn.style.visibility = "hidden";
	this.style.visibility = "inherit";

	if (gIsNS6) {
		gWizObj.ns6CWTbl = this.childNodes[0].childNodes[1];
		window.setTimeout("CWStep1NS6Init()", 250);
	}
}

function CWStep1NS6Init() {
	gWizObj.ns6CWTbl.style.visibility = "inherit";
	gWizObj.ns6CWTbl.style.display = "block";
}

//----------------
// CWStep2Obj()
//----------------

function CWStep2Obj(inOwner)
{
	this.myOwner = inOwner;

	if (this.childNodes) {
		this.basicDivs = this.childNodes[0].childNodes;
	}
	else {
		this.basicDivs = this.children[0].children;
	}

	this.ssDiv = GetPageElement("cwSSDiv");
	this.minDiv = GetPageElement("cwR50Min");
	this.noAdv = GetPageElement("cw_noadv2");
	this.isLimit = true;

	this.ySize = 0;

	this.Show = CWStep2Show;
	this.Hide = ObjHide;
	this.ssOn = CWSSOn;
	this.ssOff = CWSSOff;
}

function CWStep2Show()
{
	this.myOwner.curStep = 2;
	gWizObj.prevBtn.style.visibility = "inherit";
	gWizObj.cancelBtn.style.visibility = "inherit";
	gWizObj.nextBtn.style.visibility = "inherit";
	gWizObj.finishBtn.style.visibility = "hidden";
	this.style.visibility = "inherit";
}

function CWSSOn()
{
	this.ssDiv.style.display = "block";
	this.noAdv.style.display = "none";
}

function CWSSOff()
{
	this.ssDiv.style.display = "none";
	if (this.isLimit) this.noAdv.style.display = "none";
	else this.noAdv.style.display = "block";
}

//----------------
// CWStep3Obj()
//----------------

function CWStep3Obj(inOwner)
{
	this.myOwner = inOwner;

	var c = (this.childNodes) ? this.childNodes : this.children;

	this.adv1 = c[1];
	this.adv2 = c[2];
	this.qiR1 = GetPageElement("qinitr1");
	this.qiR5 = GetPageElement("qinitr5");

	this.ySize = 0;

	this.Show = CWStep3Show;
	this.Hide = ObjHide;
	this.ShowBuild = CWStep3ShowBuild;
	this.HideBuild = CWStep3HideBuild;
}

function CWStep3Show()
{
	this.myOwner.curStep = 3;
	gWizObj.prevBtn.style.visibility = "inherit";
	gWizObj.cancelBtn.style.visibility = "inherit";
	gWizObj.nextBtn.style.visibility = "hidden";
	gWizObj.finishBtn.style.visibility = "inherit";
	this.style.visibility = "inherit";

	if (gIsNS6) {
		var f=this.myOwner.myForm.aname;
		var v=f.value;
		f.value="Text box fix";
		f.value=v;
	}
}

function CWStep3ShowBuild()
{
	this.adv1.style.display = "block";
	this.adv2.style.display = "none";
}

function CWStep3HideBuild()
{
	this.adv1.style.display = "none";
	this.adv2.style.display = "block";
}

//----------------
// CWStatusObj()
//----------------

function CWStatusObj(inOwner)
{
	this.myOwner = inOwner;

	var c;
	if (this.childNodes) {
		c = this.childNodes;
		this.textDiv = c[0].childNodes[0];
	}
	else {
		c = this.children;
		this.textDiv = c[0].children[0];
	}

	this.icon = c[1];
	this.raid0 = c[2];
	this.raid1 = c[3];
	this.raid5 = c[4];
	this.raid10 = c[5];
	this.raid50 = c[6];
	this.vol = c[7];
	this.prot = c[8];

	this.Init = CWStatusInit;
}

function CWStatusInit(inOwner)
{
	this.raid0.style.visibility = "hidden";
	this.raid1.style.visibility = "hidden";
	this.raid5.style.visibility = "hidden";
	this.vol.style.visibility = "hidden";
	this.raid10.style.visibility = "hidden";
	this.raid50.style.visibility = "hidden";
	this.prot.style.visibility = "hidden";
	this.textDiv.innerHTML = "";
}

//----------------
// DeleteWizObj()
//----------------

function DeleteWizObj(inOwner)
{
	this.myOwner = inOwner;
	this.curStep = 0;

	this.myAction = gActDeleteLog;
	this.logList = new Array();
	this.spareList = new Array();
	this.devCntr = 0;

	var c;
	if (this.childNodes) {
		c = this.childNodes;
		this.myTitle = c[0].childNodes[0];
		this.myForm = c[1];
		c = this.myForm.childNodes;
	}
	else {
		c = this.children;
		this.myTitle = c[0].children[0];
		this.myForm = c[1];
		c = this.myForm.children;
	}

	this.warnText = "WARNING: The following logical drives will be deleted:"; // Note: This is just the default text, the actual message is internationalized
	this.myStep1 = c[1];
	this.myStep1.dwStep1Obj = DWStep1Obj;
	this.myStep1.dwStep1Obj(this);
	var maxY = this.myStep1.ySize;

	this.ySize = maxY + 5;

	this.ePrev = DWPrev;
	this.eCancel = DWCancel;
	this.eNext = DWNext;
	this.eFinish = DWFinish;
	this.eClose = DWClose;

	this.eDevClick = DWDevClick;
	this.eSegClick = DWSegClick;

	this.Cleanup = DWCleanup;

	this.Show = DWShow;
	this.Hide = ObjHide;
}

function DWShow(inCtlr)
{
	this.myForm.reset();
	this.logList.RemoveAll();
	this.spareList.RemoveAll();
	this.devCntr = 0;

	this.myStep1.Show();
	this.style.visibility = "inherit";
}

function DWPrev() { }
function DWNext() { }
function DWSegClick() { }

function DWCancel()
{
	gWizObj.curCtlr.logMgr.deleteBtn.SetOff();
	gWizObj.tgtY = 0;
	this.Cleanup();

	return true;
}

function DWFinish()
{
	var i;
	var c = this.logList;
	var cMax = c.numItems;
	var s = this.spareList;
	var sMax = s.numItems;
	var warnStr = this.warnText + "\n";
	for (i=0; i<cMax; i++) warnStr += c[i].myIcon.myText.innerHTML + "\n";
	for (i=0; i<sMax; i++) warnStr += s[i].myIcon.myText.innerHTML + "\n";
	if (!confirm(warnStr)) return this.eCancel();

	var wiz = this.myOwner;
	wiz.finishBtn.SetOn();

	gInfoBox.ReqSubmitting(gInfoBox.dwReqMsgs, 1);

	var devStr = "";
	for (i=0; i<cMax; i++) devStr += "#" + c[i].smbeId;
	this.myForm.logicals.value = devStr;

	devStr = "";
	for (i=0; i<sMax; i++) devStr += "#" + s[i].smbeId;
	this.myForm.spares.value = devStr;

	this.myForm.ctlrObj.value = wiz.curCtlr.smbeId;

	gSubmitReq = gDWSubmitReq; // post the submit request
}

function DWClose()
{
	this.curStep = 10;
	gWizObj.curCtlr.logMgr.deleteBtn.SetOff();
	gWizObj.finishBtn.SetOff();
	gWizObj.tgtY = 0;
	this.Cleanup();
}

function DWDevClick(dev)
{
	if (dev.myCtlr != this.myOwner.curCtlr) {
		gInfoBox.Reminder(gInfoBox.dwAlerts[0]); //alert("***TEMP Reminder***\nDelete logical device is in progress on another controller.\nYou must select drives on the active controller to delete them.");
		return;
	}

	if (dev.logType != "none") {
		if (dev.isSecLevel) {
			gInfoBox.Reminder(gInfoBox.dwAlerts[1]); //alert("***TEMP ALERT***\nYou cannot delete a second level array directly.  You must delete the top level array to which this second level array belongs.");
			return;
		}
		if (dev.myIcon.isDelOn) {
			this.logList.Remove(dev);
			dev.myIcon.DelOff();
			dev.CompsDelOff();
			this.devCntr--;
		}
		else {
			if (dev.hasPart) if (!confirm(gInfoBox.dwAlerts[3].innerHTML)) return;
			this.logList.Append(dev);
			dev.myIcon.DelOn();
			dev.CompsDelOn();
			this.devCntr++;
		}
	}
	else if (dev.isSpare) {
		if (dev.myIcon.isDelOn) {
			this.spareList.Remove(dev);
			dev.myIcon.DelOff();
			dev.CompsDelOff();
			this.devCntr--;
		}
		else {
			this.spareList.Append(dev);
			dev.myIcon.DelOn();
			dev.CompsDelOn();
			this.devCntr++;
		}
	}

	if (this.devCntr == 1) this.myOwner.finishBtn.Show();
	else if (!this.devCntr) this.myOwner.finishBtn.Hide();
}

function DWCleanup()
{
	var i;
	var c = this.logList;
	var iMax = c.numItems;
	for (i=0; i<iMax; i++) {
		c[i].myIcon.DelOff();
		c[i].CompsDelOff();
	}

	c = this.spareList;
	iMax = c.numItems;
	for (i=0; i<iMax; i++) {
		c[i].myIcon.DelOff();
		c[i].CompsDelOff();
	}
}


//----------------
// DWStep1Obj()
//----------------

function DWStep1Obj(inOwner)
{
	this.myOwner = inOwner;

	var c;
	if (this.childNodes) {
		c = this.childNodes;
		inOwner.warnText = c[0].childNodes[2].innerHTML;
	}
	else {
		c = this.children;
		inOwner.warnText = c[0].children[2].innerHTML;
	}

	var wiz = inOwner.myOwner;
	this.ySize = c[0].offsetHeight + wiz.basicOverhead;

	this.Show = DWStep1Show;
	this.Hide = ObjHide;
}

function DWStep1Show()
{
	this.myOwner.curStep = 1;

	gWizObj.prevBtn.style.visibility = "hidden";
	gWizObj.cancelBtn.style.visibility = "inherit";
	gWizObj.nextBtn.style.visibility = "hidden";
	gWizObj.advBtn.style.visibility = "hidden";
	gWizObj.finishBtn.style.visibility = "hidden";

	this.style.visibility = "inherit";
}

//-------------------------
// SpareWizObj()
//-------------------------

function SpareWizObj(inOwner)
{
	this.myOwner = inOwner;
	this.curStep = 0;

	this.myAction = gActSpare;
	this.assignList = new Array();
	this.delList = new Array();
	this.newList = new Array();
	this.devCntr = 0;

	var c;
	var tw;
	if (this.childNodes) {
		c = this.childNodes;
		this.myTitle = c[0].childNodes[0];
		tw = this.myTitle.childNodes[0].offsetWidth;
		this.myStatus = c[0].childNodes[1];
		this.myForm = c[1];
		c = this.myForm.childNodes;
	}
	else {
		c = this.children;
		this.myTitle = c[0].children[0];
		tw = this.myTitle.children[0].offsetWidth;
		this.myStatus = c[0].children[1];
		this.myForm = c[1];
		c = this.myForm.children;
	}

	this.myStatus.style.left = tw + 4 + "px";

	this.myStep1 = c[1];
	this.myStep1.swStep1Obj = SWStep1Obj;
	this.myStep1.swStep1Obj(this);
	var maxY = this.myStep1.ySize;

	this.ySize = maxY + 5;

	this.ePrev = SWPrev;
	this.eCancel = SWCancel;
	this.eNext = SWNext;
	this.eFinish = SWFinish;
	this.eClose = SWClose;

	this.eDevClick = SWDevClick;
	this.eSegClick = SWSegClick;

	this.Cleanup = SWCleanup;

	this.CheckNew = SWCheckNew;

	this.Show = SWShow;
	this.Hide = ObjHide;
}

function SWShow(inCtlr)
{
	this.myForm.reset();
	this.assignList.RemoveAll();
	this.delList.RemoveAll();
	this.newList.RemoveAll();
	this.devCntr = 0;

	this.myStep1.Show(inCtlr);
	this.style.visibility = "inherit";
}

function SWPrev() { }
function SWNext() { }
function SWSegClick() { }

function SWCancel()
{
	gWizObj.curCtlr.phyMgr.spareBtn.SetOff();
	gWizObj.tgtY = 0;
	this.Cleanup();

	return true;
}

function SWClose()
{
	this.curStep = 10;
	gWizObj.curCtlr.phyMgr.spareBtn.SetOff();
	gWizObj.finishBtn.SetOff();
	gWizObj.tgtY = 0;
	this.Cleanup();
}

function SWFinish()
{
	var wiz = this.myOwner;
	wiz.finishBtn.SetOn();

	gInfoBox.ReqSubmitting(gInfoBox.swReqMsgs, 1);

	var i;
	var c = this.assignList;
	var iMax = c.numItems;
	var devStr = "";
	for (i=0; i<iMax; i++) devStr += "#" + c[i].smbeId;
	this.myForm.assignTo.value = devStr;

	c = this.delList;
	iMax = c.numItems;
	devStr = "";
	for (i=0; i<iMax; i++) devStr += "#" + c[i].smbeId;
	this.myForm.delSpares.value = devStr;

	c = this.newList;
	iMax = c.numItems;
	devStr = "";
	for (i=0; i<iMax; i++) devStr += "#" + c[i].smbeId;
	this.myForm.newSpares.value = devStr;

	this.myForm.ctlrObj.value = wiz.curCtlr.smbeId;

	gSubmitReq = gSWSubmitReq; // post the submit request
}

function SWDevClick(dev)
{
	if (dev.myCtlr != this.myOwner.curCtlr) {
		gInfoBox.Reminder(gInfoBox.swAlerts[0]); //alert("***TEMP Reminder***\nManage spares is in progress on another controller.\nYou must select drives on the active controller to create and delete spares.");
		return;
	}

	if (dev.logType != "none") {
		if (!(dev.myCtlr.ctlrFlags & 0x4000)) return; // no dedicated spare support

		if (dev.isSecLevel) {
			gInfoBox.Reminder(gInfoBox.swAlerts[1]); //alert("***TEMP ALERT***\nYou cannot assign hot-spares directly to second level arrays.  You must assign hot-spares through the top level array to which this second level array belongs.");
			return;
		}
		else if (!dev.protCriteria) {
			gInfoBox.Reminder(gInfoBox.swAlerts[2]); //alert("***TEMP ALERT***\nOnly redundant array types may have hot-spares assigned to them (RAID-1, RAID-10, RAID-5, RAID-50, Volume of RAID-5, Volume of RAID-1).");
			return;
		}

		var al = this.assignList;
		if (al.numItems) {
			if (al[0] == dev) {
				al.numItems = 0;
				dev.myIcon.RSelOff();
			}
			else {
				al[0].myIcon.RSelOff();
				al[0] = dev;
				dev.myIcon.RSelOn();
				this.CheckNew(dev);
			}
		}
		else {
			al.Append(dev);
			dev.myIcon.RSelOn();
			this.CheckNew(dev);
		}

		if (al.numItems) gWizDiv.hsAssignHint.Show();
		else gWizDiv.hsAssignHint.Hide();
	}
	else if (dev.isSpare) {
		if (this.delList.Remove(dev)) dev.myIcon.DelOff();
		else { this.delList.Append(dev); dev.myIcon.DelOn(); }
	}
	else if (dev.numUsedSegs) {
		gInfoBox.Reminder(gInfoBox.swAlerts[7]); //alert("***TEMP ALERT***\nThis drive is used by a logical drive and can not be used as a hot-spare.");
		return;
	}
	else {
		var bf = (dev.bigFree) ? dev.bigFree.numBlocks : 0;
		if (bf < this.myOwner.curCtlr.minSegSize) {
			gInfoBox.Reminder(gInfoBox.swAlerts[3]); //alert("***TEMP ALERT***\nThis drive does not have enough available capacity to be used as a hot-spare.");
			return;
		}
		if (this.assignList.numItems) {
			if (bf < this.assignList[0].protCriteria) {
				gInfoBox.Reminder(gInfoBox.swAlerts[4]); //alert("***TEMP ALERT***\nThis drive does not have enough available capacity to protect the selected logical device.");
				return;
			}
			if (!dev.isClusteredBus && this.assignList[0].isClusteredBus) {
				gInfoBox.Reminder(gInfoBox.swAlerts[6]);
				return;
			}
		}
		if (this.newList.Remove(dev)) dev.myIcon.RSelOff();
		else { this.newList.Append(dev); dev.myIcon.RSelOn(); }
	}

	if (this.newList.numItems || this.delList.numItems) this.myOwner.finishBtn.Show();
	else this.myOwner.finishBtn.Hide();
}

function SWCleanup()
{
	var i;
	var c = this.delList;
	var iMax = c.numItems;
	for (i=0; i<iMax; i++) c[i].myIcon.DelOff();

	c = this.newList;
	iMax = c.numItems;
	for (i=0; i<iMax; i++) c[i].myIcon.RSelOff();

	c = this.assignList;
	iMax = c.numItems;
	for (i=0; i<iMax; i++) c[i].myIcon.RSelOff();

	gWizDiv.hsAssignHint.Hide();
}

function SWCheckNew(dev)
{
	var i = 0;
	var c = this.newList;
	var pc = dev.protCriteria;
	while (i<c.numItems) {
		if ((c[i].bigFree.numBlocks < pc) || (!c[i].isClusteredBus && dev.isClusteredBus)) { c[i].myIcon.RSelOff(); c.Remove(c[i]); }
		else i++;
	}
}

//----------------
// SWStep1Obj()
//----------------

function SWStep1Obj(inOwner)
{
	this.myOwner = inOwner;

	var c = (this.childNodes) ? this.childNodes : this.children;

	var wiz = inOwner.myOwner;
	this.ySize = c[0].offsetHeight + wiz.basicOverhead;
	if (c[1].offsetHeight > this.ySize) this.ySize = c[1].offsetHeight;
	if (gWizDiv.hsAssignHint.ySize > this.ySize) this.ySize = gWizDiv.hsAssignHint.ySize;

	this.adv1 = c[1];
	this.adv2 = c[2];

	this.Show = SWStep1Show;
	this.Hide = ObjHide;
}

function SWStep1Show(inCtlr)
{
	this.myOwner.curStep = 1;

	gWizObj.prevBtn.style.visibility = "hidden";
	gWizObj.cancelBtn.style.visibility = "inherit";
	gWizObj.nextBtn.style.visibility = "hidden";
	gWizObj.advBtn.style.visibility = "inherit";
	gWizObj.finishBtn.style.visibility = "hidden";

	if (inCtlr.ctlrFlags & 0x4000) {
		this.adv1.style.display = "block";
		this.adv2.style.display = "none";
	}
	else {
		this.adv1.style.display = "none";
		this.adv2.style.display = "block";
	}

	this.style.visibility = "inherit";
}

//----------------
// ModifyWizObj()
//----------------

function ModifyWizObj(inOwner)
{
	this.myOwner = inOwner;
	this.curStep = 0;
	this.raidType = null;
	this.myAction = gActModifyLog;
	this.expArray = null;
	this.newSegs = new Array();
	this.delSegs = new Array();
	this.origSegs = new Array();
	this.capBlks = 0;
	this.minSeg = 0;
	this.prevRTindex = 100;
	this.minNewSegs = 0;
	this.maxSegLoss = 0;
	this.minArraySize = 0;
	this.dsName = null;

	var c;
	var tw;
	if (this.childNodes) {
		c = this.childNodes;
		this.origStat = c[0].childNodes[0].childNodes[0].childNodes[1];
		this.newStat = c[0].childNodes[0].childNodes[0].childNodes[2];
		this.rImgs = c[2].childNodes;
		this.myForm = c[1];
		c = this.myForm.childNodes;
	}
	else {
		c = this.children;
		this.origStat = c[0].children[0].children[0].children[1];
		this.newStat = c[0].children[0].children[0].children[2];
		this.rImgs = c[2].children;
		this.myForm = c[1];
		c = this.myForm.children;
	}

	this.capText1 = GetPageElement("mwCap1");
	this.capImg1 = GetPageElement("mwImg1");
	this.capText2 = GetPageElement("mwCap2");
	this.capImg2 = GetPageElement("mwImg2");

	this.myStep1 = c[1];
	this.myStep1.mwStep1Obj = MWStep1Obj;
	this.myStep1.mwStep1Obj(this);
	var maxY = this.myStep1.ySize;

	this.myStep2 = c[2];
	this.myStep2.mwStep2Obj = MWStep2Obj;
	this.myStep2.mwStep2Obj(this);
	if (this.myStep2.ySize > maxY) maxY = this.myStep2.ySize;

	this.myStep3 = c[3];
	this.myStep3.mwStep3Obj = MWStep3Obj;
	this.myStep3.mwStep3Obj(this);
	if (this.myStep3.ySize > maxY) maxY = this.myStep3.ySize;

	this.ySize = maxY + 5;

	this.ePrev = MWPrev;
	this.eCancel = MWCancel;
	this.eNext = MWNext;
	this.eFinish = MWFinish;
	this.eClose = MWClose;

	this.eDevClick = MWDevClick;
	this.eSegClick = MWSegClick;

	this.Cleanup = MWCleanup;

	this.SelRType = MWSelRType;
	this.SetRaidImg = MWSetRaidImg;
	this.SetCap = MWSetCap;
	this.SegCheck = MWSegCheck;
	this.AddCheck = MWAddCheck;
	this.RemNewSeg = MWRemNewSeg;
	this.DelOrigSeg = MWDelOrigSeg;
	this.AddSeg = MWAddSeg;

	this.Hide = ObjHide;
	this.Show = MWShow;
}

function MWPrev()
{
	if (this.curStep == 2) {
		this.myStep2.Hide();
		this.myStep1.Show();
	}
	else if (this.curStep == 3) {
		this.myStep3.Hide();
		this.myStep2.Show();
	}
	else {
		gInfoBox.Reminder(gInfoBox.cwAlerts[11]); //alert("*** TEMP ALERT ***\nInvalid Previous Step");
	}
}

function MWCancel()
{
	gWizObj.curCtlr.logMgr.modifyBtn.SetOff();
	gWizObj.tgtY = 0;
	this.Cleanup();

	return true;
}

function MWCleanup()
{
	var i;
	var c = this.delSegs;
	var iMax = c.numItems;
	for (i=0; i<iMax; i++) {
		c[i].myOwner.myIcon.DelOff();
		c[i].myIcon.DelOff();
	}
	c.numItems = 0;

	c = this.newSegs;
	iMax = c.numItems;
	for (i=0; i<iMax; i++) {
		c[i].myOwner.myIcon.RSelOff();
		c[i].myIcon.RSelOff();
		c[i].myOwner.rselSegs.numItems = 0;
	}
	c.numItems = 0;

	this.origSegs.numItems = 0;

	if (this.expArray) {
		this.expArray.myIcon.RSelOff();
		this.expArray.CompsRSelOff();
		this.expArray = null;
	}
	this.origStat.style.visibility = "hidden";
	this.newStat.style.visibility = "hidden";

	this.raidType = null;
	this.myForm.reset();
}

function MWNext()
{
	var nb = this.myOwner.nextBtn;
	if (nb.isContent) return;

	if (this.curStep == 1) {
		this.myStep1.Hide();
		this.myStep2.Show();
	}
	else {
		nb.eMouseOver(); // In case the user just keeps clicking (no mouseover event generated since the mouse never left the "Next" button)
		if (nb.isContent) return;

		//this.DeselAllBlink();
		//this.SetCap();
		this.myStep2.Hide();
		this.myStep3.Show();
	}
}

function MWFinish()
{
	var wiz = this.myOwner;
	wiz.finishBtn.SetOn();

	gInfoBox.ReqSubmitting(gInfoBox.mwReqMsgs, 1);

	var i;
	var iMax = this.newSegs.numItems;
	var compStr = "";
	for (i=0; i<iMax; i++) {
		seg = this.newSegs[i];
		compStr += "#" + seg.myOwner.smbeId + "," + seg.startBlock + "," + seg.numBlocks;
	}
	this.myForm.newcomps.value = compStr;

	iMax = this.delSegs.numItems;
	compStr = "";
	for (i=0; i<iMax; i++) {
		seg = this.delSegs[i];
		compStr += "#" + seg.smbeId;
	}
	this.myForm.delcomps.value = compStr;

	this.myForm.ctlrObj.value = gWizObj.curCtlr.smbeId;
	this.myForm.expandObj.value = this.expArray.smbeId;

	gSubmitReq = gMWSubmitReq; // post the submit request
}

function MWClose()
{
	this.curStep = 10;
	gWizObj.curCtlr.logMgr.modifyBtn.SetOff();
	gWizObj.finishBtn.SetOff();
	gWizObj.tgtY = 0;
	this.Cleanup();
}

function MWDevClick(dev)
{
	if (this.curStep == 1) {
		if (dev.logType != "none") {
			if (dev.myCtlr != gWizObj.curCtlr) {
				gInfoBox.Reminder(gInfoBox.mwAlerts[17]); //alert("***TEMP Reminder***\nModify array is in progress on another controller.\nTo modify an array you must select a logical drive on the active controller.");
				return;
			}

			var lt = dev.logType;
			if (dev == this.expArray) {
				this.Cleanup();
			}
			else if ((dev.myCtlr.ctlrFamily==1) && (lt != "r0" && lt != "r5")) {
				gInfoBox.Reminder(gInfoBox.mwAlerts[16]); //alert("**TEMP Alert\nThis controller only supports modification of RAID-0 and RAID-5 arrays.");
			}
			else if ((lt == "rv") || (lt == "spv")) {
				gInfoBox.Reminder(gInfoBox.mwAlerts[0]); //alert("**TEMP Alert\nSpanned and RAID volumes cannot be modified.");
			}
			else if (dev.isSecLevel) {
				gInfoBox.Reminder(gInfoBox.mwAlerts[1]); //alert("**TEMP Alert\nSecond level arrays can not be modified.");
			}
			else if (dev.aTask) {
				gInfoBox.Reminder(gInfoBox.mwAlerts[2]); //alert("***TEMP Reminder***\nA task is running on this array.  The task must complete or be aborted before this array can be modified.");
			}
			else if (dev.myIcon.statusImg.src.indexOf("optimal") == -1) {
				gInfoBox.Reminder(gInfoBox.mwAlerts[14]); //alert("***TEMP Reminder***\nThe array is not in an optimal state and cannot be modified.");
			}
			else {
				if (this.expArray) this.Cleanup();
				this.expArray = dev;
				dev.myIcon.RSelOn();
				dev.CompsRSelOn(this.origSegs);
				this.minSeg = this.origSegs[0].numBlocks;
				this.dsName = this.origSegs[0].myOwner.dsName;
				this.origStat.style.visibility = "inherit";
				this.capText1.innerHTML = GetCapStr(dev.numBlks);
				this.SetRaidImg(dev.logType, this.capImg1);
			}
		}
	}
	else if (this.curStep >= 2) {
		if (dev.logType!="none") return;

		var seg = (dev.mwOrigSeg) ? dev.mwOrigSeg : dev.bigFree;
		if (!seg) gInfoBox.Reminder(gInfoBox.mwAlerts[3]); //alert("*** TEMP ALERT ***\nThis drive has no free space");
		else if (seg.numBlocks < this.minSeg) gInfoBox.Reminder(gInfoBox.mwAlerts[4]); //alert("*** TEMP ALERT ***\nThis drive does not have enough available space to use in the selected array.");
		else this.SegCheck(seg);
	}
}

function MWSetRaidImg(inType, inImg)
{
	switch (inType) {
		case "r0": inImg.src = this.rImgs[0].src; break;
		case "r1": inImg.src = this.rImgs[1].src; break;
		case "r5": inImg.src = this.rImgs[2].src; break;
		case "r10": inImg.src = this.rImgs[3].src; break;
		case "r50": inImg.src = this.rImgs[4].src; break;
		case "sv": inImg.src = this.rImgs[5].src; break;
		case "spv": inImg.src = this.rImgs[5].src; break;
		case "rv": inImg.src = this.rImgs[5].src; break;
	}
}

function MWSegClick(seg)
{
	if (this.curStep > 1) {
		this.SegCheck(seg);
	}
}

function MWSegCheck(seg)
{
	var dev = seg.myOwner;

	if (dev.myCtlr != gWizObj.curCtlr) {
		gInfoBox.Reminder(gInfoBox.mwAlerts[5]); //alert("***TEMP Reminder***\nModify array is in progress on another controller.\nYou must select drives on the active controller to include them in the array.");
		return;
	}

	if (dev.isSpare) {
		gInfoBox.Reminder(gInfoBox.mwAlerts[6]); //alert("***TEMP Reminder***\nHot-spares can not be included in arrays.");
		return;
	}

	if (dev.numUsedSegs >= dev.myCtlr.maxUsedSegs) {
		gInfoBox.Reminder(gInfoBox.cwAlerts[15]); //alert("***TEMP Reminder***\nThis drive is already used by the maximum number of arrays allowed.");
		return;
	}

	if (this.dsName && (this.dsName!=dev.dsName)) {
		gInfoBox.Reminder(gInfoBox.mwAlerts[15]);
		return;
	}

	var selSeg;
	if (dev.rselSegs.numItems) {
		selSeg = dev.rselSegs[0];
		if (selSeg != seg) {
			if (!this.AddCheck(seg)) return;

			if (selSeg.isMWOrig) {
				if (this.DelOrigSeg(selSeg, false)) {
					this.AddSeg(seg, dev);
				}
				else {
					gInfoBox.Reminder(gInfoBox.mwAlerts[7]); //alert("***TEMP Alert***\nAn original segment that can not be deleted already exists on the drive.");
				}
			}
			else {
				this.RemNewSeg(selSeg, selSeg.myOwner);
				this.AddSeg(seg, dev);
			}
		}
		else if (selSeg.isMWOrig) {
			this.DelOrigSeg(selSeg, true);
		}
		else {
			this.RemNewSeg(seg, dev);
		}
	}
	else if (this.AddCheck(seg)) {
		this.AddSeg(seg, dev);
	}

	this.SetCap();
}

function MWAddCheck(seg)
{
	if (seg.isMWOrig) return true;

	if (seg.segType != 0) {
		gInfoBox.Reminder(gInfoBox.mwAlerts[8]); //alert("***TEMP Reminder***\nOnly available segments can be added to arrays.");
		return false;
	}

	if (seg.numBlocks < this.minSeg) {
		gInfoBox.Reminder(gInfoBox.mwAlerts[9]); //alert("***TEMP Reminder***\nThis segment is not large enough to use in the selected array.");
		return false;
	}

	if (seg.myOwner.isSpare) {
		gInfoBox.Reminder(gInfoBox.mwAlerts[10]); //alert("***TEMP Reminder***\nHot-Spare segments can not be used in arrays.");
		return false;
	}

	return true;
}

function MWDelOrigSeg(seg, bAlert)
{
	if (this.delSegs.numItems >= this.maxSegLoss) {
		if (bAlert) gInfoBox.Reminder(gInfoBox.mwAlerts[11]); //alert("***TEMP Info***\nNo more original segments can be removed from this array.");
		return false;
	}

	var i;
	var d = this.delSegs;
	for (i=0; i<d.length; i++) {
		if (d.myParent == seg.myParent) {
			if (bAlert) gInfoBox.Reminder(gInfoBox.mwAlerts[12]); //alert("***TEMP Info***\nYou can not remove more than one drive from a redundant group.");
			return false;
		}
	}

	seg.myIcon.RSelOff();
	seg.myIcon.DelOn();
	this.delSegs.Append(seg);

	var dev = seg.myOwner;
	dev.myIcon.RSelOff();
	dev.myIcon.DelOn();
	dev.rselSegs.numItems = 0;

	return true;
}

function MWRemNewSeg(seg, dev)
{
	this.newSegs.Remove(seg);
	seg.myIcon.RSelOff();
	dev.myIcon.RSelOff();
	dev.rselSegs.Remove(seg);
}


function MWAddSeg(seg, dev)
{
	if (seg.isMWOrig) {
		seg.myIcon.DelOff();
		seg.myIcon.RSelOn();
		this.delSegs.Remove(seg);

		dev.myIcon.DelOff();
		dev.myIcon.RSelOn();
		dev.rselSegs.Append(seg);
	}
	else {
		this.newSegs.Append(seg);
		seg.myIcon.RSelOn();
		dev.myIcon.RSelOn();
		dev.rselSegs.Append(seg);
	}
}


function MWSelRType(inIndex, checkIt)
{
	if (checkIt) this.myForm.rtype[inIndex].checked = true;

	var i;
	var d = this.delSegs;
	var seg;
	var dev;
	for (i=0; i<d.numItems; i++) {
		seg = d[i];
		seg.myIcon.DelOff();
		seg.myIcon.RSelOn();

		dev = seg.myOwner;
		dev.myIcon.DelOff();
		dev.myIcon.RSelOn();
		dev.rselSegs.Append(seg);
	}
	this.delSegs.numItems = 0;

	this.minNewSegs = 0;
	this.maxSegLoss = 0;

	if (inIndex == 0) {
		this.raidType = "r0";
		this.capImg2.src = this.rImgs[0].src;
		switch (this.expArray.logType) {
			case "r5": this.maxSegLoss = 1; break;
			case "r10": this.maxSegLoss = this.expArray.compA.numItems; break;
			case "r50": this.maxSegLoss = this.expArray.compA.numItems; break;
			case "sv": this.minNewSegs = 1; break;
		}
	}
	else if (inIndex == 1) {
		this.raidType = "r5";
		this.capImg2.src = this.rImgs[2].src;
		switch (this.expArray.logType) {
			case "r0": this.minNewSegs = 1; break;
			case "r1": this.minNewSegs = 1; break;
			case "r10": this.maxSegLoss = this.expArray.compA.numItems - 1; break;
			case "r50": this.maxSegLoss = this.expArray.compA.numItems - 1; break;
			case "sv": this.minNewSegs = 2; break;
		}
	}
	else {
		this.raidType = "r10";
		this.capImg2.src = this.rImgs[3].src;
		switch (this.expArray.logType) {
			case "r0": this.minNewSegs = this.origSegs.numItems; break;
			case "r1": this.minNewSegs = 2; break;
			case "r5": this.minNewSegs = this.origSegs.numItems - 2; break;
			case "r50": this.minNewSegs = this.origSegs.numItems - (this.expArray.compA.numItems<<1); break;
			case "sv": this.minNewSegs = 3; break;
		}
	}

	this.newStat.style.visibility = "inherit";
	this.SetCap();
}

function MWSetCap()
{
	if (this.newSegs.numItems < this.minNewSegs) {
		this.capBlks = 0;
		var aStr = this.myStep3.info2.innerHTML.split(gSepChar);
		var diff = this.minNewSegs - this.newSegs.numItems;
		this.myStep3.infoDiv.innerHTML = aStr[0] + "<span style='color: #0000ff; font-weight: bold;'>" + diff + "</span>" + aStr[1];
		if (this.curStep==3) this.myOwner.finishBtn.style.visibility = "hidden";
	}
	else {
		this.myStep3.infoDiv.innerHTML = this.myStep3.info1.innerHTML;
		if (this.curStep==3) this.myOwner.finishBtn.style.visibility = "inherit";

		var numComps = this.origSegs.numItems + this.newSegs.numItems - this.delSegs.numItems;

		if (this.raidType == "r0") {
			this.capBlks = numComps * this.minSeg;
		}
		else if (this.raidType == "r10") {
			this.capBlks = (numComps >> 1) * this.minSeg;
		}
		else if (this.raidType == "r5") {
			this.capBlks = (numComps - 1) * this.minSeg;
		}
	}

	this.capText2.innerHTML = GetCapStr(this.capBlks);
}

function MWShow()
{
	this.myForm.reset();
	this.delSegs.RemoveAll();
	this.newSegs.RemoveAll();
	this.devCntr = 0;
	this.dsName = null;

	this.myStep2.Hide();
	this.myStep3.Hide();
	this.myStep1.Show();

	this.myOwner.nextBtn.eMouseOver = MWNextCheck;
	this.style.visibility = "inherit";
}

function MWNextCheck() // Attached to "nextBtn.eMouseOver()"
{
	this.isContent = false;
	var mw = this.myOwner.curWiz;
	if (mw.curStep == 1) {
		if (!mw.expArray) this.ArrayRequired();
	}
	else if (mw.curStep == 2) {
		if (!mw.raidType) this.RTRequired();
	}
/*
	else {
		this.Invalid();
	}
*/
	if (this.isContent) this.myTip.style.visibility = "inherit";
	else this.myTip.style.visibility = "hidden";
}

//----------------
// MWStep1Obj()
//----------------

function MWStep1Obj(inOwner)
{
	this.myOwner = inOwner;
	this.isInit = false;

	var c = (this.childNodes) ? this.childNodes : this.children;

	var wiz = inOwner.myOwner;

	var bsz = c[0].offsetHeight + wiz.basicOverhead;
	var asz = c[1].offsetHeight + wiz.btnPadBtm;
	if (bsz > asz) this.ySize = bsz;
	else this.ySize = asz;

	this.Show = MWStep1Show;
	this.Hide = ObjHide;
}

function MWStep1Show()
{
	this.myOwner.curStep = 1;
	gWizObj.prevBtn.style.visibility = "hidden";
	gWizObj.cancelBtn.style.visibility = "inherit";
	gWizObj.nextBtn.style.visibility = "inherit";
	gWizObj.advBtn.style.visibility = "inherit";
	gWizObj.finishBtn.style.visibility = "hidden";
	this.style.visibility = "inherit";
}

//----------------
// MWStep2Obj()
//----------------

function MWStep2Obj(inOwner)
{
	this.myOwner = inOwner;

	var c;
	if (this.childNodes) {
		c = this.childNodes;
		this.basicDivs = c[0].childNodes;
		this.ssDiv = c[1].childNodes[1];
	}
	else {
		c = this.children;
		this.basicDivs = c[0].children;
		this.ssDiv = c[1].children[1];
	}
	this.adv1 = c[1];
	this.adv2 = c[2];

	this.curSS = GetPageElement("mwCurSS");

	this.r0Div = GetPageElement("mwR0");
	this.r5Div = GetPageElement("mwR5");
	this.r10Div = GetPageElement("mwR10");

	var wiz = inOwner.myOwner;
	var bsz = c[0].offsetHeight + wiz.basicOverhead;
	var asz = c[1].offsetHeight + wiz.btnPadBtm;
	if (bsz > asz) this.ySize = bsz;
	else this.ySize = asz;

	this.Show = MWStep2Show;
	this.Hide = ObjHide;
}

function MWStep2Show()
{
	var i;
	var o = this.myOwner.myForm.stripesize.options;
	var dev = this.myOwner.expArray;
	var val = dev.ssNum;
	for(i=0; i<o.length; i++) {
		if (val==parseInt(o[i].value)) {
			o[i].selected = true;
			break;
		}
	}
	if (dev.logType=="r1" || dev.logType=="sv" || dev.logType=="av" || dev.logType=="spv") this.ssDiv.style.visibility = "hidden";
	else {
		this.ssDiv.style.visibility = "inherit";
		this.curSS.innerHTML = GetCapStr(1<<val);
	}

	this.r0Div.style.visibility = "inherit";
	this.r5Div.style.visibility = "inherit";
	this.r10Div.style.visibility = "inherit";
	if (gWizObj.curCtlr.ctlrFamily == 1) {
		this.adv1.style.display = "none";
		this.adv2.style.display = "block";
		var lt = this.myOwner.expArray.logType;
		if (lt=="r0") {
			this.myOwner.SelRType(0, true);
			this.r5Div.style.visibility = "hidden";
			this.r10Div.style.visibility = "hidden";
		}
		else if (lt=="r5") {
			this.myOwner.SelRType(1, true);
			this.r0Div.style.visibility = "hidden";
			this.r10Div.style.visibility = "hidden";
		}
	}
	else {
		this.adv1.style.display = "block";
		this.adv2.style.display = "none";
	}

	this.myOwner.curStep = 2;
	gWizObj.prevBtn.style.visibility = "inherit";
	gWizObj.cancelBtn.style.visibility = "inherit";
	gWizObj.nextBtn.style.visibility = "inherit";
	gWizObj.finishBtn.style.visibility = "hidden";
	this.style.visibility = "inherit";
}

//----------------
// MWStep3Obj()
//----------------

function MWStep3Obj(inOwner)
{
	this.myOwner = inOwner;

	var c = (this.childNodes) ? this.childNodes[0].childNodes : this.children[0].children;

	this.infoDiv = c[1];
	this.info1 = c[2];
	this.info2 = c[3];

	this.ySize = 0;

	this.Show = MWStep3Show;
	this.Hide = ObjHide;
}

function MWStep3Show()
{
	var mw = this.myOwner;
	mw.curStep = 3;

	var wo = mw.myOwner;
	wo.prevBtn.style.visibility = "inherit";
	wo.cancelBtn.style.visibility = "inherit";
	wo.nextBtn.style.visibility = "hidden";
	wo.finishBtn.style.visibility = (mw.newSegs.numItems < mw.minNewSegs) ? "hidden" : "inherit";
	this.style.visibility = "inherit";
}

